/* ****************************************************************************
 * Copyright (c) 2002 Java Eclipse Extension Project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.opensource.org/licenses/cpl.php
 * ============================================================================
 * $Header: /cvsroot/jeextension/jp.sourceforge.jeextension.styleeditor/src/jp/sourceforge/jeextension/styleeditor/preferences/AddPartitionDialog.java,v 1.12 2007/09/22 04:15:10 kohnosuke Exp $
 * $Revision: 1.12 $
 * $Date: 2007/09/22 04:15:10 $
 * ============================================================================
 * ***************************************************************************/
package jp.sourceforge.jeextension.styleeditor.preferences;

import jp.sourceforge.jeextension.common.plugin.DefaultDialog;
import jp.sourceforge.jeextension.common.xml.XMLNode;
import jp.sourceforge.jeextension.styleeditor.core.StyleEditorTools;
import jp.sourceforge.jeextension.styleeditor.entry.IPartitionEntry;
import jp.sourceforge.jeextension.styleeditor.entry.PartitionEntry;

import org.eclipse.jface.preference.ColorSelector;
import org.eclipse.jface.text.IDocument;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.MessageBox; // #ReqID:10017 RegExp
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Composite;

/**
 * AddPartitionDialog
 * @since 1.0.0
 * <!-- #IntID:00002 UI Tuned -->
 * <!-- #IntID:00003 Refactoring -->
 * <!-- #IntID:00004 Style Maximization -->
 * <!-- #IntID:00007 BugFix BGColor default enabled when entry new item -->
 * <!-- #ReqID:10017 RegExp -->
 * <!-- #IntID:00010 // singleline comment type defined -->
 * <!-- #IntID:00012 bug, regexp check off at PartitionEntryDialog -->
 */
class AddPartitionDialog extends DefaultDialog {
    
    /** ColorSelector button. */
    private ColorSelector fColorSel;

    /** 'End' Label. */
    private Label fLabelEnd;

    /** 'PartitionName' Label. */
    private Label fLabelKwd;

    /** 'RegExp' Label. */
    private Label fLabelReg;
    
    /** 'Start' Label. */
    private Label fLabelStr;
    
    /** 'Start' Label. */
    private Label fLabelBgc;
    
    /** return values reference when dialog was disposed. */
    private IPartitionEntry[] fStyleContainer;
    
    /** dialog values container. */
    private IPartitionEntry fStyleEntry;
    
    /** End's Text. */
    private Text fTextEnd;
    
    /** PartitionName's Text. */
    private Text fTextNme;
    
    /** RegExp's Text. */
    private Text fTextReg;
    
    /** Start's Text. */
    private Text fTextStr;
    
    /** Base's Check Button. */
    private Button fCheckBase;
    
    /** Regexp's Check Button. */
    private Button fUseRegExp;
    
    /** Javadoc's Check Button. */
    private Button fJavadoc;
    
    /** JavaMultiline's Check Button. */
    private Button fJavaMulti;
    
    /** JavaSingleline's Check Button. */
    private Button fJavaSingle;
    
    /** current editting extension. */
    private final String fExtension;
    
    /** Selection Radio button. */
    private Button fCheckGbc;
    
    /** Selection Radio button. */
    private Button fCheckIta;
    
    /** Selection Radio button. */
    private Button fCheckBol;
    
    /** Selection Radio button. */
    private Button fCheckStr;
    
    /** Selection Radio button. */
    private Button fCheckUnd;
    
    /** ColorSelector button. */
    private ColorSelector fColorBgc;
    
    /**
     * Initiate AddPartitionDialog Window.
     * @param shell     shell using on parent window
     * @param container dialog values container.
     * @param ext   extension name. (ex. java, means *.java)
     */
    AddPartitionDialog(Shell shell, IPartitionEntry[] container, String ext) {
        super(shell);
        this.fStyleEntry = container[0];
        this.fStyleContainer = container;
        this.fExtension = ext;
    }
    
    /**
     * {@inheritDoc}
     * @see org.eclipse.swt.widgets.Listener#handleEvent(org.eclipse.swt.widgets.Event)
     */
    public void handleEvent(Event event) {
        if (event.widget == fCheckBase) {
            if (fCheckBase.getSelection()) {
                fTextStr.setText("");
                fTextEnd.setText("");
                fTextNme.setText(IDocument.DEFAULT_CONTENT_TYPE);
                
                fTextReg.setEnabled(false);
                fTextStr.setEnabled(false);
                fTextEnd.setEnabled(false);
                fTextNme.setEnabled(false);
                fUseRegExp.setEnabled(false);
                fJavadoc.setEnabled(false);
                fJavaMulti.setEnabled(false);
                fJavaSingle.setEnabled(false);
            }
            else {
                if (fTextNme.getText().equals(
                        IDocument.DEFAULT_CONTENT_TYPE)) {
                    fTextNme.setText("");
                }
                fTextReg.setEnabled(false);
                fTextStr.setEnabled(true);
                fTextEnd.setEnabled(true);
                fTextNme.setEnabled(true);
                fUseRegExp.setEnabled(true);
                fJavadoc.setEnabled(true);
                fJavaMulti.setEnabled(true);
                fJavaSingle.setEnabled(true);
            }
        }
        if (event.widget == fUseRegExp) {
            if (fUseRegExp.getSelection()) {
                fTextStr.setText("");
                fTextEnd.setText("");
                
                fTextReg.setEnabled(true);
                fTextStr.setEnabled(false);
                fTextEnd.setEnabled(false);
                fCheckBase.setEnabled(false);
                fJavadoc.setEnabled(false);
                fJavaMulti.setEnabled(false);
                fJavaSingle.setEnabled(false);
            }
            else {
                // #IntID:00012 bug, regexp check off at PartitionEntryDialog
                fTextReg.setText("");
                
                fTextReg.setEnabled(false);
                fTextStr.setEnabled(true);
                fTextEnd.setEnabled(true);
                fCheckBase.setEnabled(true);
                fJavadoc.setEnabled(true);
                fJavaMulti.setEnabled(true);
                fJavaSingle.setEnabled(true);
            }
        }
        if (event.widget == fCheckGbc) {
            if (fCheckGbc.getSelection()) {
                fColorBgc.setEnabled(true);
                fLabelBgc.setEnabled(true);
            }
            else {
                fColorBgc.setEnabled(false);
                fLabelBgc.setEnabled(false);
            }
        }
        if (event.widget == fJavadoc) {
            if (fJavadoc.getSelection()) {
                fTextStr.setText("/**");
                fTextEnd.setText("*/");
                fTextNme.setText(IPartitionEntry.JAVA_DOC);
                
                fTextReg.setEnabled(false);
                fTextStr.setEnabled(false);
                fTextEnd.setEnabled(false);
                fTextNme.setEnabled(false);
                fCheckBase.setEnabled(false);
                fUseRegExp.setEnabled(false);
                fJavaMulti.setEnabled(false);
                fJavaSingle.setEnabled(false);
            }
            else {
                fTextStr.setText("");
                fTextEnd.setText("");
                fTextNme.setText("");
                
                fTextReg.setEnabled(false);
                fTextStr.setEnabled(true);
                fTextEnd.setEnabled(true);
                fTextNme.setEnabled(true);
                fCheckBase.setEnabled(true);
                fUseRegExp.setEnabled(true);
                fJavaMulti.setEnabled(true);
                fJavaSingle.setEnabled(true);
            }
        }
        if (event.widget == fJavaMulti) {
            if (fJavaMulti.getSelection()) {
                fTextStr.setText("/*");
                fTextEnd.setText("*/");
                fTextNme.setText(IPartitionEntry.JAVA_MULTILINE);
                
                fTextReg.setEnabled(false);
                fTextStr.setEnabled(false);
                fTextEnd.setEnabled(false);
                fTextNme.setEnabled(false);
                fCheckBase.setEnabled(false);
                fUseRegExp.setEnabled(false);
                fJavadoc.setEnabled(false);
                fJavaSingle.setEnabled(false);
            }
            else {
                fTextStr.setText("");
                fTextEnd.setText("");
                fTextNme.setText("");
                
                fTextReg.setEnabled(false);
                fTextStr.setEnabled(true);
                fTextEnd.setEnabled(true);
                fTextNme.setEnabled(true);
                fCheckBase.setEnabled(true);
                fUseRegExp.setEnabled(true);
                fJavadoc.setEnabled(true);
                fJavaSingle.setEnabled(false);
            }
        }
        // #IntID:00010 // singleline comment type defined
        if (event.widget == fJavaSingle) {
            if (fJavaSingle.getSelection()) {
                fTextStr.setText("//");
                fTextEnd.setText("");
                fTextNme.setText(IPartitionEntry.JAVA_SINGLELINE);
                
                fTextReg.setEnabled(false);
                fTextStr.setEnabled(false);
                fTextEnd.setEnabled(false);
                fTextNme.setEnabled(false);
                fCheckBase.setEnabled(false);
                fUseRegExp.setEnabled(false);
                fJavadoc.setEnabled(false);
                fJavaMulti.setEnabled(false);
            }
            else {
                fTextStr.setText("");
                fTextEnd.setText("");
                fTextNme.setText("");
                
                fTextReg.setEnabled(false);
                fTextStr.setEnabled(true);
                fTextEnd.setEnabled(true);
                fTextNme.setEnabled(true);
                fCheckBase.setEnabled(true);
                fUseRegExp.setEnabled(true);
                fJavadoc.setEnabled(true);
                fJavaMulti.setEnabled(true);
            }
        }
    }

    /**
     * {@inheritDoc}
     * @see org.eclipse.jface.dialogs.Dialog#createDialogArea(org.eclipse.swt.widgets.Composite)
     */
    protected Control createDialogArea(Composite parent) {
        
        final Composite composite = (Composite) super.createDialogArea(parent);
        final GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        composite.setLayout(gridLayout);
        
        fCheckBase = new Button(composite, SWT.CHECK);
        fCheckBase.setText(getMessage("pref.partition.dlg.base"));
        fCheckBase.setSelection(false);
        fCheckBase.addListener(SWT.Selection, this);
        final GridData gridData = new GridData(GridData.FILL_HORIZONTAL);
        gridData.horizontalSpan = 2;
        fCheckBase.setLayoutData(gridData);
        
        fUseRegExp = new Button(composite, SWT.CHECK);
        fUseRegExp.setText(getMessage("pref.partition.dlg.regexp"));
        fUseRegExp.setSelection(false);
        fUseRegExp.addListener(SWT.Selection, this);
        final GridData gridData2 = new GridData(GridData.FILL_HORIZONTAL);
        gridData2.horizontalSpan = 2;
        fUseRegExp.setLayoutData(gridData2);
        
        fJavadoc = new Button(composite, SWT.CHECK);
        fJavadoc.setText(getMessage("pref.partition.dlg.javadoc"));
        fJavadoc.setSelection(false);
        fJavadoc.addListener(SWT.Selection, this);
        final GridData gridData3 = new GridData(GridData.FILL_HORIZONTAL);
        gridData3.horizontalSpan = 2;
        fJavadoc.setLayoutData(gridData3);
        
        fJavaMulti = new Button(composite, SWT.CHECK);
        fJavaMulti.setText(getMessage("pref.partition.dlg.javamulti"));
        fJavaMulti.setSelection(false);
        fJavaMulti.addListener(SWT.Selection, this);
        final GridData gridData4 = new GridData(GridData.FILL_HORIZONTAL);
        gridData4.horizontalSpan = 2;
        fJavaMulti.setLayoutData(gridData4);
        
        // #IntID:00010 // singleline comment type defined
        fJavaSingle = new Button(composite, SWT.CHECK);
        fJavaSingle.setText(getMessage("pref.partition.dlg.javasingle"));
        fJavaSingle.setSelection(false);
        fJavaSingle.addListener(SWT.Selection, this);
        final GridData gridData5 = new GridData(GridData.FILL_HORIZONTAL);
        gridData5.horizontalSpan = 2;
        fJavaSingle.setLayoutData(gridData5);
        
        fLabelStr = new Label(composite, SWT.NONE);
        fLabelStr.setText(getMessage("pref.partition.dlg.start"));
        
        fTextStr = new Text(composite, SWT.BORDER);
        fTextStr.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
        
        fLabelEnd = new Label(composite, SWT.NONE);
        fLabelEnd.setText(getMessage("pref.partition.dlg.end"));
        
        fTextEnd = new Text(composite, SWT.BORDER);
        fTextEnd.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
        
        fLabelReg = new Label(composite, SWT.NONE);
        fLabelReg.setText(getMessage("pref.partition.dlg.expression"));
        
        fTextReg = new Text(composite, SWT.BORDER);
        fTextReg.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
        fTextReg.setEnabled(false);
        
        fLabelKwd = new Label(composite, SWT.NONE);
        fLabelKwd.setText(getMessage("pref.partition.dlg.name"));
        
        fTextNme = new Text(composite, SWT.BORDER);
        fTextNme.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
        
        final Label cLabelClr = new Label(composite, SWT.NONE);
        cLabelClr.setText(getMessage("pref.partition.dlg.color"));
        
        fColorSel = new ColorSelector(composite);
        fColorSel.setColorValue(new RGB(0, 0, 0));
        
        fLabelBgc = new Label(composite, SWT.NONE);
        fLabelBgc.setText(getMessage("pref.partition.dlg.bgcolor"));

        fColorBgc = new ColorSelector(composite);
        fColorBgc.setColorValue(new RGB(255, 255, 255));
        
        fColorBgc.setEnabled(false);

        fCheckGbc = new Button(composite, SWT.CHECK);
        fCheckGbc.setText(getMessage("pref.partition.dlg.usebgcolor"));
        fCheckGbc.addListener(SWT.Selection, this);
        final GridData gridData6 = new GridData(GridData.FILL_HORIZONTAL);
        gridData6.horizontalSpan = 2;
        fCheckGbc.setLayoutData(gridData6);

        fCheckIta = new Button(composite, SWT.CHECK);
        fCheckIta.setText(getMessage("pref.partition.dlg.italic"));
        fCheckIta.addListener(SWT.Selection, this);

        fCheckBol = new Button(composite, SWT.CHECK);
        fCheckBol.setText(getMessage("pref.partition.dlg.bold"));
        fCheckBol.addListener(SWT.Selection, this);

        fCheckStr = new Button(composite, SWT.CHECK);
        fCheckStr.setText(getMessage("pref.partition.dlg.strikethrough"));
        fCheckStr.addListener(SWT.Selection, this);

        fCheckUnd = new Button(composite, SWT.CHECK);
        fCheckUnd.setText(getMessage("pref.partition.dlg.underline"));
        fCheckUnd.addListener(SWT.Selection, this);
        
        if (fStyleEntry != null) {
            PartitionEntry pe = (PartitionEntry) fStyleEntry;
            fTextStr.setText(pe.getStart());
            fTextEnd.setText(pe.getEnd());
            fTextReg.setText(pe.getRegExp());
            
            fTextNme.setText(pe.getName());
            fColorSel.setColorValue(fStyleEntry.getRGB());
            if (fStyleEntry.isBgColor()) {
                fColorBgc.setColorValue(fStyleEntry.getBgRGB());
                fCheckGbc.setSelection(true);
                fColorBgc.setEnabled(true);
                fLabelBgc.setEnabled(true);
            }
            else {
                fColorBgc.setEnabled(false);
                fLabelBgc.setEnabled(false);
            }
            if (fStyleEntry.isItalic()) {
                fCheckIta.setSelection(true);
            }
            if (fStyleEntry.isBold()) {
                fCheckBol.setSelection(true);
            }
            if (fStyleEntry.isStrikeThrough()) {
                fCheckStr.setSelection(true);
            }
            if (fStyleEntry.isUnderline()) {
                fCheckUnd.setSelection(true);
            }
            
            Event e = new Event();
            if (fTextNme.getText().equals(IDocument.DEFAULT_CONTENT_TYPE)) {
                fCheckBase.setSelection(true);
                e.widget = fCheckBase;
            }
            if (fTextNme.getText().equals(IPartitionEntry.JAVA_DOC)) {
                fJavadoc.setSelection(true);
                e.widget = fJavadoc;
            }
            if (fTextNme.getText().equals(IPartitionEntry.JAVA_MULTILINE)) {
                fJavaMulti.setSelection(true);
                e.widget = fJavaMulti;
            }
            if (fTextNme.getText().equals(IPartitionEntry.JAVA_SINGLELINE)) {
                fJavaSingle.setSelection(true);
                e.widget = fJavaSingle;
            }
            if (fTextReg.getText().equals("") == false) {
                fUseRegExp.setSelection(true);
                e.widget = fUseRegExp;
            }
            handleEvent(e);
        }
        
        return composite;
    }
    
    /**
     * {@inheritDoc}
     * @see org.eclipse.jface.dialogs.Dialog#okPressed()
     */
    protected void okPressed() {
        if (fUseRegExp.getSelection()) {
            String detected = StyleEditorTools.checkRegExp(fTextReg.getText());
            if (detected == null) {
                // RegExp check OK
            }
            else {
                // RegExp check NG
                MessageBox mb = new MessageBox(getShell());
                mb.setMessage(detected + " " + getMessage("pref.err.regexp"));
                mb.open();
                return;
            }
        }
        
        RGB rgb = fColorSel.getColorValue();
        XMLNode node = new XMLNode("partition");
        node.setAttribute("name" , fTextNme.getText());
        node.setAttribute("red"  , String.valueOf(rgb.red));
        node.setAttribute("green", String.valueOf(rgb.green));
        node.setAttribute("blue" , String.valueOf(rgb.blue));
        if (fCheckGbc.getSelection()) {
            RGB brgb = fColorBgc.getColorValue();
            node.setAttribute("bgcolor"  , "true");
            node.setAttribute("bred"  , String.valueOf(brgb.red));
            node.setAttribute("bgreen", String.valueOf(brgb.green));
            node.setAttribute("bblue" , String.valueOf(brgb.blue));
        }
        else {
            node.setAttribute("bgcolor"  , "false");
            node.setAttribute("bred"  , "");
            node.setAttribute("bgreen", "");
            node.setAttribute("bblue" , "");
        }
        node.setAttribute("italic",         fCheckIta.getSelection() + "");
        node.setAttribute("bold",           fCheckBol.getSelection() + "");
        node.setAttribute("strikethrough",  fCheckStr.getSelection() + "");
        node.setAttribute("underline",      fCheckUnd.getSelection() + "");
        
        if (fUseRegExp.getSelection()) {
            node.setAttribute("start", "");
            node.setAttribute("end"  , "");
            node.setAttribute("regexp", fTextReg.getText());
        }
        else {
            node.setAttribute("start", fTextStr.getText());
            node.setAttribute("end"  , fTextEnd.getText());
            node.setAttribute("regexp", "");
        }
        
        if (fStyleEntry == null) {
            fStyleEntry = new PartitionEntry(node, fExtension);
        }
        else {
            StyleEditorTools.changePartitionEntry(
                    fStyleEntry, node, fExtension);
        }
        this.fStyleContainer[0] = fStyleEntry;
        
        super.okPressed();
    }
}
