/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.internal.repository.tools;

import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.app.IApplication;
import org.eclipse.equinox.app.IApplicationContext;
import org.eclipse.equinox.internal.p2.artifact.mirror.FileMirrorLog;
import org.eclipse.equinox.internal.p2.artifact.mirror.IArtifactMirrorLog;
import org.eclipse.equinox.internal.p2.artifact.mirror.Mirroring;
import org.eclipse.equinox.internal.p2.artifact.mirror.XMLMirrorLog;
import org.eclipse.equinox.internal.p2.core.helpers.LogHelper;
import org.eclipse.equinox.internal.p2.director.PermissiveSlicer;
import org.eclipse.equinox.internal.provisional.p2.artifact.repository.IArtifactRepository;
import org.eclipse.equinox.internal.provisional.p2.core.ProvisionException;
import org.eclipse.equinox.internal.provisional.p2.metadata.IArtifactKey;
import org.eclipse.equinox.internal.provisional.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.internal.provisional.p2.metadata.query.InstallableUnitQuery;
import org.eclipse.equinox.internal.provisional.p2.metadata.repository.IMetadataRepository;
import org.eclipse.equinox.internal.provisional.p2.query.Collector;
import org.eclipse.equinox.internal.provisional.p2.query.IQueryable;
import org.eclipse.equinox.internal.provisional.p2.query.Query;
import org.eclipse.equinox.p2.internal.repository.tools.AbstractApplication;
import org.eclipse.equinox.p2.internal.repository.tools.Activator;
import org.eclipse.equinox.p2.internal.repository.tools.Messages;
import org.eclipse.equinox.p2.internal.repository.tools.SlicingOptions;

public class MirrorApplication
extends AbstractApplication {
    private static final String LOG_ROOT = "p2.mirror";
    protected SlicingOptions slicingOptions = new SlicingOptions();
    private URI baseline;
    private String comparatorID;
    private boolean compare = false;
    private boolean failOnError = true;
    private boolean raw = true;
    private boolean verbose = false;
    private boolean validate = false;
    private File mirrorLogFile;
    private File comparatorLogFile;
    private IArtifactMirrorLog mirrorLog;
    private IArtifactMirrorLog comparatorLog;
    static /* synthetic */ Class class$0;

    public Object start(IApplicationContext context) throws Exception {
        this.run(null);
        return IApplication.EXIT_OK;
    }

    public IStatus run(IProgressMonitor monitor) throws ProvisionException {
        IStatus mirrorStatus = Status.OK_STATUS;
        try {
            this.initializeRepos((IProgressMonitor)new NullProgressMonitor());
            this.initializeLogs();
            this.validate();
            this.initializeIUs();
            IQueryable slice = this.slice((IProgressMonitor)new NullProgressMonitor());
            if (this.destinationArtifactRepository != null && (mirrorStatus = this.mirrorArtifacts(slice, (IProgressMonitor)new NullProgressMonitor())).getSeverity() == 4) {
                IStatus iStatus = mirrorStatus;
                return iStatus;
            }
            if (this.destinationMetadataRepository != null) {
                this.mirrorMetadata(slice, (IProgressMonitor)new NullProgressMonitor());
            }
        }
        finally {
            this.finalizeRepositories();
            this.finalizeLogs();
        }
        if (mirrorStatus.isOK()) {
            return Status.OK_STATUS;
        }
        return mirrorStatus;
    }

    private IStatus mirrorArtifacts(IQueryable slice, IProgressMonitor monitor) throws ProvisionException {
        Collector ius = slice.query((Query)InstallableUnitQuery.ANY, new Collector(), monitor);
        ArrayList<IArtifactKey> keys = new ArrayList<IArtifactKey>(ius.size());
        Iterator iterator = ius.iterator();
        while (iterator.hasNext()) {
            IInstallableUnit iu = (IInstallableUnit)iterator.next();
            IArtifactKey[] iuKeys = iu.getArtifacts();
            int i = 0;
            while (i < iuKeys.length) {
                keys.add(iuKeys[i]);
                ++i;
            }
        }
        Mirroring mirror = new Mirroring(this.getCompositeArtifactRepository(), this.destinationArtifactRepository, this.raw);
        mirror.setCompare(this.compare);
        mirror.setComparatorId(this.comparatorID);
        mirror.setBaseline(this.initializeBaseline());
        mirror.setValidate(this.validate);
        if (keys.size() > 0) {
            mirror.setArtifactKeys(keys.toArray(new IArtifactKey[keys.size()]));
        }
        if (this.comparatorLog != null) {
            mirror.setComparatorLog(this.comparatorLog);
        }
        MultiStatus result = mirror.run(this.failOnError, this.verbose);
        if (this.mirrorLog != null) {
            this.mirrorLog.log((IStatus)result);
        } else {
            LogHelper.log((IStatus)result);
        }
        return result;
    }

    private IArtifactRepository initializeBaseline() throws ProvisionException {
        if (this.baseline == null) {
            return null;
        }
        return this.addRepository(Activator.getArtifactRepositoryManager(), this.baseline, 0, null);
    }

    private void mirrorMetadata(IQueryable slice, IProgressMonitor monitor) {
        Collector allIUs = slice.query((Query)InstallableUnitQuery.ANY, new Collector(), monitor);
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.equinox.internal.provisional.p2.metadata.IInstallableUnit");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.destinationMetadataRepository.addInstallableUnits((IInstallableUnit[])allIUs.toArray((Class)clazz));
    }

    private void validate() throws ProvisionException {
        if (this.sourceRepositories.isEmpty()) {
            throw new ProvisionException(Messages.MirrorApplication_set_source_repositories);
        }
        if (!this.hasArtifactSources() && this.destinationArtifactRepository != null) {
            throw new ProvisionException(Messages.MirrorApplication_artifactDestinationNoSource);
        }
        if (!this.hasMetadataSources() && this.destinationMetadataRepository != null) {
            throw new ProvisionException(Messages.MirrorApplication_metadataDestinationNoSource);
        }
    }

    private void initializeIUs() throws ProvisionException {
        if (this.sourceIUs == null || this.sourceIUs.isEmpty()) {
            this.sourceIUs = new ArrayList();
            IMetadataRepository metadataRepo = this.getCompositeMetadataRepository();
            Collector collector = metadataRepo.query((Query)InstallableUnitQuery.ANY, new Collector(), null);
            Iterator iter = collector.iterator();
            while (iter.hasNext()) {
                IInstallableUnit iu = (IInstallableUnit)iter.next();
                this.sourceIUs.add(iu);
            }
            if (collector.size() == 0 && this.destinationMetadataRepository != null) {
                throw new ProvisionException(Messages.MirrorApplication_no_IUs);
            }
        }
    }

    private void initializeLogs() {
        if (this.compare && this.comparatorLogFile != null) {
            this.comparatorLog = this.getLog(this.comparatorLogFile, this.comparatorID);
        }
        if (this.mirrorLog == null && this.mirrorLogFile != null) {
            this.mirrorLog = this.getLog(this.mirrorLogFile, LOG_ROOT);
        }
    }

    private void finalizeLogs() {
        if (this.comparatorLog != null) {
            this.comparatorLog.close();
        }
        if (this.mirrorLog != null) {
            this.mirrorLog.close();
        }
    }

    private IArtifactMirrorLog getLog(File location, String root) {
        String absolutePath = location.getAbsolutePath();
        if (absolutePath.toLowerCase().endsWith(".xml")) {
            return new XMLMirrorLog(absolutePath, 0, root);
        }
        return new FileMirrorLog(absolutePath, 0, root);
    }

    private IQueryable slice(IProgressMonitor monitor) throws ProvisionException {
        if (this.slicingOptions == null) {
            this.slicingOptions = new SlicingOptions();
        }
        PermissiveSlicer slicer = new PermissiveSlicer((IQueryable)this.getCompositeMetadataRepository(), this.slicingOptions.getFilter(), this.slicingOptions.includeOptionalDependencies(), this.slicingOptions.isEverythingGreedy(), this.slicingOptions.forceFilterTo(), this.slicingOptions.considerStrictDependencyOnly(), this.slicingOptions.followOnlyFilteredRequirements());
        IQueryable slice = slicer.slice(this.sourceIUs.toArray(new IInstallableUnit[this.sourceIUs.size()]), monitor);
        if (slicer.getStatus().getSeverity() != 0 && this.mirrorLog != null) {
            this.mirrorLog.log((IStatus)slicer.getStatus());
        }
        if (slice == null) {
            throw new ProvisionException((IStatus)slicer.getStatus());
        }
        return slice;
    }

    public void setSlicingOptions(SlicingOptions options) {
        this.slicingOptions = options;
    }

    public void setBaseline(URI baseline) {
        this.baseline = baseline;
        this.compare = true;
    }

    public void setComparatorID(String value) {
        this.comparatorID = value;
        this.compare = true;
    }

    public void setCompare(boolean value) {
        this.compare = value;
    }

    public void setIgnoreErrors(boolean value) {
        this.failOnError = !value;
    }

    public void setRaw(boolean value) {
        this.raw = value;
    }

    public void setVerbose(boolean value) {
        this.verbose = value;
    }

    public void setComparatorLog(File comparatorLog) {
        this.comparatorLogFile = comparatorLog;
    }

    public void setLog(File mirrorLog) {
        this.mirrorLogFile = mirrorLog;
    }

    public void setLog(IArtifactMirrorLog log) {
        this.mirrorLog = log;
    }

    public void setValidate(boolean value) {
        this.validate = value;
    }
}

