/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.effects.utility;

import ch.kuramo.javie.api.IAnimatableInteger;
import ch.kuramo.javie.api.IAnimatableValue;
import ch.kuramo.javie.api.IVideoBuffer;
import ch.kuramo.javie.api.Resolution;
import ch.kuramo.javie.api.VideoBounds;
import ch.kuramo.javie.api.annotations.Effect;
import ch.kuramo.javie.api.annotations.Property;
import ch.kuramo.javie.api.services.IVideoEffectContext;
import ch.kuramo.javie.api.services.IVideoRenderSupport;
import com.google.inject.Inject;

@Effect(id="ch.kuramo.javie.ChangeBounds", category="ch.kuramo.javie.api.effectCategory.utility")
public class ChangeBounds {
    @Property(max="1000")
    private IAnimatableInteger left;
    @Property(max="1000")
    private IAnimatableInteger top;
    @Property(max="1000")
    private IAnimatableInteger right;
    @Property(max="1000")
    private IAnimatableInteger bottom;
    private final IVideoEffectContext context;
    private final IVideoRenderSupport support;

    @Inject
    public ChangeBounds(IVideoEffectContext context, IVideoRenderSupport support) {
        this.context = context;
        this.support = support;
    }

    private VideoBounds calcNewBounds(VideoBounds oldBounds) {
        Resolution resolution = this.context.getVideoResolution();
        int left = (int)resolution.scale((double)((Integer)this.context.value((IAnimatableValue)this.left)).intValue());
        int top = (int)resolution.scale((double)((Integer)this.context.value((IAnimatableValue)this.top)).intValue());
        int right = (int)resolution.scale((double)((Integer)this.context.value((IAnimatableValue)this.right)).intValue());
        int bottom = (int)resolution.scale((double)((Integer)this.context.value((IAnimatableValue)this.bottom)).intValue());
        VideoBounds newBounds = new VideoBounds(oldBounds.x - (double)left, oldBounds.y - (double)top, Math.max(0, oldBounds.width + left + right), Math.max(0, oldBounds.height + top + bottom));
        return newBounds;
    }

    public VideoBounds getVideoBounds() {
        return this.calcNewBounds(this.context.getPreviousBounds());
    }

    public IVideoBuffer doVideoEffect() {
        final IVideoBuffer input = this.context.doPreviousEffect();
        VideoBounds oldBounds = input.getBounds();
        VideoBounds newBounds = this.calcNewBounds(oldBounds);
        if (newBounds.equals((Object)oldBounds)) {
            return input;
        }
        if (newBounds.isEmpty()) {
            input.dispose();
            return this.context.createVideoBuffer(newBounds);
        }
        IVideoBuffer buffer = null;
        try {
            final IVideoBuffer output = buffer = this.context.createVideoBuffer(newBounds);
            Runnable operation = new Runnable(){

                public void run() {
                    ChangeBounds.this.support.ortho2D(output);
                    ChangeBounds.this.support.quad2D(output, new IVideoBuffer[]{input});
                }
            };
            this.support.useFramebuffer(operation, 0, output, new IVideoBuffer[]{input});
            buffer = null;
            IVideoBuffer iVideoBuffer = output;
            return iVideoBuffer;
        }
        finally {
            input.dispose();
            if (buffer != null) {
                buffer.dispose();
            }
        }
    }
}

