/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.effects.transition;

import ch.kuramo.javie.api.IAnimatableBoolean;
import ch.kuramo.javie.api.IAnimatableDouble;
import ch.kuramo.javie.api.IAnimatableEnum;
import ch.kuramo.javie.api.IAnimatableLayerReference;
import ch.kuramo.javie.api.IAnimatableValue;
import ch.kuramo.javie.api.IShaderProgram;
import ch.kuramo.javie.api.IVideoBuffer;
import ch.kuramo.javie.api.VideoBounds;
import ch.kuramo.javie.api.annotations.Effect;
import ch.kuramo.javie.api.annotations.Property;
import ch.kuramo.javie.api.annotations.ShaderSource;
import ch.kuramo.javie.api.services.IShaderRegistry;
import ch.kuramo.javie.api.services.IVideoEffectContext;
import ch.kuramo.javie.api.services.IVideoRenderSupport;
import com.google.inject.Inject;
import java.util.HashSet;
import javax.media.opengl.GLUniformData;

@Effect(id="ch.kuramo.javie.GradientWipe", category="ch.kuramo.javie.api.effectCategory.transition")
public class GradientWipe {
    @ShaderSource
    public static final String[] GRADIENT_WIPE_NORMAL = GradientWipe.createShaderSource(false);
    @ShaderSource
    public static final String[] GRADIENT_WIPE_INVERT = GradientWipe.createShaderSource(true);
    @Property(min="0", max="100")
    private IAnimatableDouble transitionCompletion;
    @Property(min="0", max="100")
    private IAnimatableDouble transitionSoftness;
    @Property
    private IAnimatableLayerReference gradientLayer;
    @Property(value="STRETCH")
    private IAnimatableEnum<GradientPlacement> gradientPlacement;
    @Property
    private IAnimatableBoolean invertGradient;
    private final IVideoEffectContext context;
    private final IVideoRenderSupport support;
    private final IShaderProgram normalProgram;
    private final IShaderProgram invertProgram;
    private static /* synthetic */ int[] $SWITCH_TABLE$ch$kuramo$javie$effects$transition$GradientWipe$GradientPlacement;

    private static String[] createShaderSource(boolean invert) {
        return new String[]{"uniform sampler2D srcTex;", "uniform sampler2D grdTex;", "uniform float min;", "uniform float max;", "", "const vec3 yvec = vec3(0.299, 0.587, 0.114);", "", "void main(void)", "{", "\tvec4 src = texture2D(srcTex, gl_TexCoord[0].st);", "\tvec4 grd = texture2D(grdTex, gl_TexCoord[1].st);", invert ? "\tfloat y = 1.0 - dot(grd.rgb, yvec);" : "\tfloat y = dot(grd.rgb, yvec);", "\tfloat a = clamp((y-min)/(max-min), 0.0, 1.0);", "\tgl_FragColor = src*a;", "}"};
    }

    @Inject
    public GradientWipe(IVideoEffectContext context, IVideoRenderSupport support, IShaderRegistry shaders) {
        this.context = context;
        this.support = support;
        this.normalProgram = shaders.getProgram(GradientWipe.class, "GRADIENT_WIPE_NORMAL");
        this.invertProgram = shaders.getProgram(GradientWipe.class, "GRADIENT_WIPE_INVERT");
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IVideoBuffer doVideoEffect() {
        completion = (Double)this.context.value((IAnimatableValue)this.transitionCompletion) / 100.0;
        if (completion == 1.0) {
            buffer = this.context.createVideoBuffer(this.context.getPreviousBounds());
            buffer.clear();
            return buffer;
        }
        input = this.context.doPreviousEffect();
        if (completion == 0.0) {
            return input;
        }
        bounds = input.getBounds();
        if (bounds.isEmpty()) {
            return input;
        }
        tmpBuffers = new HashSet<IVideoBuffer>();
        tmpBuffers.add(input);
        try {
            softness = (Double)this.context.value((IAnimatableValue)this.transitionSoftness) / 100.0;
            placement = (GradientPlacement)this.context.value(this.gradientPlacement);
            invert = (Boolean)this.context.value((IAnimatableValue)this.invertGradient);
            max = (1.0 + softness) * completion;
            min = max - softness;
            gradient = this.context.getLayerVideoFrame(this.gradientLayer);
            if (gradient == null) {
                gradient = this.context.createVideoBuffer(new VideoBounds(0, 0));
                gradient.clear();
            }
            tmpBuffers.add(gradient);
            gradBounds = gradient.getBounds();
            texCoords = new double[2][][];
            texCoords[0] = new double[][]{{0.0, 0.0}, {1.0, 0.0}, {1.0, 1.0}, {0.0, 1.0}};
            w = bounds.width;
            h = bounds.height;
            gw = gradBounds.width;
            gh = gradBounds.height;
            switch (GradientWipe.$SWITCH_TABLE$ch$kuramo$javie$effects$transition$GradientWipe$GradientPlacement()[placement.ordinal()]) {
                case 2: {
                    s = (double)(gw - w) / 2.0;
                    t = (double)(gh - h) / 2.0;
                    s0 = s / (double)gw;
                    t0 = t / (double)gh;
                    s1 = (s + (double)w) / (double)gw;
                    t1 = (t + (double)h) / (double)gh;
                    texCoords[1] = new double[][]{{s0, t0}, {s1, t0}, {s1, t1}, {s0, t1}};
                    break;
                }
                case 3: {
                    texCoords[1] = new double[][]{{0.0, 0.0}, {1.0, 0.0}, {1.0, 1.0}, {0.0, 1.0}};
                    gradient.setTextureFilter(IVideoBuffer.TextureFilter.LINEAR);
                    break;
                }
                case 1: {
                    s = (double)w / (double)gw;
                    t = (double)h / (double)gh;
                    texCoords[1] = new double[][]{{0.0, 0.0}, {s, 0.0}, {s, t}, {0.0, t}};
                    gradient.setTextureWrapMode(IVideoBuffer.TextureWrapMode.REPEAT);
                    break;
                }
            }
            program = invert != false ? this.invertProgram : this.normalProgram;
            uniforms = new HashSet<GLUniformData>();
            uniforms.add(new GLUniformData("srcTex", 0));
            uniforms.add(new GLUniformData("grdTex", 1));
            uniforms.add(new GLUniformData("min", (float)min));
            uniforms.add(new GLUniformData("max", (float)max));
            operation = new Runnable(){

                public void run() {
                    GradientWipe.this.support.ortho2D(bounds);
                    GradientWipe.this.support.quad2D(bounds, texCoords);
                }
            };
            var34_27 = this.support.useShaderProgram(program, uniforms, operation, 0, null, new IVideoBuffer[]{input, gradient});
            return var34_27;
        }
        finally {
            ** for (vb : tmpBuffers)
        }
lbl-1000:
        // 1 sources

        {
            vb.dispose();
            continue;
        }
lbl71:
        // 1 sources

        return var34_27;
    }

    static /* synthetic */ int[] $SWITCH_TABLE$ch$kuramo$javie$effects$transition$GradientWipe$GradientPlacement() {
        if ($SWITCH_TABLE$ch$kuramo$javie$effects$transition$GradientWipe$GradientPlacement != null) {
            return $SWITCH_TABLE$ch$kuramo$javie$effects$transition$GradientWipe$GradientPlacement;
        }
        int[] nArray = new int[GradientPlacement.values().length];
        try {
            nArray[GradientPlacement.CENTER.ordinal()] = 2;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[GradientPlacement.STRETCH.ordinal()] = 3;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[GradientPlacement.TILE.ordinal()] = 1;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        $SWITCH_TABLE$ch$kuramo$javie$effects$transition$GradientWipe$GradientPlacement = nArray;
        return nArray;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum GradientPlacement {
        TILE,
        CENTER,
        STRETCH;

    }
}

