/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.effects.stylize;

import ch.kuramo.javie.api.IAnimatableInteger;
import ch.kuramo.javie.api.IAnimatableValue;
import ch.kuramo.javie.api.IShaderProgram;
import ch.kuramo.javie.api.IVideoBuffer;
import ch.kuramo.javie.api.VideoBounds;
import ch.kuramo.javie.api.annotations.Effect;
import ch.kuramo.javie.api.annotations.Property;
import ch.kuramo.javie.api.annotations.ShaderSource;
import ch.kuramo.javie.api.services.IShaderRegistry;
import ch.kuramo.javie.api.services.IVideoEffectContext;
import ch.kuramo.javie.api.services.IVideoRenderSupport;
import com.google.inject.Inject;
import java.util.HashSet;
import javax.media.opengl.GLUniformData;

@Effect(id="ch.kuramo.javie.Posterize", category="ch.kuramo.javie.api.effectCategory.stylize")
public class Posterize {
    @Property(value="7", min="2", max="256")
    private IAnimatableInteger level;
    private final IVideoEffectContext context;
    private final IVideoRenderSupport support;
    private final IShaderProgram program;
    @ShaderSource
    public static final String[] POSTERIZE = new String[]{"uniform sampler2D texture;", "uniform float level;", "", "void main(void)", "{", "\tvec4 color = texture2D(texture, gl_TexCoord[0].st);", "\tgl_FragColor = floor(color * level + vec4(0.5)) / level;", "}"};

    @Inject
    public Posterize(IVideoEffectContext context, IVideoRenderSupport support, IShaderRegistry shaders) {
        this.context = context;
        this.support = support;
        this.program = shaders.getProgram(Posterize.class, "POSTERIZE");
    }

    public IVideoBuffer doVideoEffect() {
        IVideoBuffer source = this.context.doPreviousEffect();
        VideoBounds bounds = source.getBounds();
        if (bounds.isEmpty()) {
            return source;
        }
        int level = (Integer)this.context.value((IAnimatableValue)this.level);
        if (level >= 256) {
            return source;
        }
        try {
            HashSet<GLUniformData> uniforms = new HashSet<GLUniformData>();
            uniforms.add(new GLUniformData("texture", 0));
            uniforms.add(new GLUniformData("level", (float)(level - 1)));
            IVideoBuffer iVideoBuffer = this.support.useShaderProgram(this.program, uniforms, null, new IVideoBuffer[]{source});
            return iVideoBuffer;
        }
        finally {
            source.dispose();
        }
    }
}

