/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.effects.simulation;

import ch.kuramo.javie.api.Color;
import ch.kuramo.javie.api.IAnimatableDouble;
import ch.kuramo.javie.api.IAnimatableEnum;
import ch.kuramo.javie.api.IAnimatableValue;
import ch.kuramo.javie.api.IAnimatableVec2d;
import ch.kuramo.javie.api.IArray;
import ch.kuramo.javie.api.ICamera;
import ch.kuramo.javie.api.IShaderProgram;
import ch.kuramo.javie.api.IVideoBuffer;
import ch.kuramo.javie.api.Resolution;
import ch.kuramo.javie.api.ShaderType;
import ch.kuramo.javie.api.Size2i;
import ch.kuramo.javie.api.Vec2d;
import ch.kuramo.javie.api.VideoBounds;
import ch.kuramo.javie.api.annotations.Effect;
import ch.kuramo.javie.api.annotations.Property;
import ch.kuramo.javie.api.annotations.ShaderSource;
import ch.kuramo.javie.api.services.IAntiAliasSupport;
import ch.kuramo.javie.api.services.IArrayPools;
import ch.kuramo.javie.api.services.IShaderRegistry;
import ch.kuramo.javie.api.services.IVideoEffectContext;
import ch.kuramo.javie.api.services.IVideoRenderSupport;
import com.google.inject.Inject;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.util.HashSet;
import java.util.Set;
import javax.media.opengl.GL2;
import javax.media.opengl.GLUniformData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Effect(id="ch.kuramo.javie.Shatter", category="ch.kuramo.javie.api.effectCategory.simulation")
public class Shatter {
    @Property(value="RECTANGLE")
    private IAnimatableEnum<Pattern> pattern;
    @Property
    private IAnimatableDouble patternDirection;
    @Property
    private IAnimatableVec2d patternOrigin;
    @Property(value="30,30", min="1")
    private IAnimatableVec2d fragmentSize;
    @Property(value="0.1", min="0", max="1")
    private IAnimatableDouble randomness;
    @Property(value="3", min="0")
    private IAnimatableDouble rotationSpeed;
    @Property(value="3", min="0")
    private IAnimatableDouble gravity;
    @Property(value="180")
    private IAnimatableDouble gravityDirection;
    @Property(value="0", min="-90", max="90")
    private IAnimatableDouble gravityInclination;
    @Property(value="COMPOSITION_TIME")
    private IAnimatableEnum<TimeBase> timeBase;
    @Property
    private IAnimatableDouble time;
    @Property
    private IAnimatableDouble force1Time;
    @Property
    private IAnimatableVec2d force1Position;
    @Property(value="200", min="0")
    private IAnimatableDouble force1Radius;
    @Property(value="0.5", min="0")
    private IAnimatableDouble force1Delay;
    @Property(value="300")
    private IAnimatableDouble force1Strength;
    @Property
    private IAnimatableDouble force1Decay;
    @Property(value="45", min="0", max="90")
    private IAnimatableDouble force1Spread;
    @Property
    private IAnimatableEnum<CameraSystem> cameraSystem;
    @Property
    private IAnimatableDouble cameraRotationX;
    @Property
    private IAnimatableDouble cameraRotationY;
    @Property
    private IAnimatableDouble cameraRotationZ;
    @Property
    private IAnimatableVec2d cameraPositionXY;
    @Property
    private IAnimatableDouble cameraPositionZ;
    @Property(value="100", min="0")
    private IAnimatableDouble cameraZoom;
    @Property(value="10", min="0")
    private IAnimatableDouble cameraNear;
    @Property(value="100000", min="0")
    private IAnimatableDouble cameraFar;
    private final IVideoEffectContext context;
    private final IVideoRenderSupport support;
    private final IAntiAliasSupport aaSupport;
    private final IArrayPools arrayPools;
    private final IShaderProgram program;
    @ShaderSource(type=ShaderType.VERTEX_SHADER, program=false)
    public static final String[] vertex_shader = new String[]{"const vec2 randVec = vec2(12.9898, 78.233);", "", "float rand1(vec2 coord, float seed)", "{", "\treturn fract(sin(dot(coord, randVec) + seed) * 43758.5453);", "}", "", "vec3 rand3(vec2 coord, float seed)", "{", "\tfloat x = fract(sin(dot(coord, randVec) + seed) * 43758.5453);", "\tfloat y = fract(sin(dot(coord, randVec*2.0) + seed) * 43758.5453);", "\tfloat z = fract(sin(dot(coord, randVec*3.0) + seed) * 43758.5453);", "\treturn vec3(x, y, z);", "}", "", "mat3 selfRotMat(vec3 axis, float rad)", "{", "\tfloat a = axis.x;", "\tfloat b = axis.y;", "\tfloat c = axis.z;", "\tfloat cos = cos(rad);", "\tfloat sin = sin(rad);", "\tfloat omc = 1.0-cos;", "", "\tfloat a2_omc = a*a*omc;", "\tfloat ab_omc = a*b*omc;", "\tfloat ac_omc = a*c*omc;", "\tfloat b2_omc = b*b*omc;", "\tfloat bc_omc = b*c*omc;", "\tfloat c2_omc = c*c*omc;", "\tfloat asin = a*sin;", "\tfloat bsin = b*sin;", "\tfloat csin = c*sin;", "", "\treturn mat3(", "\t\ta2_omc+cos , ab_omc-csin, ac_omc+bsin,", "\t\tab_omc+csin, b2_omc+cos , bc_omc-asin,", "\t\tac_omc-bsin, bc_omc+asin, c2_omc+cos", "\t);", "}", "", "attribute vec2 vertOffset;", "attribute vec2 fragCenter;", "", "uniform vec2 texOffset;", "uniform vec2 texSize;", "uniform vec2 patOrigin;", "uniform mat2 patDirMat;", "", "uniform float randomness;", "uniform float rotationSpeed;", "uniform vec3 gravity;", "", "uniform int numOfForces;", "uniform float forceTime[3];", "uniform vec2 forcePosition[3];", "uniform float forceRadius[3];", "uniform float forceDelay[3];", "uniform float forceStrength[3];", "uniform float forceDecay[3];", "uniform float forceDepth[3];", "", "uniform float resolution;", "", "void main(void)", "{", "\tvec2 pos0 = patDirMat*(vertOffset+fragCenter-patOrigin)+patOrigin;", "\tvec2 fc = patDirMat*(fragCenter-patOrigin)+patOrigin;", "\tvec2 rc = (fragCenter-patOrigin) / resolution;", "", "\tfloat t = 0.0;", "\tvec3 v = vec3(0.0);", "", "\tfor (int i = 0; i < numOfForces; ++i) {", "\t\tfloat ft  = forceTime[i];", "\t\tvec2  fp  = forcePosition[i];", "\t\tfloat fr  = forceRadius[i];", "\t\tfloat fdl = forceDelay[i];", "\t\tfloat fs  = forceStrength[i];", "\t\tfloat fdc = forceDecay[i];", "\t\tfloat fdp = forceDepth[i];", "", "\t\tvec2 fragCenterFromFp = fc - fp;", "\t\tfloat distance = length(fragCenterFromFp);", "\t\tfloat arrivalTime;", "\t\tfloat arrivalStrength;", "", "\t\tif (distance > fr) {", "\t\t\tarrivalTime = ft;", "\t\t\tarrivalStrength = 0.0;", "\t\t} else {", "\t\t\tfloat p = distance / fr;", "\t\t\tfloat p3 = p*p*p;", "\t\t\tarrivalTime = fdl * p3;", "\t\t\tarrivalStrength = fs - fdc * p3;", "\t\t\tif (arrivalStrength * fs < 0.0) {", "\t\t\t\tarrivalStrength = 0.0;", "\t\t\t}", "\t\t}", "", "\t\tfloat afterArrival = max(0.0, ft - arrivalTime);", "\t\tif (afterArrival > t) {", "\t\t\tt = afterArrival;", "\t\t\tv = arrivalStrength * (fdp < 0.0 ? vec3(0.0, 0.0, -1.0) : normalize(vec3(fragCenterFromFp, -fdp)));", "\t\t}", "\t}", "", "\tvec3 pos1 = vec3(pos0 - fc, 0.0);", "", "\tv += length(v)*randomness*normalize(4.0*rand3(rc, 1.0)-2.0);", "", "\tvec3 selfRotAxis = cross(v, vec3(0.0, 0.0, -1.0));", "\tif (length(selfRotAxis) > 0.0) {", "\t\tfloat rs = rotationSpeed*(1.0+randomness*(4.0*rand1(rc, 2.0)-2.0));", "\t\tpos1 = selfRotMat(normalize(selfRotAxis), t*rs) * pos1;", "\t}", "", "\tvec3 pos2 = pos1 + vec3(fc, 0.0) + v*t + t*t*gravity;", "\tgl_Position = gl_ModelViewProjectionMatrix * vec4(pos2, 1.0);", "", "\tgl_TexCoord[0] = vec4((pos0 + texOffset) / texSize, 0.0, 1.0);", "}"};
    @ShaderSource(attach={"vertex_shader"})
    public static final String[] SHATTER = new String[]{"uniform sampler2D texture;", "", "void main(void)", "{", "\tvec4 color = texture2D(texture, gl_TexCoord[0].st);", "\tif (color.a == 0.0) discard;", "\tgl_FragColor = color;", "}"};

    @Inject
    public Shatter(IVideoEffectContext context, IVideoRenderSupport support, IAntiAliasSupport aaSupport, IArrayPools arrayPools, IShaderRegistry shaders) {
        this.context = context;
        this.support = support;
        this.aaSupport = aaSupport;
        this.arrayPools = arrayPools;
        this.program = shaders.getProgram(Shatter.class, "SHATTER");
    }

    public IVideoBuffer doVideoEffect() {
        IVideoBuffer input = this.context.doPreviousEffect();
        VideoBounds bounds = input.getBounds();
        if (bounds.isEmpty()) {
            return input;
        }
        Resolution resolution = this.context.getVideoResolution();
        double patDir = (Double)this.context.value((IAnimatableValue)this.patternDirection);
        Vec2d patOrigin = resolution.scale((Vec2d)this.context.value((IAnimatableValue)this.patternOrigin));
        Vec2d fragSize = resolution.scale((Vec2d)this.context.value((IAnimatableValue)this.fragmentSize));
        if ((patDir %= 360.0) < 0.0) {
            patDir += 360.0;
        }
        double patDirRad = Math.toRadians(patDir);
        double[] b2 = this.rotate(bounds, patOrigin, -patDirRad);
        int i1 = (int)Math.ceil((b2[0] - (patOrigin.x + fragSize.x / 2.0)) / fragSize.x);
        int j1 = (int)Math.ceil((b2[1] - (patOrigin.y + fragSize.y / 2.0)) / fragSize.y);
        int i2 = (int)Math.ceil((b2[2] - (patOrigin.x + fragSize.x / 2.0)) / fragSize.x);
        int j2 = (int)Math.ceil((b2[3] - (patOrigin.y + fragSize.y / 2.0)) / fragSize.y);
        IArray<float[]> attribs = null;
        try {
            int primitiveType;
            switch ((Pattern)((Object)this.context.value(this.pattern))) {
                case RECTANGLE: {
                    attribs = this.rectangle(fragSize, patOrigin, i1, j1, i2, j2);
                    primitiveType = 7;
                    break;
                }
                case BRICK: {
                    attribs = this.brickOrHexagon(true, fragSize, patOrigin, i1, j1, i2, j2);
                    primitiveType = 4;
                    break;
                }
                case HEXAGON: {
                    attribs = this.brickOrHexagon(false, fragSize, patOrigin, i1, j1, i2, j2);
                    primitiveType = 4;
                    break;
                }
                case OCTAGON_AND_DIAMOND: {
                    attribs = this.octagonAndDiamond(fragSize, patOrigin, i1, j1, i2, j2);
                    primitiveType = 4;
                    break;
                }
                default: {
                    throw new RuntimeException("unknown Pattern: " + this.pattern);
                }
            }
            input.setTextureFilter(IVideoBuffer.TextureFilter.LINEAR);
            IVideoBuffer iVideoBuffer = this.doShatter(input, attribs, primitiveType, patOrigin, patDirRad);
            return iVideoBuffer;
        }
        finally {
            input.dispose();
            if (attribs != null) {
                attribs.release();
            }
        }
    }

    private IArray<float[]> rectangle(Vec2d size, Vec2d origin, int i1, int j1, int i2, int j2) {
        double halfX = size.x / 2.0;
        double halfY = size.y / 2.0;
        float[][] pt = new float[][]{{(float)(-halfX), (float)(-halfY)}, {(float)halfX, (float)(-halfY)}, {(float)halfX, (float)halfY}, {(float)(-halfX), (float)halfY}};
        int numOfFragments = (i2 - i1 + 1) * (j2 - j1 + 1);
        IArray data = this.arrayPools.getFloatArray(numOfFragments * 4 * 4);
        float[] array = (float[])data.getArray();
        int j = j1;
        int k = 0;
        while (j <= j2) {
            int i = i1;
            while (i <= i2) {
                float x = (float)(origin.x + size.x * (double)i);
                float y = (float)(origin.y + size.y * (double)j);
                int h = 0;
                while (h < 4) {
                    array[k++] = pt[h][0];
                    array[k++] = pt[h][1];
                    array[k++] = x;
                    array[k++] = y;
                    ++h;
                }
                ++i;
            }
            ++j;
        }
        return data;
    }

    private IArray<float[]> brickOrHexagon(boolean brick, Vec2d size, Vec2d origin, int i1, int j1, int i2, int j2) {
        float[][] pt;
        ++i2;
        double halfX = size.x / 2.0;
        if (brick) {
            double halfY = size.y / 2.0;
            pt = new float[][]{{(float)(-halfX), (float)(-halfY)}, {0.0f, (float)(-halfY)}, {(float)halfX, (float)(-halfY)}, {(float)halfX, (float)halfY}, {0.0f, (float)halfY}, {(float)(-halfX), (float)halfY}, {(float)(-halfX), (float)(-halfY)}};
        } else {
            --j1;
            ++j2;
            double sizeY13 = size.y * 1.0 / 3.0;
            double sizeY23 = size.y * 2.0 / 3.0;
            pt = new float[][]{{0.0f, (float)(-sizeY23)}, {(float)halfX, (float)(-sizeY13)}, {(float)halfX, (float)sizeY13}, {0.0f, (float)sizeY23}, {(float)(-halfX), (float)sizeY13}, {(float)(-halfX), (float)(-sizeY13)}, {0.0f, (float)(-sizeY23)}};
        }
        int numOfFragments = (i2 - i1 + 1) * (j2 - j1 + 1);
        IArray data = this.arrayPools.getFloatArray(numOfFragments * 6 * 3 * 4);
        float[] array = (float[])data.getArray();
        int j = j1;
        int k = 0;
        while (j <= j2) {
            double offsetX = j % 2 != 0 ? -halfX : 0.0;
            int i = i1;
            while (i <= i2) {
                float x = (float)(origin.x + size.x * (double)i + offsetX);
                float y = (float)(origin.y + size.y * (double)j);
                int h = 0;
                while (h < 6) {
                    array[k++] = 0.0f;
                    array[k++] = 0.0f;
                    array[k++] = x;
                    array[k++] = y;
                    array[k++] = pt[h][0];
                    array[k++] = pt[h][1];
                    array[k++] = x;
                    array[k++] = y;
                    array[k++] = pt[h + 1][0];
                    array[k++] = pt[h + 1][1];
                    array[k++] = x;
                    array[k++] = y;
                    ++h;
                }
                ++i;
            }
            ++j;
        }
        return data;
    }

    private IArray<float[]> octagonAndDiamond(Vec2d size, Vec2d origin, int i1, int j1, int i2, int j2) {
        ++i2;
        ++j2;
        double theta = Math.atan2(size.y, size.x);
        double cos = Math.cos(theta);
        double sin = Math.sin(theta);
        double p = size.x / (1.0 + 2.0 * cos);
        double q = size.y / (1.0 + 2.0 * sin);
        double pcos = p * cos;
        double qsin = q * sin;
        float[][][] pt = new float[][][]{new float[][]{{(float)(-(p / 2.0)), (float)(-(q / 2.0 + qsin))}, {(float)(p / 2.0), (float)(-(q / 2.0 + qsin))}, {(float)(p / 2.0 + pcos), (float)(-(q / 2.0))}, {(float)(p / 2.0 + pcos), (float)(q / 2.0)}, {(float)(p / 2.0), (float)(q / 2.0 + qsin)}, {(float)(-(p / 2.0)), (float)(q / 2.0 + qsin)}, {(float)(-(p / 2.0 + pcos)), (float)(q / 2.0)}, {(float)(-(p / 2.0 + pcos)), (float)(-(q / 2.0))}, {(float)(-(p / 2.0)), (float)(-(q / 2.0 + qsin))}}, new float[][]{{0.0f, (float)(-qsin)}, {(float)pcos, 0.0f}, {0.0f, (float)qsin}, {(float)(-pcos), 0.0f}, {0.0f, (float)(-qsin)}}};
        int numOfFragments = (i2 - i1 + 1) * (j2 - j1 + 1);
        IArray data = this.arrayPools.getFloatArray(numOfFragments * 12 * 3 * 4);
        float[] array = (float[])data.getArray();
        double halfX = size.x / 2.0;
        double halfY = size.y / 2.0;
        int j = j1;
        int k = 0;
        while (j <= j2) {
            int i = i1;
            while (i <= i2) {
                float x = (float)(origin.x + size.x * (double)i);
                float y = (float)(origin.y + size.y * (double)j);
                int h = 0;
                while (h < 8) {
                    array[k++] = 0.0f;
                    array[k++] = 0.0f;
                    array[k++] = x;
                    array[k++] = y;
                    array[k++] = pt[0][h][0];
                    array[k++] = pt[0][h][1];
                    array[k++] = x;
                    array[k++] = y;
                    array[k++] = pt[0][h + 1][0];
                    array[k++] = pt[0][h + 1][1];
                    array[k++] = x;
                    array[k++] = y;
                    ++h;
                }
                x = (float)((double)x - halfX);
                y = (float)((double)y - halfY);
                h = 0;
                while (h < 4) {
                    array[k++] = 0.0f;
                    array[k++] = 0.0f;
                    array[k++] = x;
                    array[k++] = y;
                    array[k++] = pt[1][h][0];
                    array[k++] = pt[1][h][1];
                    array[k++] = x;
                    array[k++] = y;
                    array[k++] = pt[1][h + 1][0];
                    array[k++] = pt[1][h + 1][1];
                    array[k++] = x;
                    array[k++] = y;
                    ++h;
                }
                ++i;
            }
            ++j;
        }
        return data;
    }

    private double[] rotate(VideoBounds bounds, Vec2d origin, double rad) {
        double[][] pt = new double[][]{{bounds.x, bounds.y}, {bounds.x + (double)bounds.width, bounds.y}, {bounds.x + (double)bounds.width, bounds.y + (double)bounds.height}, {bounds.x, bounds.y + (double)bounds.height}};
        double cos = Math.cos(rad);
        double sin = Math.sin(rad);
        double[] result = new double[]{Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY};
        int i = 0;
        while (i < 4) {
            this.rotate(pt[i], origin, cos, sin);
            result[0] = Math.min(pt[i][0], result[0]);
            result[1] = Math.min(pt[i][1], result[1]);
            result[2] = Math.max(pt[i][0], result[2]);
            result[3] = Math.max(pt[i][1], result[3]);
            ++i;
        }
        return result;
    }

    private void rotate(double[] pt, Vec2d origin, double cos, double sin) {
        double x = pt[0];
        double y = pt[1];
        double x0 = origin.x;
        double y0 = origin.y;
        pt[0] = (x - x0) * cos - (y - y0) * sin + x0;
        pt[1] = (x - x0) * sin + (y - y0) * cos + y0;
    }

    private IVideoBuffer doShatter(IVideoBuffer input, final IArray<float[]> attribs, final int primitiveType, Vec2d patOrigin, double patDirRad) {
        final VideoBounds bounds = input.getBounds();
        final int[] viewport = new int[4];
        final double[] prjMatrix = new double[16];
        final double[] mvMatrix = new double[16];
        this.calcCameraParameters(bounds, viewport, prjMatrix, mvMatrix);
        IVideoBuffer buffer = null;
        try {
            Runnable operation = new Runnable(){

                public void run() {
                    final GL2 gl = Shatter.this.context.getGL().getGL2();
                    gl.glViewport(viewport[0], viewport[1], viewport[2], viewport[3]);
                    gl.glMatrixMode(5889);
                    gl.glLoadMatrixd(prjMatrix, 0);
                    gl.glMatrixMode(5888);
                    gl.glLoadMatrixd(mvMatrix, 0);
                    ByteBuffer directAttribs = ByteBuffer.allocateDirect(attribs.getLength() * 4);
                    directAttribs.order(ByteOrder.nativeOrder());
                    directAttribs.asFloatBuffer().put((float[])attribs.getArray(), 0, attribs.getLength());
                    int vertOffsetLoc = Shatter.this.program.getAttributeLocation("vertOffset");
                    int fragCenterLoc = Shatter.this.program.getAttributeLocation("fragCenter");
                    try {
                        gl.glEnableVertexAttribArray(vertOffsetLoc);
                        gl.glEnableVertexAttribArray(fragCenterLoc);
                        directAttribs.position(8);
                        gl.glVertexAttribPointer(fragCenterLoc, 2, 5126, false, 16, (Buffer)directAttribs.slice());
                        directAttribs.position(0);
                        gl.glVertexAttribPointer(vertOffsetLoc, 2, 5126, false, 16, (Buffer)directAttribs);
                        Shatter.this.aaSupport.antiAlias(bounds.width, bounds.height, true, Color.COLORLESS_TRANSPARENT, new Runnable(){

                            public void run() {
                                gl.glDrawArrays(primitiveType, 0, attribs.getLength() / 4);
                            }
                        });
                    }
                    finally {
                        gl.glDisableVertexAttribArray(vertOffsetLoc);
                        gl.glDisableVertexAttribArray(fragCenterLoc);
                    }
                }
            };
            buffer = this.context.createVideoBuffer(bounds);
            buffer.clear();
            this.support.useShaderProgram(this.program, this.prepareUniforms(bounds, patOrigin, patDirRad), operation, 0, buffer, new IVideoBuffer[]{input});
            IVideoBuffer result = buffer;
            buffer = null;
            IVideoBuffer iVideoBuffer = result;
            return iVideoBuffer;
        }
        finally {
            if (buffer != null) {
                buffer.dispose();
            }
        }
    }

    private void calcCameraParameters(VideoBounds bounds, int[] viewport, double[] prjMatrix, double[] mvMatrix) {
        CameraSystem cameraSystem = (CameraSystem)((Object)this.context.value(this.cameraSystem));
        switch (cameraSystem) {
            case LOCAL_CAMERA: {
                viewport[0] = 0;
                viewport[1] = 0;
                viewport[2] = bounds.width;
                viewport[3] = bounds.height;
                Resolution resolution = this.context.getVideoResolution();
                double cameraRotationX = (Double)this.context.value((IAnimatableValue)this.cameraRotationX);
                double cameraRotationY = (Double)this.context.value((IAnimatableValue)this.cameraRotationY);
                double cameraRotationZ = (Double)this.context.value((IAnimatableValue)this.cameraRotationZ);
                Vec2d cameraPositionXY = resolution.scale((Vec2d)this.context.value((IAnimatableValue)this.cameraPositionXY));
                double cameraPositionZ = resolution.scale(((Double)this.context.value((IAnimatableValue)this.cameraPositionZ)).doubleValue());
                double cameraZoom = resolution.scale(((Double)this.context.value((IAnimatableValue)this.cameraZoom)).doubleValue());
                double cameraFovy = Math.toDegrees(2.0 * Math.atan((double)bounds.height / (2.0 * cameraZoom)));
                double cameraAspect = (double)bounds.width / (double)bounds.height;
                double cameraNear = resolution.scale(((Double)this.context.value((IAnimatableValue)this.cameraNear)).doubleValue());
                double cameraFar = resolution.scale(((Double)this.context.value((IAnimatableValue)this.cameraFar)).doubleValue());
                GL2 gl = this.context.getGL().getGL2();
                gl.glMatrixMode(5889);
                gl.glLoadIdentity();
                this.context.getGLU().gluPerspective(cameraFovy, cameraAspect, cameraNear, cameraFar);
                gl.glMatrixMode(5888);
                gl.glLoadIdentity();
                gl.glTranslatef((float)(-cameraPositionXY.x), (float)(-cameraPositionXY.y), (float)cameraPositionZ);
                gl.glTranslatef((float)(bounds.x + (double)bounds.width / 2.0), (float)(bounds.y + (double)bounds.height / 2.0), 0.0f);
                gl.glRotatef((float)(-cameraRotationZ), 0.0f, 0.0f, 1.0f);
                gl.glRotatef((float)(-cameraRotationY), 0.0f, 1.0f, 0.0f);
                gl.glRotatef((float)(-cameraRotationX), 1.0f, 0.0f, 0.0f);
                gl.glTranslatef((float)(-(bounds.x + (double)bounds.width / 2.0)), (float)(-(bounds.y + (double)bounds.height / 2.0)), 0.0f);
                gl.glScalef(1.0f, 1.0f, -1.0f);
                gl.glGetDoublev(2983, prjMatrix, 0);
                gl.glGetDoublev(2982, mvMatrix, 0);
                break;
            }
            case COMPOSITION_CAMERA: {
                ICamera camera = this.context.getCamera();
                Size2i vpSize = camera.getViewportSize();
                viewport[0] = (bounds.width - vpSize.width) / 2;
                viewport[1] = (bounds.height - vpSize.height) / 2;
                viewport[2] = vpSize.width;
                viewport[3] = vpSize.height;
                camera.getProjectionMatrix(prjMatrix);
                camera.getModelViewMatrix(mvMatrix);
                GL2 gl = this.context.getGL().getGL2();
                gl.glMatrixMode(5888);
                gl.glLoadMatrixd(mvMatrix, 0);
                gl.glTranslatef((float)(-viewport[0]), (float)(-viewport[1]), 0.0f);
                gl.glGetDoublev(2982, mvMatrix, 0);
                break;
            }
            default: {
                throw new RuntimeException("unknown CameraSystem: " + (Object)((Object)cameraSystem));
            }
        }
    }

    private Set<GLUniformData> prepareUniforms(VideoBounds bounds, Vec2d patOrigin, double patDirRad) {
        double time;
        Resolution resolution = this.context.getVideoResolution();
        double patDirCos = Math.cos(patDirRad);
        double patDirSin = Math.sin(patDirRad);
        HashSet<GLUniformData> uniforms = new HashSet<GLUniformData>();
        uniforms.add(new GLUniformData("texture", 0));
        uniforms.add(new GLUniformData("texOffset", 2, this.toFloatBuffer(-bounds.x, -bounds.y)));
        uniforms.add(new GLUniformData("texSize", 2, this.toFloatBuffer(bounds.width, bounds.height)));
        uniforms.add(new GLUniformData("patOrigin", 2, this.toFloatBuffer(patOrigin.x, patOrigin.y)));
        uniforms.add(new GLUniformData("patDirMat", 2, 2, this.toFloatBuffer(patDirCos, patDirSin, -patDirSin, patDirCos)));
        double randomness = (Double)this.context.value((IAnimatableValue)this.randomness);
        double rotationSpeed = (Double)this.context.value((IAnimatableValue)this.rotationSpeed);
        double gravity = resolution.scale(((Double)this.context.value((IAnimatableValue)this.gravity)).doubleValue()) * 100.0;
        double gravityDirection = Math.toRadians((Double)this.context.value((IAnimatableValue)this.gravityDirection));
        double gravityInclination = Math.toRadians((Double)this.context.value((IAnimatableValue)this.gravityInclination));
        double gravityX = gravity * Math.cos(gravityInclination) * Math.sin(gravityDirection);
        double gravityY = -gravity * Math.cos(gravityInclination) * Math.cos(gravityDirection);
        double gravityZ = gravity * Math.sin(gravityInclination);
        uniforms.add(new GLUniformData("randomness", (float)randomness));
        uniforms.add(new GLUniformData("rotationSpeed", (float)rotationSpeed));
        uniforms.add(new GLUniformData("gravity", 3, this.toFloatBuffer(gravityX, gravityY, gravityZ)));
        TimeBase timeBase = (TimeBase)((Object)this.context.value(this.timeBase));
        switch (timeBase) {
            case LOCAL_TIME: {
                time = (Double)this.context.value((IAnimatableValue)this.time);
                break;
            }
            case COMPOSITION_TIME: {
                time = this.context.getTime().toSecond();
                break;
            }
            default: {
                throw new RuntimeException("unkown TimeBase: " + (Object)((Object)timeBase));
            }
        }
        float[] forceTime = new float[3];
        float[] forcePosition = new float[6];
        float[] forceRadius = new float[3];
        float[] forceDelay = new float[3];
        float[] forceStrength = new float[3];
        float[] forceDecay = new float[3];
        float[] forceDepth = new float[3];
        int i = 0;
        double ftime = (Double)this.context.value((IAnimatableValue)this.force1Time);
        Vec2d pos = resolution.scale((Vec2d)this.context.value((IAnimatableValue)this.force1Position));
        double radius = resolution.scale(((Double)this.context.value((IAnimatableValue)this.force1Radius)).doubleValue());
        double delay = (Double)this.context.value((IAnimatableValue)this.force1Delay);
        double strength = resolution.scale(((Double)this.context.value((IAnimatableValue)this.force1Strength)).doubleValue());
        double decay = resolution.scale(((Double)this.context.value((IAnimatableValue)this.force1Decay)).doubleValue());
        double spread = (Double)this.context.value((IAnimatableValue)this.force1Spread);
        forceTime[i] = (float)(time - ftime);
        forcePosition[i * 2] = (float)pos.x;
        forcePosition[i * 2 + 1] = (float)pos.y;
        forceRadius[i] = (float)radius;
        forceDelay[i] = (float)delay;
        forceStrength[i] = (float)strength;
        forceDecay[i] = (float)((double)(strength < 0.0 ? -1 : 1) * decay);
        forceDepth[i] = spread == 0.0 ? -1.0f : (float)(radius / Math.tan(Math.toRadians(spread)));
        uniforms.add(new GLUniformData("numOfForces", ++i));
        uniforms.add(new GLUniformData("forceTime[0]", 1, FloatBuffer.wrap(forceTime)));
        uniforms.add(new GLUniformData("forcePosition[0]", 2, FloatBuffer.wrap(forcePosition)));
        uniforms.add(new GLUniformData("forceRadius[0]", 1, FloatBuffer.wrap(forceRadius)));
        uniforms.add(new GLUniformData("forceDelay[0]", 1, FloatBuffer.wrap(forceDelay)));
        uniforms.add(new GLUniformData("forceStrength[0]", 1, FloatBuffer.wrap(forceStrength)));
        uniforms.add(new GLUniformData("forceDecay[0]", 1, FloatBuffer.wrap(forceDecay)));
        uniforms.add(new GLUniformData("forceDepth[0]", 1, FloatBuffer.wrap(forceDepth)));
        uniforms.add(new GLUniformData("resolution", (float)resolution.scale));
        return uniforms;
    }

    private FloatBuffer toFloatBuffer(double ... values) {
        float[] array = new float[values.length];
        int i = 0;
        while (i < values.length) {
            array[i] = (float)values[i];
            ++i;
        }
        return FloatBuffer.wrap(array);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum CameraSystem {
        LOCAL_CAMERA,
        COMPOSITION_CAMERA;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Pattern {
        RECTANGLE,
        BRICK,
        HEXAGON,
        OCTAGON_AND_DIAMOND;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum TimeBase {
        LOCAL_TIME,
        COMPOSITION_TIME;

    }
}

