/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.effects.generate;

import ch.kuramo.javie.api.BlendMode;
import ch.kuramo.javie.api.Color;
import ch.kuramo.javie.api.ColorMode;
import ch.kuramo.javie.api.IArray;
import ch.kuramo.javie.api.IVideoBuffer;
import ch.kuramo.javie.api.Quality;
import ch.kuramo.javie.api.Resolution;
import ch.kuramo.javie.api.VideoBounds;
import ch.kuramo.javie.api.services.IArrayPools;
import ch.kuramo.javie.api.services.IBlendSupport;
import ch.kuramo.javie.api.services.ITexture1DSupport;
import ch.kuramo.javie.api.services.IVideoEffectContext;
import javax.media.opengl.GL2;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class GradientBase {
    protected final IVideoEffectContext context;
    protected final IBlendSupport blendSupport;
    protected final ITexture1DSupport tex1DSupport;
    protected final IArrayPools arrayPools;

    protected GradientBase(IVideoEffectContext context, IBlendSupport blendSupport, ITexture1DSupport tex1DSupport, IArrayPools arrayPools) {
        this.context = context;
        this.blendSupport = blendSupport;
        this.tex1DSupport = tex1DSupport;
        this.arrayPools = arrayPools;
    }

    protected IVideoBuffer doGradientEffect(BlendMode blendMode, double opacity) {
        IVideoBuffer original;
        VideoBounds bounds;
        if (blendMode == BlendMode.NONE) {
            bounds = this.context.getPreviousBounds();
            original = this.context.createVideoBuffer(bounds);
        } else {
            original = this.context.doPreviousEffect();
            bounds = original.getBounds();
        }
        if (bounds.isEmpty()) {
            return original;
        }
        IVideoBuffer gradient = null;
        try {
            gradient = this.createGradient(bounds);
            if (blendMode == BlendMode.NONE && opacity == 1.0) {
                IVideoBuffer result = gradient;
                gradient = null;
                IVideoBuffer iVideoBuffer = result;
                return iVideoBuffer;
            }
            IVideoBuffer iVideoBuffer = this.blendSupport.blend(gradient, original, null, blendMode, opacity, this.context);
            return iVideoBuffer;
        }
        finally {
            if (original != null) {
                original.dispose();
            }
            if (gradient != null) {
                gradient.dispose();
            }
        }
    }

    protected abstract IVideoBuffer createGradient(VideoBounds var1);

    protected int createRGBGradientTexture(Color colorA, Color colorB, int texSize, RepeatMode repeatMode) {
        if (texSize <= 0) {
            throw new IllegalArgumentException("texSize must be greater than 0");
        }
        IArray data = null;
        try {
            data = this.arrayPools.getFloatArray(texSize * 4);
            float[] array = (float[])data.getArray();
            if (texSize == 1) {
                double a = colorA.a * 0.5 + colorB.a * 0.5;
                array[0] = (float)((colorA.r * 0.5 + colorB.r * 0.5) * a);
                array[1] = (float)((colorA.g * 0.5 + colorB.g * 0.5) * a);
                array[2] = (float)((colorA.b * 0.5 + colorB.b * 0.5) * a);
                array[3] = (float)a;
            } else {
                int i = 0;
                while (i < texSize) {
                    double t = (double)i / ((double)texSize - 1.0);
                    double a = colorA.a * (1.0 - t) + colorB.a * t;
                    array[i * 4] = (float)((colorA.r * (1.0 - t) + colorB.r * t) * a);
                    array[i * 4 + 1] = (float)((colorA.g * (1.0 - t) + colorB.g * t) * a);
                    array[i * 4 + 2] = (float)((colorA.b * (1.0 - t) + colorB.b * t) * a);
                    array[i * 4 + 3] = (float)a;
                    ++i;
                }
            }
            int n = this.createTexture((IArray<float[]>)data, repeatMode);
            return n;
        }
        finally {
            if (data != null) {
                data.release();
            }
        }
    }

    protected int createHSLGradientTexture(Color colorA, Color colorB, boolean reverseHue, int texSize, RepeatMode repeatMode) {
        if (texSize <= 0) {
            throw new IllegalArgumentException("texSize must be greater than 0");
        }
        IArray data = null;
        try {
            data = this.arrayPools.getFloatArray(texSize * 4);
            float[] array = (float[])data.getArray();
            double[] hslA = new double[3];
            double[] hslB = new double[3];
            this.rgb2hsl(colorA, hslA);
            this.rgb2hsl(colorB, hslB);
            if (reverseHue) {
                if (hslA[0] <= hslB[0]) {
                    hslA[0] = hslA[0] + 1.0;
                }
            } else if (hslA[0] > hslB[0]) {
                hslB[0] = hslB[0] + 1.0;
            }
            double[] hsl = new double[3];
            double[] rgb = new double[3];
            if (texSize == 1) {
                hsl[0] = hslA[0] * 0.5 + hslB[0] * 0.5;
                hsl[1] = hslA[1] * 0.5 + hslB[1] * 0.5;
                hsl[2] = hslA[2] * 0.5 + hslB[2] * 0.5;
                this.hsl2rgb(hsl, rgb);
                double a = colorA.a * 0.5 + colorB.a * 0.5;
                array[0] = (float)(rgb[0] * a);
                array[1] = (float)(rgb[1] * a);
                array[2] = (float)(rgb[2] * a);
                array[3] = (float)a;
            } else {
                int i = 0;
                while (i < texSize) {
                    double t = (double)i / ((double)texSize - 1.0);
                    hsl[0] = hslA[0] * (1.0 - t) + hslB[0] * t;
                    hsl[1] = hslA[1] * (1.0 - t) + hslB[1] * t;
                    hsl[2] = hslA[2] * (1.0 - t) + hslB[2] * t;
                    this.hsl2rgb(hsl, rgb);
                    double a = colorA.a * (1.0 - t) + colorB.a * t;
                    array[i * 4] = (float)(rgb[0] * a);
                    array[i * 4 + 1] = (float)(rgb[1] * a);
                    array[i * 4 + 2] = (float)(rgb[2] * a);
                    array[i * 4 + 3] = (float)a;
                    ++i;
                }
            }
            int n = this.createTexture((IArray<float[]>)data, repeatMode);
            return n;
        }
        finally {
            if (data != null) {
                data.release();
            }
        }
    }

    private void rgb2hsl(Color rgb, double[] hsl) {
        double hue;
        double sat;
        double min = Math.min(Math.min(rgb.r, rgb.g), rgb.b);
        double max = Math.max(Math.max(rgb.r, rgb.g), rgb.b);
        double dmax = max - min;
        double luma = (max + min) * 0.5;
        if (dmax == 0.0) {
            sat = 0.0;
            hue = 0.0;
        } else {
            sat = luma < 0.5 ? dmax / (max + min) : dmax / (2.0 - max - min);
            double dr = ((max - rgb.r) / 6.0 + dmax / 2.0) / dmax;
            double dg = ((max - rgb.g) / 6.0 + dmax / 2.0) / dmax;
            double db = ((max - rgb.b) / 6.0 + dmax / 2.0) / dmax;
            double d = rgb.r == max ? db - dg : (hue = rgb.g == max ? 0.3333333333333333 + dr - db : 0.6666666666666666 + dg - dr);
            if (hue < 0.0) {
                hue += 1.0;
            } else if (hue > 1.0) {
                hue -= 1.0;
            }
        }
        hsl[0] = hue;
        hsl[1] = sat;
        hsl[2] = luma;
    }

    private void hsl2rgb(double[] hsl, double[] rgb) {
        double hue = hsl[0];
        double sat = hsl[1];
        double luma = hsl[2];
        if (hue > 1.0) {
            hue -= 1.0;
        }
        if (sat == 0.0) {
            rgb[1] = rgb[2] = luma;
            rgb[0] = rgb[2];
        } else {
            double t2 = luma < 0.5 ? luma * (1.0 + sat) : luma + sat - luma * sat;
            double t1 = luma * 2.0 - t2;
            rgb[0] = this.hue2rgb(t1, t2, hue + 0.3333333333333333);
            rgb[1] = this.hue2rgb(t1, t2, hue);
            rgb[2] = this.hue2rgb(t1, t2, hue - 0.3333333333333333);
        }
    }

    private double hue2rgb(double t1, double t2, double hue) {
        if (hue < 0.0) {
            hue += 1.0;
        } else if (hue > 1.0) {
            hue -= 1.0;
        }
        return hue * 6.0 < 1.0 ? t1 + (t2 - t1) * 6.0 * hue : (hue * 2.0 < 1.0 ? t2 : (hue * 3.0 < 2.0 ? t1 + (t2 - t1) * (0.6666666666666666 - hue) * 6.0 : t1));
    }

    private int createTexture(IArray<float[]> array, RepeatMode repeatMode) {
        int wrapMode;
        Quality quality = this.context.getQuality();
        Resolution resolution = this.context.getVideoResolution();
        ColorMode colorMode = this.context.getColorMode();
        int internalFormat = quality == Quality.DRAFT || resolution.scale < 1.0 ? 32856 : (colorMode == ColorMode.RGBA32_FLOAT ? 34836 : (colorMode == ColorMode.RGBA16_FLOAT ? 34842 : (quality == Quality.BEST ? 34842 : 32856)));
        switch (repeatMode) {
            case CLAMP_TO_EDGE: {
                wrapMode = 33071;
                break;
            }
            case SAWTOOTH: {
                wrapMode = 10497;
                break;
            }
            case TRIANGLE: {
                wrapMode = 33648;
                break;
            }
            default: {
                wrapMode = 33069;
            }
        }
        return this.tex1DSupport.texture1DFromArray(array, 6408, internalFormat, 9729, wrapMode);
    }

    protected void deleteTextures(int ... texture) {
        GL2 gl = this.context.getGL().getGL2();
        gl.glDeleteTextures(texture.length, texture, 0);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ColorSpace {
        RGB,
        HSL,
        HSL_REVERSE_HUE;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum RepeatMode {
        NONE,
        CLAMP_TO_EDGE,
        SAWTOOTH,
        TRIANGLE;

    }
}

