/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.provisional.p2.engine.phases;

import java.net.URI;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.internal.p2.core.helpers.ServiceHelper;
import org.eclipse.equinox.internal.p2.engine.EngineActivator;
import org.eclipse.equinox.internal.provisional.p2.artifact.repository.IArtifactDescriptor;
import org.eclipse.equinox.internal.provisional.p2.artifact.repository.IArtifactRepository;
import org.eclipse.equinox.internal.provisional.p2.artifact.repository.IArtifactRepositoryManager;
import org.eclipse.equinox.internal.provisional.p2.artifact.repository.IArtifactRequest;
import org.eclipse.equinox.internal.provisional.p2.core.ProvisionException;
import org.eclipse.equinox.internal.provisional.p2.engine.IProfile;
import org.eclipse.equinox.internal.provisional.p2.engine.InstallableUnitOperand;
import org.eclipse.equinox.internal.provisional.p2.engine.InstallableUnitPhase;
import org.eclipse.equinox.internal.provisional.p2.engine.ProvisioningAction;
import org.eclipse.equinox.internal.provisional.p2.engine.ProvisioningContext;
import org.eclipse.equinox.internal.provisional.p2.engine.phases.Messages;
import org.eclipse.equinox.internal.provisional.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.internal.provisional.p2.metadata.ITouchpointType;
import org.osgi.framework.BundleContext;

public class Sizing
extends InstallableUnitPhase {
    private static final String PHASE_ID = "sizing";
    private static final String COLLECT_PHASE_ID = "collect";
    private long sizeOnDisk;
    private long dlSize;
    static /* synthetic */ Class class$0;

    public Sizing(int weight, String phaseName) {
        super(PHASE_ID, weight);
    }

    protected boolean isApplicable(InstallableUnitOperand op) {
        return op.second() != null && !op.second().equals((Object)op.first());
    }

    public long getDiskSize() {
        return this.sizeOnDisk;
    }

    public long getDlSize() {
        return this.dlSize;
    }

    protected ProvisioningAction[] getActions(InstallableUnitOperand operand) {
        IInstallableUnit unit = operand.second();
        ProvisioningAction[] parsedActions = this.getActions(unit, COLLECT_PHASE_ID);
        if (parsedActions != null) {
            return parsedActions;
        }
        ITouchpointType type = unit.getTouchpointType();
        if (type == null || type == ITouchpointType.NONE) {
            return null;
        }
        String actionId = this.getActionManager().getTouchpointQualifiedActionId(COLLECT_PHASE_ID, type);
        ProvisioningAction action = this.getActionManager().getAction(actionId, null);
        if (action == null) {
            return null;
        }
        return new ProvisioningAction[]{action};
    }

    protected String getProblemMessage() {
        return Messages.Phase_Sizing_Error;
    }

    protected IStatus completePhase(IProgressMonitor monitor, IProfile profile, Map parameters) {
        List artifactRequests = (List)parameters.get("artifactRequests");
        ProvisioningContext context = (ProvisioningContext)parameters.get("context");
        int statusCode = 0;
        HashSet<IArtifactRequest> artifactsToObtain = new HashSet<IArtifactRequest>(artifactRequests.size());
        Iterator it = artifactRequests.iterator();
        while (it.hasNext()) {
            IArtifactRequest[] requests = (IArtifactRequest[])it.next();
            if (requests == null) continue;
            int i = 0;
            while (i < requests.length) {
                artifactsToObtain.add(requests[i]);
                ++i;
            }
        }
        if (monitor.isCanceled()) {
            return Status.CANCEL_STATUS;
        }
        BundleContext bundleContext = EngineActivator.getContext();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.equinox.internal.provisional.p2.artifact.repository.IArtifactRepositoryManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        IArtifactRepositoryManager repoMgr = (IArtifactRepositoryManager)ServiceHelper.getService((BundleContext)bundleContext, (String)clazz.getName());
        URI[] repositories = null;
        repositories = context == null || context.getArtifactRepositories() == null ? repoMgr.getKnownRepositories(0) : context.getArtifactRepositories();
        Iterator iterator = artifactsToObtain.iterator();
        while (iterator.hasNext() && !monitor.isCanceled()) {
            IArtifactRequest artifactRequest = (IArtifactRequest)iterator.next();
            boolean found = false;
            int i = 0;
            while (i < repositories.length) {
                block18: {
                    IArtifactRepository repo;
                    try {
                        repo = repoMgr.loadRepository(repositories[i], monitor);
                    }
                    catch (ProvisionException provisionException) {
                        break block18;
                    }
                    if (monitor.isCanceled()) {
                        return Status.CANCEL_STATUS;
                    }
                    IArtifactDescriptor[] descriptors = repo.getArtifactDescriptors(artifactRequest.getArtifactKey());
                    if (descriptors.length > 0) {
                        if (descriptors[0].getProperty("artifact.size") != null) {
                            this.sizeOnDisk += Long.parseLong(descriptors[0].getProperty("artifact.size"));
                        } else {
                            statusCode = 1202;
                        }
                        if (descriptors[0].getProperty("download.size") != null) {
                            this.dlSize += Long.parseLong(descriptors[0].getProperty("download.size"));
                        } else {
                            statusCode = 1202;
                        }
                        found = true;
                        break;
                    }
                }
                ++i;
            }
            if (found) continue;
            return new Status(4, "org.eclipse.equinox.p2.engine", 1200, Messages.Phase_Sizing_Error, null);
        }
        if (statusCode != 0) {
            return new Status(2, "org.eclipse.equinox.p2.engine", statusCode, Messages.Phase_Sizing_Warning, null);
        }
        return null;
    }

    protected IStatus initializePhase(IProgressMonitor monitor, IProfile profile, Map parameters) {
        parameters.put("artifactRequests", new ArrayList());
        return null;
    }
}

