/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.impl.macosx.cgl;

import com.jogamp.common.nio.PointerBuffer;
import com.jogamp.opengl.impl.Debug;
import com.jogamp.opengl.impl.macosx.cgl.CGL;
import com.jogamp.opengl.impl.macosx.cgl.MacOSXCGLDrawable;
import com.jogamp.opengl.impl.macosx.cgl.MacOSXPbufferCGLContext;
import javax.media.nativewindow.DefaultGraphicsConfiguration;
import javax.media.nativewindow.NativeSurface;
import javax.media.nativewindow.SurfaceChangeable;
import javax.media.opengl.GLCapabilitiesImmutable;
import javax.media.opengl.GLContext;
import javax.media.opengl.GLDrawableFactory;
import javax.media.opengl.GLException;
import javax.media.opengl.GLProfile;

public class MacOSXPbufferCGLDrawable
extends MacOSXCGLDrawable {
    private static final boolean DEBUG = Debug.debug("MacOSXPbufferCGLDrawable");
    private int textureTarget;
    private int texture;
    protected long pBuffer;
    private boolean haveSetOpenGLMode = false;
    private int openGLMode = 1;
    protected Impl impl;

    public MacOSXPbufferCGLDrawable(GLDrawableFactory gLDrawableFactory, NativeSurface nativeSurface) {
        super(gLDrawableFactory, nativeSurface, true);
        if (DEBUG) {
            System.out.println("Pbuffer config: " + this.getNativeSurface().getGraphicsConfiguration().getNativeGraphicsConfiguration());
        }
        this.initOpenGLImpl();
        this.createPbuffer();
        if (DEBUG) {
            System.err.println("Created pbuffer " + this);
        }
    }

    protected void setRealizedImpl() {
        if (this.realized) {
            this.createPbuffer();
        } else {
            this.destroyImpl();
        }
    }

    public GLContext createContext(GLContext gLContext) {
        return new MacOSXPbufferCGLContext(this, gLContext);
    }

    protected void destroyImpl() {
        if (this.pBuffer != 0L) {
            NativeSurface nativeSurface = this.getNativeSurface();
            this.impl.destroy(this.pBuffer);
            this.pBuffer = 0L;
            ((SurfaceChangeable)nativeSurface).setSurfaceHandle(0L);
            if (DEBUG) {
                System.err.println("Destroyed pbuffer: " + this.pBuffer);
            }
        }
    }

    public long getHandle() {
        return this.pBuffer;
    }

    protected void swapBuffersImpl() {
        if (DEBUG) {
            System.err.println("unhandled swapBuffersImpl() called for: " + this);
        }
    }

    private void createPbuffer() {
        int n;
        int n2;
        NativeSurface nativeSurface;
        block7: {
            block8: {
                nativeSurface = this.getNativeSurface();
                DefaultGraphicsConfiguration defaultGraphicsConfiguration = (DefaultGraphicsConfiguration)nativeSurface.getGraphicsConfiguration().getNativeGraphicsConfiguration();
                GLCapabilitiesImmutable gLCapabilitiesImmutable = (GLCapabilitiesImmutable)defaultGraphicsConfiguration.getChosenCapabilities();
                GLProfile gLProfile = gLCapabilitiesImmutable.getGLProfile();
                if (gLProfile.isGL2GL3() && gLCapabilitiesImmutable.getPbufferRenderToTextureRectangle()) {
                    n2 = 34037;
                } else {
                    n = this.getNextPowerOf2(this.getWidth());
                    int n3 = this.getNextPowerOf2(this.getHeight());
                    ((SurfaceChangeable)nativeSurface).setSize(n, n3);
                    n2 = 3553;
                }
                n = 6408;
                if (!gLCapabilitiesImmutable.getPbufferFloatingPointBuffers()) break block7;
                if (!gLProfile.isGL2GL3()) break block8;
                switch (gLCapabilitiesImmutable.getRedBits()) {
                    case 16: {
                        n = 34842;
                        break block7;
                    }
                    case 32: {
                        n = 34836;
                        break block7;
                    }
                    default: {
                        throw new GLException("Invalid floating-point bit depth (only 16 and 32 supported)");
                    }
                }
            }
            n = 6408;
        }
        this.pBuffer = this.impl.create(n2, n, this.getWidth(), this.getHeight());
        if (this.pBuffer == 0L) {
            throw new GLException("pbuffer creation error: CGL.createPBuffer() failed");
        }
        ((SurfaceChangeable)nativeSurface).setSurfaceHandle(this.pBuffer);
    }

    private int getNextPowerOf2(int n) {
        if ((n - 1 & n) == 0) {
            return n;
        }
        int n2 = 0;
        while (n > 0) {
            n >>= 1;
            ++n2;
        }
        return 1 << n2;
    }

    public void setOpenGLMode(int n) {
        if (n == this.openGLMode) {
            return;
        }
        if (this.haveSetOpenGLMode) {
            throw new GLException("Can't switch between using NSOpenGLPixelBuffer and CGLPBufferObj more than once");
        }
        this.destroyImpl();
        this.openGLMode = n;
        this.haveSetOpenGLMode = true;
        if (DEBUG) {
            System.err.println("Switching PBuffer drawable mode to " + (n == 1 ? "NSOPENGL_MODE" : "CGL_MODE"));
        }
        this.initOpenGLImpl();
        this.createPbuffer();
    }

    public int getOpenGLMode() {
        return this.openGLMode;
    }

    private void initOpenGLImpl() {
        switch (this.openGLMode) {
            case 1: {
                this.impl = new NSOpenGLImpl();
                break;
            }
            case 2: {
                this.impl = new CGLImpl();
                break;
            }
            default: {
                throw new InternalError("Illegal implementation mode " + this.openGLMode);
            }
        }
    }

    class CGLImpl
    implements Impl {
        CGLImpl() {
        }

        public long create(int n, int n2, int n3, int n4) {
            PointerBuffer pointerBuffer = PointerBuffer.allocateDirect((int)1);
            int n5 = CGL.CGLCreatePBuffer(n3, n4, n, n2, 0L, pointerBuffer);
            if (n5 != 0) {
                throw new GLException("Error creating CGL-based pbuffer: error code " + n5);
            }
            return pointerBuffer.get(0);
        }

        public void destroy(long l) {
            int n = CGL.CGLDestroyPBuffer(l);
            if (n != 0) {
                throw new GLException("Error destroying CGL-based pbuffer: error code " + n);
            }
        }
    }

    class NSOpenGLImpl
    implements Impl {
        NSOpenGLImpl() {
        }

        public long create(int n, int n2, int n3, int n4) {
            return CGL.createPBuffer(n, n2, n3, n4);
        }

        public void destroy(long l) {
            CGL.destroyPBuffer(l);
        }
    }

    static interface Impl {
        public long create(int var1, int var2, int var3, int var4);

        public void destroy(long var1);
    }
}

