/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.metadata.generator;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.eclipse.equinox.internal.p2.metadata.generator.features.ProductFile;
import org.eclipse.equinox.internal.provisional.p2.core.Version;
import org.eclipse.equinox.internal.provisional.p2.core.VersionRange;
import org.eclipse.equinox.internal.provisional.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.internal.provisional.p2.metadata.generator.MetadataGeneratorHelper;
import org.eclipse.equinox.internal.provisional.p2.query.Collector;
import org.eclipse.equinox.internal.provisional.p2.query.MatchQuery;

public class ProductQuery
extends MatchQuery {
    private static final String EQUINOX_LAUNCHER = "org.eclipse.equinox.launcher";
    private final ProductFile product;
    private final String flavor;
    private final Map children = new HashMap();
    private final String versionAdvice;
    private final Collector collector = new Collector(){
        private final HashMap elements = new HashMap();

        public boolean accept(Object object) {
            if (!(object instanceof IInstallableUnit)) {
                return true;
            }
            IInstallableUnit iu = (IInstallableUnit)object;
            if (this.elements.containsKey(iu.getId())) {
                IInstallableUnit existing = (IInstallableUnit)this.elements.get(iu.getId());
                if (existing.getVersion().compareTo((Object)iu.getVersion()) >= 0) {
                    return true;
                }
                this.getCollection().remove(existing);
            }
            this.elements.put(iu.getId(), iu);
            return super.accept(object);
        }
    };

    public ProductQuery(ProductFile product, String flavor, Map configIUs, String versionAdvice) {
        this.product = product;
        this.flavor = flavor;
        this.versionAdvice = versionAdvice;
        this.initialize(configIUs);
    }

    public Collector getCollector() {
        return this.collector;
    }

    private Properties loadVersions(String location) {
        Properties properties;
        block16: {
            properties = new Properties();
            if (location == null) {
                return properties;
            }
            File file = new File(location);
            if (file.exists()) {
                InputStream stream = null;
                try {
                    try {
                        stream = new BufferedInputStream(new FileInputStream(file));
                        properties.load(stream);
                    }
                    catch (IOException iOException) {
                        if (stream != null) {
                            try {
                                stream.close();
                            }
                            catch (IOException iOException2) {}
                        }
                        break block16;
                    }
                }
                catch (Throwable throwable) {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (IOException iOException) {}
                    }
                    throw throwable;
                }
                if (stream != null) {
                    try {
                        stream.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        return properties;
    }

    private void initialize(Map configIUs) {
        IInstallableUnit object;
        Iterator ius;
        boolean features = this.product.useFeatures();
        Properties versions = this.loadVersions(this.versionAdvice);
        List contents = features ? this.product.getFeatures() : this.product.getPlugins();
        Iterator iterator = contents.iterator();
        while (iterator.hasNext()) {
            String item = (String)iterator.next();
            VersionRange range = VersionRange.emptyRange;
            if (versions.containsKey(item)) {
                Version value = new Version(versions.getProperty(item));
                range = new VersionRange(value, true, value, true);
            }
            if (features) {
                item = MetadataGeneratorHelper.getTransformedId(item, false, true);
            }
            this.children.put(item, range);
            if (!configIUs.containsKey(item)) continue;
            Iterator ius2 = ((Set)configIUs.get(item)).iterator();
            while (ius2.hasNext()) {
                IInstallableUnit object2 = (IInstallableUnit)ius2.next();
                this.children.put(object2.getId(), new VersionRange(object2.getVersion(), true, object2.getVersion(), true));
            }
        }
        String launcherPrefix = String.valueOf(this.product.getId()) + ".launcher";
        if (configIUs.containsKey(launcherPrefix)) {
            ius = ((Set)configIUs.get(launcherPrefix)).iterator();
            while (ius.hasNext()) {
                object = (IInstallableUnit)ius.next();
                this.children.put(object.getId(), new VersionRange(object.getVersion(), true, object.getVersion(), true));
            }
        }
        if (!this.children.containsKey(EQUINOX_LAUNCHER)) {
            this.children.put(EQUINOX_LAUNCHER, VersionRange.emptyRange);
            this.children.put(String.valueOf(this.flavor) + EQUINOX_LAUNCHER, VersionRange.emptyRange);
        }
        if (configIUs.containsKey(EQUINOX_LAUNCHER)) {
            ius = ((Set)configIUs.get(EQUINOX_LAUNCHER)).iterator();
            while (ius.hasNext()) {
                object = (IInstallableUnit)ius.next();
                this.children.put(object.getId(), new VersionRange(object.getVersion(), true, object.getVersion(), true));
            }
        }
        if (features && configIUs.containsKey("CONFIGURATION_CUS")) {
            ius = ((Set)configIUs.get("CONFIGURATION_CUS")).iterator();
            while (ius.hasNext()) {
                object = (IInstallableUnit)ius.next();
                this.children.put(object.getId(), new VersionRange(object.getVersion(), true, object.getVersion(), true));
            }
        }
    }

    public boolean isMatch(Object object) {
        if (!(object instanceof IInstallableUnit)) {
            return false;
        }
        IInstallableUnit candidate = (IInstallableUnit)object;
        VersionRange range = (VersionRange)this.children.get(candidate.getId());
        if (range != null) {
            return range.isIncluded(candidate.getVersion());
        }
        return false;
    }
}

