/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.core.output;

import ch.kuramo.javie.api.Color;
import ch.kuramo.javie.api.IAudioBuffer;
import ch.kuramo.javie.api.IVideoBuffer;
import ch.kuramo.javie.api.Resolution;
import ch.kuramo.javie.api.Time;
import ch.kuramo.javie.api.services.IAlphaChannelSupport;
import ch.kuramo.javie.core.misc.AtiIntelLock;
import ch.kuramo.javie.core.output.Output;
import ch.kuramo.javie.core.output.ProgressMonitor;
import ch.kuramo.javie.core.services.AudioRenderSupport;
import ch.kuramo.javie.core.services.GLGlobal;
import ch.kuramo.javie.core.services.RenderContext;
import com.google.inject.Inject;
import java.util.Arrays;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class PullSourceOutput
extends Output {
    private static final Logger _logger = LoggerFactory.getLogger(PullSourceOutput.class);
    private static final VideoRequest END_VIDEO = new VideoRequest(null);
    private static final AudioRequest END_AUDIO = new AudioRequest(null, 0);
    private ProgressMonitor _progressMonitor;
    private final BlockingQueue<VideoRequest> _videoRequestQueue = new ArrayBlockingQueue<VideoRequest>(1);
    private final BlockingQueue<Object> _videoResponseQueue = new ArrayBlockingQueue<Object>(1);
    private final BlockingQueue<AudioRequest> _audioRequestQueue = new ArrayBlockingQueue<AudioRequest>(1);
    private final BlockingQueue<Object> _audioResponseQueue = new ArrayBlockingQueue<Object>(1);
    @Inject
    private RenderContext _context;
    @Inject
    private IAlphaChannelSupport _alphaSupport;
    @Inject
    private AudioRenderSupport _arSupport;
    @Inject
    private GLGlobal _glGlobal;
    private static /* synthetic */ int[] $SWITCH_TABLE$ch$kuramo$javie$core$output$Output$VideoChannels;

    public void doOutput(ProgressMonitor progMon) {
        if (this.getComposition() == null) {
            throw new IllegalStateException("composition is not set");
        }
        if (this.getFile() == null) {
            throw new IllegalStateException("file is not set");
        }
        boolean videoEnabled = this.isVideoEnabled();
        boolean audioEnabled = this.isAudioEnabled();
        if (!videoEnabled && !audioEnabled) {
            throw new IllegalStateException("neither video nor audio is enabled.");
        }
        ProgressMonitor progressMonitor = this._progressMonitor = progMon != null ? progMon : ProgressMonitor.NULL;
        if (videoEnabled) {
            Thread videoThread = new Thread(new Runnable(){

                public void run() {
                    PullSourceOutput.this.videoLoop();
                }
            });
            videoThread.start();
        }
        if (audioEnabled) {
            Thread audioThread = new Thread(new Runnable(){

                public void run() {
                    PullSourceOutput.this.audioLoop();
                }
            });
            audioThread.start();
        }
        this.doOutput();
        if (videoEnabled) {
            try {
                this._videoRequestQueue.put(END_VIDEO);
            }
            catch (InterruptedException e) {
                _logger.warn("unexpected interruption", (Throwable)e);
            }
        }
        if (audioEnabled) {
            try {
                this._audioRequestQueue.put(END_AUDIO);
            }
            catch (InterruptedException e) {
                _logger.warn("unexpected interruption", (Throwable)e);
            }
        }
    }

    protected abstract void doOutput();

    /*
     * Unable to fully structure code
     */
    protected void videoLoop() {
        block19: {
            atiIntelLock = AtiIntelLock.get(this._glGlobal);
            comp = this.getComposition();
            audioMode = this.getAudioMode();
            this._context.activate();
            comp.prepareExpression(this._context.createInitialExpressionScope(comp));
            while (true) lbl-1000:
            // 5 sources

            {
                vb = null;
                try {
                    request = this._videoRequestQueue.take();
                    time = request.time;
                    if (time == null) break block19;
                    try {
                        this._context.reset();
                        this._context.setVideoResolution(Resolution.FULL);
                        this._context.setVideoFrameDuration(comp.getFrameDuration());
                        this._context.setAudioMode(audioMode);
                        this._context.setAudioAnimationRate(audioMode.sampleRate / 100);
                        this._context.setTime(time);
                        atiIntelLock.lock();
                        try {
                            vb = comp.renderVideoFrame();
                            switch (PullSourceOutput.$SWITCH_TABLE$ch$kuramo$javie$core$output$Output$VideoChannels()[this.getVideoChannels().ordinal()]) {
                                case 1: {
                                    this._alphaSupport.discardAlpha(vb);
                                    break;
                                }
                                case 2: {
                                    this._alphaSupport.alphaToGrayscale(vb, Color.WHITE);
                                    break;
                                }
                                case 3: {
                                    vbOld = vb;
                                    vb = this._alphaSupport.unmultiply(vbOld);
                                    vbOld.dispose();
                                    break;
                                }
                                case 4: {
                                    this._alphaSupport.addColorMatte(vb, this.getColorMatte());
                                }
                            }
                            this.finishVideoRequest(request, vb);
                            this._videoResponseQueue.put(this);
                        }
                        finally {
                            atiIntelLock.unlock();
                        }
                    }
                    catch (InterruptedException e) {
                        PullSourceOutput._logger.warn("unexpected interruption", (Throwable)e);
                    }
                }
                finally {
                    if (vb == null) continue;
                    vb.dispose();
                    continue;
                }
                break;
            }
            ** GOTO lbl-1000
            finally {
                this._context.deactivate();
            }
        }
    }

    protected void postVideoRequest(VideoRequest request) throws InterruptedException {
        this._videoRequestQueue.put(request);
        this._videoResponseQueue.take();
    }

    protected abstract void finishVideoRequest(VideoRequest var1, IVideoBuffer var2);

    /*
     * Unable to fully structure code
     */
    protected void audioLoop() {
        block11: {
            comp = this.getComposition();
            audioMode = this.getAudioMode();
            totalFrames = comp.getDuration().toFrameNumber(audioMode.sampleDuration);
            this._context.activate();
            comp.prepareExpression(this._context.createInitialExpressionScope(comp));
            while (true) lbl-1000:
            // 4 sources

            {
                ab = null;
                try {
                    request = this._audioRequestQueue.take();
                    time = request.time;
                    if (time == null) break block11;
                    try {
                        this._context.reset();
                        this._context.setAudioMode(audioMode);
                        this._context.setAudioAnimationRate(audioMode.sampleRate / 100);
                        this._context.setAudioFrameCount((int)Math.min((long)request.frameCount, totalFrames - time.timeValue));
                        this._context.setVideoResolution(Resolution.FULL);
                        this._context.setVideoFrameDuration(comp.getFrameDuration());
                        this._context.setTime(time);
                        ab = comp.renderAudioChunk();
                        if (ab == null) {
                            ab = this.createAudioBufferClear();
                        }
                        this.finishAudioRequest(request, ab);
                        this._audioResponseQueue.put(this);
                    }
                    catch (InterruptedException e) {
                        PullSourceOutput._logger.warn("unexpected interruption", (Throwable)e);
                    }
                }
                finally {
                    if (ab == null) continue;
                    ab.dispose();
                    continue;
                }
                break;
            }
            ** GOTO lbl-1000
            finally {
                this._context.deactivate();
            }
        }
    }

    protected void postAudioRequest(AudioRequest request) throws InterruptedException {
        this._audioRequestQueue.put(request);
        this._audioResponseQueue.take();
    }

    protected abstract void finishAudioRequest(AudioRequest var1, IAudioBuffer var2);

    private IAudioBuffer createAudioBufferClear() {
        IAudioBuffer ab = this._arSupport.createAudioBuffer();
        switch (ab.getAudioMode().dataType) {
            case SHORT: {
                Arrays.fill((short[])ab.getData(), 0, ab.getDataLength(), (short)0);
                break;
            }
            case INT: {
                Arrays.fill((int[])ab.getData(), 0, ab.getDataLength(), 0);
                break;
            }
            case FLOAT: {
                Arrays.fill((float[])ab.getData(), 0, ab.getDataLength(), 0.0f);
                break;
            }
            default: {
                throw new UnsupportedOperationException("unsupported AudioMode.DataType: " + ab.getAudioMode().dataType);
            }
        }
        return ab;
    }

    protected void beginTask(int totalWork) {
        this._progressMonitor.beginTask(totalWork);
    }

    protected void currentWork(int currentWork) {
        this._progressMonitor.currentWork(currentWork);
    }

    protected void done() {
        this._progressMonitor.done();
    }

    protected boolean isCanceled() {
        return this._progressMonitor.isCanceled();
    }

    static /* synthetic */ int[] $SWITCH_TABLE$ch$kuramo$javie$core$output$Output$VideoChannels() {
        if ($SWITCH_TABLE$ch$kuramo$javie$core$output$Output$VideoChannels != null) {
            return $SWITCH_TABLE$ch$kuramo$javie$core$output$Output$VideoChannels;
        }
        int[] nArray = new int[Output.VideoChannels.values().length];
        try {
            nArray[Output.VideoChannels.ALPHA.ordinal()] = 2;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Output.VideoChannels.RGB.ordinal()] = 1;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Output.VideoChannels.RGBA_PREMULTIPLIED.ordinal()] = 4;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Output.VideoChannels.RGBA_STRAIGHT.ordinal()] = 3;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        $SWITCH_TABLE$ch$kuramo$javie$core$output$Output$VideoChannels = nArray;
        return nArray;
    }

    protected static class AudioRequest {
        protected final Time time;
        protected final int frameCount;

        protected AudioRequest(Time time, int frameCount) {
            this.time = time;
            this.frameCount = frameCount;
        }
    }

    protected static class VideoRequest {
        protected final Time time;

        protected VideoRequest(Time time) {
            this.time = time;
        }
    }
}

