/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.core.internal.services;

import ch.kuramo.javie.api.Color;
import ch.kuramo.javie.api.Size2i;
import ch.kuramo.javie.api.Time;
import ch.kuramo.javie.api.Vec2d;
import ch.kuramo.javie.api.Vec3d;
import ch.kuramo.javie.api.VideoBounds;
import ch.kuramo.javie.core.Project;
import ch.kuramo.javie.core.services.ProjectEncoder;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import net.arnx.jsonic.JSON;

public class ProjectEncoderImpl
implements ProjectEncoder {
    public String encode(Project p, File baseDir) throws IOException {
        return this.encode(p, baseDir, false);
    }

    public String encode(Project p, File baseDir, boolean prettyPrint) throws IOException {
        File[] fileArray = File.listRoots();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File root = fileArray[n2];
            if (baseDir.equals(root)) {
                baseDir = null;
                break;
            }
            ++n2;
        }
        EncoderJSON json = baseDir != null ? new EncoderJSON(baseDir) : new EncoderJSON();
        json.setPrettyPrint(prettyPrint);
        return json.format(p);
    }

    public String encodeElement(Object element) {
        EncoderJSON json = new EncoderJSON();
        return json.format(element);
    }

    private static class EncoderJSON
    extends JSON {
        private final URI _baseURI;

        private EncoderJSON(File baseDir) throws IOException {
            this._baseURI = baseDir.getCanonicalFile().toURI();
        }

        private EncoderJSON() {
            this._baseURI = null;
        }

        protected Object preformat(JSON.Context context, Object value) throws Exception {
            if (value instanceof File) {
                return this.relativize((File)value);
            }
            if (value instanceof Color) {
                return this.toArray((Color)value);
            }
            if (value instanceof Size2i) {
                return this.toArray((Size2i)value);
            }
            if (value instanceof VideoBounds) {
                return this.toArray((VideoBounds)value);
            }
            if (value instanceof Vec2d) {
                return this.toArray((Vec2d)value);
            }
            if (value instanceof Vec3d) {
                return this.toArray((Vec3d)value);
            }
            if (value instanceof Time) {
                return this.toArray((Time)value);
            }
            if (value instanceof Enum) {
                return ((Enum)value).name();
            }
            return super.preformat(context, value);
        }

        private String relativize(File file) {
            URI uri;
            try {
                uri = file.getCanonicalFile().toURI();
            }
            catch (IOException iOException) {
                uri = file.getAbsoluteFile().toURI();
            }
            if (this._baseURI == null) {
                return uri.toASCIIString();
            }
            if (uri.getPath().startsWith(this._baseURI.getPath())) {
                return this._baseURI.relativize(uri).toASCIIString();
            }
            return uri.toASCIIString();
        }

        private double[] toArray(Color c) {
            return new double[]{c.rawRed, c.rawGreen, c.rawBlue, c.rawAlpha};
        }

        private int[] toArray(Size2i d) {
            return new int[]{d.width, d.height};
        }

        private Object[] toArray(VideoBounds bounds) {
            return new Object[]{bounds.x, bounds.y, bounds.width, bounds.height};
        }

        private double[] toArray(Vec2d vec2d) {
            return new double[]{vec2d.x, vec2d.y};
        }

        private double[] toArray(Vec3d vec3d) {
            return new double[]{vec3d.x, vec3d.y, vec3d.z};
        }

        private long[] toArray(Time t) {
            return new long[]{t.timeValue, t.timeScale};
        }
    }
}

