/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.core.internal.services;

import ch.kuramo.javie.api.Color;
import ch.kuramo.javie.api.Size2i;
import ch.kuramo.javie.api.Time;
import ch.kuramo.javie.api.Vec2d;
import ch.kuramo.javie.api.Vec3d;
import ch.kuramo.javie.api.VideoBounds;
import ch.kuramo.javie.core.AbstractAnimatableEnum;
import ch.kuramo.javie.core.AbstractAnimatableValue;
import ch.kuramo.javie.core.ArithmeticalAnimatableValue;
import ch.kuramo.javie.core.Effect;
import ch.kuramo.javie.core.EffectConverter;
import ch.kuramo.javie.core.EffectDescriptor;
import ch.kuramo.javie.core.Interpolation;
import ch.kuramo.javie.core.Keyframe;
import ch.kuramo.javie.core.MediaLayer;
import ch.kuramo.javie.core.MotionBlur;
import ch.kuramo.javie.core.Project;
import ch.kuramo.javie.core.ProjectDecodeException;
import ch.kuramo.javie.core.annotations.ProjectElement;
import ch.kuramo.javie.core.internal.services.UnknownEffect;
import ch.kuramo.javie.core.services.EffectRegistry;
import ch.kuramo.javie.core.services.ProjectDecoder;
import ch.kuramo.javie.core.services.ProjectElementFactory;
import com.google.inject.Inject;
import com.google.inject.Injector;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import net.arnx.jsonic.JSON;
import net.arnx.jsonic.JSONException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProjectDecoderImpl
implements ProjectDecoder {
    @Inject
    private ProjectElementFactory _elementFactory;
    @Inject
    private EffectRegistry _effectRegistry;
    @Inject
    private Injector _injector;

    @Override
    public Project decode(CharSequence s, File baseDir) throws IOException, ProjectDecodeException {
        try {
            DecoderJSON json = new DecoderJSON(baseDir);
            Project p = (Project)json.parse(s, Project.class);
            p.afterDecode();
            return p;
        }
        catch (JSONException e) {
            if (e.getCause() instanceof ProjectDecodeException) {
                throw (ProjectDecodeException)e.getCause();
            }
            throw e;
        }
    }

    @Override
    public <T> T decodeElement(CharSequence s, Class<T> clazz) throws ProjectDecodeException {
        try {
            DecoderJSON json = new DecoderJSON();
            return (T)json.parse(s, clazz);
        }
        catch (JSONException e) {
            if (e.getCause() instanceof ProjectDecodeException) {
                throw (ProjectDecodeException)e.getCause();
            }
            throw e;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class DecoderJSON
    extends JSON {
        private final URI _baseURI;

        private DecoderJSON(File baseDir) throws IOException {
            this._baseURI = baseDir.getCanonicalFile().toURI();
        }

        private DecoderJSON() {
            this._baseURI = null;
        }

        protected <T> T create(JSON.Context context, Class<? extends T> c) throws Exception {
            if (c.getAnnotation(ProjectElement.class) != null || Effect.class.isAssignableFrom(c)) {
                return (T)ProjectDecoderImpl.this._injector.getInstance(c);
            }
            return (T)super.create(context, c);
        }

        protected <T> T postparse(JSON.Context context, Object value, Class<? extends T> c, Type type) throws Exception {
            if (value instanceof Map) {
                Map map = (Map)value;
                if (Keyframe.class.isAssignableFrom(c) && type instanceof ParameterizedType) {
                    return c.cast(this.createKeyframe(context, map, (ParameterizedType)type));
                }
                if ((c.getSuperclass() == AbstractAnimatableValue.class || c.getSuperclass() == ArithmeticalAnimatableValue.class || c.getSuperclass() == AbstractAnimatableEnum.class) && c.getGenericSuperclass() instanceof ParameterizedType) {
                    return c.cast(this.createAnimatableValue(context, map, c, (Class)((ParameterizedType)c.getGenericSuperclass()).getActualTypeArguments()[0]));
                }
                String elementType = (String)map.get("TYPE");
                if (elementType != null) {
                    Class<Object> clazz;
                    if (Effect.class.isAssignableFrom(c)) {
                        EffectConverter ec;
                        while ((ec = ProjectDecoderImpl.this._effectRegistry.getEffectConverter(elementType)) != null) {
                            ec.convert(map);
                            elementType = ec.getNewType();
                        }
                        EffectDescriptor ed = ProjectDecoderImpl.this._effectRegistry.getEffectDescriptor(elementType);
                        Class effectClass = ed != null ? ed.getEffectClass() : UnknownEffect.class;
                        clazz = effectClass;
                    } else {
                        clazz = ProjectDecoderImpl.this._elementFactory.getClass(elementType);
                        if (MediaLayer.class.isAssignableFrom(clazz)) {
                            this.convertMotionBlur(map);
                        }
                    }
                    if (clazz == null) {
                        throw new ProjectDecodeException("no such project element found: type=" + elementType);
                    }
                    return (T)super.postparse(context, value, clazz, clazz);
                }
            } else {
                if (value instanceof String && File.class.isAssignableFrom(c)) {
                    return c.cast(this.createAbsoluteFile((String)value));
                }
                if (value instanceof List) {
                    List list = (List)value;
                    if (Color.class.isAssignableFrom(c)) {
                        return c.cast(this.createColor(context, list));
                    }
                    if (Size2i.class.isAssignableFrom(c)) {
                        return c.cast(this.createSize2i(context, list));
                    }
                    if (VideoBounds.class.isAssignableFrom(c)) {
                        return c.cast(this.createVideoBounds(context, list));
                    }
                    if (Vec2d.class.isAssignableFrom(c)) {
                        return c.cast(this.createVec2d(context, list));
                    }
                    if (Vec3d.class.isAssignableFrom(c)) {
                        return c.cast(this.createVec3d(context, list));
                    }
                    if (Time.class.isAssignableFrom(c)) {
                        return c.cast(this.createTime(context, list));
                    }
                } else if (value instanceof String && c.isEnum()) {
                    T e = Enum.valueOf(c, (String)value);
                    return c.cast(e);
                }
            }
            return (T)super.postparse(context, value, c, type);
        }

        private Keyframe<?> createKeyframe(JSON.Context context, Map<?, ?> map, ParameterizedType ptype) throws Exception {
            Time time = (Time)context.convert((Object)"time", map.get("time"), Time.class);
            Object value = context.convert((Object)"value", map.get("value"), ptype.getActualTypeArguments()[0]);
            Interpolation interpolation = (Interpolation)((Object)context.convert((Object)"interpolation", map.get("interpolation"), Interpolation.class));
            Keyframe<Object> keyframe = new Keyframe<Object>(time, value, interpolation);
            return keyframe;
        }

        private Object createAnimatableValue(JSON.Context context, Map<?, ?> map, Class<?> clazz, Class<?> actualTypeArg) throws Exception {
            Constructor<?> cstr = clazz.getConstructor(actualTypeArg, Collection.class, String.class);
            Object staticValue = context.convert((Object)"staticValue", map.get("staticValue"), actualTypeArg);
            Collection keyframes = (Collection)context.convert((Object)"keyframes", map.get("keyframes"), cstr.getGenericParameterTypes()[1]);
            String expression = (String)context.convert((Object)"expression", map.get("expression"), String.class);
            return cstr.newInstance(staticValue, keyframes, expression);
        }

        private File createAbsoluteFile(String uriAsString) throws ProjectDecodeException {
            try {
                URI uri = new URI(uriAsString);
                if (this._baseURI != null) {
                    uri = this._baseURI.resolve(uri);
                }
                return new File(uri);
            }
            catch (URISyntaxException e) {
                throw new ProjectDecodeException(e);
            }
        }

        private Color createColor(JSON.Context context, List<?> list) throws Exception {
            return new Color(((Double)context.convert((Object)0, list.get(0), Double.TYPE)).doubleValue(), ((Double)context.convert((Object)1, list.get(1), Double.TYPE)).doubleValue(), ((Double)context.convert((Object)2, list.get(2), Double.TYPE)).doubleValue(), ((Double)context.convert((Object)3, list.get(3), Double.TYPE)).doubleValue());
        }

        private Size2i createSize2i(JSON.Context context, List<?> list) throws Exception {
            return new Size2i(((Integer)context.convert((Object)0, list.get(0), Integer.TYPE)).intValue(), ((Integer)context.convert((Object)1, list.get(1), Integer.TYPE)).intValue());
        }

        private VideoBounds createVideoBounds(JSON.Context context, List<?> list) throws Exception {
            return new VideoBounds(((Double)context.convert((Object)0, list.get(0), Double.TYPE)).doubleValue(), ((Double)context.convert((Object)1, list.get(1), Double.TYPE)).doubleValue(), ((Integer)context.convert((Object)2, list.get(2), Integer.TYPE)).intValue(), ((Integer)context.convert((Object)3, list.get(3), Integer.TYPE)).intValue());
        }

        private Vec2d createVec2d(JSON.Context context, List<?> list) throws Exception {
            return new Vec2d(((Double)context.convert((Object)0, list.get(0), Double.TYPE)).doubleValue(), ((Double)context.convert((Object)1, list.get(1), Double.TYPE)).doubleValue());
        }

        private Vec3d createVec3d(JSON.Context context, List<?> list) throws Exception {
            return new Vec3d(((Double)context.convert((Object)0, list.get(0), Double.TYPE)).doubleValue(), ((Double)context.convert((Object)1, list.get(1), Double.TYPE)).doubleValue(), ((Double)context.convert((Object)2, list.get(2), Double.TYPE)).doubleValue());
        }

        private Time createTime(JSON.Context context, List<?> list) throws Exception {
            return new Time(((Long)context.convert((Object)0, list.get(0), Long.TYPE)).longValue(), ((Integer)context.convert((Object)1, list.get(1), Integer.TYPE)).intValue());
        }

        private void convertMotionBlur(Map<?, ?> map) {
            Map<?, ?> m = map;
            if (m.containsKey("motionBlur")) {
                return;
            }
            Object motionBlurEnabled = m.remove("motionBlurEnabled");
            m.put("motionBlur", Boolean.TRUE.equals(motionBlurEnabled) ? MotionBlur.TRANSFORM.name() : MotionBlur.NONE.name());
        }
    }
}

