/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.core.internal.services;

import ch.kuramo.javie.api.IShaderProgram;
import ch.kuramo.javie.api.IVideoBuffer;
import ch.kuramo.javie.api.VideoBounds;
import ch.kuramo.javie.api.annotations.ShaderSource;
import ch.kuramo.javie.api.services.IConvolutionSupport;
import ch.kuramo.javie.api.services.IShaderRegistry;
import ch.kuramo.javie.api.services.IVideoRenderSupport;
import com.google.inject.Inject;
import java.nio.FloatBuffer;
import java.util.HashSet;
import java.util.Set;
import javax.media.opengl.GLUniformData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConvolutionSupportImpl
implements IConvolutionSupport {
    @ShaderSource
    public static final String[] CONVOLUTION = new String[]{"uniform sampler2D texture;", "uniform int ksize;", "uniform float kernel[101];", "uniform vec2 offset[101];", "", "void main(void)", "{", "\tvec2 texCoord = gl_TexCoord[0].st;", "\tvec4 sum = vec4(0.0);", "\tfor (int i = 0; i < ksize; ++i) {", "\t\tsum += kernel[i] * texture2D(texture, texCoord + offset[i]);", "\t}", "\tgl_FragColor = sum;", "}"};
    private final IVideoRenderSupport support;
    private final IShaderProgram program;

    @Inject
    public ConvolutionSupportImpl(IVideoRenderSupport support, IShaderRegistry shaders) {
        this.support = support;
        this.program = shaders.getProgram(ConvolutionSupportImpl.class, "CONVOLUTION");
    }

    private Set<GLUniformData> uniforms(float[] kernel, float[] offset) {
        int ksize = kernel.length;
        HashSet<GLUniformData> uniforms = new HashSet<GLUniformData>();
        uniforms.add(new GLUniformData("texture", 0));
        uniforms.add(new GLUniformData("ksize", ksize));
        uniforms.add(new GLUniformData("kernel[0]", 1, FloatBuffer.wrap(kernel, 0, ksize)));
        uniforms.add(new GLUniformData("offset[0]", 2, FloatBuffer.wrap(offset, 0, ksize * 2)));
        return uniforms;
    }

    public IVideoBuffer convolve(IVideoBuffer input, IVideoBuffer output, float[] kernel, float[] coordOffset, Runnable operation, int pushAttribs) {
        return this.support.useShaderProgram(this.program, this.uniforms(kernel, coordOffset), operation, pushAttribs, output, new IVideoBuffer[]{input});
    }

    public IVideoBuffer convolve(IVideoBuffer input, IVideoBuffer output, float[] kernel, float[] coordOffset) {
        return this.support.useShaderProgram(this.program, this.uniforms(kernel, coordOffset), output, new IVideoBuffer[]{input});
    }

    private float[] offset2D(int ksize, VideoBounds inputBounds) {
        if (ksize % 2 == 0) {
            throw new IllegalArgumentException("kernel size must be odd number");
        }
        float[] offset = new float[ksize * ksize * 2];
        int half = ksize / 2;
        int j = 0;
        while (j < ksize) {
            int i = 0;
            while (i < ksize) {
                int k = j * ksize + i;
                offset[k * 2] = (float)(i - half) / (float)inputBounds.width;
                offset[k * 2 + 1] = (float)(j - half) / (float)inputBounds.height;
                ++i;
            }
            ++j;
        }
        return offset;
    }

    public IVideoBuffer convolve2D(IVideoBuffer input, IVideoBuffer output, int kernelSize, float[] kernel, Runnable operation, int pushAttribs) {
        return this.convolve(input, output, kernel, this.offset2D(kernelSize, input.getBounds()), operation, pushAttribs);
    }

    public IVideoBuffer convolve2D(IVideoBuffer input, IVideoBuffer output, int kernelSize, float[] kernel) {
        return this.convolve(input, output, kernel, this.offset2D(kernelSize, input.getBounds()));
    }

    private float[] offset1D(int ksize, IConvolutionSupport.ConvolutionDirection direction, VideoBounds inputBounds) {
        int inputSize;
        int j;
        if (ksize % 2 == 0) {
            throw new IllegalArgumentException("kernel size must be odd number");
        }
        if (direction == IConvolutionSupport.ConvolutionDirection.HORIZONTAL) {
            j = 0;
            inputSize = inputBounds.width;
        } else {
            j = 1;
            inputSize = inputBounds.height;
        }
        float[] offset = new float[ksize * 2];
        int half = ksize / 2;
        int k = 1 - j;
        int i = 0;
        while (i < ksize) {
            offset[i * 2 + j] = (float)(i - half) / (float)inputSize;
            offset[i * 2 + k] = 0.0f;
            ++i;
        }
        return offset;
    }

    public IVideoBuffer convolve1D(IVideoBuffer input, IVideoBuffer output, float[] kernel, IConvolutionSupport.ConvolutionDirection direction, Runnable operation, int pushAttribs) {
        return this.convolve(input, output, kernel, this.offset1D(kernel.length, direction, input.getBounds()), operation, pushAttribs);
    }

    public IVideoBuffer convolve1D(IVideoBuffer input, IVideoBuffer output, float[] kernel, IConvolutionSupport.ConvolutionDirection direction) {
        return this.convolve(input, output, kernel, this.offset1D(kernel.length, direction, input.getBounds()));
    }
}

