/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.core.internal.services;

import ch.kuramo.javie.api.Time;
import ch.kuramo.javie.core.Composition;
import ch.kuramo.javie.core.CoreContext;
import ch.kuramo.javie.core.ExpressionScope;
import ch.kuramo.javie.core.Expressionee;
import ch.kuramo.javie.core.Expressioner;
import ch.kuramo.javie.core.WrappedOperation;
import com.google.inject.Inject;
import com.google.inject.Injector;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import org.mozilla.javascript.Scriptable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractCoreContextProxy<I extends CoreContext>
implements CoreContext {
    private final Class<I> _implClass;
    @Inject
    private Injector _injector;

    public AbstractCoreContextProxy(Class<I> implClass) {
        this._implClass = implClass;
    }

    public AbstractCoreContextProxy() {
        Class clazz;
        Type type = this.getClass().getGenericSuperclass();
        if (!(type instanceof ParameterizedType)) {
            throw new UnsupportedOperationException();
        }
        this._implClass = clazz = (Class)((ParameterizedType)type).getActualTypeArguments()[0];
    }

    protected abstract ThreadLocal<I> getThreadLocal();

    protected I getImpl() {
        CoreContext impl = (CoreContext)this.getThreadLocal().get();
        if (impl == null) {
            throw new IllegalStateException(String.valueOf(this._implClass.getSimpleName()) + " of current thread is not activated.");
        }
        return (I)impl;
    }

    @Override
    public void activate() {
        CoreContext impl = (CoreContext)this.getThreadLocal().get();
        if (impl != null) {
            throw new IllegalStateException(String.valueOf(this._implClass.getSimpleName()) + " of current thread has already been activated.");
        }
        impl = (CoreContext)this._injector.getInstance(this._implClass);
        impl.activate();
        this.getThreadLocal().set(impl);
    }

    @Override
    public void deactivate() {
        I impl = this.getImpl();
        impl.deactivate();
        this.getThreadLocal().set(null);
    }

    @Override
    public boolean isActive() {
        CoreContext impl = (CoreContext)this.getThreadLocal().get();
        return impl != null && impl.isActive();
    }

    @Override
    public void reset() {
        this.getImpl().reset();
    }

    @Override
    public <T> T saveAndExecute(WrappedOperation<T> operation) {
        return this.getImpl().saveAndExecute(operation);
    }

    @Override
    public Time getTime() {
        return this.getImpl().getTime();
    }

    @Override
    public void setTime(Time time) {
        this.getImpl().setTime(time);
    }

    @Override
    public Composition getComposition() {
        return this.getImpl().getComposition();
    }

    @Override
    public void setComposition(Composition comp) {
        this.getImpl().setComposition(comp);
    }

    @Override
    public ExpressionScope createInitialExpressionScope(Composition comp) {
        return this.getImpl().createInitialExpressionScope(comp);
    }

    @Override
    public <T> T getExpressionElement(Expressionee exprnee) {
        return this.getImpl().getExpressionElement(exprnee);
    }

    @Override
    public boolean checkCyclicEvaluation(Expressioner<?> expr) {
        return this.getImpl().checkCyclicEvaluation(expr);
    }

    @Override
    public <T> T evaluateExpression(Expressioner<T> expr) {
        return this.getImpl().evaluateExpression(expr);
    }

    @Override
    public Scriptable toNativeJavaObject(Object javaObject, Class<?> defaultHint) {
        return this.toNativeJavaObject(javaObject, defaultHint);
    }
}

