/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.core.internal;

import ch.kuramo.javie.api.Color;
import ch.kuramo.javie.api.GeometryInputType;
import ch.kuramo.javie.api.GeometryOutputType;
import ch.kuramo.javie.api.IAudioBuffer;
import ch.kuramo.javie.api.IShaderProgram;
import ch.kuramo.javie.api.IVideoBuffer;
import ch.kuramo.javie.api.Quality;
import ch.kuramo.javie.api.Resolution;
import ch.kuramo.javie.api.ShaderType;
import ch.kuramo.javie.api.Time;
import ch.kuramo.javie.api.Vec2d;
import ch.kuramo.javie.api.Vec3d;
import ch.kuramo.javie.api.VideoBounds;
import ch.kuramo.javie.api.annotations.GeometryShaderParameters;
import ch.kuramo.javie.api.annotations.ShaderSource;
import ch.kuramo.javie.api.services.IAntiAliasSupport;
import ch.kuramo.javie.api.services.IBlurSupport;
import ch.kuramo.javie.api.services.IShaderRegistry;
import ch.kuramo.javie.api.services.IVideoRenderSupport;
import ch.kuramo.javie.core.AbstractAnimatableEnum;
import ch.kuramo.javie.core.AnimatableColor;
import ch.kuramo.javie.core.AnimatableDouble;
import ch.kuramo.javie.core.AnimatableInteger;
import ch.kuramo.javie.core.AnimatableString;
import ch.kuramo.javie.core.AnimatableVec2d;
import ch.kuramo.javie.core.CoreContext;
import ch.kuramo.javie.core.Effect;
import ch.kuramo.javie.core.ExpressionScope;
import ch.kuramo.javie.core.Expressionee;
import ch.kuramo.javie.core.Keyframe;
import ch.kuramo.javie.core.LayerNature;
import ch.kuramo.javie.core.MediaInput;
import ch.kuramo.javie.core.MediaLayer;
import ch.kuramo.javie.core.TAProperty;
import ch.kuramo.javie.core.TASelector;
import ch.kuramo.javie.core.TextAnimator;
import ch.kuramo.javie.core.TextLayer;
import ch.kuramo.javie.core.Util;
import ch.kuramo.javie.core.VectorMediaInput;
import ch.kuramo.javie.core.VideoLayerRenderer;
import ch.kuramo.javie.core.WrappedOperation;
import ch.kuramo.javie.core.annotations.ProjectElement;
import ch.kuramo.javie.core.internal.AbstractMediaLayer;
import ch.kuramo.javie.core.internal.CharacterGroup;
import ch.kuramo.javie.core.internal.HSLUtil;
import ch.kuramo.javie.core.internal.LayerMatrixUtil;
import ch.kuramo.javie.core.internal.TextAnimatorImpl;
import ch.kuramo.javie.core.services.Font;
import ch.kuramo.javie.core.services.FontList;
import ch.kuramo.javie.core.services.FontManager;
import ch.kuramo.javie.core.services.GLGlobal;
import ch.kuramo.javie.core.services.RenderContext;
import ch.kuramo.javie.core.services.VideoEffectPipeline;
import ch.kuramo.javie.core.services.VideoRenderSupport;
import com.google.inject.Inject;
import ftgl.FTGL;
import ftgl.FTGLfont;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.media.opengl.GL2;
import javax.media.opengl.GLUniformData;
import javax.media.opengl.glu.GLU;
import javax.vecmath.AxisAngle4d;
import javax.vecmath.Matrix3d;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point2d;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import javax.vecmath.Vector4d;
import net.arnx.jsonic.JSONHint;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ProjectElement(value="textLayer")
public class TextLayerImpl
extends AbstractMediaLayer
implements TextLayer {
    private final TextInput _input = new TextInput();
    private boolean _videoEnabled = true;
    private boolean _ctcr;
    private AnimatableString _sourceText = new AnimatableString("\u30c6\u30ad\u30b9\u30c8");
    private AnimatableString _font = new AnimatableString("");
    private AnimatableInteger _fontSize = new AnimatableInteger((Integer)36, 1, Integer.MAX_VALUE);
    private TextLayer.TextType _textType = TextLayer.TextType.FILL_ONLY;
    private AnimatableColor _fillColor = new AnimatableColor(Color.WHITE);
    private AnimatableColor _strokeColor = new AnimatableColor(new Color(1.0, 0.0, 0.0));
    private AnimatableDouble _strokeWidth = new AnimatableDouble((Double)1.0, 0.0, 1296.0);
    private AnimatableLineJoin _lineJoin = new AnimatableLineJoin(TextLayer.LineJoin.MITER);
    private AnimatableDouble _miterLimit = new AnimatableDouble((Double)10.0, 1.0, Double.POSITIVE_INFINITY);
    private AnimatableOrderOfFillAndStroke _orderOfFillAndStroke = new AnimatableOrderOfFillAndStroke(TextLayer.OrderOfFillAndStroke.STROKE_OVER_FILL);
    private AnimatableHorizontalAlignment _horizontalAlignment = new AnimatableHorizontalAlignment(TextLayer.HorizontalAlignment.LEFT);
    private AnimatableDouble _tracking = new AnimatableDouble((Double)0.0, -1000.0, 1000.0);
    private AnimatableDouble _leading = new AnimatableDouble(-1.0);
    private TextAnimatorImpl.AnimatableAnchorPointGrouping _anchorPointGrouping = new TextAnimatorImpl.AnimatableAnchorPointGrouping(TextAnimator.AnchorPointGrouping.CHARACTER);
    private AnimatableVec2d _groupingAlignment = new AnimatableVec2d(Vec2d.ZERO);
    private TextAnimatorImpl.AnimatableCharacterAlignment _characterAlignment = new TextAnimatorImpl.AnimatableCharacterAlignment(TextAnimator.CharacterAlignment.CENTER);
    private List<TextAnimator> _textAnimators = Util.newList();
    private boolean _perCharacter3D;
    private final RenderContext _context;
    private final IVideoRenderSupport _support;
    private final VideoRenderSupport _oldSupport;
    private final VideoEffectPipeline _vePipeline;
    private final IAntiAliasSupport _aaSupport;
    private final IBlurSupport _blurSupport;
    private final FontList _fontList;
    private final FontManager _fontManager;
    private final IShaderProgram[] _strokePrograms;
    private final boolean _geometryShaderAvailable;
    @ShaderSource(type=ShaderType.VERTEX_SHADER, program=false)
    public static final String[] line_join_vs = new String[]{"void main(void)", "{", "\tgl_Position = gl_Vertex;", "\tgl_FrontColor = gl_Color;", "}"};
    @ShaderSource(type=ShaderType.FRAGMENT_SHADER, program=false)
    public static final String[] line_join_fs = new String[]{"void main(void)", "{", "\tgl_FragColor = gl_Color;", "\tgl_FragDepth = 0.0;", "}"};
    @ShaderSource(type=ShaderType.GEOMETRY_SHADER, attach={"line_join_vs", "line_join_fs"})
    @GeometryShaderParameters(inputType=GeometryInputType.LINES_ADJACENCY, outputType=GeometryOutputType.TRIANGLE_STRIP, verticesOut=8)
    public static final String[] MITER = TextLayerImpl.createLineJoinGeometryShader(TextLayer.LineJoin.MITER);
    @ShaderSource(type=ShaderType.GEOMETRY_SHADER, attach={"line_join_vs", "line_join_fs"})
    @GeometryShaderParameters(inputType=GeometryInputType.LINES_ADJACENCY, outputType=GeometryOutputType.TRIANGLE_STRIP, verticesOut=58)
    public static final String[] ROUND = TextLayerImpl.createLineJoinGeometryShader(TextLayer.LineJoin.ROUND);
    @ShaderSource(type=ShaderType.GEOMETRY_SHADER, attach={"line_join_vs", "line_join_fs"})
    @GeometryShaderParameters(inputType=GeometryInputType.LINES_ADJACENCY, outputType=GeometryOutputType.TRIANGLE_STRIP, verticesOut=7)
    public static final String[] BEVEL = TextLayerImpl.createLineJoinGeometryShader(TextLayer.LineJoin.BEVEL);
    private static int[][] frustumPlaneTable;
    private static /* synthetic */ int[] $SWITCH_TABLE$ch$kuramo$javie$core$TextLayer$TextType;

    static {
        int[][] nArrayArray = new int[6][];
        int[] nArray = new int[4];
        nArray[1] = 2;
        nArray[2] = 6;
        nArray[3] = 1;
        nArrayArray[0] = nArray;
        int[] nArray2 = new int[4];
        nArray2[0] = 1;
        nArray2[1] = 3;
        nArray2[2] = 7;
        nArrayArray[1] = nArray2;
        int[] nArray3 = new int[4];
        nArray3[1] = 1;
        nArray3[2] = 2;
        nArray3[3] = 6;
        nArrayArray[2] = nArray3;
        int[] nArray4 = new int[4];
        nArray4[0] = 6;
        nArray4[1] = 7;
        nArray4[2] = 4;
        nArrayArray[3] = nArray4;
        int[] nArray5 = new int[4];
        nArray5[1] = 1;
        nArray5[2] = 6;
        nArray5[3] = 2;
        nArrayArray[4] = nArray5;
        int[] nArray6 = new int[4];
        nArray6[0] = 2;
        nArray6[1] = 3;
        nArray6[2] = 4;
        nArrayArray[5] = nArray6;
        frustumPlaneTable = nArrayArray;
    }

    @Inject
    public TextLayerImpl(RenderContext context, IVideoRenderSupport support, VideoRenderSupport oldSupport, VideoEffectPipeline vePipeline, IAntiAliasSupport aaSupport, IBlurSupport blurSupport, FontList fontList, FontManager fontManager, IShaderRegistry shaders, GLGlobal glGlobal) {
        this._context = context;
        this._support = support;
        this._oldSupport = oldSupport;
        this._vePipeline = vePipeline;
        this._aaSupport = aaSupport;
        this._blurSupport = blurSupport;
        this._fontList = fontList;
        this._fontManager = fontManager;
        this._strokePrograms = new IShaderProgram[]{shaders.getProgram(TextLayerImpl.class, "MITER"), shaders.getProgram(TextLayerImpl.class, "ROUND"), shaders.getProgram(TextLayerImpl.class, "BEVEL")};
        this._geometryShaderAvailable = glGlobal.getExtensions().contains("GL_EXT_geometry_shader4") || glGlobal.getExtensions().contains("GL_ARB_geometry_shader4");
    }

    @Override
    public boolean isVideoEnabled() {
        return this._videoEnabled;
    }

    @Override
    public void setVideoEnabled(boolean enabled) {
        this._videoEnabled = enabled;
    }

    @Override
    @JSONHint(ignore=true)
    public boolean isAudioEnabled() {
        return false;
    }

    @Override
    @JSONHint(ignore=true)
    public void setAudioEnabled(boolean enabled) {
        throw new UnsupportedOperationException();
    }

    @Override
    @JSONHint(ignore=true)
    public MediaInput getMediaInput() {
        return this._input;
    }

    @Override
    public boolean isCTCR() {
        return this._ctcr;
    }

    @Override
    public void setCTCR(boolean ctcr) {
        this._ctcr = ctcr;
    }

    @Override
    public AnimatableString getSourceText() {
        return this._sourceText;
    }

    public void setSourceText(AnimatableString sourceText) {
        sourceText.copyConfigurationFrom(this._sourceText);
        this._sourceText = sourceText;
    }

    @Override
    public AnimatableString getFont() {
        return this._font;
    }

    public void setFont(AnimatableString font) {
        font.copyConfigurationFrom(this._font);
        this._font = font;
    }

    @Override
    public AnimatableInteger getFontSize() {
        return this._fontSize;
    }

    public void setFontSize(AnimatableInteger fontSize) {
        fontSize.copyConfigurationFrom(this._fontSize);
        this._fontSize = fontSize;
    }

    @Override
    public TextLayer.TextType getTextType() {
        return this._textType;
    }

    @Override
    public void setTextType(TextLayer.TextType textType) {
        this._textType = textType;
    }

    @Override
    public AnimatableColor getFillColor() {
        return this._fillColor;
    }

    public void setFillColor(AnimatableColor fillColor) {
        fillColor.copyConfigurationFrom(this._fillColor);
        this._fillColor = fillColor;
    }

    @Override
    public AnimatableColor getStrokeColor() {
        return this._strokeColor;
    }

    public void setStrokeColor(AnimatableColor strokeColor) {
        strokeColor.copyConfigurationFrom(this._strokeColor);
        this._strokeColor = strokeColor;
    }

    @Override
    public AnimatableDouble getStrokeWidth() {
        return this._strokeWidth;
    }

    public void setStrokeWidth(AnimatableDouble strokeWidth) {
        strokeWidth.copyConfigurationFrom(this._strokeWidth);
        this._strokeWidth = strokeWidth;
    }

    public AnimatableLineJoin getLineJoin() {
        return this._lineJoin;
    }

    public void setLineJoin(AnimatableLineJoin lineJoin) {
        lineJoin.copyConfigurationFrom(this._lineJoin);
        this._lineJoin = lineJoin;
    }

    @Override
    public AnimatableDouble getMiterLimit() {
        return this._miterLimit;
    }

    public void setMiterLimit(AnimatableDouble miterLimit) {
        miterLimit.copyConfigurationFrom(this._miterLimit);
        this._miterLimit = miterLimit;
    }

    public AnimatableOrderOfFillAndStroke getOrderOfFillAndStroke() {
        return this._orderOfFillAndStroke;
    }

    public void setOrderOfFillAndStroke(AnimatableOrderOfFillAndStroke orderOfFillAndStroke) {
        orderOfFillAndStroke.copyConfigurationFrom(this._orderOfFillAndStroke);
        this._orderOfFillAndStroke = orderOfFillAndStroke;
    }

    public AnimatableHorizontalAlignment getHorizontalAlignment() {
        return this._horizontalAlignment;
    }

    public void setHorizontalAlignment(AnimatableHorizontalAlignment horizontalAlignment) {
        horizontalAlignment.copyConfigurationFrom(this._horizontalAlignment);
        this._horizontalAlignment = horizontalAlignment;
    }

    @Override
    public AnimatableDouble getTracking() {
        return this._tracking;
    }

    public void setTracking(AnimatableDouble tracking) {
        tracking.copyConfigurationFrom(this._tracking);
        this._tracking = tracking;
    }

    @Override
    public AnimatableDouble getLeading() {
        return this._leading;
    }

    public void setLeading(AnimatableDouble leading) {
        leading.copyConfigurationFrom(this._leading);
        this._leading = leading;
    }

    public TextAnimatorImpl.AnimatableAnchorPointGrouping getAnchorPointGrouping() {
        return this._anchorPointGrouping;
    }

    public void setAnchorPointGrouping(TextAnimatorImpl.AnimatableAnchorPointGrouping anchorPointGrouping) {
        anchorPointGrouping.copyConfigurationFrom(this._anchorPointGrouping);
        this._anchorPointGrouping = anchorPointGrouping;
    }

    @Override
    public AnimatableVec2d getGroupingAlignment() {
        return this._groupingAlignment;
    }

    public void setGroupingAlignment(AnimatableVec2d groupingAlignment) {
        groupingAlignment.copyConfigurationFrom(this._groupingAlignment);
        this._groupingAlignment = groupingAlignment;
    }

    public TextAnimatorImpl.AnimatableCharacterAlignment getCharacterAlignment() {
        return this._characterAlignment;
    }

    public void setCharacterAlignment(TextAnimatorImpl.AnimatableCharacterAlignment characterAlignment) {
        characterAlignment.copyConfigurationFrom(this._characterAlignment);
        this._characterAlignment = characterAlignment;
    }

    @Override
    public List<TextAnimator> getTextAnimators() {
        return this._textAnimators;
    }

    public void setTextAnimators(List<TextAnimator> textAnimators) {
        this._textAnimators = textAnimators;
    }

    @Override
    public boolean isPerCharacter3D() {
        return this._perCharacter3D;
    }

    @Override
    public void setPerCharacter3D(boolean perCharacter3D) {
        this._perCharacter3D = perCharacter3D;
    }

    @Override
    public void prepareExpression(ExpressionScope scope) {
        super.prepareExpression(scope);
        scope.assignTo(this._sourceText);
        scope.assignTo(this._font);
        scope.assignTo(this._fontSize);
        scope.assignTo(this._fillColor);
        scope.assignTo(this._strokeColor);
        scope.assignTo(this._strokeWidth);
        scope.assignTo(this._lineJoin);
        scope.assignTo(this._miterLimit);
        scope.assignTo(this._orderOfFillAndStroke);
        scope.assignTo(this._horizontalAlignment);
        scope.assignTo(this._tracking);
        scope.assignTo(this._leading);
        scope.assignTo(this._anchorPointGrouping);
        scope.assignTo(this._groupingAlignment);
        scope.assignTo(this._characterAlignment);
        for (TextAnimator animator : this._textAnimators) {
            animator.prepareExpression(scope);
        }
    }

    @Override
    public Object createExpressionElement(CoreContext context) {
        return new TextLayerExpressionElement(context);
    }

    @Override
    public List<VideoLayerRenderer> createPerCharacter3DRenderers() {
        FTGLfont strokeFont;
        boolean perCharacter3D;
        boolean bl = perCharacter3D = LayerNature.isThreeD(this) && this.isPerCharacter3D();
        if (!perCharacter3D) {
            throw new IllegalStateException();
        }
        boolean fillOnly = this.getTextType() == TextLayer.TextType.FILL_ONLY;
        String psName = (String)this._font.value(this._context);
        int fontSize = (Integer)this._fontSize.value(this._context);
        FTGLfont polygonFont = this.getFillFont(psName, fontSize, true);
        FTGLfont fTGLfont = strokeFont = fillOnly ? null : this.getStrokeFont(psName, fontSize);
        if (polygonFont == null) {
            return Util.newList();
        }
        int[] totals = new int[4];
        String sourceText = (String)this._sourceText.value(this._context);
        List<TACharacter> chars = this.createTACharacters(totals, sourceText, polygonFont);
        if (chars.isEmpty()) {
            return Util.newList();
        }
        FTGLfont bufferFont = null;
        if (fillOnly && (bufferFont = this.getFillFont(psName, fontSize, false)) == null) {
            return Util.newList();
        }
        List<VideoLayerRenderer> renderers = Util.newList();
        boolean ctcr = LayerNature.isCTCR(this);
        Map<Time, List<TACharacter>> charsCache = Util.newMap();
        int i = 0;
        while (i < chars.size()) {
            TACharacter c = chars.get(i);
            if (c.charIndex2 >= 0) {
                if (ctcr) {
                    renderers.add(this.createPerCharacter3DRendererCR(totals, chars, i, charsCache, bufferFont, polygonFont, strokeFont));
                } else {
                    renderers.add(this.createPerCharacter3DRendererNormal(totals, chars, i, charsCache, bufferFont, polygonFont, strokeFont));
                }
            }
            ++i;
        }
        return renderers;
    }

    private VideoLayerRenderer.NormalLayerRenderer createPerCharacter3DRendererNormal(final int[] totals, final List<TACharacter> chars, final int charIndex, final Map<Time, List<TACharacter>> charsCache, final FTGLfont bufferFont, final FTGLfont polygonFont, final FTGLfont strokeFont) {
        final Resolution resolution = this._context.getVideoResolution();
        return new VideoLayerRenderer.AbstractNormalLayerRenderer(){
            private final WrappedOperation<VideoBounds> inputBoundsOperation;
            {
                this.inputBoundsOperation = new WrappedOperation<VideoBounds>(){

                    @Override
                    public VideoBounds execute() {
                        TACharacter c = TextLayerImpl.this.pc3d_getChar(nArray, list, n, map, fTGLfont, resolution2);
                        return resolution2.scale(TextLayerImpl.this.bbox2ToVideoBounds(c));
                    }
                };
            }

            @Override
            public MediaLayer getLayer() {
                return TextLayerImpl.this;
            }

            @Override
            public double getOpacity() {
                return (Double)TextLayerImpl.this.getOpacity().value(TextLayerImpl.this._context) / 100.0;
            }

            @Override
            public void multModelViewMatrix(double[] mvMatrix) {
                TACharacter c = TextLayerImpl.this.pc3d_getChar(totals, chars, charIndex, charsCache, polygonFont, resolution);
                TextLayerImpl.this.pc3d_multCharMatrix(mvMatrix, c);
            }

            @Override
            public VideoBounds calcBounds(boolean withEffects) {
                return TextLayerImpl.this._vePipeline.getVideoBounds(TextLayerImpl.this, this.getEffects(withEffects), this.inputBoundsOperation);
            }

            @Override
            public IVideoBuffer render(boolean withEffects, boolean frameBlendEnabled) {
                return TextLayerImpl.this._vePipeline.doVideoEffects(TextLayerImpl.this, this.getEffects(withEffects), this.inputBoundsOperation, this.createInputBufferOperation(frameBlendEnabled));
            }

            private List<Effect> getEffects(boolean withEffects) {
                return withEffects && TextLayerImpl.this.isEffectsEnabled() ? TextLayerImpl.this.getEffects() : Collections.emptyList();
            }

            private WrappedOperation<IVideoBuffer> createInputBufferOperation(boolean frameBlendEnabled) {
                return new WrappedOperation<IVideoBuffer>(){

                    @Override
                    public IVideoBuffer execute() {
                        TACharacter c = TextLayerImpl.this.pc3d_getChar(totals, chars, charIndex, charsCache, polygonFont, resolution);
                        return TextLayerImpl.this.pc3d_renderCharNormal(c, bufferFont, polygonFont, strokeFont, resolution);
                    }
                };
            }
        };
    }

    private VideoLayerRenderer.CRLayerRenderer createPerCharacter3DRendererCR(final int[] totals, final List<TACharacter> chars, final int charIndex, final Map<Time, List<TACharacter>> charsCache, final FTGLfont bufferFont, final FTGLfont polygonFont, final FTGLfont strokeFont) {
        final Resolution resolution = this._context.getVideoResolution();
        return new VideoLayerRenderer.AbstractCRLayerRenderer(){

            @Override
            public MediaLayer getLayer() {
                return TextLayerImpl.this;
            }

            @Override
            public double getOpacity() {
                return (Double)TextLayerImpl.this.getOpacity().value(TextLayerImpl.this._context) / 100.0;
            }

            @Override
            public void multModelViewMatrix(double[] mvMatrix) {
                TACharacter c = TextLayerImpl.this.pc3d_getChar(totals, chars, charIndex, charsCache, polygonFont, resolution);
                TextLayerImpl.this.pc3d_multCharMatrix(mvMatrix, c);
            }

            @Override
            public VideoBounds calcBounds(boolean withEffects, VideoBounds viewport) {
                return TextLayerImpl.this._vePipeline.getVideoBounds(TextLayerImpl.this, this.getEffects(withEffects), this.createInputBoundsOperation(viewport));
            }

            @Override
            public IVideoBuffer render(boolean withEffects, VideoBounds viewport, double[] prjMatrix, double[] mvMatrix) {
                return TextLayerImpl.this._vePipeline.doVideoEffects(TextLayerImpl.this, this.getEffects(withEffects), this.createInputBoundsOperation(viewport), this.createInputBufferOperation(viewport, prjMatrix, mvMatrix));
            }

            @Override
            public IVideoBuffer render() {
                return TextLayerImpl.this._context.saveAndExecute(new WrappedOperation<IVideoBuffer>(){

                    @Override
                    public IVideoBuffer execute() {
                        TACharacter c = TextLayerImpl.this.pc3d_getChar(totals, chars, charIndex, charsCache, polygonFont, resolution);
                        return TextLayerImpl.this.pc3d_renderCharNormal(c, bufferFont, polygonFont, strokeFont, resolution);
                    }
                });
            }

            private List<Effect> getEffects(boolean withEffects) {
                return withEffects && TextLayerImpl.this.isEffectsEnabled() ? TextLayerImpl.this.getEffects() : Collections.emptyList();
            }

            private WrappedOperation<VideoBounds> createInputBoundsOperation(final VideoBounds viewport) {
                return new WrappedOperation<VideoBounds>(){

                    @Override
                    public VideoBounds execute() {
                        return viewport;
                    }
                };
            }

            private WrappedOperation<IVideoBuffer> createInputBufferOperation(final VideoBounds bounds, final double[] prjMatrix, final double[] mvMatrix) {
                return new WrappedOperation<IVideoBuffer>(){

                    @Override
                    public IVideoBuffer execute() {
                        IVideoBuffer buffer = null;
                        try {
                            buffer = TextLayerImpl.this._support.createVideoBuffer(bounds);
                            buffer.clear();
                            TACharacter c = TextLayerImpl.this.pc3d_getChar(totals, chars, charIndex, charsCache, polygonFont, resolution);
                            TAContext ctx = new TAContext();
                            ctx.viewport = bounds;
                            ctx.prjMatrix = prjMatrix;
                            ctx.mvMatrix = mvMatrix;
                            ctx.resolution = resolution;
                            ctx.chars = Collections.singletonList(c);
                            ctx.perCharacter3D = true;
                            ctx.polygonFont = true;
                            ctx.fillFont = polygonFont;
                            ctx.strokeFont = strokeFont;
                            TextLayerImpl.this.render(ctx, buffer);
                            IVideoBuffer result = buffer;
                            buffer = null;
                            IVideoBuffer iVideoBuffer = result;
                            return iVideoBuffer;
                        }
                        finally {
                            if (buffer != null) {
                                buffer.dispose();
                            }
                        }
                    }
                };
            }
        };
    }

    private TACharacter pc3d_getChar(int[] totals, List<TACharacter> chars, int charIndex, Map<Time, List<TACharacter>> charsCache, FTGLfont fillFont, Resolution resolution) {
        Time mediaTime = this.calcVideoMediaTime(this.getMediaInput());
        List<TACharacter> chars2 = charsCache.get(mediaTime);
        if (chars2 == null) {
            chars2 = new ArrayList<TACharacter>(chars.size());
            for (TACharacter c : chars) {
                chars2.add(c.clone());
            }
            this.initTACharacters(totals, chars2, true, fillFont, mediaTime);
            for (TACharacter c : chars2) {
                this.calcCharMatrix(c, true, resolution);
            }
            charsCache.put(mediaTime, chars2);
        }
        return chars2.get(charIndex);
    }

    private void pc3d_multCharMatrix(double[] mvMatrix, TACharacter c) {
        this._oldSupport.setMatrix(null, mvMatrix);
        LayerMatrixUtil.multModelViewMatrix(this, this._context, this._oldSupport);
        this._oldSupport.getMatrix(null, mvMatrix);
        Matrix4d m = new Matrix4d(mvMatrix);
        m.transpose();
        m.mul(c.matrix);
        int i = 0;
        while (i < 16) {
            mvMatrix[i] = m.getElement(i % 4, i / 4);
            ++i;
        }
    }

    private IVideoBuffer pc3d_renderCharNormal(TACharacter c, FTGLfont bufferFont, FTGLfont polygonFont, FTGLfont strokeFont, Resolution resolution) {
        IVideoBuffer buffer = null;
        try {
            VideoBounds bounds = resolution.scale(this.bbox2ToVideoBounds(c));
            buffer = this._support.createVideoBuffer(bounds);
            buffer.clear();
            TAContext ctx = new TAContext();
            ctx.viewport = bounds;
            ctx.resolution = resolution;
            ctx.chars = Collections.singletonList(c);
            ctx.perCharacter3D = true;
            ctx.polygonFont = bufferFont == null;
            ctx.fillFont = bufferFont != null ? bufferFont : polygonFont;
            ctx.strokeFont = strokeFont;
            this.render(ctx, buffer);
            IVideoBuffer result = buffer;
            buffer = null;
            IVideoBuffer iVideoBuffer = result;
            return iVideoBuffer;
        }
        finally {
            if (buffer != null) {
                buffer.dispose();
            }
        }
    }

    private static String[] createLineJoinGeometryShader(TextLayer.LineJoin lineJoin) {
        return new String[]{"#version 120", "#extension GL_EXT_geometry_shader4 : enable", "", "#define " + lineJoin.name(), "", "uniform float halfWidth;", "#ifdef MITER", "uniform float miterLimit;", "#endif", "", "void vertex(vec3 v)", "{", "\tgl_Position = gl_ModelViewProjectionMatrix * vec4(v, 1.0);", "\tgl_FrontColor = gl_FrontColorIn[1];", "\tEmitVertex();", "}", "", "void main(void)", "{", "\tvec3 p0 = gl_PositionIn[0].xyz;", "\tvec3 p1 = gl_PositionIn[1].xyz;", "\tvec3 p2 = gl_PositionIn[2].xyz;", "\tvec3 p3 = gl_PositionIn[3].xyz;", "", "\tvec3 v1 = p1 - p0;", "\tvec3 v2 = p2 - p1;", "", "\tvec3 c = cross(v1, v2);", "\tvec3 v4;", "\tif (length(c) > 0.0) {", "\t\tvec3 v3 = normalize(cross(v1, c));", "\t\tv4 = normalize(cross(v2, c));", "", "#ifdef ROUND", "\t\tvec3 v5 = v3;", "\t\tfloat r = acos(dot(v3, v4));", "\t\tfloat s = -sign(c.z);", "\t\tfor (float t = 0.175; t < r; t += 0.175) {", "\t\t\tvertex(p1+halfWidth*v5);", "\t\t\tvertex(p1);", "", "\t\t\tfloat cos = cos(t);", "\t\t\tfloat sin = sin(s*t);", "\t\t\tvec3 v6 = mat3(cos,-sin,0,sin,cos,0,0,0,1)*v3;", "\t\t\tvertex(p1+halfWidth*v6);", "", "\t\t\tEndPrimitive();", "\t\t\tv5 = v6;", "\t\t}", "\t\tvertex(p1+halfWidth*v5);", "\t\tvertex(p1);", "\t\tvertex(p1+halfWidth*v4);", "\t\tEndPrimitive();", "", "#else", "\t\tvertex(p1+halfWidth*v3);", "#ifdef MITER", "\t\tif (dot(normalize(-v1), normalize(v2)) <= miterLimit) {", "\t\t\tvec3 v5 = normalize(v3+v4);", "\t\t\tvertex(p1+halfWidth*v5/dot(v3, v5));", "\t\t}", "#endif", "\t\tvertex(p1);", "\t\tvertex(p1+halfWidth*v4);", "#endif", "\t\tEndPrimitive();", "", "\t} else {", "\t\tc = vec3(0.0, 0.0, 1.0);", "\t\tv4 = normalize(cross(v2, c));", "\t}", "", "\tvertex(p1+halfWidth*v4);", "\tvertex(p1-halfWidth*v4);", "\tvertex(p2+halfWidth*v4);", "\tvertex(p2-halfWidth*v4);", "\tEndPrimitive();", "}"};
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private void render(final TAContext ctx, IVideoBuffer buffer) {
        textType = this.getTextType();
        ctx.lineJoin = textType != TextLayer.TextType.FILL_ONLY ? (TextLayer.LineJoin)this._lineJoin.value(this._context) : null;
        ctx.miterLimit = ctx.lineJoin == TextLayer.LineJoin.MITER ? Math.cos(2.0 * Math.asin(1.0 / (Double)this._miterLimit.value(this._context))) : 0.0;
        v0 = fasOrder = textType == TextLayer.TextType.FILL_AND_STROKE ? (TextLayer.OrderOfFillAndStroke)this._orderOfFillAndStroke.value(this._context) : null;
        if (textType != TextLayer.TextType.FILL_ONLY && ctx.strokeFont != null) {
            dt = false;
            for (TACharacter c : ctx.chars) {
                opacity = c.strokeOpacity * c.opacity;
                if (c.strokeColor == null || !(c.strokeWidth > 0.0) || opacity == 0.0 || opacity == 1.0) continue;
                dt = true;
                break;
            }
            depthTest = dt;
        } else {
            depthTest = false;
        }
        try {
            switch (TextLayerImpl.$SWITCH_TABLE$ch$kuramo$javie$core$TextLayer$TextType()[textType.ordinal()]) {
                case 1: {
                    this.createBlurredImages(ctx, true, false);
                    break;
                }
                case 2: {
                    this.createBlurredImages(ctx, false, true);
                    break;
                }
                case 3: {
                    this.createBlurredImages(ctx, true, true);
                }
            }
            operation /* !! */  = new Runnable(){

                public void run() {
                    block0 : switch (textType) {
                        case FILL_ONLY: {
                            TextLayerImpl.this.renderCharacters(ctx, true, false, false);
                            return;
                        }
                        case STROKE_ONLY: {
                            TextLayerImpl.this.renderCharacters(ctx, false, true, false);
                            return;
                        }
                        case FILL_AND_STROKE: {
                            switch (fasOrder) {
                                case STROKE_OVER_FILL: {
                                    TextLayerImpl.this.renderCharacters(ctx, true, true, false);
                                    break block0;
                                }
                                case FILL_OVER_STROKE: {
                                    TextLayerImpl.this.renderCharacters(ctx, false, true, true);
                                    break block0;
                                }
                                case ALL_STROKES_OVER_ALL_FILLS: {
                                    TextLayerImpl.this.renderCharacters(ctx, true, false, false);
                                    TextLayerImpl.this.renderCharacters(ctx, false, true, false);
                                    break block0;
                                }
                                case ALL_FILLS_OVER_ALL_STROKES: {
                                    TextLayerImpl.this.renderCharacters(ctx, false, true, false);
                                    TextLayerImpl.this.renderCharacters(ctx, true, false, false);
                                }
                            }
                        }
                    }
                }
            };
            if (ctx.polygonFont) {
                bounds = buffer.getBounds();
                innerOp = operation /* !! */ ;
                operation /* !! */  = new Runnable(){

                    public void run() {
                        TextLayerImpl.this._aaSupport.antiAlias(bounds.width, bounds.height, depthTest, Color.COLORLESS_TRANSPARENT, innerOp);
                    }
                };
            }
            pushAttribs = 286977;
            this._support.useFramebuffer(operation /* !! */ , pushAttribs, buffer, new IVideoBuffer[0]);
        }
        finally {
            ** for (c : ctx.chars)
        }
lbl-1000:
        // 1 sources

        {
            if (c.blurredFill != null) {
                c.blurredFill.dispose();
                c.blurredFill = null;
            }
            if (c.blurredStroke == null) continue;
            c.blurredStroke.dispose();
            c.blurredStroke = null;
            continue;
        }
lbl43:
        // 1 sources

    }

    private void createBlurredImages(TAContext ctx, boolean fill, boolean stroke) {
        for (TACharacter c : ctx.chars) {
            if (!(c.blurX > 0.0) && !(c.blurY > 0.0)) continue;
            if (ctx.prjMatrix == null) {
                if (fill && c.fillColor != null && c.fillOpacity > 0.0 && c.opacity > 0.0) {
                    this.createBlurredImageNormal(ctx, c, true);
                }
                if (!this._geometryShaderAvailable || !stroke || ctx.strokeFont == null || c.strokeColor == null || !(c.strokeWidth > 0.0) || !(c.strokeOpacity > 0.0) || !(c.opacity > 0.0)) continue;
                this.createBlurredImageNormal(ctx, c, false);
                continue;
            }
            this.clipCharBBox2(ctx, c);
            if (c.bbox2cp == null) continue;
            if (fill && c.fillColor != null && c.fillOpacity > 0.0 && c.opacity > 0.0) {
                this.createBlurredImageCR(ctx, c, true);
            }
            if (!this._geometryShaderAvailable || !stroke || ctx.strokeFont == null || c.strokeColor == null || !(c.strokeWidth > 0.0) || !(c.strokeOpacity > 0.0) || !(c.opacity > 0.0)) continue;
            this.createBlurredImageCR(ctx, c, false);
        }
    }

    private void createBlurredImageNormal(final TAContext ctx, final TACharacter c, boolean fill) {
        if (fill && c.blurredFill != null) {
            throw new IllegalStateException();
        }
        if (!fill && c.blurredStroke != null) {
            throw new IllegalStateException();
        }
        final VideoBounds bounds = ctx.perCharacter3D ? ctx.viewport : this.bbox2ToVideoBounds(c);
        IVideoBuffer buffer = null;
        try {
            Runnable operation;
            buffer = this._support.createVideoBuffer(bounds);
            if (fill) {
                operation = new Runnable(){

                    public void run() {
                        TextLayerImpl.this.setupMatrix(bounds, null, null, null, ctx.resolution);
                        TextLayerImpl.this.fillCharacter(c, ctx.fillFont);
                    }
                };
                if (ctx.polygonFont) {
                    final Runnable innerOp = operation;
                    operation = new Runnable(){

                        public void run() {
                            TextLayerImpl.this._aaSupport.antiAlias(bounds.width, bounds.height, innerOp);
                        }
                    };
                } else {
                    buffer.clear();
                }
            } else {
                operation = new Runnable(){

                    public void run() {
                        TextLayerImpl.this._aaSupport.antiAlias(bounds.width, bounds.height, c.strokeOpacity * c.opacity < 1.0, Color.COLORLESS_TRANSPARENT, new Runnable(){

                            public void run() {
                                TextLayerImpl.this.setupMatrix(bounds, null, null, null, ctx.resolution);
                                TextLayerImpl.this.strokeCharacter(c, ctx.strokeFont, ctx.lineJoin, ctx.miterLimit);
                            }
                        });
                    }
                };
            }
            int pushAttribs = 0x6001 | (fill ? 0 : 256);
            this._support.useFramebuffer(operation, pushAttribs, buffer, new IVideoBuffer[0]);
            if (fill) {
                c.blurredFill = this.blur(buffer, ctx.resolution.scale(c.blurX), ctx.resolution.scale(c.blurY));
            } else {
                c.blurredStroke = this.blur(buffer, ctx.resolution.scale(c.blurX), ctx.resolution.scale(c.blurY));
            }
        }
        finally {
            if (buffer != null) {
                buffer.dispose();
            }
        }
    }

    private IVideoBuffer blur(IVideoBuffer buffer, double blurX, double blurY) {
        if (blurX <= 0.0 && blurY <= 0.0) {
            throw new IllegalArgumentException();
        }
        if (blurX == blurY) {
            return this._blurSupport.gaussianBlur(buffer, blurX, IBlurSupport.BlurDimensions.BOTH, true, true);
        }
        IVideoBuffer tmp = null;
        try {
            tmp = blurX > 0.0 ? this._blurSupport.gaussianBlur(buffer, blurX, IBlurSupport.BlurDimensions.HORIZONTAL, true, true) : buffer;
            if (blurY > 0.0) {
                IVideoBuffer iVideoBuffer = this._blurSupport.gaussianBlur(tmp, blurY, IBlurSupport.BlurDimensions.VERTICAL, true, true);
                return iVideoBuffer;
            }
            IVideoBuffer result = tmp;
            tmp = null;
            IVideoBuffer iVideoBuffer = result;
            return iVideoBuffer;
        }
        finally {
            if (tmp != null && tmp != buffer) {
                tmp.dispose();
            }
        }
    }

    private void createBlurredImageCR(final TAContext ctx, final TACharacter c, boolean fill) {
        if (fill && c.blurredFill != null) {
            throw new IllegalStateException();
        }
        if (!fill && c.blurredStroke != null) {
            throw new IllegalStateException();
        }
        double tmpScale = 0.0;
        int i = 0;
        int n = c.bbox2c.length;
        while (i < n) {
            int j = i + 1;
            while (j < n) {
                tmpScale = Math.max(tmpScale, c.bbox2cp[i].distance(c.bbox2cp[j]) / c.bbox2c[i].distance(c.bbox2c[j]));
                ++j;
            }
            ++i;
        }
        final double scale = tmpScale = Math.min(tmpScale, LayerNature.getQuality(this) == Quality.BEST ? 2.0 : (double)(1 * Math.max(ctx.viewport.width, ctx.viewport.height)) / Math.max(c.bbox2[2] - c.bbox2[0], c.bbox2[1] - c.bbox2[3]));
        int x = (int)Math.floor(c.bbox2[0] * scale);
        int y = (int)Math.floor(c.bbox2[3] * scale);
        int width = (int)Math.ceil(c.bbox2[2] * scale - (double)x);
        int height = (int)Math.ceil(c.bbox2[1] * scale - (double)y);
        final VideoBounds scaledBounds = new VideoBounds((double)x, (double)y, width, height);
        IVideoBuffer buf1 = null;
        IVideoBuffer buf2 = null;
        IVideoBuffer buf3 = null;
        IVideoBuffer buf4 = null;
        try {
            buf1 = this._support.createVideoBuffer(scaledBounds);
            Runnable operation = fill ? new Runnable(){

                public void run() {
                    TextLayerImpl.this._aaSupport.antiAlias(scaledBounds.width, scaledBounds.height, new Runnable(){

                        public void run() {
                            TextLayerImpl.this.setupMatrix(scaledBounds, null, null, null, scale);
                            TextLayerImpl.this.fillCharacter(c, ctx.fillFont);
                        }
                    });
                }
            } : new Runnable(){

                public void run() {
                    TextLayerImpl.this._aaSupport.antiAlias(scaledBounds.width, scaledBounds.height, c.strokeOpacity * c.opacity < 1.0, Color.COLORLESS_TRANSPARENT, new Runnable(){

                        public void run() {
                            TextLayerImpl.this.setupMatrix(scaledBounds, null, null, null, scale);
                            TextLayerImpl.this.strokeCharacter(c, ctx.strokeFont, ctx.lineJoin, ctx.miterLimit);
                        }
                    });
                }
            };
            int pushAttribs = 0x6001 | (fill ? 0 : 256);
            this._support.useFramebuffer(operation, pushAttribs, buf1, new IVideoBuffer[0]);
            double blurX = Math.min(6250.0, scale * c.blurX);
            double blurY = Math.min(6250.0, scale * c.blurY);
            buf2 = this.blur(buf1, blurX, blurY);
            if (LayerNature.getQuality(this) == Quality.DRAFT) {
                buf2.setTextureFilter(IVideoBuffer.TextureFilter.NEAREST);
            } else {
                buf2.setTextureFilter(IVideoBuffer.TextureFilter.MIPMAP);
            }
            operation = new Runnable(){

                public void run() {
                    GL2 gl = TextLayerImpl.this._context.getGL().getGL2();
                    gl.glViewport(0, 0, ctx.viewport.width, ctx.viewport.height);
                    gl.glMatrixMode(5889);
                    gl.glLoadMatrixd(ctx.prjMatrix, 0);
                    gl.glMatrixMode(5888);
                    gl.glLoadMatrixd(ctx.mvMatrix, 0);
                    if (!ctx.perCharacter3D) {
                        double[] matrix = new double[]{c.matrix.m00, c.matrix.m10, c.matrix.m20, c.matrix.m30, c.matrix.m01, c.matrix.m11, c.matrix.m21, c.matrix.m31, c.matrix.m02, c.matrix.m12, c.matrix.m22, c.matrix.m32, c.matrix.m03, c.matrix.m13, c.matrix.m23, c.matrix.m33};
                        gl.glMultMatrixd(matrix, 0);
                    }
                    float rslScalef = (float)ctx.resolution.scale;
                    gl.glScalef(rslScalef, rslScalef, rslScalef);
                    gl.glClearColor(0.0f, 0.0f, 0.0f, 0.0f);
                    gl.glClear(16384);
                    gl.glBegin(9);
                    Point3d[] point3dArray = c.bbox2c;
                    int n = c.bbox2c.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Point3d pt = point3dArray[n2];
                        double tx = (pt.x * scale - scaledBounds.x) / (double)scaledBounds.width;
                        double ty = (pt.y * scale - scaledBounds.y) / (double)scaledBounds.height;
                        gl.glTexCoord2f((float)tx, (float)ty);
                        gl.glVertex2f((float)pt.x, (float)pt.y);
                        ++n2;
                    }
                    gl.glEnd();
                }
            };
            buf3 = this._support.createVideoBuffer(ctx.viewport);
            pushAttribs = 16384;
            this._support.useFramebuffer(operation, pushAttribs, buf3, new IVideoBuffer[]{buf2});
            buf4 = this._support.createVideoBuffer(c.bbox4);
            this._support.copy(buf3, buf4);
            if (fill) {
                c.blurredFill = buf4;
            } else {
                c.blurredStroke = buf4;
            }
            buf4 = null;
        }
        finally {
            if (buf1 != null) {
                buf1.dispose();
            }
            if (buf2 != null) {
                buf2.dispose();
            }
            if (buf3 != null) {
                buf3.dispose();
            }
            if (buf4 != null) {
                buf4.dispose();
            }
        }
    }

    private void renderCharacters(TAContext ctx, boolean fill, boolean stroke, boolean fill2) {
        for (TACharacter c : ctx.chars) {
            Matrix4d charMatrix;
            Matrix4d matrix4d = charMatrix = ctx.perCharacter3D ? null : c.matrix;
            if (fill && c.fillColor != null && c.fillOpacity > 0.0 && c.opacity > 0.0) {
                if (c.blurredFill == null) {
                    this.setupMatrix(ctx.viewport, ctx.prjMatrix, ctx.mvMatrix, charMatrix, ctx.resolution);
                    this.fillCharacter(c, ctx.fillFont);
                } else {
                    this.setupMatrix(ctx.viewport, null, null, (Matrix4d)(ctx.prjMatrix == null ? charMatrix : null), Resolution.FULL);
                    this.composeBlurredImage(ctx, c.blurredFill);
                }
            }
            if (this._geometryShaderAvailable && stroke && ctx.strokeFont != null && c.strokeColor != null && c.strokeWidth > 0.0 && c.strokeOpacity > 0.0 && c.opacity > 0.0) {
                if (c.blurredStroke == null) {
                    this.setupMatrix(ctx.viewport, ctx.prjMatrix, ctx.mvMatrix, charMatrix, ctx.resolution);
                    this.strokeCharacter(c, ctx.strokeFont, ctx.lineJoin, ctx.miterLimit);
                } else {
                    this.setupMatrix(ctx.viewport, null, null, (Matrix4d)(ctx.prjMatrix == null ? charMatrix : null), Resolution.FULL);
                    this.composeBlurredImage(ctx, c.blurredStroke);
                }
            }
            if (!fill2 || c.fillColor == null || !(c.fillOpacity > 0.0) || !(c.opacity > 0.0)) continue;
            if (c.blurredFill == null) {
                this.setupMatrix(ctx.viewport, ctx.prjMatrix, ctx.mvMatrix, charMatrix, ctx.resolution);
                this.fillCharacter(c, ctx.fillFont);
                continue;
            }
            this.setupMatrix(ctx.viewport, null, null, (Matrix4d)(ctx.prjMatrix == null ? charMatrix : null), Resolution.FULL);
            this.composeBlurredImage(ctx, c.blurredFill);
        }
    }

    private void setupMatrix(VideoBounds viewport, double[] prjMatrix, double[] mvMatrix, Matrix4d charMatrix, Resolution resolution) {
        this.setupMatrix(viewport, prjMatrix, mvMatrix, charMatrix, resolution.scale);
    }

    private void setupMatrix(VideoBounds viewport, double[] prjMatrix, double[] mvMatrix, Matrix4d charMatrix, double extraScaling) {
        GL2 gl = this._context.getGL().getGL2();
        if (prjMatrix == null) {
            this._support.ortho2D(viewport);
            gl.glMatrixMode(5888);
        } else {
            gl.glViewport(0, 0, viewport.width, viewport.height);
            gl.glMatrixMode(5889);
            gl.glLoadMatrixd(prjMatrix, 0);
            gl.glMatrixMode(5888);
            gl.glLoadMatrixd(mvMatrix, 0);
        }
        if (charMatrix != null) {
            double[] matrix = new double[]{charMatrix.m00, charMatrix.m10, charMatrix.m20, charMatrix.m30, charMatrix.m01, charMatrix.m11, charMatrix.m21, charMatrix.m31, charMatrix.m02, charMatrix.m12, charMatrix.m22, charMatrix.m32, charMatrix.m03, charMatrix.m13, charMatrix.m23, charMatrix.m33};
            gl.glMultMatrixd(matrix, 0);
        }
        float scale = (float)extraScaling;
        gl.glScalef(scale, scale, scale);
    }

    private void fillCharacter(TACharacter c, FTGLfont fillFont) {
        GL2 gl = this._context.getGL().getGL2();
        float a = (float)(c.fillOpacity * c.opacity);
        float r = (float)c.fillColor.r;
        float g = (float)c.fillColor.g;
        float b = (float)c.fillColor.b;
        gl.glColor4f(r, g, b, a);
        gl.glEnable(3042);
        gl.glBlendFuncSeparate(770, 771, 1, 771);
        FTGL.ftglRenderFont((FTGLfont)fillFont, (String)c.string, (int)65535);
        gl.glDisable(3042);
    }

    private void strokeCharacter(final TACharacter c, final FTGLfont strokeFont, final TextLayer.LineJoin lineJoin, final double miterLimit) {
        final IShaderProgram program = this._strokePrograms[lineJoin.ordinal()];
        if (program == null) {
            return;
        }
        final GL2 gl = this._context.getGL().getGL2();
        float a = (float)(c.strokeOpacity * c.opacity);
        float r = (float)c.strokeColor.r;
        float g = (float)c.strokeColor.g;
        float b = (float)c.strokeColor.b;
        gl.glColor4f(r, g, b, a);
        if (a < 1.0f) {
            gl.glEnable(2929);
            gl.glClearDepthf(1.0f);
            gl.glClear(256);
        }
        gl.glEnable(3042);
        gl.glBlendFuncSeparate(770, 771, 1, 771);
        program.useProgram(new Runnable(){

            public void run() {
                GLUniformData data = new GLUniformData("halfWidth", (float)(c.strokeWidth * 0.5));
                data.setLocation(program.getUniformLocation(data.getName()));
                gl.glUniform(data);
                if (lineJoin == TextLayer.LineJoin.MITER) {
                    data = new GLUniformData("miterLimit", (float)miterLimit);
                    data.setLocation(program.getUniformLocation(data.getName()));
                    gl.glUniform(data);
                }
                FTGL.ftglRenderFont((FTGLfont)strokeFont, (String)c.string, (int)65535);
            }
        });
        gl.glDisable(3042);
        gl.glDisable(2929);
    }

    private void composeBlurredImage(TAContext ctx, IVideoBuffer buffer) {
        Quality quality = ctx.resolution.scale < 1.0 ? Quality.DRAFT : LayerNature.getQuality(this);
        switch (quality) {
            case BEST: {
                if (ctx.prjMatrix == null && !ctx.perCharacter3D) {
                    buffer.setTextureFilter(IVideoBuffer.TextureFilter.MIPMAP);
                    break;
                }
                buffer.setTextureFilter(IVideoBuffer.TextureFilter.LINEAR);
                break;
            }
            case NORMAL: {
                buffer.setTextureFilter(IVideoBuffer.TextureFilter.LINEAR);
                break;
            }
            case DRAFT: {
                buffer.setTextureFilter(IVideoBuffer.TextureFilter.NEAREST);
            }
        }
        GL2 gl = this._context.getGL().getGL2();
        gl.glColor4f(1.0f, 1.0f, 1.0f, 1.0f);
        gl.glEnable(3042);
        gl.glBlendFuncSeparate(1, 771, 1, 771);
        gl.glEnable(3553);
        gl.glBindTexture(3553, buffer.getTexture());
        VideoBounds b = buffer.getBounds();
        this._support.quad2D(b, (double[][][])new double[][][]{new double[][]{{0.0, 0.0}, {1.0, 0.0}, {1.0, 1.0}, {0.0, 1.0}}});
        gl.glBindTexture(3553, 0);
        gl.glDisable(3553);
        gl.glDisable(3042);
    }

    private FTGLfont getFillFont(String psName, int fontSize, boolean polygonFont) {
        Font font = this._fontList.get(psName);
        if (font == null && (font = this._fontList.defaultFont()) == null) {
            return null;
        }
        String fontPath = font.fontFile.getAbsolutePath();
        int faceIndex = font.faceIndex;
        if (polygonFont) {
            return this._fontManager.getPolygonFont(fontPath, faceIndex, fontSize);
        }
        return this._fontManager.getBufferFont(fontPath, faceIndex, fontSize);
    }

    private FTGLfont getStrokeFont(String psName, int fontSize) {
        Font font = this._fontList.get(psName);
        if (font == null && (font = this._fontList.defaultFont()) == null) {
            return null;
        }
        String fontPath = font.fontFile.getAbsolutePath();
        int faceIndex = font.faceIndex;
        return this._fontManager.getOutlineFont(fontPath, faceIndex, fontSize);
    }

    private VideoBounds calcBounds(List<TACharacter> chars, Resolution resolution) {
        boolean empty = true;
        double top = Double.POSITIVE_INFINITY;
        double left = Double.POSITIVE_INFINITY;
        double bottom = Double.NEGATIVE_INFINITY;
        double right = Double.NEGATIVE_INFINITY;
        for (TACharacter c : chars) {
            this.calcCharMatrix(c, false, resolution);
            this.calcCharBBox3(c, resolution);
            left = Math.min(c.bbox3[0], left);
            top = Math.min(c.bbox3[1], top);
            right = Math.max(c.bbox3[2], right);
            bottom = Math.max(c.bbox3[3], bottom);
            empty = false;
        }
        if (empty) {
            return new VideoBounds(0, 0);
        }
        left = Math.floor(left);
        top = Math.floor(top);
        int width = (int)Math.ceil(right - left);
        int height = (int)Math.ceil(bottom - top);
        return new VideoBounds(left, top, width, height);
    }

    private void calcCharMatrix(TACharacter c, boolean perCharacter3D, Resolution resolution) {
        if (c.matrix != null) {
            return;
        }
        Matrix4d m = new Matrix4d();
        m.setIdentity();
        Matrix4d t = new Matrix4d();
        t.setIdentity();
        t.setTranslation(new Vector3d(resolution.scale(c.positionX), resolution.scale(c.positionY), resolution.scale(perCharacter3D ? c.positionZ : 0.0)));
        m.mul(t);
        if (perCharacter3D) {
            t.setIdentity();
            t.setRotation(new AxisAngle4d(1.0, 0.0, 0.0, Math.toRadians(c.rotationX)));
            m.mul(t);
            t.setIdentity();
            t.setRotation(new AxisAngle4d(0.0, 1.0, 0.0, Math.toRadians(c.rotationY)));
            m.mul(t);
        }
        t.setIdentity();
        t.setRotation(new AxisAngle4d(0.0, 0.0, 1.0, Math.toRadians(c.rotationZ)));
        m.mul(t);
        t.setIdentity();
        t.setRotationScale(new Matrix3d(c.scaleX, 0.0, 0.0, 0.0, c.scaleY, 0.0, 0.0, 0.0, perCharacter3D ? c.scaleZ : 1.0));
        m.mul(t);
        double skewAxis = Math.toRadians(c.skewAxis);
        t.setIdentity();
        t.setRotation(new AxisAngle4d(0.0, 0.0, 1.0, -skewAxis));
        m.mul(t);
        t.setIdentity();
        t.m01 = Math.tan(Math.toRadians(-c.skew));
        m.mul(t);
        t.setIdentity();
        t.setRotation(new AxisAngle4d(0.0, 0.0, 1.0, skewAxis));
        m.mul(t);
        t.setIdentity();
        t.setTranslation(new Vector3d(resolution.scale(-c.anchorPointX), resolution.scale(-c.anchorPointY), resolution.scale(perCharacter3D ? -c.anchorPointZ : 0.0)));
        m.mul(t);
        t.setIdentity();
        t.setRotationScale(new Matrix3d(1.0, 0.0, 0.0, 0.0, -1.0, 0.0, 0.0, 0.0, 1.0));
        m.mul(t);
        c.matrix = m;
    }

    private void calcCharBBox2(TACharacter c) {
        if (c.bbox2 != null) {
            return;
        }
        double outerX = c.strokeWidth * 0.5 + c.blurX;
        double outerY = c.strokeWidth * 0.5 + c.blurY;
        outerX += c.strokeWidth * 0.5;
        outerY += c.strokeWidth * 0.5;
        c.bbox2 = new double[]{(double)c.bbox[0] - (outerX += 2.0), (double)c.bbox[4] + (outerY += 2.0), (double)c.bbox[3] + outerX, (double)c.bbox[1] - outerY};
    }

    private void calcCharBBox3(TACharacter c, Resolution resolution) {
        if (c.bbox3 != null) {
            return;
        }
        this.calcCharBBox2(c);
        Point3d[] bbox = new Point3d[]{new Point3d(c.bbox2[0], c.bbox2[1], 0.0), new Point3d(c.bbox2[2], c.bbox2[1], 0.0), new Point3d(c.bbox2[2], c.bbox2[3], 0.0), new Point3d(c.bbox2[0], c.bbox2[3], 0.0)};
        double[] bbox3 = new double[]{Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY};
        Matrix4d m = new Matrix4d(c.matrix);
        m.mul(new Matrix4d(resolution.scale, 0.0, 0.0, 0.0, 0.0, resolution.scale, 0.0, 0.0, 0.0, 0.0, resolution.scale, 0.0, 0.0, 0.0, 0.0, 1.0));
        Point3d[] point3dArray = bbox;
        int n = bbox.length;
        int n2 = 0;
        while (n2 < n) {
            Point3d pt = point3dArray[n2];
            m.transform(pt);
            bbox3[0] = Math.min(bbox3[0], pt.x);
            bbox3[1] = Math.min(bbox3[1], pt.y);
            bbox3[2] = Math.max(bbox3[2], pt.x);
            bbox3[3] = Math.max(bbox3[3], pt.y);
            ++n2;
        }
        c.bbox3 = bbox3;
    }

    private void clipCharBBox2(TAContext ctx, TACharacter c) {
        if (c.bbox2c != null) {
            return;
        }
        this.calcCharBBox2(c);
        VideoBounds viewport = ctx.viewport;
        double[] prjMatrix = ctx.prjMatrix;
        double[] mvMatrix = ctx.mvMatrix;
        Resolution resolution = ctx.resolution;
        Matrix4d m = new Matrix4d(mvMatrix);
        m.transpose();
        if (!ctx.perCharacter3D) {
            m.mul(c.matrix);
        }
        m.mul(new Matrix4d(resolution.scale, 0.0, 0.0, 0.0, 0.0, resolution.scale, 0.0, 0.0, 0.0, 0.0, resolution.scale, 0.0, 0.0, 0.0, 0.0, 1.0));
        mvMatrix = new double[]{m.m00, m.m10, m.m20, m.m30, m.m01, m.m11, m.m21, m.m31, m.m02, m.m12, m.m22, m.m32, m.m03, m.m13, m.m23, m.m33};
        int w = viewport.width;
        int h = viewport.height;
        int[] nArray = new int[4];
        nArray[2] = w;
        nArray[3] = h;
        int[] vp = nArray;
        double[][] unprj = new double[8][3];
        GLU glu = this._context.getGLU();
        glu.gluUnProject(0.0, 0.0, 0.0, mvMatrix, 0, prjMatrix, 0, vp, 0, unprj[0], 0);
        glu.gluUnProject(0.0, 0.0, 1.0, mvMatrix, 0, prjMatrix, 0, vp, 0, unprj[1], 0);
        glu.gluUnProject((double)w, 0.0, 0.0, mvMatrix, 0, prjMatrix, 0, vp, 0, unprj[2], 0);
        glu.gluUnProject((double)w, 0.0, 1.0, mvMatrix, 0, prjMatrix, 0, vp, 0, unprj[3], 0);
        glu.gluUnProject((double)w, (double)h, 0.0, mvMatrix, 0, prjMatrix, 0, vp, 0, unprj[4], 0);
        glu.gluUnProject((double)w, (double)h, 1.0, mvMatrix, 0, prjMatrix, 0, vp, 0, unprj[5], 0);
        glu.gluUnProject(0.0, (double)h, 0.0, mvMatrix, 0, prjMatrix, 0, vp, 0, unprj[6], 0);
        glu.gluUnProject(0.0, (double)h, 1.0, mvMatrix, 0, prjMatrix, 0, vp, 0, unprj[7], 0);
        Vector4d[] frustumPlanes = new Vector4d[6];
        int i = 0;
        while (i < 6) {
            Point3d p0 = new Point3d(unprj[frustumPlaneTable[i][0]]);
            Point3d p1 = new Point3d(unprj[frustumPlaneTable[i][1]]);
            Point3d p2 = new Point3d(unprj[frustumPlaneTable[i][2]]);
            Vector3d v1 = new Vector3d();
            v1.sub((Tuple3d)p1, (Tuple3d)p0);
            Vector3d v2 = new Vector3d();
            v2.sub((Tuple3d)p2, (Tuple3d)p0);
            Vector3d n = new Vector3d();
            n.cross(v1, v2);
            n.normalize();
            double d = -n.dot(new Vector3d((Tuple3d)p0));
            frustumPlanes[i] = new Vector4d(n.x, n.y, n.z, d);
            ++i;
        }
        List<Point3d> vertices = Util.newList();
        vertices.add(new Point3d(c.bbox2[0], c.bbox2[1], 0.0));
        vertices.add(new Point3d(c.bbox2[2], c.bbox2[1], 0.0));
        vertices.add(new Point3d(c.bbox2[2], c.bbox2[3], 0.0));
        vertices.add(new Point3d(c.bbox2[0], c.bbox2[3], 0.0));
        int i2 = 0;
        while (i2 < 6) {
            Vector4d plane = frustumPlanes[i2];
            double[] opposite = unprj[frustumPlaneTable[i2][3]];
            double signum = Math.signum(plane.dot(new Vector4d(opposite[0], opposite[1], opposite[2], 1.0)));
            List<Point3d>[] partitioned = this.partitionPolygon(plane, signum, vertices);
            if (partitioned != null && partitioned[1] != null) {
                if (partitioned[0] == null) {
                    vertices.clear();
                    break;
                }
                vertices = partitioned[0];
            }
            ++i2;
        }
        c.bbox2c = vertices.toArray(new Point3d[vertices.size()]);
        if (!vertices.isEmpty()) {
            List<Point2d> bbox2cp = Util.newList();
            double[] bbox4 = new double[]{Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY};
            double[] winPos = new double[3];
            for (Point3d pt : vertices) {
                glu.gluProject(pt.x, pt.y, pt.z, mvMatrix, 0, ctx.prjMatrix, 0, vp, 0, winPos, 0);
                bbox2cp.add(new Point2d(winPos));
                bbox4[0] = Math.min(bbox4[0], winPos[0]);
                bbox4[1] = Math.min(bbox4[1], winPos[1]);
                bbox4[2] = Math.max(bbox4[2], winPos[0]);
                bbox4[3] = Math.max(bbox4[3], winPos[1]);
            }
            c.bbox2cp = bbox2cp.toArray(new Point2d[bbox2cp.size()]);
            int x = (int)Math.floor(bbox4[0]);
            int y = (int)Math.floor(bbox4[1]);
            int width = (int)Math.ceil(bbox4[2] - (double)x);
            int height = (int)Math.ceil(bbox4[3] - (double)y);
            c.bbox4 = new VideoBounds((double)x, (double)y, width, height);
        }
    }

    /*
     * Unable to fully structure code
     */
    private List<Point3d>[] partitionPolygon(Vector4d plane, double signum, List<Point3d> vertices) {
        d = 0.0;
        for (Point3d pt : vertices) {
            dd = plane.dot(new Vector4d(pt.x, pt.y, pt.z, 1.0));
            if (!(Math.abs(dd) > Math.abs(d))) continue;
            d = dd;
        }
        if (Math.abs(d) < 0.001) {
            return null;
        }
        vertices = Util.newList(vertices);
        vertIndex1 = -1;
        vertIndex2 = -1;
        i1 = 0;
        while (i1 < vertices.size()) {
            block14: {
                block15: {
                    block16: {
                        i2 = (i1 + 1) % vertices.size();
                        vert1 = vertices.get(i1);
                        vert2 = vertices.get(i2);
                        d1 = plane.dot(new Vector4d(vert1.x, vert1.y, vert1.z, 1.0));
                        d2 = plane.dot(new Vector4d(vert2.x, vert2.y, vert2.z, 1.0));
                        if (Math.signum(d1) == Math.signum(d2)) break block14;
                        if (!(Math.abs(d1) < 0.001)) break block15;
                        if (vertIndex1 != -1) break block16;
                        vertIndex1 = i1;
                        break block14;
                    }
                    vertIndex2 = i1;
                    break;
                }
                if (!(Math.abs(d2) < 0.001)) ** GOTO lbl34
                if (vertIndex1 == -1) {
                    vertIndex1 = ++i1;
                } else {
                    vertIndex2 = i1 + 1;
                    break;
lbl34:
                    // 1 sources

                    v = new Vector3d();
                    v.sub((Tuple3d)vert2, (Tuple3d)vert1);
                    t = -d1 / plane.dot(new Vector4d((Tuple3d)v));
                    v.scale(t);
                    vertNew = new Point3d();
                    vertNew.add((Tuple3d)vert1, (Tuple3d)v);
                    vertices.add(i1 + 1, vertNew);
                    if (vertIndex1 == -1) {
                        vertIndex1 = ++i1;
                    } else {
                        vertIndex2 = i1 + 1;
                        break;
                    }
                }
            }
            ++i1;
        }
        if (vertIndex2 == -1 || vertIndex2 - vertIndex1 <= 1 || vertIndex2 - vertIndex1 >= vertices.size() - 1) {
            d = 0.0;
            for (Point3d pt : vertices) {
                dd = plane.dot(new Vector4d(pt.x, pt.y, pt.z, 1.0));
                if (!(Math.abs(dd) > Math.abs(d))) continue;
                d = dd;
            }
            if (Math.signum(d) == signum) {
                v0 = new List[2];
                v1 = v0;
                v0[0] = vertices;
            } else {
                v2 = new List[2];
                v1 = v2;
                v2[1] = vertices;
            }
            result = v1;
            return result;
        }
        vertices.add(vertices.get(0));
        vertices1 = Util.newList(vertices.subList(0, vertIndex1 + 1));
        vertices2 = Util.newList(vertices.subList(vertIndex1, vertIndex2 + 1));
        vertices1.addAll(vertices.subList(vertIndex2, vertices.size() - 1));
        d = 0.0;
        for (Point3d pt : vertices1) {
            dd = plane.dot(new Vector4d(pt.x, pt.y, pt.z, 1.0));
            if (!(Math.abs(dd) > Math.abs(d))) continue;
            d = dd;
        }
        if (Math.signum(d) == signum) {
            v3 = new List[2];
            v3[0] = vertices1;
            v4 = v3;
            v3[1] = vertices2;
        } else {
            v5 = new List[2];
            v5[0] = vertices2;
            v4 = v5;
            v5[1] = vertices1;
        }
        result = v4;
        return result;
    }

    private VideoBounds bbox2ToVideoBounds(TACharacter c) {
        this.calcCharBBox2(c);
        int x = (int)Math.floor(c.bbox2[0]);
        int y = (int)Math.floor(c.bbox2[3]);
        int width = (int)Math.ceil(c.bbox2[2] - (double)x);
        int height = (int)Math.ceil(c.bbox2[1] - (double)y);
        return new VideoBounds((double)x, (double)y, width, height);
    }

    private List<TACharacter> createTACharacters(int[] totals, String sourceText, FTGLfont font) {
        if (!sourceText.endsWith("\n")) {
            sourceText = String.valueOf(sourceText) + "\n";
        }
        List<TACharacter> chars = Util.newList();
        int charTotal = 0;
        int charTotal2 = 0;
        int wordTotal = 0;
        int lineTotal = 0;
        boolean word = false;
        int i = 0;
        while (i < sourceText.length()) {
            int codePoint = sourceText.codePointAt(i);
            if (Character.isSupplementaryCodePoint(codePoint)) {
                ++i;
            }
            if (codePoint < 0 || codePoint > 65535) {
                codePoint = 35;
            }
            if (codePoint == 10) {
                if (word) {
                    ++wordTotal;
                    word = false;
                }
                ++lineTotal;
            } else {
                String string = new String(new int[]{codePoint}, 0, 1);
                double advance = FTGL.ftglGetFontAdvance((FTGLfont)font, (String)string);
                float[] bbox = new float[6];
                FTGL.ftglGetFontBBox((FTGLfont)font, (String)string, (int)-1, (float[])bbox);
                int type = Character.getType(codePoint);
                if (type == 12) {
                    chars.add(new TACharacter(codePoint, string, advance, bbox, charTotal, -1, -1, lineTotal));
                    if (word) {
                        ++wordTotal;
                        word = false;
                    }
                } else {
                    chars.add(new TACharacter(codePoint, string, advance, bbox, charTotal, charTotal2, wordTotal, lineTotal));
                    ++charTotal2;
                    word = true;
                }
                ++charTotal;
            }
            ++i;
        }
        totals[0] = charTotal;
        totals[1] = charTotal2;
        totals[2] = wordTotal;
        totals[3] = lineTotal;
        return chars;
    }

    private void initTACharacters(int[] totals, List<TACharacter> chars, boolean perCharacter3D, FTGLfont font, Time mediaTime) {
        Color fillColor = null;
        Color strokeColor = null;
        double strokeWidth = 0.0;
        if (this._textType == TextLayer.TextType.FILL_ONLY || this._textType == TextLayer.TextType.FILL_AND_STROKE) {
            fillColor = (Color)this._fillColor.value(this._context);
        }
        if (this._textType == TextLayer.TextType.STROKE_ONLY || this._textType == TextLayer.TextType.FILL_AND_STROKE) {
            strokeColor = (Color)this._strokeColor.value(this._context);
            strokeWidth = (Double)this._strokeWidth.value(this._context);
        }
        for (TACharacter c : chars) {
            c.fillColor = fillColor;
            c.strokeColor = strokeColor;
            c.strokeWidth = strokeWidth;
        }
        double tracking = (Double)this._tracking.value(this._context);
        double leading = (Double)this._leading.value(this._context);
        TextLayer.HorizontalAlignment hAlign = (TextLayer.HorizontalAlignment)((Object)this._horizontalAlignment.value(this._context));
        int fontSize = FTGL.ftglGetFontFaceSize((FTGLfont)font);
        tracking *= 0.001 * (double)fontSize;
        if (leading < 0.0) {
            leading = (double)fontSize * 1.2;
        }
        if (this._textAnimators.isEmpty()) {
            this.initPosition(chars, tracking, leading);
            this.horizontalAlignment(chars, hAlign);
        } else {
            Map<TextAnimator, List<TASelector.Evaluator>> evaluators = this.selectorEvaluators(totals, mediaTime);
            Map<TextAnimator, Map<TAProperty, Object>> properties = this.animatorProperties(perCharacter3D);
            TextAnimator.CharacterAlignment charAlign = (TextAnimator.CharacterAlignment)((Object)this._characterAlignment.value(this._context));
            if (charAlign == TextAnimator.CharacterAlignment.ADJUST_KERNING) {
                this.characterValueAndOffset(chars, font, charAlign, evaluators, properties);
            }
            this.initPosition(chars, tracking, leading);
            this.horizontalAlignment(chars, hAlign);
            this.tracking(chars, hAlign, evaluators, properties);
            this.lineSpacing(chars, evaluators, properties);
            TextAnimator.AnchorPointGrouping ancGrouping = (TextAnimator.AnchorPointGrouping)((Object)this._anchorPointGrouping.value(this._context));
            Vec2d grAlign = (Vec2d)this._groupingAlignment.value(this._context);
            double ascender = FTGL.ftglGetFontAscender((FTGLfont)font);
            this.anchorPointGrouping(chars, ancGrouping, grAlign.x * 0.01, grAlign.y * 0.01, ascender);
            if (charAlign != TextAnimator.CharacterAlignment.ADJUST_KERNING) {
                this.characterValueAndOffset(chars, font, charAlign, evaluators, properties);
            }
            this.otherProperties(chars, perCharacter3D, evaluators, properties);
        }
        Iterator<TACharacter> it = chars.iterator();
        while (it.hasNext()) {
            TACharacter c = it.next();
            if (c.charIndex2 >= 0 && Character.isDefined(c.codePoint) && !Character.isISOControl(c.codePoint)) continue;
            it.remove();
        }
    }

    private void characterValueAndOffset(List<TACharacter> chars, FTGLfont font, TextAnimator.CharacterAlignment charAlign, Map<TextAnimator, List<TASelector.Evaluator>> evaluators, Map<TextAnimator, Map<TAProperty, Object>> properties) {
        List<TextAnimator> animators = Util.newList();
        for (TextAnimator animator : this._textAnimators) {
            if (!animator.isEnabled() || !animator.getProperties().contains((Object)TAProperty.characterValue) && !animator.getProperties().contains((Object)TAProperty.characterOffset)) continue;
            animators.add(animator);
        }
        if (animators.isEmpty()) {
            return;
        }
        for (TextAnimator animator : animators) {
            Map<TAProperty, Object> props = properties.get(animator);
            Object charValueObj = props.get((Object)TAProperty.characterValue);
            Object charOffsetObj = props.get((Object)TAProperty.characterOffset);
            Object charRange = props.get((Object)TAProperty.characterRange);
            if (charRange == null) {
                charRange = TextAnimator.CharacterRange.GROUP;
            }
            for (TACharacter c : chars) {
                int charOffset;
                int charValue;
                double t;
                if (c.charIndex2 < 0) continue;
                List<TASelector.Evaluator> list = evaluators.get(animator);
                if (list.isEmpty()) {
                    t = 1.0;
                } else {
                    double[] tvec = null;
                    for (TASelector.Evaluator evaluator : list) {
                        tvec = evaluator.evaluate(tvec, c.indices);
                    }
                    if (tvec == null) continue;
                    t = tvec[0];
                }
                int codePoint = c.codePoint;
                if (charValueObj != null && (charValue = ((Integer)charValueObj).intValue()) > 0) {
                    if (charRange == TextAnimator.CharacterRange.GROUP) {
                        int gap;
                        int[] r1;
                        codePoint = CharacterGroup.map(codePoint);
                        charValue = CharacterGroup.map(charValue);
                        int[] r0 = CharacterGroup.rangeOf(codePoint);
                        if (r0[0] < (r1 = CharacterGroup.rangeOf(charValue))[0]) {
                            gap = r1[0] - r0[1];
                            if ((codePoint = (int)Math.round((1.0 - t) * (double)codePoint + t * (double)(charValue - gap))) >= r0[1]) {
                                codePoint += gap;
                            }
                        } else if (r1[0] < r0[0]) {
                            gap = r0[0] - r1[1];
                            if ((codePoint = (int)Math.round((1.0 - t) * (double)(codePoint - gap) + t * (double)charValue)) >= r1[1]) {
                                codePoint += gap;
                            }
                        } else {
                            codePoint = (int)Math.round((1.0 - t) * (double)codePoint + t * (double)charValue);
                        }
                        codePoint = CharacterGroup.unmap(codePoint);
                    } else {
                        codePoint = (int)Math.round((1.0 - t) * (double)codePoint + t * (double)charValue);
                    }
                }
                if (charOffsetObj != null && (charOffset = ((Integer)charOffsetObj).intValue()) != 0) {
                    int[] range;
                    if (charRange == TextAnimator.CharacterRange.GROUP) {
                        codePoint = CharacterGroup.map(codePoint);
                        range = CharacterGroup.rangeOf(codePoint);
                    } else {
                        range = CharacterGroup.fullRange();
                    }
                    int mod = range[1] - range[0];
                    codePoint = (int)Math.round((double)codePoint + t * (double)charOffset - (double)range[0]) % mod;
                    if (codePoint < 0) {
                        codePoint += mod;
                    }
                    codePoint += range[0];
                    if (charRange == TextAnimator.CharacterRange.GROUP) {
                        codePoint = CharacterGroup.unmap(codePoint);
                    }
                }
                double oldAdvance = c.advance;
                c.codePoint = codePoint;
                c.string = new String(new int[]{codePoint}, 0, 1);
                c.advance = FTGL.ftglGetFontAdvance((FTGLfont)font, (String)c.string);
                c.bbox = new float[6];
                FTGL.ftglGetFontBBox((FTGLfont)font, (String)c.string, (int)-1, (float[])c.bbox);
                switch (charAlign) {
                    case LEFT_OR_TOP: {
                        break;
                    }
                    case CENTER: {
                        c.anchorPointX += (c.advance - oldAdvance) * 0.5;
                        break;
                    }
                    case RIGHT_OR_BOTTOM: {
                        c.anchorPointX += c.advance - oldAdvance;
                        break;
                    }
                }
            }
        }
    }

    private void initPosition(List<TACharacter> chars, double tracking, double leading) {
        double y = 0.0;
        int lineIndex = 0;
        List<TACharacter> lineChars = Util.newList();
        Iterator<TACharacter> it = chars.iterator();
        while (true) {
            TACharacter c = null;
            if (it.hasNext()) {
                c = it.next();
                if (c.lineIndex == lineIndex) {
                    lineChars.add(c);
                    continue;
                }
            }
            if (!lineChars.isEmpty()) {
                double x = 0.0;
                for (TACharacter lc : lineChars) {
                    lc.positionX = x;
                    lc.positionY = y;
                    x += Math.max(0.0, lc.advance + tracking);
                }
                lineChars.clear();
            }
            if (c == null) break;
            y += leading * (double)(c.lineIndex - lineIndex);
            lineIndex = c.lineIndex;
            lineChars.add(c);
        }
    }

    private void horizontalAlignment(List<TACharacter> chars, TextLayer.HorizontalAlignment hAlign) {
        int lineIndex = 0;
        List<TACharacter> lineChars = Util.newList();
        Iterator<TACharacter> it = chars.iterator();
        while (true) {
            TACharacter c = null;
            if (it.hasNext()) {
                c = it.next();
                if (c.lineIndex == lineIndex) {
                    lineChars.add(c);
                    continue;
                }
            }
            if (!lineChars.isEmpty()) {
                double dx;
                switch (hAlign) {
                    case LEFT: {
                        dx = Double.POSITIVE_INFINITY;
                        for (TACharacter lc : lineChars) {
                            dx = Math.min(dx, lc.positionX);
                        }
                        break;
                    }
                    case CENTER: {
                        double left = Double.POSITIVE_INFINITY;
                        double right = Double.NEGATIVE_INFINITY;
                        for (TACharacter lc : lineChars) {
                            left = Math.min(left, lc.positionX);
                            right = Math.max(right, lc.positionX + lc.advance);
                        }
                        dx = (left + right) * 0.5;
                        break;
                    }
                    default: {
                        dx = Double.NEGATIVE_INFINITY;
                        for (TACharacter lc : lineChars) {
                            dx = Math.max(dx, lc.positionX + lc.advance);
                        }
                    }
                }
                for (TACharacter lc : lineChars) {
                    lc.positionX -= dx;
                }
                lineChars.clear();
            }
            if (c == null) break;
            lineIndex = c.lineIndex;
            lineChars.add(c);
        }
    }

    private void anchorPointGrouping(List<TACharacter> chars, TextAnimator.AnchorPointGrouping ancGrouping, double grAlignX, double grAlignY, double ascender) {
        block0 : switch (ancGrouping) {
            case CHARACTER: {
                for (TACharacter c : chars) {
                    c.anchorPointX = c.advance * 0.5 * (1.0 + grAlignX);
                    c.anchorPointY = ascender * grAlignY;
                    c.positionX += c.anchorPointX;
                    c.positionY += c.anchorPointY;
                }
                break;
            }
            case WORD: {
                int wordIndex = 0;
                List<TACharacter> wordChars = Util.newList();
                Iterator<TACharacter> it = chars.iterator();
                while (true) {
                    TACharacter c = null;
                    if (it.hasNext()) {
                        c = it.next();
                        if (c.wordIndex < 0) continue;
                        if (c.wordIndex == wordIndex) {
                            wordChars.add(c);
                            continue;
                        }
                    }
                    if (!wordChars.isEmpty()) {
                        double left = Double.POSITIVE_INFINITY;
                        double right = Double.NEGATIVE_INFINITY;
                        for (TACharacter wc : wordChars) {
                            left = Math.min(left, wc.positionX);
                            right = Math.max(right, wc.positionX + wc.advance);
                        }
                        double posX = (left + right) * 0.5 + (right - left) * grAlignX * 0.5;
                        double ancY = ascender * grAlignY;
                        for (TACharacter wc : wordChars) {
                            wc.anchorPointX = posX - wc.positionX;
                            wc.anchorPointY = ancY;
                            wc.positionX = posX;
                            wc.positionY += ancY;
                        }
                        wordChars.clear();
                    }
                    if (c == null) break block0;
                    wordIndex = c.wordIndex;
                    wordChars.add(c);
                }
            }
            case LINE: {
                int lineIndex = 0;
                List<TACharacter> lineChars = Util.newList();
                Iterator<TACharacter> it = chars.iterator();
                while (true) {
                    TACharacter c = null;
                    if (it.hasNext()) {
                        c = it.next();
                        if (c.lineIndex == lineIndex) {
                            lineChars.add(c);
                            continue;
                        }
                    }
                    if (!lineChars.isEmpty()) {
                        double left = Double.POSITIVE_INFINITY;
                        double right = Double.NEGATIVE_INFINITY;
                        for (TACharacter lc : lineChars) {
                            left = Math.min(left, lc.positionX);
                            right = Math.max(right, lc.positionX + lc.advance);
                        }
                        double posX = (left + right) * 0.5 + (right - left) * grAlignX * 0.5;
                        double ancY = ascender * grAlignY;
                        for (TACharacter lc : lineChars) {
                            lc.anchorPointX = posX - lc.positionX;
                            lc.anchorPointY = ancY;
                            lc.positionX = posX;
                            lc.positionY += ancY;
                        }
                        lineChars.clear();
                    }
                    if (c == null) break block0;
                    lineIndex = c.lineIndex;
                    lineChars.add(c);
                }
            }
            case ALL: {
                double left = Double.POSITIVE_INFINITY;
                double top = Double.POSITIVE_INFINITY;
                double right = Double.NEGATIVE_INFINITY;
                double bottom = Double.NEGATIVE_INFINITY;
                for (TACharacter c : chars) {
                    left = Math.min(left, c.positionX);
                    top = Math.min(top, c.positionY - ascender);
                    right = Math.max(right, c.positionX + c.advance);
                    bottom = Math.max(bottom, c.positionY);
                }
                double posX = (left + right) * 0.5 + (right - left) * grAlignX * 0.5;
                double posY = (top + bottom) * 0.5 + (bottom - top) * grAlignY * 0.5;
                for (TACharacter c : chars) {
                    c.anchorPointX = posX - c.positionX;
                    c.anchorPointY = posY - c.positionY;
                    c.positionX = posX;
                    c.positionY = posY;
                }
                break;
            }
        }
    }

    private void tracking(List<TACharacter> chars, TextLayer.HorizontalAlignment hAlign, Map<TextAnimator, List<TASelector.Evaluator>> evaluators, Map<TextAnimator, Map<TAProperty, Object>> properties) {
        Map<TextAnimator, Double> trackingValues = Util.newMap();
        for (TextAnimator animator : this._textAnimators) {
            Double tracking = (Double)properties.get(animator).get((Object)TAProperty.tracking);
            if (tracking == null) continue;
            trackingValues.put(animator, tracking);
        }
        if (trackingValues.isEmpty()) {
            return;
        }
        int lineIndex = 0;
        List<TACharacter> lineChars = Util.newList();
        Iterator<TACharacter> it = chars.iterator();
        while (true) {
            TACharacter c = null;
            if (it.hasNext()) {
                c = it.next();
                if (c.lineIndex == lineIndex) {
                    lineChars.add(c);
                    continue;
                }
            }
            if (!lineChars.isEmpty()) {
                double dx = 0.0;
                Iterator it2 = lineChars.iterator();
                block6: while (true) {
                    TACharacter lc = (TACharacter)it2.next();
                    lc.positionX += dx;
                    if (!it2.hasNext()) break;
                    Iterator<TextAnimator> iterator = this._textAnimators.iterator();
                    while (true) {
                        if (!iterator.hasNext()) continue block6;
                        TextAnimator animator = iterator.next();
                        Double tracking = (Double)trackingValues.get(animator);
                        if (tracking == null) continue;
                        List<TASelector.Evaluator> list = evaluators.get(animator);
                        if (list.isEmpty()) {
                            dx += tracking.doubleValue();
                            continue;
                        }
                        double[] tvec = null;
                        for (TASelector.Evaluator evaluator : list) {
                            tvec = evaluator.evaluate(tvec, lc.indices);
                        }
                        if (tvec == null) continue;
                        dx += tvec[0] * tracking;
                    }
                    break;
                }
                switch (hAlign) {
                    case CENTER: {
                        dx *= 0.5;
                    }
                    case RIGHT: {
                        for (TACharacter lc : lineChars) {
                            lc.positionX -= dx;
                        }
                        break;
                    }
                }
                lineChars.clear();
            }
            if (c == null) break;
            lineIndex = c.lineIndex;
            lineChars.add(c);
        }
    }

    private void lineSpacing(List<TACharacter> chars, Map<TextAnimator, List<TASelector.Evaluator>> evaluators, Map<TextAnimator, Map<TAProperty, Object>> properties) {
        Map<TextAnimator, Vec2d> lineSpacingValues = Util.newMap();
        for (TextAnimator animator : this._textAnimators) {
            Vec2d lineSpacing = (Vec2d)properties.get(animator).get((Object)TAProperty.lineSpacing);
            if (lineSpacing == null) continue;
            lineSpacingValues.put(animator, lineSpacing);
        }
        if (lineSpacingValues.isEmpty()) {
            return;
        }
        double dx = 0.0;
        double dy = 0.0;
        int lineIndex = 0;
        List<TACharacter> lineChars = Util.newList();
        Iterator<TACharacter> it = chars.iterator();
        while (true) {
            TACharacter c = null;
            if (it.hasNext()) {
                c = it.next();
                if (c.lineIndex == 0) continue;
                if (c.lineIndex == lineIndex) {
                    lineChars.add(c);
                    continue;
                }
            }
            if (!lineChars.isEmpty()) {
                int[][] indices = new int[lineChars.size()][];
                int i = 0;
                while (i < indices.length) {
                    indices[i] = ((TACharacter)lineChars.get((int)i)).indices;
                    ++i;
                }
                for (TextAnimator animator : this._textAnimators) {
                    Vec2d lineSpacing = (Vec2d)lineSpacingValues.get(animator);
                    if (lineSpacing == null) continue;
                    List<TASelector.Evaluator> list = evaluators.get(animator);
                    if (list.isEmpty()) {
                        dx += lineSpacing.x;
                        dy += lineSpacing.y;
                        continue;
                    }
                    double[] tvec = null;
                    for (TASelector.Evaluator evaluator : list) {
                        tvec = evaluator.evaluate(tvec, indices);
                    }
                    if (tvec == null) continue;
                    dx += tvec[0] * lineSpacing.x;
                    dy += tvec[1] * lineSpacing.y;
                }
                for (TACharacter lc : lineChars) {
                    lc.positionX += dx;
                    lc.positionY += dy;
                }
                lineChars.clear();
            }
            if (c == null) break;
            lineIndex = c.lineIndex;
            lineChars.add(c);
        }
    }

    private void otherProperties(List<TACharacter> chars, boolean perCharacter3D, Map<TextAnimator, List<TASelector.Evaluator>> evaluators, Map<TextAnimator, Map<TAProperty, Object>> properties) {
        for (TextAnimator animator : this._textAnimators) {
            if (!animator.isEnabled()) continue;
            block23: for (TACharacter c : chars) {
                double[] tvec = null;
                double[] fillHSL = null;
                double[] strokeHSL = null;
                block24: for (Map.Entry<TAProperty, Object> e : properties.get(animator).entrySet()) {
                    TAProperty p = e.getKey();
                    block0 : switch (p) {
                        case tracking: 
                        case lineSpacing: 
                        case characterRange: 
                        case characterValue: 
                        case characterOffset: {
                            break;
                        }
                        default: {
                            if (tvec == null) {
                                List<TASelector.Evaluator> list = evaluators.get(animator);
                                if (list.isEmpty()) {
                                    tvec = new double[]{1.0, 1.0, 1.0};
                                } else {
                                    for (TASelector.Evaluator evaluator : list) {
                                        tvec = evaluator.evaluate(tvec, c.indices);
                                    }
                                    if (tvec == null) continue block23;
                                }
                            }
                            Object v = e.getValue();
                            switch (p) {
                                case anchorPoint: {
                                    c.anchorPointX += tvec[0] * ((Vec3d)v).x;
                                    c.anchorPointY += tvec[1] * ((Vec3d)v).y;
                                    if (!perCharacter3D) continue block24;
                                    c.anchorPointZ += tvec[2] * ((Vec3d)v).z;
                                    break block0;
                                }
                                case position: {
                                    c.positionX += tvec[0] * ((Vec3d)v).x;
                                    c.positionY += tvec[1] * ((Vec3d)v).y;
                                    if (!perCharacter3D) continue block24;
                                    c.positionZ += tvec[2] * ((Vec3d)v).z;
                                    break block0;
                                }
                                case scale: {
                                    c.scaleX *= 1.0 - tvec[0] + tvec[0] * ((Vec3d)v).x * 0.01;
                                    c.scaleY *= 1.0 - tvec[1] + tvec[1] * ((Vec3d)v).y * 0.01;
                                    if (!perCharacter3D) continue block24;
                                    c.scaleZ *= 1.0 - tvec[2] + tvec[2] * ((Vec3d)v).z * 0.01;
                                    break block0;
                                }
                                case skew: {
                                    c.skew += tvec[0] * (Double)v;
                                    break block0;
                                }
                                case skewAxis: {
                                    c.skewAxis += tvec[0] * (Double)v;
                                    break block0;
                                }
                                case rotationX: {
                                    if (!perCharacter3D) continue block24;
                                    c.rotationX += tvec[0] * (Double)v;
                                    break block0;
                                }
                                case rotationY: {
                                    if (!perCharacter3D) continue block24;
                                    c.rotationY += tvec[1] * (Double)v;
                                    break block0;
                                }
                                case rotationZ: {
                                    c.rotationZ += tvec[2] * (Double)v;
                                    break block0;
                                }
                                case opacity: {
                                    c.opacity *= 1.0 - tvec[0] + tvec[0] * (Double)v * 0.01;
                                    break block0;
                                }
                                case fillRGB: {
                                    if (c.fillColor == null) continue block24;
                                    Color color = (Color)v;
                                    c.fillColor = new Color((1.0 - tvec[0]) * c.fillColor.r + tvec[0] * color.r, (1.0 - tvec[1]) * c.fillColor.g + tvec[1] * color.g, (1.0 - tvec[2]) * c.fillColor.b + tvec[2] * color.b);
                                    break block0;
                                }
                                case fillHue: 
                                case fillSaturation: 
                                case fillLuminosity: {
                                    if (c.fillColor == null) continue block24;
                                    if (fillHSL == null) {
                                        fillHSL = new double[3];
                                    }
                                    fillHSL[p.ordinal() - TAProperty.fillHue.ordinal()] = (Double)v;
                                    break block0;
                                }
                                case fillOpacity: {
                                    if (c.fillColor == null) continue block24;
                                    c.fillOpacity *= 1.0 - tvec[0] + tvec[0] * (Double)v * 0.01;
                                    break block0;
                                }
                                case strokeRGB: {
                                    if (c.strokeColor == null) continue block24;
                                    Color color = (Color)v;
                                    c.strokeColor = new Color((1.0 - tvec[0]) * c.strokeColor.r + tvec[0] * color.r, (1.0 - tvec[1]) * c.strokeColor.g + tvec[1] * color.g, (1.0 - tvec[2]) * c.strokeColor.b + tvec[2] * color.b);
                                    break block0;
                                }
                                case strokeHue: 
                                case strokeSaturation: 
                                case strokeLuminosity: {
                                    if (c.strokeColor == null) continue block24;
                                    if (strokeHSL == null) {
                                        strokeHSL = new double[3];
                                    }
                                    strokeHSL[p.ordinal() - TAProperty.strokeHue.ordinal()] = (Double)v;
                                    break block0;
                                }
                                case strokeOpacity: {
                                    if (c.strokeColor == null) continue block24;
                                    c.strokeOpacity *= 1.0 - tvec[0] + tvec[0] * (Double)v * 0.01;
                                    break block0;
                                }
                                case strokeWidth: {
                                    if (this.getTextType() == TextLayer.TextType.FILL_ONLY) continue block24;
                                    c.strokeWidth = Math.max(0.0, c.strokeWidth + tvec[0] * (Double)v);
                                    break block0;
                                }
                                case blur: {
                                    c.blurX = Math.max(0.0, c.blurX + tvec[0] * ((Vec2d)v).x);
                                    c.blurY = Math.max(0.0, c.blurY + tvec[1] * ((Vec2d)v).y);
                                    break block0;
                                }
                                default: {
                                    throw new RuntimeException("unknown TAProperty: " + (Object)((Object)p));
                                }
                            }
                        }
                    }
                }
                if (fillHSL != null) {
                    c.fillColor = HSLUtil.addHSL(c.fillColor, tvec[0] * fillHSL[0] / 360.0, tvec[1] * fillHSL[1] * 0.01, tvec[2] * fillHSL[2] * 0.01);
                }
                if (strokeHSL == null) continue;
                c.strokeColor = HSLUtil.addHSL(c.strokeColor, tvec[0] * strokeHSL[0] / 360.0, tvec[1] * strokeHSL[1] * 0.01, tvec[2] * strokeHSL[2] * 0.01);
            }
        }
    }

    private Map<TextAnimator, List<TASelector.Evaluator>> selectorEvaluators(int[] totals, Time mediaTime) {
        Map<TextAnimator, List<TASelector.Evaluator>> map = Util.newMap();
        for (TextAnimator animator : this._textAnimators) {
            List<TASelector.Evaluator> list = Util.newList();
            map.put(animator, list);
            if (!animator.isEnabled()) continue;
            for (TASelector selector : animator.getSelectors()) {
                if (!selector.isEnabled()) continue;
                list.add(selector.createEvaluator(totals, mediaTime));
            }
        }
        return map;
    }

    /*
     * Unable to fully structure code
     */
    private Map<TextAnimator, Map<TAProperty, Object>> animatorProperties(boolean perCharacter3D) {
        map = Util.newMap();
        for (TextAnimator animator : this._textAnimators) {
            map2 = Util.newMap();
            map.put(animator, map2);
            if (!animator.isEnabled()) continue;
            for (TAProperty p : animator.getProperties()) {
                if (perCharacter3D) ** GOTO lbl-1000
                switch (TextLayerImpl.$SWITCH_TABLE$ch$kuramo$javie$core$TAProperty()[p.ordinal()]) {
                    case 6: 
                    case 7: {
                        break;
                    }
                    default: lbl-1000:
                    // 2 sources

                    {
                        switch (TextLayerImpl.$SWITCH_TABLE$ch$kuramo$javie$core$TAProperty()[p.ordinal()]) {
                            case 1: {
                                value = animator.getAnchorPoint().value(this._context);
                                break;
                            }
                            case 2: {
                                value = animator.getPosition().value(this._context);
                                break;
                            }
                            case 3: {
                                value = animator.getScale().value(this._context);
                                break;
                            }
                            case 4: {
                                value = animator.getSkew().value(this._context);
                                break;
                            }
                            case 5: {
                                value = animator.getSkewAxis().value(this._context);
                                break;
                            }
                            case 6: {
                                value = animator.getRotationX().value(this._context);
                                break;
                            }
                            case 7: {
                                value = animator.getRotationY().value(this._context);
                                break;
                            }
                            case 8: {
                                value = animator.getRotationZ().value(this._context);
                                break;
                            }
                            case 9: {
                                value = animator.getOpacity().value(this._context);
                                break;
                            }
                            case 10: {
                                value = animator.getFillRGB().value(this._context);
                                break;
                            }
                            case 11: {
                                value = animator.getFillHue().value(this._context);
                                break;
                            }
                            case 12: {
                                value = animator.getFillSaturation().value(this._context);
                                break;
                            }
                            case 13: {
                                value = animator.getFillLuminosity().value(this._context);
                                break;
                            }
                            case 14: {
                                value = animator.getFillOpacity().value(this._context);
                                break;
                            }
                            case 15: {
                                value = animator.getStrokeRGB().value(this._context);
                                break;
                            }
                            case 16: {
                                value = animator.getStrokeHue().value(this._context);
                                break;
                            }
                            case 17: {
                                value = animator.getStrokeSaturation().value(this._context);
                                break;
                            }
                            case 18: {
                                value = animator.getStrokeLuminosity().value(this._context);
                                break;
                            }
                            case 19: {
                                value = animator.getStrokeOpacity().value(this._context);
                                break;
                            }
                            case 20: {
                                value = animator.getStrokeWidth().value(this._context);
                                break;
                            }
                            case 21: {
                                value = animator.getTracking().value(this._context);
                                break;
                            }
                            case 22: {
                                value = animator.getLineSpacing().value(this._context);
                                break;
                            }
                            case 23: {
                                value = animator.getCharacterRange().value(this._context);
                                break;
                            }
                            case 24: {
                                value = animator.getCharacterValue().value(this._context);
                                break;
                            }
                            case 25: {
                                value = animator.getCharacterOffset().value(this._context);
                                break;
                            }
                            case 26: {
                                value = animator.getBlur().value(this._context);
                                break;
                            }
                            default: {
                                throw new RuntimeException("unknown TAProperty: " + (Object)p);
                            }
                        }
                        map2.put(p, value);
                    }
                }
            }
        }
        return map;
    }

    static /* synthetic */ int[] $SWITCH_TABLE$ch$kuramo$javie$core$TextLayer$TextType() {
        if ($SWITCH_TABLE$ch$kuramo$javie$core$TextLayer$TextType != null) {
            return $SWITCH_TABLE$ch$kuramo$javie$core$TextLayer$TextType;
        }
        int[] nArray = new int[TextLayer.TextType.values().length];
        try {
            nArray[TextLayer.TextType.FILL_AND_STROKE.ordinal()] = 3;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[TextLayer.TextType.FILL_ONLY.ordinal()] = 1;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[TextLayer.TextType.STROKE_ONLY.ordinal()] = 2;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        $SWITCH_TABLE$ch$kuramo$javie$core$TextLayer$TextType = nArray;
        return nArray;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AnimatableHorizontalAlignment
    extends AbstractAnimatableEnum<TextLayer.HorizontalAlignment> {
        public AnimatableHorizontalAlignment(TextLayer.HorizontalAlignment staticValue, Collection<Keyframe<TextLayer.HorizontalAlignment>> keyframes, String expression) {
            super(TextLayer.HorizontalAlignment.class, staticValue, keyframes, expression);
        }

        public AnimatableHorizontalAlignment(TextLayer.HorizontalAlignment defaultValue) {
            super(TextLayer.HorizontalAlignment.class, defaultValue);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AnimatableLineJoin
    extends AbstractAnimatableEnum<TextLayer.LineJoin> {
        public AnimatableLineJoin(TextLayer.LineJoin staticValue, Collection<Keyframe<TextLayer.LineJoin>> keyframes, String expression) {
            super(TextLayer.LineJoin.class, staticValue, keyframes, expression);
        }

        public AnimatableLineJoin(TextLayer.LineJoin defaultValue) {
            super(TextLayer.LineJoin.class, defaultValue);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AnimatableOrderOfFillAndStroke
    extends AbstractAnimatableEnum<TextLayer.OrderOfFillAndStroke> {
        public AnimatableOrderOfFillAndStroke(TextLayer.OrderOfFillAndStroke staticValue, Collection<Keyframe<TextLayer.OrderOfFillAndStroke>> keyframes, String expression) {
            super(TextLayer.OrderOfFillAndStroke.class, staticValue, keyframes, expression);
        }

        public AnimatableOrderOfFillAndStroke(TextLayer.OrderOfFillAndStroke defaultValue) {
            super(TextLayer.OrderOfFillAndStroke.class, defaultValue);
        }
    }

    private static class TACharacter
    implements Cloneable {
        int codePoint;
        String string;
        double advance;
        float[] bbox;
        final int charIndex2;
        final int wordIndex;
        final int lineIndex;
        final int[] indices;
        double anchorPointX;
        double anchorPointY;
        double anchorPointZ;
        double positionX;
        double positionY;
        double positionZ;
        double scaleX = 1.0;
        double scaleY = 1.0;
        double scaleZ = 1.0;
        double skew;
        double skewAxis;
        double rotationX;
        double rotationY;
        double rotationZ;
        double opacity = 1.0;
        Color fillColor;
        double fillOpacity = 1.0;
        Color strokeColor;
        double strokeOpacity = 1.0;
        double strokeWidth;
        double blurX;
        double blurY;
        Matrix4d matrix;
        double[] bbox2;
        double[] bbox3;
        Point3d[] bbox2c;
        Point2d[] bbox2cp;
        VideoBounds bbox4;
        IVideoBuffer blurredFill;
        IVideoBuffer blurredStroke;

        TACharacter(int codePoint, String string, double advance, float[] bbox, int charIndex, int charIndex2, int wordIndex, int lineIndex) {
            this.codePoint = codePoint;
            this.string = string;
            this.advance = advance;
            this.bbox = bbox;
            this.charIndex2 = charIndex2;
            this.wordIndex = wordIndex;
            this.lineIndex = lineIndex;
            this.indices = new int[]{charIndex, charIndex2, wordIndex, lineIndex};
        }

        protected TACharacter clone() {
            try {
                return (TACharacter)super.clone();
            }
            catch (CloneNotSupportedException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static class TAContext {
        VideoBounds viewport;
        double[] prjMatrix;
        double[] mvMatrix;
        Resolution resolution;
        List<TACharacter> chars;
        boolean perCharacter3D;
        boolean polygonFont;
        FTGLfont fillFont;
        FTGLfont strokeFont;
        TextLayer.LineJoin lineJoin;
        double miterLimit;

        private TAContext() {
        }
    }

    private class TextInput
    implements VectorMediaInput {
        private TextInput() {
        }

        public boolean isVideoAvailable() {
            return true;
        }

        public boolean isAudioAvailable() {
            return false;
        }

        public Time getDuration() {
            return null;
        }

        public Time getVideoFrameDuration() {
            return null;
        }

        public VideoBounds getVideoFrameBounds() {
            int fontSize;
            if (!TextLayerImpl.this._context.isActive()) {
                return new VideoBounds(100, 100);
            }
            String psName = (String)TextLayerImpl.this._font.value(TextLayerImpl.this._context);
            FTGLfont fillFont = TextLayerImpl.this.getFillFont(psName, fontSize = ((Integer)TextLayerImpl.this._fontSize.value(TextLayerImpl.this._context)).intValue(), true);
            if (fillFont == null) {
                return new VideoBounds(0, 0);
            }
            int[] totals = new int[4];
            String sourceText = (String)TextLayerImpl.this._sourceText.value(TextLayerImpl.this._context);
            List chars = TextLayerImpl.this.createTACharacters(totals, sourceText, fillFont);
            if (chars.isEmpty()) {
                return new VideoBounds(0, 0);
            }
            TextLayerImpl.this.initTACharacters(totals, chars, false, fillFont, TextLayerImpl.this.calcVideoMediaTime(this));
            return TextLayerImpl.this.calcBounds(chars, Resolution.FULL);
        }

        public IVideoBuffer getVideoFrame(Time mediaTime) {
            FTGLfont strokeFont;
            boolean fillOnly = TextLayerImpl.this.getTextType() == TextLayer.TextType.FILL_ONLY;
            String psName = (String)TextLayerImpl.this._font.value(TextLayerImpl.this._context);
            int fontSize = (Integer)TextLayerImpl.this._fontSize.value(TextLayerImpl.this._context);
            FTGLfont fillFont = TextLayerImpl.this.getFillFont(psName, fontSize, true);
            FTGLfont fTGLfont = strokeFont = fillOnly ? null : TextLayerImpl.this.getStrokeFont(psName, fontSize);
            if (fillFont == null) {
                return TextLayerImpl.this._support.createVideoBuffer(new VideoBounds(0, 0));
            }
            int[] totals = new int[4];
            String sourceText = (String)TextLayerImpl.this._sourceText.value(TextLayerImpl.this._context);
            List chars = TextLayerImpl.this.createTACharacters(totals, sourceText, fillFont);
            if (chars.isEmpty()) {
                return TextLayerImpl.this._support.createVideoBuffer(new VideoBounds(0, 0));
            }
            TextLayerImpl.this.initTACharacters(totals, chars, false, fillFont, mediaTime);
            if (fillOnly && (fillFont = TextLayerImpl.this.getFillFont(psName, fontSize, false)) == null) {
                return TextLayerImpl.this._support.createVideoBuffer(new VideoBounds(0, 0));
            }
            Resolution resolution = TextLayerImpl.this._context.getVideoResolution();
            VideoBounds bounds = TextLayerImpl.this.calcBounds(chars, resolution);
            IVideoBuffer buffer = null;
            try {
                buffer = TextLayerImpl.this._support.createVideoBuffer(bounds);
                buffer.clear();
                TAContext ctx = new TAContext();
                ctx.viewport = bounds;
                ctx.resolution = resolution;
                ctx.chars = chars;
                ctx.perCharacter3D = false;
                ctx.polygonFont = !fillOnly;
                ctx.fillFont = fillFont;
                ctx.strokeFont = strokeFont;
                TextLayerImpl.this.render(ctx, buffer);
                IVideoBuffer result = buffer;
                buffer = null;
                IVideoBuffer iVideoBuffer = result;
                return iVideoBuffer;
            }
            finally {
                if (buffer != null) {
                    buffer.dispose();
                }
            }
        }

        public void rasterize(IVideoBuffer buffer, double[] prjMatrix, double[] mvMatrix, Time mediaTime) {
            FTGLfont strokeFont;
            boolean fillOnly = TextLayerImpl.this.getTextType() == TextLayer.TextType.FILL_ONLY;
            String psName = (String)TextLayerImpl.this._font.value(TextLayerImpl.this._context);
            int fontSize = (Integer)TextLayerImpl.this._fontSize.value(TextLayerImpl.this._context);
            FTGLfont fillFont = TextLayerImpl.this.getFillFont(psName, fontSize, true);
            FTGLfont fTGLfont = strokeFont = fillOnly ? null : TextLayerImpl.this.getStrokeFont(psName, fontSize);
            if (fillFont == null) {
                return;
            }
            int[] totals = new int[4];
            String sourceText = (String)TextLayerImpl.this._sourceText.value(TextLayerImpl.this._context);
            List chars = TextLayerImpl.this.createTACharacters(totals, sourceText, fillFont);
            if (chars.isEmpty()) {
                return;
            }
            TextLayerImpl.this.initTACharacters(totals, chars, false, fillFont, mediaTime);
            TAContext ctx = new TAContext();
            ctx.viewport = buffer.getBounds();
            ctx.prjMatrix = prjMatrix;
            ctx.mvMatrix = mvMatrix;
            ctx.resolution = TextLayerImpl.this._context.getVideoResolution();
            ctx.chars = chars;
            ctx.perCharacter3D = false;
            ctx.polygonFont = true;
            ctx.fillFont = fillFont;
            ctx.strokeFont = strokeFont;
            Iterator it = chars.iterator();
            while (it.hasNext()) {
                TACharacter c = (TACharacter)it.next();
                TextLayerImpl.this.calcCharMatrix(c, false, ctx.resolution);
                TextLayerImpl.this.clipCharBBox2(ctx, c);
                if (c.bbox2c.length != 0) continue;
                it.remove();
            }
            TextLayerImpl.this.render(ctx, buffer);
        }

        public IAudioBuffer getAudioChunk(Time mediaTime) {
            throw new UnsupportedOperationException("audio is not available");
        }
    }

    public class TextLayerExpressionElement
    extends AbstractMediaLayer.MediaLayerExpressionElement {
        public TextLayerExpressionElement(CoreContext context) {
            super(context);
        }

        public Object getSourceText() {
            return this.elem(TextLayerImpl.this._sourceText);
        }

        public Object getFont() {
            return this.elem(TextLayerImpl.this._font);
        }

        public Object getFontSize() {
            return this.elem(TextLayerImpl.this._fontSize);
        }

        public String getTextType() {
            return TextLayerImpl.this._textType.name();
        }

        public Object getFillColor() {
            return this.elem(TextLayerImpl.this._fillColor);
        }

        public Object getStrokeColor() {
            return this.elem(TextLayerImpl.this._strokeColor);
        }

        public Object getStrokeWidth() {
            return this.elem(TextLayerImpl.this._strokeWidth);
        }

        public Object getLineJoin() {
            return this.elem(TextLayerImpl.this._lineJoin);
        }

        public Object getMiterLimit() {
            return this.elem(TextLayerImpl.this._miterLimit);
        }

        public Object getOrderOfFillAndStroke() {
            return this.elem(TextLayerImpl.this._orderOfFillAndStroke);
        }

        public Object getHorizontalAlignment() {
            return this.elem(TextLayerImpl.this._horizontalAlignment);
        }

        public Object getTracking() {
            return this.elem(TextLayerImpl.this._tracking);
        }

        public Object getLeading() {
            return this.elem(TextLayerImpl.this._leading);
        }

        public Object getAnchorPointGrouping() {
            return this.elem(TextLayerImpl.this._anchorPointGrouping);
        }

        public Object getGroupingAlignment() {
            return this.elem(TextLayerImpl.this._groupingAlignment);
        }

        public Object getCharacterAlignment() {
            return this.elem(TextLayerImpl.this._characterAlignment);
        }

        public boolean isPerCharacter3D() {
            return TextLayerImpl.this._perCharacter3D;
        }

        public Object getTextAnimators() {
            Object[] array = new Object[TextLayerImpl.this._textAnimators.size()];
            int i = 0;
            while (i < array.length) {
                array[i] = this.elem((Expressionee)TextLayerImpl.this._textAnimators.get(i));
                ++i;
            }
            return array;
        }

        public Object textAnimator(int index) {
            return this.elem((Expressionee)TextLayerImpl.this._textAnimators.get(index - 1));
        }

        public Object textAnimator(String name) {
            for (TextAnimator animator : TextLayerImpl.this._textAnimators) {
                if (!animator.getName().equals(name)) continue;
                return this.elem(animator);
            }
            return null;
        }
    }
}

