/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.core.internal;

import ch.kuramo.javie.api.IAudioBuffer;
import ch.kuramo.javie.api.IVideoBuffer;
import ch.kuramo.javie.api.Time;
import ch.kuramo.javie.api.VideoBounds;
import ch.kuramo.javie.core.AbstractItem;
import ch.kuramo.javie.core.FileItem;
import ch.kuramo.javie.core.MediaInput;
import ch.kuramo.javie.core.MediaItem;
import ch.kuramo.javie.core.MediaOptions;
import ch.kuramo.javie.core.MediaSource;
import ch.kuramo.javie.core.Project;
import ch.kuramo.javie.core.ProjectDecodeException;
import ch.kuramo.javie.core.annotations.ProjectElement;
import ch.kuramo.javie.core.internal.MediaInputPlaceholderImpl;
import ch.kuramo.javie.core.services.MediaSourceFactory;
import com.google.inject.Inject;
import com.google.inject.Injector;
import java.io.File;
import net.arnx.jsonic.JSONHint;

@ProjectElement(value="mediaFile")
public class MediaFileItem
extends AbstractItem
implements MediaItem,
FileItem {
    private File _file;
    private MediaSource _mediaSource;
    private MediaOptions _mediaOptions;
    private MediaInput _mediaInput;
    private VideoBounds _placeholderBounds;
    @Inject
    private MediaSourceFactory _mediaSourceFactory;
    @Inject
    private Injector _injector;

    public void initialize(File file) {
        super.initialize();
        this._mediaSource = this._mediaSourceFactory.get(this.getId(), file);
        if (this._mediaSource != null) {
            this._file = file;
            this.setName(file.getName());
            this._mediaOptions = this._mediaSource.validateOptions(null);
            this._mediaInput = new MediaInputImpl();
        }
    }

    protected void finalize() throws Throwable {
        this.dispose();
        super.finalize();
    }

    public void dispose() {
        this._mediaInput = null;
        if (this._mediaSource != null) {
            this._mediaSourceFactory.release(this.getId());
            this._mediaSource = null;
        }
    }

    public File getFile() {
        return this._file;
    }

    public void setFile(File file) {
        this._file = file;
    }

    @JSONHint(ignore=true)
    public MediaSource getMediaSource() {
        return this._mediaSource;
    }

    public MediaOptions getMediaOptions() {
        return this._mediaOptions != null ? this._mediaOptions.clone() : null;
    }

    public void setMediaOptions(MediaOptions options) {
        if (this._mediaSource != null) {
            this._mediaOptions = this._mediaSource.validateOptions(options);
        } else {
            if (this._mediaInput != null) {
                throw new UnsupportedOperationException();
            }
            this._mediaOptions = options != null ? options.clone() : null;
        }
    }

    @JSONHint(ignore=true)
    public MediaInput getMediaInput() {
        return this._mediaInput;
    }

    public VideoBounds getPlaceholderBounds() {
        if (this._mediaSource != null && this._mediaSource.isVideoAvailable()) {
            this._placeholderBounds = this._mediaSource.getVideoFrameBounds(this._mediaOptions);
        }
        return this._placeholderBounds;
    }

    public void setPlaceholderBounds(VideoBounds placeholderBounds) {
        this._placeholderBounds = placeholderBounds;
    }

    public void afterDecode(Project p) throws ProjectDecodeException {
        super.afterDecode(p);
        this._mediaSource = this._mediaSourceFactory.get(this.getId(), this._file);
        if (this._mediaSource != null) {
            this._mediaOptions = this._mediaSource.validateOptions(this._mediaOptions);
            this._mediaInput = new MediaInputImpl();
        } else {
            MediaInputPlaceholderImpl placeholder = (MediaInputPlaceholderImpl)this._injector.getInstance(MediaInputPlaceholderImpl.class);
            placeholder.setVideoFrameBounds(this._placeholderBounds);
            this._mediaInput = placeholder;
        }
    }

    @JSONHint(ignore=true)
    public String getKind() {
        return null;
    }

    private class MediaInputImpl
    implements MediaInput {
        private MediaInputImpl() {
        }

        public boolean isVideoAvailable() {
            return MediaFileItem.this._mediaSource.isVideoAvailable();
        }

        public boolean isAudioAvailable() {
            return MediaFileItem.this._mediaSource.isAudioAvailable();
        }

        public Time getDuration() {
            return MediaFileItem.this._mediaSource.getDuration(MediaFileItem.this._mediaOptions);
        }

        public Time getVideoFrameDuration() {
            return MediaFileItem.this._mediaSource.getVideoFrameDuration(MediaFileItem.this._mediaOptions);
        }

        public VideoBounds getVideoFrameBounds() {
            return MediaFileItem.this._mediaSource.getVideoFrameBounds(MediaFileItem.this._mediaOptions);
        }

        public IVideoBuffer getVideoFrame(Time mediaTime) {
            return MediaFileItem.this._mediaSource.getVideoFrame(mediaTime, MediaFileItem.this._mediaOptions);
        }

        public IAudioBuffer getAudioChunk(Time mediaTime) {
            return MediaFileItem.this._mediaSource.getAudioChunk(mediaTime, MediaFileItem.this._mediaOptions);
        }
    }
}

