/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.core.internal;

import ch.kuramo.javie.api.Color;
import ch.kuramo.javie.api.Vec3d;
import ch.kuramo.javie.core.AbstractLayer;
import ch.kuramo.javie.core.AnimatableColor;
import ch.kuramo.javie.core.AnimatableDouble;
import ch.kuramo.javie.core.AnimatableVec3d;
import ch.kuramo.javie.core.CoreContext;
import ch.kuramo.javie.core.ExpressionScope;
import ch.kuramo.javie.core.LightLayer;
import ch.kuramo.javie.core.LightType;
import ch.kuramo.javie.core.annotations.ProjectElement;

@ProjectElement(value="lightLayer")
public class LightLayerImpl
extends AbstractLayer
implements LightLayer {
    private boolean videoEnabled = true;
    private AnimatableVec3d pointOfInterest = new AnimatableVec3d(new Vec3d(0.0, 0.0, 0.0));
    private AnimatableVec3d position = new AnimatableVec3d(new Vec3d(0.0, 0.0, 0.0));
    private AnimatableVec3d orientation = new AnimatableVec3d(new Vec3d(0.0, 0.0, 0.0), true);
    private AnimatableDouble rotationX = new AnimatableDouble(0.0);
    private AnimatableDouble rotationY = new AnimatableDouble(0.0);
    private AnimatableDouble rotationZ = new AnimatableDouble(0.0);
    private LightType lightType = LightType.POINT;
    private AnimatableDouble intensity = new AnimatableDouble(100.0);
    private AnimatableVec3d attenuation = new AnimatableVec3d(new Vec3d(1.0, 0.0, 0.0), Vec3d.ZERO, Vec3d.POSITIVE_INFINITY);
    private AnimatableColor color = new AnimatableColor(Color.WHITE);
    private AnimatableDouble coneAngle = new AnimatableDouble((Double)90.0, 0.0, 180.0);
    private AnimatableDouble coneFeather = new AnimatableDouble((Double)50.0, 0.0, 100.0);
    private boolean castsShadows = false;
    private AnimatableDouble shadowDarkness = new AnimatableDouble((Double)100.0, 0.0, Double.POSITIVE_INFINITY);
    private AnimatableDouble shadowDiffusion = new AnimatableDouble((Double)0.0, 0.0, Double.POSITIVE_INFINITY);

    public boolean isVideoEnabled() {
        return this.videoEnabled;
    }

    public void setVideoEnabled(boolean enabled) {
        this.videoEnabled = enabled;
    }

    public AnimatableVec3d getPointOfInterest() {
        return this.pointOfInterest;
    }

    public void setPointOfInterest(AnimatableVec3d pointOfInterest) {
        pointOfInterest.copyConfigurationFrom(this.pointOfInterest);
        this.pointOfInterest = pointOfInterest;
    }

    public AnimatableVec3d getPosition() {
        return this.position;
    }

    public void setPosition(AnimatableVec3d position) {
        position.copyConfigurationFrom(this.position);
        this.position = position;
    }

    public AnimatableVec3d getOrientation() {
        return this.orientation;
    }

    public void setOrientation(AnimatableVec3d orientation) {
        orientation.copyConfigurationFrom(this.orientation);
        this.orientation = orientation;
    }

    public AnimatableDouble getRotationX() {
        return this.rotationX;
    }

    public void setRotationX(AnimatableDouble rotationX) {
        rotationX.copyConfigurationFrom(this.rotationX);
        this.rotationX = rotationX;
    }

    public AnimatableDouble getRotationY() {
        return this.rotationY;
    }

    public void setRotationY(AnimatableDouble rotationY) {
        rotationY.copyConfigurationFrom(this.rotationY);
        this.rotationY = rotationY;
    }

    public AnimatableDouble getRotationZ() {
        return this.rotationZ;
    }

    public void setRotationZ(AnimatableDouble rotationZ) {
        rotationZ.copyConfigurationFrom(this.rotationZ);
        this.rotationZ = rotationZ;
    }

    public LightType getLightType() {
        return this.lightType;
    }

    public void setLightType(LightType lightType) {
        this.lightType = lightType;
    }

    public AnimatableDouble getIntensity() {
        return this.intensity;
    }

    public void setIntensity(AnimatableDouble intensity) {
        intensity.copyConfigurationFrom(this.intensity);
        this.intensity = intensity;
    }

    public AnimatableVec3d getAttenuation() {
        return this.attenuation;
    }

    public void setAttenuation(AnimatableVec3d attenuation) {
        attenuation.copyConfigurationFrom(this.attenuation);
        this.attenuation = attenuation;
    }

    public AnimatableColor getColor() {
        return this.color;
    }

    public void setColor(AnimatableColor color) {
        color.copyConfigurationFrom(this.color);
        this.color = color;
    }

    public AnimatableDouble getConeAngle() {
        return this.coneAngle;
    }

    public void setConeAngle(AnimatableDouble coneAngle) {
        coneAngle.copyConfigurationFrom(this.coneAngle);
        this.coneAngle = coneAngle;
    }

    public AnimatableDouble getConeFeather() {
        return this.coneFeather;
    }

    public void setConeFeather(AnimatableDouble coneFeather) {
        coneFeather.copyConfigurationFrom(this.coneFeather);
        this.coneFeather = coneFeather;
    }

    public boolean isCastsShadows() {
        return this.castsShadows;
    }

    public void setCastsShadows(boolean castsShadows) {
        this.castsShadows = castsShadows;
    }

    public AnimatableDouble getShadowDarkness() {
        return this.shadowDarkness;
    }

    public void setShadowDarkness(AnimatableDouble shadowDarkness) {
        shadowDarkness.copyConfigurationFrom(this.shadowDarkness);
        this.shadowDarkness = shadowDarkness;
    }

    public AnimatableDouble getShadowDiffusion() {
        return this.shadowDiffusion;
    }

    public void setShadowDiffusion(AnimatableDouble shadowDiffusion) {
        shadowDiffusion.copyConfigurationFrom(this.shadowDiffusion);
        this.shadowDiffusion = shadowDiffusion;
    }

    public void prepareExpression(ExpressionScope scope) {
        super.prepareExpression(scope);
        scope.assignTo(this.orientation);
        scope.assignTo(this.rotationX);
        scope.assignTo(this.rotationY);
        scope.assignTo(this.rotationZ);
        scope.assignTo(this.position);
        scope.assignTo(this.pointOfInterest);
        scope.assignTo(this.intensity);
        scope.assignTo(this.attenuation);
        scope.assignTo(this.color);
        scope.assignTo(this.coneAngle);
        scope.assignTo(this.coneFeather);
        scope.assignTo(this.shadowDarkness);
        scope.assignTo(this.shadowDiffusion);
    }

    public Object createExpressionElement(CoreContext context) {
        return new LightLayerExpressionElement(context);
    }

    public class LightLayerExpressionElement
    extends AbstractLayer.LayerExpressionElement {
        public LightLayerExpressionElement(CoreContext context) {
            super(context);
        }

        public Object getOrientation() {
            return this.elem(LightLayerImpl.this.orientation);
        }

        public Object getRotation() {
            return this.getRotationZ();
        }

        public Object getRotationX() {
            return this.elem(LightLayerImpl.this.rotationX);
        }

        public Object getRotationY() {
            return this.elem(LightLayerImpl.this.rotationY);
        }

        public Object getRotationZ() {
            return this.elem(LightLayerImpl.this.rotationZ);
        }

        public Object getPosition() {
            return this.elem(LightLayerImpl.this.position);
        }

        public Object getPointOfInterest() {
            return this.elem(LightLayerImpl.this.pointOfInterest);
        }

        public String getLightType() {
            return LightLayerImpl.this.lightType.name();
        }

        public Object getIntensity() {
            return this.elem(LightLayerImpl.this.intensity);
        }

        public Object getAttenuation() {
            return this.elem(LightLayerImpl.this.attenuation);
        }

        public Object getColor() {
            return this.elem(LightLayerImpl.this.color);
        }

        public Object getConeAngle() {
            return this.elem(LightLayerImpl.this.coneAngle);
        }

        public Object getConeFeather() {
            return this.elem(LightLayerImpl.this.coneFeather);
        }

        public boolean isCastsShadows() {
            return LightLayerImpl.this.castsShadows;
        }

        public Object getShadowDarkness() {
            return this.elem(LightLayerImpl.this.shadowDarkness);
        }

        public Object getShadowDiffusion() {
            return this.elem(LightLayerImpl.this.shadowDiffusion);
        }
    }
}

