/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.core.internal;

import ch.kuramo.javie.api.Resolution;
import ch.kuramo.javie.api.Vec3d;
import ch.kuramo.javie.core.CameraLayer;
import ch.kuramo.javie.core.Layer;
import ch.kuramo.javie.core.LayerComposition;
import ch.kuramo.javie.core.LayerNature;
import ch.kuramo.javie.core.LightLayer;
import ch.kuramo.javie.core.TransformableLayer;
import ch.kuramo.javie.core.services.RenderContext;
import ch.kuramo.javie.core.services.VideoRenderSupport;

class LayerMatrixUtil {
    private final RenderContext _context;
    private final VideoRenderSupport _vrSupport;

    static void multModelViewMatrix(TransformableLayer layer, RenderContext context, VideoRenderSupport vrSupport) {
        LayerMatrixUtil util = new LayerMatrixUtil(context, vrSupport);
        util.multModelViewMatrix(layer, true);
    }

    static void multModelViewMatrix(LightLayer layer, RenderContext context, VideoRenderSupport vrSupport) {
        LayerMatrixUtil util = new LayerMatrixUtil(context, vrSupport);
        util.multModelViewMatrix(layer, true);
    }

    static void multParentMatrix(CameraLayer cameraLayer, RenderContext context, VideoRenderSupport vrSupport) {
        Layer parent = ((LayerComposition)context.getComposition()).getParentLayer(cameraLayer);
        if (parent != null) {
            new LayerMatrixUtil(context, vrSupport).multModelViewMatrixInverse(parent, true);
        }
    }

    private LayerMatrixUtil(RenderContext context, VideoRenderSupport vrSupport) {
        this._context = context;
        this._vrSupport = vrSupport;
    }

    private void multModelViewMatrix(Layer layer, boolean threeD) {
        threeD &= LayerNature.isThreeD(layer);
        Layer parent = ((LayerComposition)this._context.getComposition()).getParentLayer(layer);
        if (parent != null) {
            this.multModelViewMatrix(parent, threeD);
        }
        if (layer instanceof TransformableLayer) {
            this.multTransformableLayerMatrix((TransformableLayer)layer, threeD, false);
        } else if (layer instanceof LightLayer) {
            this.multLightLayerMatrix((LightLayer)layer, threeD, false);
        } else if (layer instanceof CameraLayer) {
            this.multCameraLayerMatrix((CameraLayer)layer, threeD, false);
        }
    }

    private void multModelViewMatrixInverse(Layer layer, boolean threeD) {
        threeD &= LayerNature.isThreeD(layer);
        if (layer instanceof TransformableLayer) {
            this.multTransformableLayerMatrix((TransformableLayer)layer, threeD, true);
        } else if (layer instanceof LightLayer) {
            this.multLightLayerMatrix((LightLayer)layer, threeD, true);
        } else if (layer instanceof CameraLayer) {
            this.multCameraLayerMatrix((CameraLayer)layer, threeD, true);
        }
        Layer parent = ((LayerComposition)this._context.getComposition()).getParentLayer(layer);
        if (parent != null) {
            this.multModelViewMatrixInverse(parent, threeD);
        }
    }

    private void multTransformableLayerMatrix(TransformableLayer tlayer, boolean threeD, boolean inverse) {
        Vec3d rotation;
        Vec3d orientation;
        if (!LayerNature.isVideoNature(tlayer)) {
            return;
        }
        Vec3d anchorPoint = (Vec3d)tlayer.getAnchorPoint().value(this._context);
        Vec3d scale = (Vec3d)tlayer.getScale().value(this._context);
        Vec3d position = (Vec3d)tlayer.getPosition().value(this._context);
        if (threeD) {
            orientation = (Vec3d)tlayer.getOrientation().value(this._context);
            rotation = new Vec3d(((Double)tlayer.getRotationX().value(this._context)).doubleValue(), ((Double)tlayer.getRotationY().value(this._context)).doubleValue(), ((Double)tlayer.getRotationZ().value(this._context)).doubleValue());
        } else {
            anchorPoint = new Vec3d(anchorPoint.x, anchorPoint.y, 0.0);
            scale = new Vec3d(scale.x, scale.y, 100.0);
            orientation = new Vec3d(0.0, 0.0, 0.0);
            rotation = new Vec3d(0.0, 0.0, ((Double)tlayer.getRotationZ().value(this._context)).doubleValue());
            position = new Vec3d(position.x, position.y, 0.0);
        }
        Resolution resolution = this._context.getVideoResolution();
        if (inverse) {
            this._vrSupport.multModelViewMatrixInverse(resolution.scale(anchorPoint), scale, rotation, orientation, null, resolution.scale(position));
        } else {
            this._vrSupport.multModelViewMatrix(resolution.scale(anchorPoint), scale, rotation, orientation, null, resolution.scale(position));
        }
    }

    private void multLightLayerMatrix(LightLayer layer, boolean threeD, boolean inverse) {
        Vec3d rotation;
        Vec3d orientation;
        Vec3d anchorPoint = Vec3d.ZERO;
        Vec3d scale = new Vec3d(100.0, 100.0, 100.0);
        Vec3d interest = null;
        Vec3d position = (Vec3d)layer.getPosition().value(this._context);
        switch (layer.getLightType()) {
            case PARALLEL: 
            case SPOT: {
                interest = (Vec3d)layer.getPointOfInterest().value(this._context);
            }
        }
        if (threeD) {
            orientation = (Vec3d)layer.getOrientation().value(this._context);
            rotation = new Vec3d(((Double)layer.getRotationX().value(this._context)).doubleValue(), ((Double)layer.getRotationY().value(this._context)).doubleValue(), ((Double)layer.getRotationZ().value(this._context)).doubleValue());
        } else {
            if (interest != null) {
                anchorPoint = new Vec3d(interest.x, interest.y, 0.0);
                interest = null;
            }
            orientation = Vec3d.ZERO;
            rotation = new Vec3d(0.0, 0.0, ((Double)layer.getRotationZ().value(this._context)).doubleValue());
            position = new Vec3d(position.x, position.y, 0.0);
        }
        Resolution resolution = this._context.getVideoResolution();
        if (inverse) {
            this._vrSupport.multModelViewMatrixInverse(resolution.scale(anchorPoint), scale, rotation, orientation, interest != null ? resolution.scale(interest) : null, resolution.scale(position));
        } else {
            this._vrSupport.multModelViewMatrix(resolution.scale(anchorPoint), scale, rotation, orientation, interest != null ? resolution.scale(interest) : null, resolution.scale(position));
        }
    }

    private void multCameraLayerMatrix(CameraLayer clayer, boolean threeD, boolean inverse) {
        Resolution resolution = this._context.getVideoResolution();
        Vec3d position = (Vec3d)clayer.getPosition().value(this._context);
        Vec3d interest = (Vec3d)clayer.getPointOfInterest().value(this._context);
        if (threeD) {
            Vec3d orientation = (Vec3d)clayer.getOrientation().value(this._context);
            Vec3d rotation = new Vec3d(((Double)clayer.getRotationX().value(this._context)).doubleValue(), ((Double)clayer.getRotationY().value(this._context)).doubleValue(), ((Double)clayer.getRotationZ().value(this._context)).doubleValue());
            if (inverse) {
                this._vrSupport.multCameraMatrix(rotation, orientation, resolution.scale(interest), resolution.scale(position), false);
            } else {
                this._vrSupport.multCameraMatrixInverse(rotation, orientation, resolution.scale(interest), resolution.scale(position));
            }
        } else {
            Vec3d anchorPoint = new Vec3d(interest.x, interest.y, 0.0);
            Vec3d scale = new Vec3d(100.0, 100.0, 100.0);
            Vec3d orientation = new Vec3d(0.0, 0.0, 0.0);
            Vec3d rotation = new Vec3d(0.0, 0.0, ((Double)clayer.getRotationZ().value(this._context)).doubleValue());
            position = new Vec3d(position.x, position.y, 0.0);
            if (inverse) {
                this._vrSupport.multModelViewMatrixInverse(resolution.scale(anchorPoint), scale, rotation, orientation, null, resolution.scale(position));
            } else {
                this._vrSupport.multModelViewMatrix(resolution.scale(anchorPoint), scale, rotation, orientation, null, resolution.scale(position));
            }
        }
    }
}

