/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.core.internal;

import ch.kuramo.javie.api.Resolution;
import ch.kuramo.javie.api.Size2i;
import ch.kuramo.javie.api.Time;
import ch.kuramo.javie.api.Vec3d;
import ch.kuramo.javie.core.Camera;
import ch.kuramo.javie.core.CameraLayer;
import ch.kuramo.javie.core.Layer;
import ch.kuramo.javie.core.LayerComposition;
import ch.kuramo.javie.core.LayerNature;
import ch.kuramo.javie.core.Util;
import ch.kuramo.javie.core.internal.LayerMatrixUtil;
import ch.kuramo.javie.core.services.RenderContext;
import ch.kuramo.javie.core.services.VideoRenderSupport;
import com.google.inject.Inject;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import javax.media.opengl.GL2;
import javax.media.opengl.glu.GLU;

class CameraImpl
implements Camera {
    private final RenderContext _context;
    private final VideoRenderSupport _vrSupport;
    private final CameraLayer _cameraLayer;
    private final Size2i _compSize;
    private final Size2i _viewportSize;
    private final double[] _prjMatrix2D;
    private final double[] _mvMatrix2D;
    private final Map<Time, double[][]> _matrix3DCache;

    @Inject
    CameraImpl(RenderContext context, VideoRenderSupport vrSupport) {
        LayerComposition comp = (LayerComposition)context.getComposition();
        CameraLayer cameraLayer = null;
        List<Layer> layers = comp.getLayers();
        Time time = context.getTime();
        ListIterator<Layer> it = layers.listIterator(layers.size());
        while (it.hasPrevious()) {
            Layer layer = it.previous();
            if (!(layer instanceof CameraLayer) || !LayerNature.isVideoEnabled(layer) || layer.getInPoint().after(time) || !layer.getOutPoint().after(time)) continue;
            cameraLayer = (CameraLayer)layer;
            break;
        }
        this._context = context;
        this._vrSupport = vrSupport;
        this._cameraLayer = cameraLayer;
        this._compSize = comp.getSize();
        this._viewportSize = context.getVideoResolution().scale(this._compSize);
        this._prjMatrix2D = new double[16];
        this._mvMatrix2D = new double[16];
        this._matrix3DCache = Util.newMap();
        this.createMatrix2D();
    }

    private void createMatrix2D() {
        GL2 gl = this._context.getGL().getGL2();
        GLU glu = this._context.getGLU();
        gl.glMatrixMode(5889);
        gl.glLoadIdentity();
        glu.gluOrtho2D(0.0f, (float)this._viewportSize.width, 0.0f, (float)this._viewportSize.height);
        gl.glMatrixMode(5888);
        gl.glLoadIdentity();
        this._vrSupport.getMatrix(this._prjMatrix2D, this._mvMatrix2D);
    }

    public Size2i getViewportSize() {
        return this._viewportSize;
    }

    public double[] getProjection2D() {
        return this._prjMatrix2D;
    }

    public double[] getModelView2D() {
        return this._mvMatrix2D;
    }

    public double[] getProjection3D() {
        return this.getMatrix3D()[0];
    }

    public double[] getModelView3D() {
        return this.getMatrix3D()[1];
    }

    private double[][] getMatrix3D() {
        double far;
        double near;
        double fovy;
        double zoom;
        Vec3d interest;
        Vec3d position;
        Vec3d rotation;
        Vec3d orientation;
        Time time = this._context.getTime();
        double[][] matrix = this._matrix3DCache.get(time);
        if (matrix != null) {
            return matrix;
        }
        double aspect = (double)this._viewportSize.width / (double)this._viewportSize.height;
        if (this._cameraLayer != null) {
            orientation = (Vec3d)this._cameraLayer.getOrientation().value(this._context);
            rotation = new Vec3d(((Double)this._cameraLayer.getRotationX().value(this._context)).doubleValue(), ((Double)this._cameraLayer.getRotationY().value(this._context)).doubleValue(), ((Double)this._cameraLayer.getRotationZ().value(this._context)).doubleValue());
            position = (Vec3d)this._cameraLayer.getPosition().value(this._context);
            interest = (Vec3d)this._cameraLayer.getPointOfInterest().value(this._context);
            zoom = (Double)this._cameraLayer.getZoom().value(this._context);
            fovy = Math.toDegrees(2.0 * Math.atan((double)this._compSize.height / (2.0 * zoom)));
            near = (Double)this._cameraLayer.getNear().value(this._context);
            far = (Double)this._cameraLayer.getFar().value(this._context);
        } else {
            zoom = this.getDefaultZoom();
            fovy = Math.toDegrees(2.0 * Math.atan((double)this._compSize.height / (2.0 * zoom)));
            near = 10.0;
            far = 100000.0;
            orientation = new Vec3d(0.0, 0.0, 0.0);
            rotation = new Vec3d(0.0, 0.0, 0.0);
            position = new Vec3d((double)this._compSize.width / 2.0, (double)this._compSize.height / 2.0, -zoom);
            interest = new Vec3d(position.x, position.y, 0.0);
        }
        Resolution resolution = this._context.getVideoResolution();
        position = resolution.scale(position);
        interest = resolution.scale(interest);
        near = resolution.scale(near);
        far = resolution.scale(far);
        GL2 gl = this._context.getGL().getGL2();
        GLU glu = this._context.getGLU();
        gl.glMatrixMode(5889);
        gl.glLoadIdentity();
        glu.gluPerspective(fovy, aspect, near, far);
        gl.glMatrixMode(5888);
        gl.glLoadIdentity();
        this._vrSupport.multCameraMatrix(rotation, orientation, interest, position, true);
        if (this._cameraLayer != null) {
            LayerMatrixUtil.multParentMatrix(this._cameraLayer, this._context, this._vrSupport);
        }
        matrix = new double[2][16];
        this._vrSupport.getMatrix(matrix[0], matrix[1]);
        this._matrix3DCache.put(time, matrix);
        return matrix;
    }

    private double getDefaultZoom() {
        double fovx = 39.6;
        return (double)this._compSize.width / (2.0 * Math.tan(Math.toRadians(fovx / 2.0)));
    }

    public void getProjectionMatrix(double[] matrix) {
        System.arraycopy(this.getProjection3D(), 0, matrix, 0, 16);
    }

    public void getModelViewMatrix(double[] matrix) {
        System.arraycopy(this.getModelView3D(), 0, matrix, 0, 16);
    }
}

