/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.core;

import ch.kuramo.javie.api.IObjectArray;
import ch.kuramo.javie.api.Time;
import ch.kuramo.javie.core.AnimatableValue;
import ch.kuramo.javie.core.CoreContext;
import ch.kuramo.javie.core.Interpolation;
import ch.kuramo.javie.core.Keyframe;
import ch.kuramo.javie.core.Util;
import ch.kuramo.javie.core.WrappedOperation;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import net.arnx.jsonic.JSONHint;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractAnimatableValue<V>
implements AnimatableValue<V> {
    protected V _defaultValue;
    protected V _staticValue;
    protected final SortedMap<Time, Keyframe<V>> _keyframes;
    protected String _expression;
    private static final Set<Interpolation> INTERPOLATIONS = Util.unmodifiableSet(Interpolation.HOLD);

    public AbstractAnimatableValue(V staticValue, Collection<Keyframe<V>> keyframes, String expression) {
        this._defaultValue = staticValue;
        this._staticValue = staticValue;
        this._keyframes = Util.newSortedMap();
        this._expression = expression;
        if (keyframes != null) {
            for (Keyframe<V> k : keyframes) {
                this.putKeyframe(k);
            }
        }
    }

    public AbstractAnimatableValue(V defaultValue) {
        this(defaultValue, null, null);
    }

    public void copyConfigurationFrom(AbstractAnimatableValue<V> src) {
        if (this.getClass() != src.getClass()) {
            throw new IllegalArgumentException("class does not match: " + src.getClass());
        }
        this._defaultValue = src._defaultValue;
    }

    @Override
    public V value(CoreContext context) {
        if (this._expression != null && !context.checkCyclicEvaluation(this)) {
            try {
                Object value = context.evaluateExpression(this);
                if (value != null) {
                    return (V)value;
                }
                throw new NullPointerException();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return this.interpolate(context.getTime());
    }

    @Override
    public V valueAtTime(final Time time, final CoreContext context) {
        if (this._expression != null && !context.checkCyclicEvaluation(this)) {
            try {
                Object value = context.saveAndExecute(new WrappedOperation<V>(){

                    @Override
                    public V execute() {
                        context.setTime(time);
                        return context.evaluateExpression(AbstractAnimatableValue.this);
                    }
                });
                if (value != null) {
                    return (V)value;
                }
                throw new NullPointerException();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return this.interpolate(time);
    }

    @Override
    public void values(IObjectArray<V> values, Time sampleDuration, int animationRate, CoreContext context) {
        this.valuesAtTime(values, sampleDuration, animationRate, context.getTime(), context);
    }

    @Override
    public void valuesAtTime(IObjectArray<V> values, final Time sampleDuration, final int animationRate, final Time time, final CoreContext context) {
        final Object[] array = (Object[])values.getArray();
        final int len = values.getLength();
        if (this._expression != null && !context.checkCyclicEvaluation(this)) {
            try {
                context.saveAndExecute(new WrappedOperation<Object>(){

                    @Override
                    public Object execute() {
                        Object v = null;
                        int i = 0;
                        while (i < len) {
                            if (i % animationRate == 0) {
                                Time t = time.add(new Time(sampleDuration.timeValue * (long)i, sampleDuration.timeScale));
                                context.setTime(t);
                                v = context.evaluateExpression(AbstractAnimatableValue.this);
                            }
                            array[i] = v;
                            ++i;
                        }
                        return null;
                    }
                });
                return;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        Object v = null;
        int i = 0;
        while (i < len) {
            if (i % animationRate == 0) {
                Time t = time.add(new Time(sampleDuration.timeValue * (long)i, sampleDuration.timeScale));
                v = this.interpolate(t);
            }
            array[i] = v;
            ++i;
        }
    }

    protected V interpolate(Time time) {
        SortedMap<Time, Keyframe<V>> headMap;
        if (this._keyframes.isEmpty()) {
            return this._staticValue;
        }
        Keyframe k1 = null;
        Keyframe<V> k2 = null;
        Iterator<Map.Entry<Time, Keyframe<V>>> tail = this._keyframes.tailMap(time).entrySet().iterator();
        if (tail.hasNext()) {
            Map.Entry<Time, Keyframe<V>> entry = tail.next();
            if (entry.getKey().equals((Object)time)) {
                k1 = entry.getValue();
                if (tail.hasNext()) {
                    k2 = tail.next().getValue();
                }
            } else {
                k2 = entry.getValue();
            }
        }
        if (k1 == null && !(headMap = this._keyframes.headMap(time)).isEmpty()) {
            k1 = (Keyframe)headMap.get(headMap.lastKey());
        }
        if (k1 == null) {
            return k2.value;
        }
        if (k2 == null) {
            return k1.value;
        }
        return this.interpolate(time, k1, k2, tail);
    }

    protected V interpolate(Time time, Keyframe<V> k1, Keyframe<V> k2, Iterator<Map.Entry<Time, Keyframe<V>>> tail) {
        switch (k1.interpolation) {
            case HOLD: {
                return k1.value;
            }
        }
        throw new UnsupportedOperationException(k1.interpolation.name());
    }

    @Override
    public V getStaticValue() {
        return this._staticValue;
    }

    @Override
    public boolean hasKeyframe() {
        return !this._keyframes.isEmpty();
    }

    @Override
    public Keyframe<V> getKeyframe(Time time) {
        return (Keyframe)this._keyframes.get(time);
    }

    @Deprecated
    public Collection<Keyframe<V>> getKeyframes() {
        return Collections.unmodifiableCollection(this._keyframes.values());
    }

    @Override
    @JSONHint(ignore=true)
    public SortedMap<Time, Keyframe<V>> getKeyframeMap() {
        return Collections.unmodifiableSortedMap(this._keyframes);
    }

    @Override
    public Keyframe<V> putKeyframe(Keyframe<V> keyframe) {
        if (!this.getAvailableInterpolations().contains((Object)keyframe.interpolation)) {
            throw new IllegalArgumentException("unsupported interpolation: " + keyframe.interpolation.name());
        }
        return this._keyframes.put(keyframe.time, keyframe);
    }

    @Override
    public Keyframe<V> putKeyframe(Time time, V value, Interpolation interpolation) {
        return this.putKeyframe(new Keyframe<V>(time, value, interpolation));
    }

    @Override
    public Keyframe<V> removeKeyframe(Time time) {
        Keyframe removed = (Keyframe)this._keyframes.remove(time);
        if (this._keyframes.isEmpty() && removed != null) {
            this._staticValue = removed.value;
        }
        return removed;
    }

    @Override
    public void clearKeyframes() {
        if (!this._keyframes.isEmpty()) {
            this.clearKeyframes(((Keyframe)this._keyframes.get((Object)this._keyframes.firstKey())).value);
        }
    }

    @Override
    public void clearKeyframes(V staticValue) {
        this._staticValue = staticValue;
        this._keyframes.clear();
    }

    @Override
    public void reset() {
        this.reset(this._defaultValue);
    }

    @Override
    public void reset(V staticValue) {
        this.clearKeyframes(staticValue);
        this._expression = null;
    }

    @Override
    public String getExpression() {
        return this._expression;
    }

    @Override
    public void setExpression(String expression) {
        this._expression = expression;
    }

    @Override
    @JSONHint(ignore=true)
    public Set<Interpolation> getAvailableInterpolations() {
        return INTERPOLATIONS;
    }

    @Override
    @JSONHint(ignore=true)
    public Interpolation getDefaultInterpolation() {
        return Interpolation.HOLD;
    }

    protected V valueAtTime(double t, CoreContext context) {
        int timeScale = context.getTime().timeScale;
        Time time = new Time((long)(t * (double)timeScale), timeScale);
        return this.valueAtTime(time, context);
    }
}

