/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.app.views.layercomp;

import ch.kuramo.javie.app.InjectorHolder;
import ch.kuramo.javie.app.views.layercomp.AnimatableStringElementDelegate;
import ch.kuramo.javie.app.views.layercomp.AnimatableValueElement;
import ch.kuramo.javie.app.widgets.FontUtil;
import ch.kuramo.javie.app.widgets.GridBuilder;
import ch.kuramo.javie.app.widgets.InPlaceEditorShell;
import ch.kuramo.javie.core.AnimatableString;
import ch.kuramo.javie.core.Util;
import ch.kuramo.javie.core.services.Font;
import ch.kuramo.javie.core.services.FontList;
import com.google.inject.Inject;
import com.ibm.icu.text.Normalizer;
import com.ibm.icu.text.Transliterator;
import java.util.List;
import java.util.regex.Pattern;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;

class TextFontElementDelegate
extends AnimatableStringElementDelegate {
    private static final Transliterator H2K_TRANSLITERATOR = Transliterator.getInstance((String)"Hiragana-Katakana");
    private static final Pattern SPACE_PATTERN = Pattern.compile("\\s");
    private static Point defaultEditorSize = new Point(200, 300);
    @Inject
    private FontList fontList;

    TextFontElementDelegate(AnimatableValueElement element, String name, AnimatableString avalue) {
        super(element, name, avalue);
        InjectorHolder.getInjector().injectMembers((Object)this);
    }

    protected void drawValue(GC gc, int x, int y, int height, boolean focused) {
        Font font = this.fontList.get((String)this.value);
        this.drawValue(gc, x, y, height, focused, font != null ? String.valueOf(font.familyName) + " " + font.subfamilyName : "      ");
    }

    protected void openInPlaceEditor() {
        final Shell shell = InPlaceEditorShell.create((Control)this.element.viewer.getTree(), (Rectangle)this.valueArea.get(this.valueIndex), TextFontElementDelegate.defaultEditorSize.x, TextFontElementDelegate.defaultEditorSize.y, true);
        shell.setMinimumSize(100, 100);
        FillLayout fillLayout = new FillLayout();
        fillLayout.marginWidth = 5;
        fillLayout.marginHeight = 5;
        shell.setLayout((Layout)fillLayout);
        GridBuilder gb = new GridBuilder((Composite)shell, 1, false);
        gb.getLayout().marginWidth = 0;
        gb.getLayout().marginHeight = 0;
        final Text searchText = gb.hAlign(4).hGrab().text(640, "");
        FontUtil.setCompatibleFont((Control)searchText);
        final Tree fontTree = gb.align(4, 4).grab(true, true).tree(68356);
        final TreeViewer fontViewer = new TreeViewer(fontTree);
        shell.layout();
        shell.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (!shell.isDisposed()) {
                    defaultEditorSize = shell.getSize();
                }
            }
        });
        searchText.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 0x1000002) {
                    fontTree.setFocus();
                }
            }
        });
        fontViewer.setContentProvider((IContentProvider)new FontNameContetProvider());
        fontViewer.setLabelProvider((IBaseLabelProvider)FontNameLabelProvider.getInstance());
        fontViewer.setInput((Object)this.fontList.listFamilyNames());
        final String relation = Util.randomId();
        fontViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                Object element = ((TreeSelection)event.getSelection()).getFirstElement();
                if (element instanceof Font) {
                    TextFontElementDelegate.this.modifyValue(((Font)element).psName, relation);
                }
            }
        });
        fontViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                Object element = ((TreeSelection)event.getSelection()).getFirstElement();
                if (element instanceof Font) {
                    TextFontElementDelegate.this.modifyValue(((Font)element).psName, relation);
                    if (!shell.isDisposed()) {
                        shell.setVisible(false);
                    }
                } else {
                    fontViewer.setExpandedState(element, !fontViewer.getExpandedState(element));
                }
            }
        });
        final String[] text = new String[]{""};
        searchText.addModifyListener(new ModifyListener(){
            private long lasttime;
            private boolean scheduled;

            public void modifyText(ModifyEvent e) {
                text[0] = searchText.getText();
                text[0] = Normalizer.normalize((String)text[0], (Normalizer.Mode)Normalizer.NFKC);
                text[0] = H2K_TRANSLITERATOR.transliterate(text[0]);
                text[0] = SPACE_PATTERN.matcher(text[0]).replaceAll("").toLowerCase();
                if (!this.scheduled) {
                    long time = System.currentTimeMillis();
                    if (time >= this.lasttime + 500L) {
                        fontViewer.refresh(false);
                        this.lasttime = time;
                    } else {
                        this.scheduled = true;
                        e.display.timerExec((int)(this.lasttime + 500L - time), new Runnable(){

                            public void run() {
                                fontViewer.refresh(false);
                                lasttime = System.currentTimeMillis();
                                scheduled = false;
                            }
                        });
                    }
                }
            }
        });
        fontViewer.addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                if (text[0].length() == 0 || element instanceof Font) {
                    return true;
                }
                String name = (String)element;
                name = Normalizer.normalize((String)name, (Normalizer.Mode)Normalizer.NFKC);
                name = H2K_TRANSLITERATOR.transliterate(name);
                name = SPACE_PATTERN.matcher(name).replaceAll("").toLowerCase();
                return name.contains(text[0]);
            }
        });
        Font currentFont = this.fontList.get((String)this.value);
        if (currentFont != null) {
            List familyNames = this.fontList.listFamilyNames();
            fontViewer.setExpandedState((Object)currentFont.familyName, true);
            fontViewer.reveal(familyNames.get(familyNames.size() - 1));
            fontViewer.reveal((Object)currentFont.familyName);
            fontViewer.setSelection((ISelection)new TreeSelection(new TreePath(new Object[]{currentFont.familyName, currentFont})));
        }
        shell.open();
    }

    public boolean canEdit(int columnIndex) {
        if (columnIndex == 1) {
            return false;
        }
        return super.canEdit(columnIndex);
    }

    private class FontNameContetProvider
    implements ITreeContentProvider {
        private FontNameContetProvider() {
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object inputElement) {
            return ((List)inputElement).toArray();
        }

        public boolean hasChildren(Object element) {
            return element instanceof String;
        }

        public Object[] getChildren(Object parentElement) {
            return parentElement instanceof String ? TextFontElementDelegate.this.fontList.getFamily((String)parentElement).toArray() : null;
        }

        public Object getParent(Object element) {
            return element instanceof Font ? ((Font)element).familyName : null;
        }
    }

    private static class FontNameLabelProvider
    extends LabelProvider {
        private static final FontNameLabelProvider instance = new FontNameLabelProvider();

        private FontNameLabelProvider() {
        }

        public static FontNameLabelProvider getInstance() {
            return instance;
        }

        public String getText(Object element) {
            return element instanceof Font ? ((Font)element).subfamilyName : super.getText(element);
        }
    }
}

