/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.app.views.layercomp;

import ch.kuramo.javie.app.EnumLabels;
import ch.kuramo.javie.app.views.layercomp.Element;
import ch.kuramo.javie.app.views.layercomp.LayerPropertyElement;
import ch.kuramo.javie.core.Layer;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class LayerEnumPropertyElement<E extends Enum<E>>
extends LayerPropertyElement<E> {
    public LayerEnumPropertyElement(Element parent, Layer layer, String label) {
        super(parent, layer, label);
    }

    public LayerEnumPropertyElement(Element parent, Layer layer, String label, String operationLabel) {
        super(parent, layer, label, operationLabel);
    }

    @Override
    protected String getValueString() {
        return EnumLabels.getLabel((Enum)this.getValue());
    }

    @Override
    protected void mouseDownOnValueArea() {
        Menu menu = this.createPopUpMenu(this.valueArea.x - 5, this.valueArea.y + this.valueArea.height + 2);
        final Enum value = (Enum)this.getValue();
        Class<?> enumClass = value.getClass();
        Enum[] enumArray = (Enum[])enumClass.getEnumConstants();
        int n = enumArray.length;
        int n2 = 0;
        while (n2 < n) {
            final Enum e = enumArray[n2];
            if (EnumLabels.insertSeparator(e)) {
                new MenuItem(menu, 2);
            }
            Action action = new Action(EnumLabels.getLabel(e), 8){

                public void run() {
                    if (e != value) {
                        LayerEnumPropertyElement.this.setValue(e);
                    }
                }
            };
            action.setChecked(e == value);
            new ActionContributionItem((IAction)action).fill(menu, -1);
            ++n2;
        }
        menu.setVisible(true);
    }

    public static <E extends Enum<E>> LayerEnumPropertyElement<E> forSimpleProperty(Element parent, Layer layer, String property, String label) {
        return new ForSimpleProperty(parent, layer, property, label);
    }

    public static <E extends Enum<E>> LayerEnumPropertyElement<E> forSimpleProperty(Element parent, Layer layer, String property, String label, String operationLabel) {
        return new ForSimpleProperty(parent, layer, property, label, operationLabel);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class ForSimpleProperty<E extends Enum<E>>
    extends LayerEnumPropertyElement<E> {
        private final String property;

        public ForSimpleProperty(Element parent, Layer layer, String property, String label) {
            super(parent, layer, label);
            this.property = property;
        }

        public ForSimpleProperty(Element parent, Layer layer, String property, String label, String operationLabel) {
            super(parent, layer, label, operationLabel);
            this.property = property;
        }

        @Override
        public String getProperty() {
            return this.property;
        }
    }
}

