/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.app.views.layercomp;

import ch.kuramo.javie.app.ImageUtil;
import ch.kuramo.javie.app.project.LayerCompMotionBlurOperation;
import ch.kuramo.javie.app.project.ProjectManager;
import ch.kuramo.javie.app.views.LayerCompositionView;
import ch.kuramo.javie.core.LayerComposition;
import org.eclipse.core.commands.operations.IOperationHistoryListener;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.commands.operations.OperationHistoryEvent;
import org.eclipse.jface.action.Action;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;

public class LayerCompMotionBlurAction
extends Action {
    private final ProjectManager pm;
    private final LayerComposition comp;

    public LayerCompMotionBlurAction(final LayerCompositionView view) {
        super("\u30e2\u30fc\u30b7\u30e7\u30f3\u30d6\u30e9\u30fc", 2);
        this.pm = ProjectManager.forWorkbenchWindow(view.getSite().getWorkbenchWindow());
        this.comp = view.getLayerComposition();
        this.setImageDescriptor(ImageUtil.getCompositionMotionBlurIcon());
        this.setChecked(this.comp.isMotionBlurEnabled());
        final IOperationHistoryListener historyListener = new IOperationHistoryListener(){

            public void historyNotification(OperationHistoryEvent event) {
                switch (event.getEventType()) {
                    case 9: 
                    case 10: {
                        IUndoableOperation op = event.getOperation();
                        if (!(op instanceof LayerCompMotionBlurOperation) || !op.hasContext(LayerCompMotionBlurAction.this.pm.getUndoContext())) break;
                        LayerCompMotionBlurAction.this.setChecked(LayerCompMotionBlurAction.this.comp.isMotionBlurEnabled());
                    }
                }
            }
        };
        view.getSite().getPage().addPartListener(new IPartListener(){

            public void partActivated(IWorkbenchPart part) {
            }

            public void partBroughtToTop(IWorkbenchPart part) {
            }

            public void partDeactivated(IWorkbenchPart part) {
            }

            public void partOpened(IWorkbenchPart part) {
            }

            public void partClosed(IWorkbenchPart part) {
                if (part == view) {
                    PlatformUI.getWorkbench().getOperationSupport().getOperationHistory().removeOperationHistoryListener(historyListener);
                }
            }
        });
        PlatformUI.getWorkbench().getOperationSupport().getOperationHistory().addOperationHistoryListener(historyListener);
    }

    public void run() {
        this.pm.postOperation(new LayerCompMotionBlurOperation(this.pm, this.comp, this.isChecked()));
    }
}

