/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.app.views.layercomp;

import ch.kuramo.javie.api.Vec3d;
import ch.kuramo.javie.app.views.layercomp.AnimatableValueElement;
import ch.kuramo.javie.app.views.layercomp.AnimatableValueElementDelegate;
import ch.kuramo.javie.core.AnimatableVec3d;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnimatableVec3dElementDelegate
extends AnimatableValueElementDelegate<Vec3d> {
    protected final boolean threeD;
    protected final double increment;
    protected final int displayPrecision;
    protected final int editorPrecision;
    protected final String unit;
    protected Vec3dCellEditor editor;

    public AnimatableVec3dElementDelegate(AnimatableValueElement element, String name, AnimatableVec3d avalue, boolean threeD) {
        this(element, name, avalue, threeD, null);
    }

    public AnimatableVec3dElementDelegate(AnimatableValueElement element, String name, AnimatableVec3d avalue, boolean threeD, String unit) {
        this(element, name, avalue, threeD, 1.0, 1, 4, unit);
    }

    public AnimatableVec3dElementDelegate(AnimatableValueElement element, String name, AnimatableVec3d avalue, boolean threeD, double increment, int displayPrecision, int editorPrecision, String unit) {
        super(element, name, avalue);
        this.threeD = threeD;
        this.increment = increment;
        this.displayPrecision = displayPrecision;
        this.editorPrecision = editorPrecision;
        this.unit = unit;
    }

    @Override
    protected void drawValue(GC gc, int x, int y, int height, boolean focused) {
        if (this.editor != null) {
            return;
        }
        x = this.drawValue(gc, x, y, height, focused, ((Vec3d)this.value).x, this.displayPrecision, this.unit);
        x = this.drawSeparator(gc, x, y, height, focused);
        x = this.drawValue(gc, x, y, height, focused, ((Vec3d)this.value).y, this.displayPrecision, this.unit);
        if (this.threeD) {
            x = this.drawSeparator(gc, x, y, height, focused);
            x = this.drawValue(gc, x, y, height, focused, ((Vec3d)this.value).z, this.displayPrecision, this.unit);
        }
    }

    protected int drawValue(GC gc, int x, int y, int height, int valueIndex, double value) {
        if (this.editor == null) {
            throw new IllegalStateException("no editor");
        }
        if (this.valueIndex != valueIndex) {
            return this.drawValue(gc, x, y, height, false, value, this.displayPrecision, this.unit);
        }
        Rectangle bounds = this.editor.getTextBounds();
        if (this.unit != null) {
            this.setValueForeground(gc, false);
            return this.drawString(gc, x + bounds.width + (WIN32 ? 0 : 3), y, height, this.unit);
        }
        return x + bounds.width;
    }

    protected int drawSeparator(GC gc, int x, int y, int height, boolean focused) {
        this.setForeground(gc, focused);
        x = this.drawString(gc, x + 2, y, height, ",");
        return x + 4;
    }

    @Override
    protected boolean canDragGestureEdit() {
        return true;
    }

    @Override
    protected Vec3d dragGesture(double dx, double dy) {
        double[] orig = new double[]{((Vec3d)this.originalValue).x, ((Vec3d)this.originalValue).y, ((Vec3d)this.originalValue).z};
        double[] array = new double[]{((Vec3d)this.value).x, ((Vec3d)this.value).y, ((Vec3d)this.value).z};
        array[this.valueIndex] = orig[this.valueIndex] + this.increment * dx;
        return new Vec3d(array[0], array[1], array[2]);
    }

    @Override
    public boolean canEdit(int columnIndex) {
        if (columnIndex == 1) {
            return this.canInPlaceEdit;
        }
        return false;
    }

    @Override
    public CellEditor getCellEditor(int columnIndex) {
        if (columnIndex == 1) {
            if (this.editor == null) {
                this.editor = new Vec3dCellEditor((Composite)this.element.viewer.getTree(), 2052);
            }
            return this.editor;
        }
        return null;
    }

    @Override
    public Object getCellEditorValue(int columnIndex) {
        if (columnIndex == 1) {
            double[] array = new double[]{((Vec3d)this.value).x, ((Vec3d)this.value).y, ((Vec3d)this.value).z};
            return this.formatValue(array[this.valueIndex], this.editorPrecision);
        }
        return null;
    }

    @Override
    public void setCellEditorValue(int columnIndex, Object value) {
        if (columnIndex == 1) {
            double[] array = new double[]{((Vec3d)this.value).x, ((Vec3d)this.value).y, ((Vec3d)this.value).z};
            if (value.equals(this.formatValue(array[this.valueIndex], this.editorPrecision))) {
                return;
            }
            try {
                array[this.valueIndex] = Double.valueOf((String)value);
                this.modifyValue(new Vec3d(array[0], array[1], array[2]));
            }
            catch (NumberFormatException numberFormatException) {
                this.element.viewer.getTree().getDisplay().beep();
            }
        }
    }

    protected class Vec3dCellEditor
    extends TextCellEditor {
        private boolean activated;

        protected Vec3dCellEditor(Composite parent, int style) {
            super(parent, style);
        }

        protected Control createControl(final Composite parent) {
            final Composite composite = new Composite(parent, 0x80000 | (COCOA ? 262144 : 0));
            composite.setFont(parent.getFont());
            composite.setBackground(parent.getBackground());
            composite.setLayout((Layout)new FormLayout());
            super.createControl(composite);
            this.text.setBackground(this.text.getDisplay().getSystemColor(1));
            Rectangle valueBounds = (Rectangle)AnimatableVec3dElementDelegate.this.valueArea.get(AnimatableVec3dElementDelegate.this.valueIndex);
            int left = valueBounds.x - ((Rectangle)AnimatableVec3dElementDelegate.this.valueArea.get((int)0)).x + (WIN32 ? 3 : 0);
            int right = left + Math.max(60, valueBounds.width + 30);
            FormData data = new FormData();
            data.top = new FormAttachment(0, 0);
            data.bottom = new FormAttachment(100, 0);
            data.left = new FormAttachment(0, left);
            data.right = new FormAttachment(0, right);
            this.text.setLayoutData((Object)data);
            composite.addMouseListener((MouseListener)new MouseAdapter(){

                public void mouseDown(MouseEvent e) {
                    parent.forceFocus();
                    if (e.button == 1) {
                        int i = 0;
                        int n = ((Vec3dCellEditor)Vec3dCellEditor.this).AnimatableVec3dElementDelegate.this.valueArea.size();
                        while (i < n) {
                            Rectangle r = (Rectangle)((Vec3dCellEditor)Vec3dCellEditor.this).AnimatableVec3dElementDelegate.this.valueArea.get(i);
                            if (r.contains(e.x, e.y)) {
                                ((Vec3dCellEditor)Vec3dCellEditor.this).AnimatableVec3dElementDelegate.this.valueIndex = i < ((Vec3dCellEditor)Vec3dCellEditor.this).AnimatableVec3dElementDelegate.this.valueIndex ? i : i + 1;
                                parent.update();
                                AnimatableVec3dElementDelegate.this.openInPlaceEditor();
                                break;
                            }
                            ++i;
                        }
                    }
                }
            });
            composite.addPaintListener(new PaintListener(){

                public void paintControl(PaintEvent e) {
                    GC gc = e.gc;
                    int x = WIN32 ? 5 : 2;
                    int height = composite.getBounds().height;
                    x = AnimatableVec3dElementDelegate.this.drawValue(gc, x, 0, height, 0, ((Vec3d)((Vec3dCellEditor)Vec3dCellEditor.this).AnimatableVec3dElementDelegate.this.value).x);
                    x = AnimatableVec3dElementDelegate.this.drawSeparator(gc, x, 0, height, false);
                    x = AnimatableVec3dElementDelegate.this.drawValue(gc, x, 0, height, 1, ((Vec3d)((Vec3dCellEditor)Vec3dCellEditor.this).AnimatableVec3dElementDelegate.this.value).y);
                    if (((Vec3dCellEditor)Vec3dCellEditor.this).AnimatableVec3dElementDelegate.this.threeD) {
                        x = AnimatableVec3dElementDelegate.this.drawSeparator(gc, x, 0, height, false);
                        x = AnimatableVec3dElementDelegate.this.drawValue(gc, x, 0, height, 2, ((Vec3d)((Vec3dCellEditor)Vec3dCellEditor.this).AnimatableVec3dElementDelegate.this.value).z);
                    }
                }
            });
            return composite;
        }

        private Rectangle getTextBounds() {
            return this.text.getBounds();
        }

        public void activate() {
            super.activate();
            this.activated = true;
        }

        public void deactivate() {
            super.deactivate();
            if (this.activated) {
                AnimatableVec3dElementDelegate.this.editor = null;
                this.dispose();
            }
        }
    }
}

