/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.app.views.layercomp;

import ch.kuramo.javie.api.Time;
import ch.kuramo.javie.app.Activator;
import ch.kuramo.javie.app.ImageUtil;
import ch.kuramo.javie.app.project.ProjectManager;
import ch.kuramo.javie.app.project.ProjectOperation;
import ch.kuramo.javie.app.project.RemoveKeyframesOperation;
import ch.kuramo.javie.app.views.layercomp.AnimatableValueElement;
import ch.kuramo.javie.app.views.layercomp.EffectAnimatableValueElement;
import ch.kuramo.javie.app.views.layercomp.Element;
import ch.kuramo.javie.app.views.layercomp.LayerAnimatableValueElement;
import ch.kuramo.javie.app.views.layercomp.Switch;
import ch.kuramo.javie.app.views.layercomp.SwitchGroup;
import ch.kuramo.javie.app.views.layercomp.TimelineManager;
import ch.kuramo.javie.app.widgets.InPlaceEditorShell;
import ch.kuramo.javie.core.AnimatableValue;
import ch.kuramo.javie.core.ArithmeticalAnimatableValue;
import ch.kuramo.javie.core.JavieRuntimeException;
import ch.kuramo.javie.core.Keyframe;
import ch.kuramo.javie.core.LayerComposition;
import ch.kuramo.javie.core.Util;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.TreeItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AnimatableValueElementDelegate<V> {
    private static final int[] UNDERLINE_DASH = new int[]{2, 2};
    protected static final boolean COCOA = SWT.getPlatform().equals("cocoa");
    protected static final boolean WIN32 = SWT.getPlatform().equals("win32");
    protected final AnimatableValueElement element;
    protected final String name;
    protected final AnimatableValue<V> avalue;
    protected V value;
    protected final Rectangle stopwatchArea = new Rectangle(Integer.MIN_VALUE, Integer.MIN_VALUE, 13, 14);
    protected final List<Rectangle> valueArea = Util.newList();
    protected final SwitchGroup keyframeNavSwitch = new SwitchGroup();
    protected int yKeyframe = Integer.MIN_VALUE;
    protected V originalValue;
    protected int valueIndex;
    protected DragGestureEditor dragGestureEditor;
    protected boolean canInPlaceEdit;
    protected Element[] children;
    private static Method cocoaGetCurrentButtonStateMethod;
    private static final Image prevKeyframeImage;
    private static final Image prevKeyframeDisabledImage;
    private static final Image nextKeyframeImage;
    private static final Image nextKeyframeDisabledImage;

    static {
        prevKeyframeImage = Activator.getDefault().getImageRegistry().get("IMG_KFNAV_PREV");
        prevKeyframeDisabledImage = Activator.getDefault().getImageRegistry().get("IMG_KFNAV_PREV_DISABLED");
        nextKeyframeImage = Activator.getDefault().getImageRegistry().get("IMG_KFNAV_NEXT");
        nextKeyframeDisabledImage = Activator.getDefault().getImageRegistry().get("IMG_KFNAV_NEXT_DISABLED");
    }

    public AnimatableValueElementDelegate(AnimatableValueElement element, String name, AnimatableValue<V> avalue) {
        this.element = element;
        this.name = name;
        this.avalue = avalue;
        this.keyframeNavSwitch.add(new PrevKeyframeSwitch());
        this.keyframeNavSwitch.add(new ToggleKeyframeSwitch());
        this.keyframeNavSwitch.add(new NextKeyframeSwitch());
    }

    public Image getColumnImage(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return ImageUtil.getStopwatchIcon(this.avalue.hasKeyframe());
            }
        }
        return null;
    }

    public String getColumnText(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return this.name;
            }
            case 1: {
                return " ";
            }
        }
        return null;
    }

    public boolean hasChildren() {
        return this.hasExpression();
    }

    public Element[] getChildren() {
        if (this.hasExpression()) {
            if (this.children == null) {
                this.children = new Element[]{new ExpressionElement()};
            }
            return this.children;
        }
        return Element.EMPTY_CHILDREN;
    }

    public void paintColumn(Event event) {
        switch (event.index) {
            case 0: {
                this.stopwatchArea.x = event.x + 5;
                this.stopwatchArea.y = event.y + (WIN32 ? 1 : 4);
                break;
            }
            case 1: {
                this.updateValue();
                this.valueArea.clear();
                if (this.value == null) break;
                GC gc = event.gc;
                int x = event.x + 5;
                int y = event.y;
                int height = ((TreeItem)event.item).getBounds((int)event.index).height;
                boolean focused = (event.detail & 2) != 0 && ((Control)event.widget).isFocusControl();
                this.drawValue(gc, x, y, height, focused);
                break;
            }
            case 5: {
                this.keyframeNavSwitch.paint(event);
                break;
            }
            case 7: {
                TimelineManager tm = (TimelineManager)this.element.viewer.getData("TIMELINE_MANAGER");
                this.yKeyframe = tm.drawKeyframes(event, this.avalue);
            }
        }
    }

    public void updateCursor(MouseEvent event, int columnIndex) {
        Cursor cursor = null;
        block0 : switch (columnIndex) {
            case 1: {
                for (Rectangle r : this.valueArea) {
                    if (!r.contains(event.x, event.y)) continue;
                    cursor = event.display.getSystemCursor(21);
                    break block0;
                }
                break;
            }
        }
        this.element.viewer.getTree().setCursor(cursor);
    }

    public void mouseDown(MouseEvent event, int columnIndex) {
        block0 : switch (columnIndex) {
            case 0: {
                if (!this.stopwatchArea.contains(event.x, event.y)) break;
                this.toggleStopwatchButon();
                break;
            }
            case 1: {
                if (event.button != 1) break;
                int i = 0;
                int n = this.valueArea.size();
                while (i < n) {
                    Rectangle r = this.valueArea.get(i);
                    if (r.contains(event.x, event.y)) {
                        if (!this.canDragGestureEdit()) {
                            this.valueIndex = i;
                            this.openInPlaceEditor();
                            break block0;
                        }
                        if (this.dragGestureEditor != null) break block0;
                        this.originalValue = this.value;
                        this.valueIndex = i;
                        this.dragGestureEditor = new DragGestureEditor(event);
                        break block0;
                    }
                    ++i;
                }
                break;
            }
            case 5: {
                this.keyframeNavSwitch.mouseDown(event);
                break;
            }
            case 7: {
                TimelineManager tm = (TimelineManager)this.element.viewer.getData("TIMELINE_MANAGER");
                tm.mouseDown(event, this.yKeyframe, this.element, this.avalue);
            }
        }
    }

    public boolean canEdit(int columnIndex) {
        return false;
    }

    public CellEditor getCellEditor(int columnIndex) {
        return null;
    }

    public Object getCellEditorValue(int columnIndex) {
        return null;
    }

    public void setCellEditorValue(int columnIndex, Object value) {
    }

    public boolean updateValue() {
        Map animatableValues = (Map)this.element.viewer.getData("ANIMATABLE_VALUES");
        Object newValue = animatableValues.get(this.avalue);
        if (this.value != null && !this.value.equals(newValue) || this.value == null && newValue != null) {
            this.value = newValue;
            return true;
        }
        return false;
    }

    public boolean hasExpression() {
        return this.avalue.getExpression() != null;
    }

    protected void openInPlaceEditor() {
        this.element.viewer.getTree().setCursor(null);
        this.canInPlaceEdit = true;
        this.element.viewer.editElement((Object)this.element, 1);
        this.canInPlaceEdit = false;
    }

    protected void modifyValue(V newValue) {
        this.modifyValue(newValue, null);
    }

    protected void modifyValue(V newValue, String relation) {
        if (newValue != null && this.avalue instanceof ArithmeticalAnimatableValue) {
            newValue = ((ArithmeticalAnimatableValue)this.avalue).clamp(newValue);
        }
        if (this.value != null && !this.value.equals(newValue) || this.value == null && newValue != null) {
            ProjectManager pm = (ProjectManager)this.element.viewer.getData("PROJECT_MANAGER");
            TimelineManager tm = (TimelineManager)this.element.viewer.getData("TIMELINE_MANAGER");
            pm.postOperation(this.avalue.hasKeyframe() ? this.element.createModifyKeyframeOperation(pm, tm.getCurrentTime(), newValue, relation) : this.element.createModifyValueOperation(pm, newValue, relation));
        }
    }

    protected void modifyExpression(String newExpr) {
        String oldExpr;
        if (newExpr != null && (newExpr = newExpr.trim()).length() == 0) {
            newExpr = null;
        }
        if ((oldExpr = this.avalue.getExpression()) != null && !oldExpr.equals(newExpr) || oldExpr == null && newExpr != null) {
            ProjectManager pm = (ProjectManager)this.element.viewer.getData("PROJECT_MANAGER");
            ProjectOperation operation = this.element.createModifyExpressionOperation(pm, newExpr);
            pm.postOperation(operation);
        }
    }

    protected void toggleStopwatchButon() {
        ProjectManager pm = (ProjectManager)this.element.viewer.getData("PROJECT_MANAGER");
        TimelineManager tm = (TimelineManager)this.element.viewer.getData("TIMELINE_MANAGER");
        pm.postOperation(this.avalue.hasKeyframe() ? this.element.createClearKeyframesOperation(pm) : this.element.createModifyKeyframeOperation(pm, tm.getCurrentTime(), this.value, null));
    }

    protected abstract void drawValue(GC var1, int var2, int var3, int var4, boolean var5);

    protected abstract boolean canDragGestureEdit();

    protected abstract V dragGesture(double var1, double var3);

    protected void setForeground(GC gc, boolean focused) {
        gc.setForeground(gc.getDevice().getSystemColor(focused ? 1 : 2));
    }

    protected void setValueForeground(GC gc, boolean focused) {
        gc.setForeground(gc.getDevice().getSystemColor(focused ? 1 : 10));
    }

    protected int drawValue(GC gc, int x, int y, int height, boolean focused, String value) {
        this.setValueForeground(gc, focused);
        Point extent = gc.textExtent(value, 1);
        gc.drawString(value, x, y += (height - extent.y) / 2, true);
        this.valueArea.add(new Rectangle(x, y, extent.x, extent.y));
        y += extent.y;
        gc.setLineDash(UNDERLINE_DASH);
        if (COCOA) {
            gc.drawLine(x, y - 1, x + extent.x, y - 1);
        } else if (WIN32) {
            gc.drawLine(x, y, x + extent.x - 2, y);
        } else {
            gc.drawLine(x, y, x + extent.x, y);
        }
        return x + extent.x;
    }

    protected int drawValue(GC gc, int x, int y, int height, boolean focused, Double value, int precision, String unit) {
        return this.drawValue(gc, x, y, height, focused, value, false, precision, unit);
    }

    protected int drawValue(GC gc, int x, int y, int height, boolean focused, Double value, boolean alwaysSign, int precision, String unit) {
        x = this.drawValue(gc, x, y, height, focused, String.format(String.valueOf(alwaysSign ? "%+." : "%.") + precision + "f", value));
        if (unit != null) {
            x = this.drawString(gc, x + 1, y, height, unit);
        }
        return x;
    }

    protected int drawValue(GC gc, int x, int y, int height, boolean focused, Integer value, String unit) {
        x = this.drawValue(gc, x, y, height, focused, value.toString());
        if (unit != null) {
            x = this.drawString(gc, x + 1, y, height, unit);
        }
        return x;
    }

    protected int drawString(GC gc, int x, int y, int height, String str) {
        Point extent = gc.textExtent(str, 1);
        gc.drawString(str, x, y += (height - extent.y) / 2, true);
        return x + extent.x;
    }

    protected String formatValue(Double value, int precision) {
        if (precision < 0) {
            throw new IllegalArgumentException();
        }
        String s = String.format("%." + precision + "f", value);
        int dotIndex = s.indexOf(46);
        if (dotIndex != -1) {
            int i = s.length() - 1;
            while (i >= dotIndex) {
                char c = s.charAt(i);
                if (c != '0') {
                    return s.substring(0, c == '.' ? i : i + 1);
                }
                --i;
            }
        }
        return s;
    }

    private static int getCocoaCurrentButtonState() {
        try {
            if (cocoaGetCurrentButtonStateMethod == null) {
                Class<?> clazz = Class.forName("org.eclipse.swt.internal.cocoa.OS");
                cocoaGetCurrentButtonStateMethod = clazz.getMethod("GetCurrentButtonState", new Class[0]);
            }
            return (Integer)cocoaGetCurrentButtonStateMethod.invoke(null, new Object[0]);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new JavieRuntimeException((Throwable)e);
        }
    }

    protected class DragGestureEditor {
        private final String relation = Util.randomId();
        private final long downTime;
        private final Point downPoint;
        private boolean dragDetected;
        private Point detectPoint;
        private Point prevPoint;
        private double[] currentPoint;

        protected DragGestureEditor(MouseEvent event) {
            Control control = (Control)event.widget;
            this.downTime = System.currentTimeMillis();
            this.downPoint = control.toDisplay(event.x, event.y);
            this.init(control);
        }

        private void init(final Control control) {
            final Display display = control.getDisplay();
            Listener listener = new Listener(){

                public void handleEvent(Event e) {
                    switch (e.type) {
                        case 5: {
                            if (!control.isDisposed()) {
                                if (COCOA && (AnimatableValueElementDelegate.getCocoaCurrentButtonState() & 1) == 0) break;
                                Point pt = display.getCursorLocation();
                                if (!DragGestureEditor.this.dragDetected) {
                                    DragGestureEditor.this.dragDetected = System.currentTimeMillis() - DragGestureEditor.this.downTime > 100L && (Math.abs(pt.x - ((DragGestureEditor)DragGestureEditor.this).downPoint.x) > 3 || Math.abs(pt.y - ((DragGestureEditor)DragGestureEditor.this).downPoint.y) > 3);
                                    if (DragGestureEditor.this.dragDetected) {
                                        DragGestureEditor.this.currentPoint = new double[]{pt.x, pt.y};
                                        Point point = pt;
                                        DragGestureEditor.this.detectPoint = point;
                                        DragGestureEditor.this.prevPoint = point;
                                    }
                                }
                                if (!DragGestureEditor.this.dragDetected) break;
                                double deltaScale = (e.stateMask & SWT.MOD2) != 0 ? 10.0 : ((e.stateMask & SWT.MOD1) != 0 ? 0.1 : 1.0);
                                double[] dArray = DragGestureEditor.this.currentPoint;
                                dArray[0] = dArray[0] + (double)(pt.x - ((DragGestureEditor)DragGestureEditor.this).prevPoint.x) * deltaScale;
                                double[] dArray2 = DragGestureEditor.this.currentPoint;
                                dArray2[1] = dArray2[1] + (double)(pt.y - ((DragGestureEditor)DragGestureEditor.this).prevPoint.y) * deltaScale;
                                DragGestureEditor.this.prevPoint = pt;
                                Object newValue = AnimatableValueElementDelegate.this.dragGesture(DragGestureEditor.this.currentPoint[0] - (double)((DragGestureEditor)DragGestureEditor.this).detectPoint.x, DragGestureEditor.this.currentPoint[1] - (double)((DragGestureEditor)DragGestureEditor.this).detectPoint.y);
                                AnimatableValueElementDelegate.this.modifyValue(newValue, DragGestureEditor.this.relation);
                                break;
                            }
                        }
                        case 4: 
                        case 27: {
                            ((DragGestureEditor)DragGestureEditor.this).AnimatableValueElementDelegate.this.dragGestureEditor = null;
                            display.removeFilter(5, (Listener)this);
                            display.removeFilter(4, (Listener)this);
                            display.removeFilter(27, (Listener)this);
                            if (e.type != 4 || control.isDisposed() || DragGestureEditor.this.dragDetected) break;
                            AnimatableValueElementDelegate.this.openInPlaceEditor();
                        }
                    }
                }
            };
            display.addFilter(5, listener);
            display.addFilter(4, listener);
            display.addFilter(27, listener);
        }
    }

    public class ExpressionElement
    extends Element {
        private Rectangle exprArea;
        private Point editorSize;

        public ExpressionElement() {
            super(AnimatableValueElementDelegate.this.element);
        }

        public String getColumnText(int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return "\u30a8\u30af\u30b9\u30d7\u30ec\u30c3\u30b7\u30e7\u30f3\uff1a" + AnimatableValueElementDelegate.this.name;
                }
                case 7: {
                    return AnimatableValueElementDelegate.this.avalue.getExpression().replaceAll("\\r?\\n|\\r", " ");
                }
            }
            return super.getColumnText(columnIndex);
        }

        public void paintColumn(Event event) {
            if (event.index == 7) {
                this.exprArea = ((TreeItem)event.item).getBounds(7);
            }
            super.paintColumn(event);
        }

        public void mouseDown(MouseEvent event, int columnIndex) {
            super.mouseDown(event, columnIndex);
            if (columnIndex == 7 && event.button == 1) {
                this.openInPlaceEditor();
            }
        }

        public void openInPlaceEditor() {
            Font font;
            if (this.exprArea == null) {
                this.viewer.getTree().getDisplay().asyncExec(new Runnable(){

                    public void run() {
                        if (ExpressionElement.this.exprArea != null) {
                            ExpressionElement.this.openInPlaceEditor();
                        }
                    }
                });
                return;
            }
            if (this.editorSize == null) {
                this.editorSize = new Point(this.exprArea.width, 200);
            }
            final Shell shell = InPlaceEditorShell.create((Control)this.viewer.getTree(), this.exprArea, this.editorSize.x, this.editorSize.y, true);
            shell.setMinimumSize(100, 100);
            FillLayout fillLayout = new FillLayout();
            fillLayout.marginWidth = 5;
            fillLayout.marginHeight = 5;
            shell.setLayout((Layout)fillLayout);
            final Text text = new Text((Composite)shell, 2818);
            text.setTabs(4);
            if (WIN32) {
                font = new Font((Device)text.getDisplay(), "MS Gothic", 10, 0);
                text.setFont(font);
            } else if (COCOA) {
                font = new Font((Device)text.getDisplay(), "Monaco", 11, 0);
                text.setFont(font);
            } else {
                font = null;
            }
            text.setText(AnimatableValueElementDelegate.this.avalue.getExpression());
            text.selectAll();
            shell.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    AnimatableValueElementDelegate.this.modifyExpression(text.getText());
                    ExpressionElement.this.editorSize = shell.getSize();
                    if (font != null) {
                        text.setFont(null);
                        font.dispose();
                    }
                }
            });
            shell.open();
        }
    }

    private class NextKeyframeSwitch
    implements Switch {
        private final TimelineManager tm;
        private final LayerComposition comp;

        private NextKeyframeSwitch() {
            this.tm = (TimelineManager)AnimatableValueElementDelegate.this.element.viewer.getData("TIMELINE_MANAGER");
            this.comp = (LayerComposition)AnimatableValueElementDelegate.this.element.viewer.getData("LAYER_COMPOSITION");
        }

        private Time getNextTime() {
            Time frameDuration = this.comp.getFrameDuration();
            Time halfOfFrameDuration = new Time(frameDuration.timeValue / 2L, frameDuration.timeScale);
            SortedMap tailMap = AnimatableValueElementDelegate.this.avalue.getKeyframeMap().tailMap(this.tm.getCurrentTime().add(frameDuration).subtract(halfOfFrameDuration));
            if (tailMap.isEmpty()) {
                return null;
            }
            Time time = tailMap.firstKey().add(halfOfFrameDuration);
            return Time.fromFrameNumber((long)time.toFrameNumber(frameDuration), (Time)frameDuration);
        }

        public boolean hasBorder() {
            return false;
        }

        public void mouseDown(MouseEvent event) {
            Time nextTime;
            if (AnimatableValueElementDelegate.this.avalue.hasKeyframe() && (nextTime = this.getNextTime()) != null) {
                this.tm.setTime(nextTime);
            }
        }

        public Image getImage() {
            return AnimatableValueElementDelegate.this.avalue.hasKeyframe() ? (this.getNextTime() != null ? nextKeyframeImage : nextKeyframeDisabledImage) : null;
        }
    }

    private class PrevKeyframeSwitch
    implements Switch {
        private final TimelineManager tm;
        private final LayerComposition comp;

        private PrevKeyframeSwitch() {
            this.tm = (TimelineManager)AnimatableValueElementDelegate.this.element.viewer.getData("TIMELINE_MANAGER");
            this.comp = (LayerComposition)AnimatableValueElementDelegate.this.element.viewer.getData("LAYER_COMPOSITION");
        }

        private Time getPrevTime() {
            Time frameDuration = this.comp.getFrameDuration();
            Time halfOfFrameDuration = new Time(frameDuration.timeValue / 2L, frameDuration.timeScale);
            SortedMap headMap = AnimatableValueElementDelegate.this.avalue.getKeyframeMap().headMap(this.tm.getCurrentTime().subtract(halfOfFrameDuration));
            if (headMap.isEmpty()) {
                return null;
            }
            Time time = headMap.lastKey().add(halfOfFrameDuration);
            return Time.fromFrameNumber((long)time.toFrameNumber(frameDuration), (Time)frameDuration);
        }

        public boolean hasBorder() {
            return false;
        }

        public void mouseDown(MouseEvent event) {
            Time prevTime;
            if (AnimatableValueElementDelegate.this.avalue.hasKeyframe() && (prevTime = this.getPrevTime()) != null) {
                this.tm.setTime(prevTime);
            }
        }

        public Image getImage() {
            return AnimatableValueElementDelegate.this.avalue.hasKeyframe() ? (this.getPrevTime() != null ? prevKeyframeImage : prevKeyframeDisabledImage) : null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ToggleKeyframeSwitch
    implements Switch {
        private final TimelineManager tm;
        private final ProjectManager pm;
        private final LayerComposition comp;

        private ToggleKeyframeSwitch() {
            this.tm = (TimelineManager)AnimatableValueElementDelegate.this.element.viewer.getData("TIMELINE_MANAGER");
            this.pm = (ProjectManager)AnimatableValueElementDelegate.this.element.viewer.getData("PROJECT_MANAGER");
            this.comp = (LayerComposition)AnimatableValueElementDelegate.this.element.viewer.getData("LAYER_COMPOSITION");
        }

        private SortedMap<Time, Keyframe<V>> getKeyframeMap() {
            Time frameDuration = this.comp.getFrameDuration();
            Time halfOfFrameDuration = new Time(frameDuration.timeValue / 2L, frameDuration.timeScale);
            Time time = this.tm.getCurrentTime();
            Time t1 = time.subtract(halfOfFrameDuration);
            Time t2 = time.add(frameDuration).subtract(halfOfFrameDuration);
            return AnimatableValueElementDelegate.this.avalue.getKeyframeMap().subMap(t1, t2);
        }

        @Override
        public boolean hasBorder() {
            return AnimatableValueElementDelegate.this.avalue.hasKeyframe();
        }

        @Override
        public void mouseDown(MouseEvent event) {
            if (!AnimatableValueElementDelegate.this.avalue.hasKeyframe()) {
                return;
            }
            Collection keyframes = this.getKeyframeMap().values();
            if (keyframes.isEmpty()) {
                this.pm.postOperation(AnimatableValueElementDelegate.this.element.createModifyKeyframeOperation(this.pm, this.tm.getCurrentTime(), AnimatableValueElementDelegate.this.value, null));
            } else {
                List data = Util.newList();
                if (AnimatableValueElementDelegate.this.element instanceof LayerAnimatableValueElement) {
                    LayerAnimatableValueElement avalueElem = (LayerAnimatableValueElement)AnimatableValueElementDelegate.this.element;
                    String id = avalueElem.layer.getId();
                    String prop = avalueElem.getProperty();
                    for (Keyframe kf : keyframes) {
                        data.add(new Object[]{id, -1, prop, kf});
                    }
                } else {
                    EffectAnimatableValueElement avalueElem = (EffectAnimatableValueElement)AnimatableValueElementDelegate.this.element;
                    String id = avalueElem.layer.getId();
                    int effectIndex = avalueElem.layer.getEffects().indexOf(avalueElem.effect);
                    String prop = avalueElem.descriptor.getName();
                    for (Keyframe kf : keyframes) {
                        data.add(new Object[]{id, effectIndex, prop, kf});
                    }
                }
                this.pm.postOperation(new RemoveKeyframesOperation(this.pm, this.comp, (Object[][])data.toArray((T[])new Object[data.size()][])));
            }
        }

        @Override
        public Image getImage() {
            SortedMap keyframeMap = this.getKeyframeMap();
            if (keyframeMap.isEmpty()) {
                return null;
            }
            Time time = this.tm.getCurrentTime();
            Keyframe kf = (Keyframe)keyframeMap.get(time);
            if (kf == null) {
                Keyframe kf2;
                SortedMap head = keyframeMap.headMap(time);
                SortedMap tail = keyframeMap.tailMap(time);
                Keyframe kf1 = head.isEmpty() ? null : (Keyframe)head.get(head.lastKey());
                Keyframe keyframe = kf2 = tail.isEmpty() ? null : (Keyframe)tail.get(tail.firstKey());
                if (kf1 != null && kf2 != null) {
                    kf = kf2.time.subtract(time).before(time.subtract(kf1.time)) ? kf2 : kf1;
                } else if (kf1 != null) {
                    kf = kf1;
                } else if (kf2 != null) {
                    kf = kf2;
                }
            }
            return ImageUtil.getKeyframeIcon(kf.interpolation, false);
        }
    }
}

