/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.app.views.layercomp;

import ch.kuramo.javie.app.views.layercomp.AnimatableValueElement;
import ch.kuramo.javie.app.views.layercomp.AnimatableValueElementDelegate;
import ch.kuramo.javie.core.AnimatableDouble;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AngleElementDelegate
extends AnimatableValueElementDelegate<Double> {
    protected final double increment;
    protected final int displayPrecision;
    protected final int editorPrecision;
    protected final String unit;
    protected AngleCellEditor editor;

    public AngleElementDelegate(AnimatableValueElement element, String name, AnimatableDouble avalue) {
        this(element, name, avalue, null);
    }

    public AngleElementDelegate(AnimatableValueElement element, String name, AnimatableDouble avalue, String unit) {
        this(element, name, avalue, 1.0, 1, 4, unit);
    }

    public AngleElementDelegate(AnimatableValueElement element, String name, AnimatableDouble avalue, double increment, int displayPrecision, int editorPrecision, String unit) {
        super(element, name, avalue);
        this.increment = increment;
        this.displayPrecision = displayPrecision;
        this.editorPrecision = editorPrecision;
        this.unit = unit;
    }

    @Override
    protected void drawValue(GC gc, int x, int y, int height, boolean focused) {
        if (this.editor != null) {
            return;
        }
        x = this.drawValue(gc, x, y, height, focused, (int)((Double)this.value / 360.0), "x");
        x += 5;
        x = this.drawValue(gc, x, y, height, focused, (Double)this.value % 360.0, true, this.displayPrecision, this.unit);
    }

    protected int drawValue(GC gc, int x, int y, int height, int valueIndex, double value) {
        if (this.editor == null) {
            throw new IllegalStateException("no editor");
        }
        if (this.valueIndex == valueIndex) {
            Rectangle bounds = this.editor.getTextBounds();
            if (valueIndex == 0) {
                this.setValueForeground(gc, false);
                return this.drawString(gc, x + bounds.width + (WIN32 ? 0 : 3), y, height, "x");
            }
            if (this.unit != null) {
                this.setValueForeground(gc, false);
                return this.drawString(gc, x + bounds.width + (WIN32 ? 0 : 3), y, height, this.unit);
            }
            return x + bounds.width;
        }
        if (valueIndex == 0) {
            return this.drawValue(gc, x, y, height, false, (int)(value / 360.0), "x");
        }
        return this.drawValue(gc, x, y, height, false, value % 360.0, true, this.displayPrecision, this.unit);
    }

    @Override
    protected boolean canDragGestureEdit() {
        return true;
    }

    @Override
    protected Double dragGesture(double dx, double dy) {
        return (Double)this.originalValue + this.increment * dx * (double)(this.valueIndex == 0 ? 360 : 1);
    }

    @Override
    public boolean canEdit(int columnIndex) {
        if (columnIndex == 1) {
            return this.canInPlaceEdit;
        }
        return false;
    }

    @Override
    public CellEditor getCellEditor(int columnIndex) {
        if (columnIndex == 1) {
            if (this.editor == null) {
                this.editor = new AngleCellEditor((Composite)this.element.viewer.getTree(), 2052);
            }
            return this.editor;
        }
        return null;
    }

    @Override
    public Object getCellEditorValue(int columnIndex) {
        if (columnIndex == 1) {
            return this.valueIndex == 0 ? String.valueOf((int)((Double)this.value / 360.0)) : this.formatValue((Double)this.value % 360.0, this.editorPrecision);
        }
        return null;
    }

    @Override
    public void setCellEditorValue(int columnIndex, Object value) {
        if (columnIndex == 1) {
            try {
                double newValue;
                if (this.valueIndex == 0) {
                    if (value.equals(String.valueOf((int)((Double)this.value / 360.0)))) {
                        return;
                    }
                    newValue = Double.valueOf((String)value) * 360.0 + (Double)this.value % 360.0;
                } else {
                    if (value.equals(this.formatValue((Double)this.value % 360.0, this.editorPrecision))) {
                        return;
                    }
                    newValue = (double)((int)((Double)this.value / 360.0) * 360) + Double.valueOf((String)value);
                }
                this.modifyValue(newValue);
            }
            catch (NumberFormatException numberFormatException) {
                this.element.viewer.getTree().getDisplay().beep();
            }
        }
    }

    private class AngleCellEditor
    extends TextCellEditor {
        private boolean activated;

        protected AngleCellEditor(Composite parent, int style) {
            super(parent, style);
        }

        protected Control createControl(final Composite parent) {
            final Composite composite = new Composite(parent, 0x80000 | (COCOA ? 262144 : 0));
            composite.setFont(parent.getFont());
            composite.setBackground(parent.getBackground());
            composite.setLayout((Layout)new FormLayout());
            super.createControl(composite);
            this.text.setBackground(this.text.getDisplay().getSystemColor(1));
            Rectangle valueBounds = (Rectangle)AngleElementDelegate.this.valueArea.get(AngleElementDelegate.this.valueIndex);
            int left = valueBounds.x - ((Rectangle)AngleElementDelegate.this.valueArea.get((int)0)).x + (WIN32 ? 3 : 0);
            int right = left + Math.max(60, valueBounds.width + 30);
            FormData data = new FormData();
            data.top = new FormAttachment(0, 0);
            data.bottom = new FormAttachment(100, 0);
            data.left = new FormAttachment(0, left);
            data.right = new FormAttachment(0, right);
            this.text.setLayoutData((Object)data);
            composite.addMouseListener((MouseListener)new MouseAdapter(){

                public void mouseDown(MouseEvent e) {
                    parent.forceFocus();
                    if (e.button == 1) {
                        int i = 0;
                        int n = ((AngleCellEditor)AngleCellEditor.this).AngleElementDelegate.this.valueArea.size();
                        while (i < n) {
                            Rectangle r = (Rectangle)((AngleCellEditor)AngleCellEditor.this).AngleElementDelegate.this.valueArea.get(i);
                            if (r.contains(e.x, e.y)) {
                                ((AngleCellEditor)AngleCellEditor.this).AngleElementDelegate.this.valueIndex = i < ((AngleCellEditor)AngleCellEditor.this).AngleElementDelegate.this.valueIndex ? i : i + 1;
                                parent.update();
                                AngleElementDelegate.this.openInPlaceEditor();
                                break;
                            }
                            ++i;
                        }
                    }
                }
            });
            composite.addPaintListener(new PaintListener(){

                public void paintControl(PaintEvent e) {
                    GC gc = e.gc;
                    int x = WIN32 ? 5 : 2;
                    int height = composite.getBounds().height;
                    x = AngleElementDelegate.this.drawValue(gc, x, 0, height, 0, (Double)((AngleCellEditor)AngleCellEditor.this).AngleElementDelegate.this.value);
                    x += 5;
                    x = AngleElementDelegate.this.drawValue(gc, x, 0, height, 1, (Double)((AngleCellEditor)AngleCellEditor.this).AngleElementDelegate.this.value);
                }
            });
            return composite;
        }

        private Rectangle getTextBounds() {
            return this.text.getBounds();
        }

        public void activate() {
            super.activate();
            this.activated = true;
        }

        public void deactivate() {
            super.deactivate();
            if (this.activated) {
                AngleElementDelegate.this.editor = null;
                this.dispose();
            }
        }
    }
}

