/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.app.project;

import ch.kuramo.javie.app.InjectorHolder;
import ch.kuramo.javie.app.project.ProjectManager;
import ch.kuramo.javie.app.project.ProjectOperation;
import ch.kuramo.javie.core.JavieRuntimeException;
import ch.kuramo.javie.core.Layer;
import ch.kuramo.javie.core.LayerComposition;
import ch.kuramo.javie.core.Project;
import ch.kuramo.javie.core.ProjectDecodeException;
import ch.kuramo.javie.core.TextAnimator;
import ch.kuramo.javie.core.TextLayer;
import ch.kuramo.javie.core.Util;
import ch.kuramo.javie.core.services.ProjectDecoder;
import ch.kuramo.javie.core.services.ProjectEncoder;
import com.google.inject.Inject;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemoveTextAnimatorsOperation
extends ProjectOperation {
    private final String compId;
    private final List<Entry> entries = Util.newList();
    @Inject
    private ProjectEncoder encoder;
    @Inject
    private ProjectDecoder decoder;

    public RemoveTextAnimatorsOperation(ProjectManager pm, Collection<Object[]> animators) {
        super(pm, "\u30c6\u30ad\u30b9\u30c8\u30a2\u30cb\u30e1\u30fc\u30bf\u306e\u524a\u9664");
        InjectorHolder.getInjector().injectMembers((Object)this);
        LayerComposition comp = pm.checkLayer((Layer)((TextLayer)animators.iterator().next()[0]));
        this.compId = comp.getId();
        for (Object[] o : animators) {
            TextLayer layer = (TextLayer)o[0];
            TextAnimator animator = (TextAnimator)o[1];
            if (pm.checkLayer((Layer)layer) != comp) {
                throw new IllegalArgumentException();
            }
            int animatorIndex = layer.getTextAnimators().indexOf(animator);
            if (animatorIndex == -1) {
                throw new IllegalArgumentException();
            }
            String data = this.encoder.encodeElement((Object)animator);
            this.entries.add(new Entry(data, layer.getId(), animatorIndex));
        }
        Collections.sort(this.entries, new Comparator<Entry>(){

            @Override
            public int compare(Entry o1, Entry o2) {
                int c = o1.layerId.compareTo(o2.layerId);
                return c != 0 ? c : o1.animatorIndex - o2.animatorIndex;
            }
        });
    }

    @Override
    protected IStatus executeOrRedo(IProgressMonitor monitor, IAdaptable info, Project project, ProjectManager pm) throws ExecutionException {
        LayerComposition comp = (LayerComposition)project.getComposition(this.compId);
        List reverseEntries = Util.newList(this.entries);
        Collections.reverse(reverseEntries);
        for (Entry entry : reverseEntries) {
            TextLayer layer = (TextLayer)comp.getLayer(entry.layerId);
            layer.getTextAnimators().remove(entry.animatorIndex);
        }
        if (pm != null) {
            this.fireTextAnimatorsAddRemove(false, comp, pm);
        }
        return Status.OK_STATUS;
    }

    @Override
    protected IStatus undo(IProgressMonitor monitor, IAdaptable info, Project project, ProjectManager pm) throws ExecutionException {
        LayerComposition comp = (LayerComposition)project.getComposition(this.compId);
        for (Entry entry : this.entries) {
            TextAnimator animator;
            try {
                animator = (TextAnimator)this.decoder.decodeElement((CharSequence)entry.data, TextAnimator.class);
            }
            catch (ProjectDecodeException e) {
                throw new JavieRuntimeException((Throwable)e);
            }
            TextLayer layer = (TextLayer)comp.getLayer(entry.layerId);
            layer.getTextAnimators().add(entry.animatorIndex, animator);
        }
        if (pm != null) {
            this.fireTextAnimatorsAddRemove(true, comp, pm);
        }
        return Status.OK_STATUS;
    }

    private Object[][] createData(LayerComposition comp) {
        List data = Util.newList();
        for (Entry entry : this.entries) {
            TextLayer layer = (TextLayer)comp.getLayer(entry.layerId);
            data.add(new Object[]{layer, entry.animatorIndex});
        }
        return (Object[][])data.toArray((T[])new Object[data.size()][]);
    }

    private void fireTextAnimatorsAddRemove(boolean add, LayerComposition comp, ProjectManager pm) {
        Object[][] data = this.createData(comp);
        if (add) {
            pm.fireTextAnimatorsAdd(comp, data);
        } else {
            pm.fireTextAnimatorsRemove(comp, data);
        }
    }

    private static class Entry {
        final String data;
        final String layerId;
        final int animatorIndex;

        private Entry(String data, String layerId, int animatorIndex) {
            this.data = data;
            this.layerId = layerId;
            this.animatorIndex = animatorIndex;
        }
    }
}

