/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.app.project;

import ch.kuramo.javie.app.InjectorHolder;
import ch.kuramo.javie.app.project.ProjectManager;
import ch.kuramo.javie.app.project.ProjectOperation;
import ch.kuramo.javie.core.JavieRuntimeException;
import ch.kuramo.javie.core.Layer;
import ch.kuramo.javie.core.LayerComposition;
import ch.kuramo.javie.core.Project;
import ch.kuramo.javie.core.ProjectDecodeException;
import ch.kuramo.javie.core.TASelector;
import ch.kuramo.javie.core.TextAnimator;
import ch.kuramo.javie.core.TextLayer;
import ch.kuramo.javie.core.Util;
import ch.kuramo.javie.core.services.ProjectDecoder;
import ch.kuramo.javie.core.services.ProjectEncoder;
import com.google.inject.Inject;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemoveTASelectorsOperation
extends ProjectOperation {
    private final String compId;
    private final List<Entry> entries = Util.newList();
    @Inject
    private ProjectEncoder encoder;
    @Inject
    private ProjectDecoder decoder;

    public RemoveTASelectorsOperation(ProjectManager pm, Collection<Object[]> selectors) {
        super(pm, "\u30bb\u30ec\u30af\u30bf\u306e\u524a\u9664");
        InjectorHolder.getInjector().injectMembers((Object)this);
        LayerComposition comp = pm.checkLayer((Layer)((TextLayer)selectors.iterator().next()[0]));
        this.compId = comp.getId();
        for (Object[] o : selectors) {
            TextLayer layer = (TextLayer)o[0];
            TextAnimator animator = (TextAnimator)o[1];
            TASelector selector = (TASelector)o[2];
            if (pm.checkLayer((Layer)layer) != comp) {
                throw new IllegalArgumentException();
            }
            int animatorIndex = layer.getTextAnimators().indexOf(animator);
            if (animatorIndex == -1) {
                throw new IllegalArgumentException();
            }
            int selectorIndex = animator.getSelectors().indexOf(selector);
            if (selectorIndex == -1) {
                throw new IllegalArgumentException();
            }
            String data = this.encoder.encodeElement((Object)selector);
            this.entries.add(new Entry(data, layer.getId(), animatorIndex, selectorIndex));
        }
        Collections.sort(this.entries, new Comparator<Entry>(){

            @Override
            public int compare(Entry o1, Entry o2) {
                int c = o1.layerId.compareTo(o2.layerId);
                if (c != 0) {
                    return c;
                }
                c = o1.animatorIndex - o2.animatorIndex;
                if (c != 0) {
                    return c;
                }
                return o1.selectorIndex - o2.selectorIndex;
            }
        });
    }

    @Override
    protected IStatus executeOrRedo(IProgressMonitor monitor, IAdaptable info, Project project, ProjectManager pm) throws ExecutionException {
        LayerComposition comp = (LayerComposition)project.getComposition(this.compId);
        List reverseEntries = Util.newList(this.entries);
        Collections.reverse(reverseEntries);
        for (Entry entry : reverseEntries) {
            TextLayer layer = (TextLayer)comp.getLayer(entry.layerId);
            TextAnimator animator = (TextAnimator)layer.getTextAnimators().get(entry.animatorIndex);
            animator.getSelectors().remove(entry.selectorIndex);
        }
        if (pm != null) {
            this.fireTASelectorsAddRemove(false, comp, pm);
        }
        return Status.OK_STATUS;
    }

    @Override
    protected IStatus undo(IProgressMonitor monitor, IAdaptable info, Project project, ProjectManager pm) throws ExecutionException {
        LayerComposition comp = (LayerComposition)project.getComposition(this.compId);
        for (Entry entry : this.entries) {
            TASelector selector;
            try {
                selector = (TASelector)this.decoder.decodeElement((CharSequence)entry.data, TASelector.class);
            }
            catch (ProjectDecodeException e) {
                throw new JavieRuntimeException((Throwable)e);
            }
            TextLayer layer = (TextLayer)comp.getLayer(entry.layerId);
            TextAnimator animator = (TextAnimator)layer.getTextAnimators().get(entry.animatorIndex);
            animator.getSelectors().add(entry.selectorIndex, selector);
        }
        if (pm != null) {
            this.fireTASelectorsAddRemove(true, comp, pm);
        }
        return Status.OK_STATUS;
    }

    private Object[][] createData(LayerComposition comp) {
        List data = Util.newList();
        for (Entry entry : this.entries) {
            TextLayer layer = (TextLayer)comp.getLayer(entry.layerId);
            data.add(new Object[]{layer, entry.animatorIndex, entry.selectorIndex});
        }
        return (Object[][])data.toArray((T[])new Object[data.size()][]);
    }

    private void fireTASelectorsAddRemove(boolean add, LayerComposition comp, ProjectManager pm) {
        Object[][] data = this.createData(comp);
        if (add) {
            pm.fireTASelectorsAdd(comp, data);
        } else {
            pm.fireTASelectorsRemove(comp, data);
        }
    }

    private static class Entry {
        final String data;
        final String layerId;
        final int animatorIndex;
        final int selectorIndex;

        private Entry(String data, String layerId, int animatorIndex, int selectorIndex) {
            this.data = data;
            this.layerId = layerId;
            this.animatorIndex = animatorIndex;
            this.selectorIndex = selectorIndex;
        }
    }
}

