/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.app.project;

import ch.kuramo.javie.app.project.ProjectManager;
import ch.kuramo.javie.app.project.ProjectOperation;
import ch.kuramo.javie.core.Layer;
import ch.kuramo.javie.core.LayerComposition;
import ch.kuramo.javie.core.Project;
import ch.kuramo.javie.core.TAProperty;
import ch.kuramo.javie.core.TextAnimator;
import ch.kuramo.javie.core.TextLayer;
import ch.kuramo.javie.core.Util;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemoveTAPropertiesOperation
extends ProjectOperation {
    private final String compId;
    private final List<Entry> entries = Util.newList();

    public RemoveTAPropertiesOperation(ProjectManager pm, Collection<Object[]> properties) {
        super(pm, "\u30d7\u30ed\u30d1\u30c6\u30a3\u306e\u524a\u9664");
        LayerComposition comp = pm.checkLayer((Layer)((TextLayer)properties.iterator().next()[0]));
        this.compId = comp.getId();
        for (Object[] o : properties) {
            TextLayer layer = (TextLayer)o[0];
            TextAnimator animator = (TextAnimator)o[1];
            String property = (String)o[2];
            if (pm.checkLayer((Layer)layer) != comp) {
                throw new IllegalArgumentException();
            }
            int animatorIndex = layer.getTextAnimators().indexOf(animator);
            if (animatorIndex == -1) {
                throw new IllegalArgumentException();
            }
            TAProperty tap = TAProperty.valueOf((String)property);
            if (!animator.getProperties().contains(tap)) continue;
            this.entries.add(new Entry(layer.getId(), animatorIndex, tap));
        }
        this._noEffect = this.entries.isEmpty();
    }

    @Override
    protected IStatus executeOrRedo(IProgressMonitor monitor, IAdaptable info, Project project, ProjectManager pm) throws ExecutionException {
        LayerComposition comp = (LayerComposition)project.getComposition(this.compId);
        List data = null;
        if (pm != null) {
            data = Util.newList();
        }
        for (Entry entry : this.entries) {
            TextLayer layer = (TextLayer)comp.getLayer(entry.layerId);
            TextAnimator animator = (TextAnimator)layer.getTextAnimators().get(entry.animatorIndex);
            animator.getProperties().remove(entry.property);
            if (pm == null) continue;
            data.add(new Object[]{layer, entry.animatorIndex, entry.property.name()});
        }
        if (pm != null) {
            pm.fireTAPropertiesRemove(comp, (Object[][])data.toArray((T[])new Object[data.size()][]));
        }
        return Status.OK_STATUS;
    }

    @Override
    protected IStatus undo(IProgressMonitor monitor, IAdaptable info, Project project, ProjectManager pm) throws ExecutionException {
        LayerComposition comp = (LayerComposition)project.getComposition(this.compId);
        List data = null;
        if (pm != null) {
            data = Util.newList();
        }
        for (Entry entry : this.entries) {
            TextLayer layer = (TextLayer)comp.getLayer(entry.layerId);
            TextAnimator animator = (TextAnimator)layer.getTextAnimators().get(entry.animatorIndex);
            animator.getProperties().add(entry.property);
            if (pm == null) continue;
            data.add(new Object[]{layer, entry.animatorIndex, entry.property.name()});
        }
        if (pm != null) {
            pm.fireTAPropertiesAdd(comp, (Object[][])data.toArray((T[])new Object[data.size()][]));
        }
        return Status.OK_STATUS;
    }

    private static class Entry {
        final String layerId;
        final int animatorIndex;
        final TAProperty property;

        private Entry(String layerId, int animatorIndex, TAProperty property) {
            this.layerId = layerId;
            this.animatorIndex = animatorIndex;
            this.property = property;
        }
    }
}

