/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.app.project;

import ch.kuramo.javie.app.InjectorHolder;
import ch.kuramo.javie.app.project.ProjectManager;
import ch.kuramo.javie.app.project.ProjectOperation;
import ch.kuramo.javie.core.Effect;
import ch.kuramo.javie.core.EffectableLayer;
import ch.kuramo.javie.core.JavieRuntimeException;
import ch.kuramo.javie.core.Layer;
import ch.kuramo.javie.core.LayerComposition;
import ch.kuramo.javie.core.Project;
import ch.kuramo.javie.core.ProjectDecodeException;
import ch.kuramo.javie.core.Util;
import ch.kuramo.javie.core.services.ProjectDecoder;
import ch.kuramo.javie.core.services.ProjectEncoder;
import com.google.inject.Inject;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemoveEffectsOperation
extends ProjectOperation {
    private final String _compId;
    private final List<Entry> _entries = Util.newList();
    @Inject
    private ProjectEncoder _encoder;
    @Inject
    private ProjectDecoder _decoder;

    public RemoveEffectsOperation(ProjectManager pm, Collection<Object[]> effects) {
        super(pm, "\u30a8\u30d5\u30a7\u30af\u30c8\u306e\u524a\u9664");
        InjectorHolder.getInjector().injectMembers((Object)this);
        LayerComposition comp = pm.checkLayer((Layer)((EffectableLayer)effects.iterator().next()[0]));
        this._compId = comp.getId();
        for (Object[] o : effects) {
            EffectableLayer layer = (EffectableLayer)o[0];
            Effect effect = (Effect)o[1];
            if (pm.checkLayer((Layer)layer) != comp) {
                throw new IllegalArgumentException();
            }
            int effectIndex = layer.getEffects().indexOf(effect);
            if (effectIndex == -1) {
                throw new IllegalArgumentException();
            }
            String data = this._encoder.encodeElement((Object)effect);
            this._entries.add(new Entry(data, layer.getId(), effectIndex));
        }
        Collections.sort(this._entries, new Comparator<Entry>(){

            @Override
            public int compare(Entry o1, Entry o2) {
                int c = o1.layerId.compareTo(o2.layerId);
                return c != 0 ? c : o1.effectIndex - o2.effectIndex;
            }
        });
    }

    @Override
    protected IStatus executeOrRedo(IProgressMonitor monitor, IAdaptable info, Project project, ProjectManager pm) throws ExecutionException {
        LayerComposition comp = (LayerComposition)project.getComposition(this._compId);
        List reverseEntries = Util.newList(this._entries);
        Collections.reverse(reverseEntries);
        for (Entry entry : reverseEntries) {
            EffectableLayer layer = (EffectableLayer)comp.getLayer(entry.layerId);
            layer.getEffects().remove(entry.effectIndex);
        }
        if (pm != null) {
            this.fireEffectsAddRemove(false, comp, pm);
        }
        return Status.OK_STATUS;
    }

    @Override
    protected IStatus undo(IProgressMonitor monitor, IAdaptable info, Project project, ProjectManager pm) throws ExecutionException {
        LayerComposition comp = (LayerComposition)project.getComposition(this._compId);
        for (Entry entry : this._entries) {
            Effect effect;
            try {
                effect = (Effect)this._decoder.decodeElement((CharSequence)entry.data, Effect.class);
                effect.afterDecode(project);
            }
            catch (ProjectDecodeException e) {
                throw new JavieRuntimeException((Throwable)e);
            }
            EffectableLayer layer = (EffectableLayer)comp.getLayer(entry.layerId);
            layer.getEffects().add(entry.effectIndex, effect);
        }
        if (pm != null) {
            this.fireEffectsAddRemove(true, comp, pm);
        }
        return Status.OK_STATUS;
    }

    private Object[][] createData(LayerComposition comp) {
        List data = Util.newList();
        for (Entry entry : this._entries) {
            EffectableLayer layer = (EffectableLayer)comp.getLayer(entry.layerId);
            data.add(new Object[]{layer, entry.effectIndex});
        }
        return (Object[][])data.toArray((T[])new Object[data.size()][]);
    }

    private void fireEffectsAddRemove(boolean add, LayerComposition comp, ProjectManager pm) {
        Object[][] data = this.createData(comp);
        if (add) {
            pm.fireEffectsAdd(comp, data);
        } else {
            pm.fireEffectsRemove(comp, data);
        }
    }

    private static class Entry {
        private String data;
        private String layerId;
        private int effectIndex;

        private Entry(String data, String layerId, int effectIndex) {
            this.data = data;
            this.layerId = layerId;
            this.effectIndex = effectIndex;
        }
    }
}

