/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.app.project;

import ch.kuramo.javie.app.project.ProjectManager;
import ch.kuramo.javie.core.JavieRuntimeException;
import ch.kuramo.javie.core.Project;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.AbstractOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.swt.widgets.Shell;

public abstract class ProjectOperation
extends AbstractOperation {
    private final ProjectManager _projectManager;
    protected final String _relation;
    protected boolean _syncShadow;
    protected boolean _noEffect;

    public ProjectOperation(ProjectManager projectManager, String label) {
        this(projectManager, label, null, false);
    }

    public ProjectOperation(ProjectManager projectManager, String label, String relation) {
        this(projectManager, label, relation, false);
    }

    public ProjectOperation(ProjectManager projectManager, String label, boolean syncShadow) {
        this(projectManager, label, null, syncShadow);
    }

    public ProjectOperation(ProjectManager projectManager, String label, String relation, boolean syncShadow) {
        super(label);
        this._projectManager = projectManager;
        this._relation = relation;
        this._syncShadow = syncShadow;
    }

    boolean projectManagerMatches(ProjectManager projectManager) {
        return this._projectManager == projectManager;
    }

    public String getRelation() {
        return this._relation;
    }

    public boolean isSyncShadow() {
        return this._syncShadow;
    }

    public void setSyncShadow(boolean syncShadow) {
        this._syncShadow = syncShadow;
    }

    public boolean isNoEffect() {
        return this._noEffect;
    }

    protected Shell getShell() {
        return this._projectManager.getWorkbenchWindow().getShell();
    }

    public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        return this.redo(monitor, info);
    }

    public IStatus redo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        IStatus status = this.executeOrRedo(monitor, info, this._projectManager.getProject(), this._projectManager);
        if (status.isOK()) {
            this._projectManager.postShadowOperation(this._syncShadow, new Runnable(){

                public void run() {
                    try {
                        IStatus status = ProjectOperation.this.executeOrRedo(null, null, ProjectOperation.this._projectManager.getShadow(), null);
                        if (!status.isOK()) {
                            throw new JavieRuntimeException("error running shadow operation: " + status);
                        }
                    }
                    catch (ExecutionException e) {
                        throw new JavieRuntimeException("error running shadow operation", (Throwable)e);
                    }
                }
            });
        }
        return status;
    }

    public IStatus undo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        IStatus status = this.undo(monitor, info, this._projectManager.getProject(), this._projectManager);
        if (status.isOK()) {
            this._projectManager.postShadowOperation(this._syncShadow, new Runnable(){

                public void run() {
                    try {
                        IStatus status = ProjectOperation.this.undo(null, null, ProjectOperation.this._projectManager.getShadow(), null);
                        if (!status.isOK()) {
                            throw new JavieRuntimeException("error running shadow operation: " + status);
                        }
                    }
                    catch (ExecutionException e) {
                        throw new JavieRuntimeException("error running shadow operation", (Throwable)e);
                    }
                }
            });
        }
        return status;
    }

    protected abstract IStatus executeOrRedo(IProgressMonitor var1, IAdaptable var2, Project var3, ProjectManager var4) throws ExecutionException;

    protected abstract IStatus undo(IProgressMonitor var1, IAdaptable var2, Project var3, ProjectManager var4) throws ExecutionException;

    public boolean tryMerging(ProjectOperation operation, IProgressMonitor monitor, IAdaptable info) {
        if (this._relation == null || !this._relation.equals(operation.getRelation())) {
            return false;
        }
        if (!this.merge(operation, monitor, info, this._projectManager.getProject(), this._projectManager)) {
            return false;
        }
        this._projectManager.postShadowOperation(this._syncShadow, new Runnable(){

            public void run() {
                if (!ProjectOperation.this.merge(null, null, null, ProjectOperation.this._projectManager.getShadow(), null)) {
                    throw new JavieRuntimeException("error running shadow operation: unable to merge");
                }
            }
        });
        return true;
    }

    protected boolean merge(ProjectOperation operation, IProgressMonitor monitor, IAdaptable info, Project project, ProjectManager pm) {
        return false;
    }
}

