/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.app.project;

import ch.kuramo.javie.api.Size2i;
import ch.kuramo.javie.api.Time;
import ch.kuramo.javie.api.VideoBounds;
import ch.kuramo.javie.app.InjectorHolder;
import ch.kuramo.javie.app.project.NewLayerCompositionOperation;
import ch.kuramo.javie.app.project.NewLayerFromItemOperation;
import ch.kuramo.javie.app.project.NewLayersForPrecomposeOperation;
import ch.kuramo.javie.app.project.ProjectManager;
import ch.kuramo.javie.app.project.ProjectOperation;
import ch.kuramo.javie.app.project.ProjectOperationCollection;
import ch.kuramo.javie.app.project.ProjectOperationProxy;
import ch.kuramo.javie.app.project.RemoveLayersOperation;
import ch.kuramo.javie.app.project.ReplaceLayerItemOperation;
import ch.kuramo.javie.core.Composition;
import ch.kuramo.javie.core.CompositionItem;
import ch.kuramo.javie.core.ItemLayer;
import ch.kuramo.javie.core.Layer;
import ch.kuramo.javie.core.LayerComposition;
import ch.kuramo.javie.core.MediaInput;
import ch.kuramo.javie.core.MediaItemLayer;
import ch.kuramo.javie.core.Util;
import ch.kuramo.javie.core.services.ProjectEncoder;
import com.google.inject.Inject;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PrecomposeOperation
extends ProjectOperationCollection {
    @Inject
    private ProjectEncoder encoder;

    public PrecomposeOperation(ProjectManager pm, LayerComposition comp, List<Layer> layers, boolean leaveAttrs, String newCompName) {
        super(pm, "\u30d7\u30ea\u30b3\u30f3\u30dd\u30fc\u30ba");
        InjectorHolder.getInjector().injectMembers((Object)this);
        pm.checkComposition((Composition)comp);
        if (layers.isEmpty()) {
            throw new IllegalArgumentException();
        }
        for (Layer l : layers) {
            if (pm.checkLayer(l) == comp) continue;
            throw new IllegalArgumentException();
        }
        if (newCompName.length() == 0) {
            throw new IllegalArgumentException();
        }
        if (leaveAttrs) {
            if (layers.size() != 1 || !(layers.get(0) instanceof MediaItemLayer)) {
                throw new IllegalArgumentException();
            }
            this.initForLeavingAttributes(pm, comp, (MediaItemLayer)layers.get(0), newCompName);
        } else {
            this.initForMovingAttributes(pm, comp, layers, newCompName);
        }
    }

    private void initForLeavingAttributes(final ProjectManager pm, LayerComposition comp, MediaItemLayer layer, String newCompName) {
        MediaInput input = layer.getMediaInput();
        VideoBounds bounds = input.getVideoFrameBounds();
        Size2i size = bounds != null ? new Size2i(bounds.width, bounds.height) : comp.getSize();
        Time duration = input.getDuration();
        if (duration == null) {
            duration = layer.getOutPoint().subtract(layer.getStartTime());
        }
        final String compId = comp.getId();
        final String layerId = layer.getId();
        final NewLayerCompositionOperation newCompOp = new NewLayerCompositionOperation(pm, null, newCompName, comp.getColorMode(), size, comp.getFrameDuration(), duration, comp.isFrameDurationPreserved(), comp.getMotionBlurShutterAngle(), comp.getMotionBlurShutterPhase(), comp.getMotionBlurSamples());
        ProjectOperationProxy newLayerOp = new ProjectOperationProxy(pm, "NewLayerFromItemOperation", true){

            ProjectOperation createOperation() {
                CompositionItem newCompItem = (CompositionItem)pm.getProject().getItem(newCompOp.getCompositionItemId());
                LayerComposition newComp = (LayerComposition)newCompItem.getComposition();
                LayerComposition comp = (LayerComposition)pm.getProject().getComposition(compId);
                MediaItemLayer layer = (MediaItemLayer)comp.getLayer(layerId);
                return new NewLayerFromItemOperation(pm, newComp, 0, Arrays.asList(layer.getItem()));
            }
        };
        ProjectOperationProxy replaceItemOp = new ProjectOperationProxy(pm, "ReplaceLayerItemOperation", true){

            ProjectOperation createOperation() {
                CompositionItem newCompItem = (CompositionItem)pm.getProject().getItem(newCompOp.getCompositionItemId());
                LayerComposition comp = (LayerComposition)pm.getProject().getComposition(compId);
                MediaItemLayer layer = (MediaItemLayer)comp.getLayer(layerId);
                return new ReplaceLayerItemOperation<CompositionItem>(pm, (ItemLayer<CompositionItem>)layer, newCompItem);
            }
        };
        this.add(newCompOp);
        this.add(newLayerOp);
        this.add(replaceItemOp);
    }

    private void initForMovingAttributes(final ProjectManager pm, LayerComposition comp, List<Layer> layers, String newCompName) {
        final String compId = comp.getId();
        final int newLayerIndex = comp.getLayers().indexOf(layers.get(layers.size() - 1)) + 1 - layers.size();
        List data = Util.newList();
        final Map idMap = Util.newMap();
        for (Layer l : layers) {
            data.add(this.encoder.encodeElement((Object)l));
            idMap.put(l.getId(), Util.randomId());
        }
        final NewLayerCompositionOperation newCompOp = new NewLayerCompositionOperation(pm, null, newCompName, comp.getColorMode(), comp.getSize(), comp.getFrameDuration(), comp.getDuration(), comp.isFrameDurationPreserved(), comp.getMotionBlurShutterAngle(), comp.getMotionBlurShutterPhase(), comp.getMotionBlurSamples());
        NewLayersForPrecomposeOperation newLayersOp = new NewLayersForPrecomposeOperation(pm, newCompOp.getLayerCompositionId(), data, idMap);
        ProjectOperationProxy rmOrigLayersOp = new ProjectOperationProxy(pm, "RemoveLayersOperation", true){

            ProjectOperation createOperation() {
                LayerComposition comp = (LayerComposition)pm.getProject().getComposition(compId);
                List layers = Util.newList();
                for (String id : idMap.keySet()) {
                    layers.add(comp.getLayer(id));
                }
                return new RemoveLayersOperation(pm, layers);
            }
        };
        ProjectOperationProxy newPrecompLayerOp = new ProjectOperationProxy(pm, "NewLayerFromItemOperation", true){

            ProjectOperation createOperation() {
                CompositionItem newCompItem = (CompositionItem)pm.getProject().getItem(newCompOp.getCompositionItemId());
                LayerComposition comp = (LayerComposition)pm.getProject().getComposition(compId);
                return new NewLayerFromItemOperation(pm, comp, newLayerIndex, Arrays.asList(newCompItem));
            }
        };
        this.add(newCompOp);
        this.add(newLayersOp);
        this.add(rmOrigLayersOp);
        this.add(newPrecompLayerOp);
    }
}

