/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.app.project;

import ch.kuramo.javie.app.InjectorHolder;
import ch.kuramo.javie.app.project.ProjectManager;
import ch.kuramo.javie.app.project.ProjectOperation;
import ch.kuramo.javie.core.FileItem;
import ch.kuramo.javie.core.Folder;
import ch.kuramo.javie.core.Item;
import ch.kuramo.javie.core.MediaItem;
import ch.kuramo.javie.core.Project;
import ch.kuramo.javie.core.ProjectDecodeException;
import ch.kuramo.javie.core.Util;
import ch.kuramo.javie.core.services.ProjectDecoder;
import ch.kuramo.javie.core.services.ProjectElementFactory;
import ch.kuramo.javie.core.services.ProjectEncoder;
import com.google.inject.Inject;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NewFileItemsOperation
extends ProjectOperation {
    private final String _parentId;
    private Set<File> _files;
    private Map<String, String> _data;
    @Inject
    private ProjectElementFactory _elementFactory;
    @Inject
    private ProjectEncoder _encoder;
    @Inject
    private ProjectDecoder _decoder;

    public NewFileItemsOperation(ProjectManager projectManager, Folder parent, Collection<File> files) {
        super(projectManager, "\u30d5\u30a1\u30a4\u30eb\u306e\u8aad\u307f\u8fbc\u307f");
        projectManager.checkItem((Item)parent);
        InjectorHolder.getInjector().injectMembers((Object)this);
        this._parentId = parent != null ? parent.getId() : null;
        this._files = Util.newSet(files);
    }

    @Override
    protected IStatus executeOrRedo(IProgressMonitor monitor, IAdaptable info, Project project, ProjectManager pm) throws ExecutionException {
        Set<FileItem> fileItems;
        if (this._data == null) {
            Folder parent = (Folder)project.getItem(this._parentId);
            fileItems = this.newFileItems();
            if (fileItems == null || fileItems.size() == 0) {
                return Status.CANCEL_STATUS;
            }
            this._data = Util.newLinkedHashMap();
            for (FileItem item : fileItems) {
                item.setParent(parent);
                this._data.put(item.getId(), this._encoder.encodeElement((Object)item));
            }
            this._files = null;
        } else {
            fileItems = this.decodeFileItems(project, pm == null);
            if (fileItems == null) {
                return Status.CANCEL_STATUS;
            }
        }
        project.getItems().addAll(fileItems);
        if (pm != null) {
            this.fireItemsAdd(fileItems, project, pm);
        }
        return Status.OK_STATUS;
    }

    @Override
    protected IStatus undo(IProgressMonitor monitor, IAdaptable info, Project project, ProjectManager pm) throws ExecutionException {
        Set fileItems = Util.newSet();
        for (String id : this._data.keySet()) {
            FileItem item = (FileItem)project.getItem(id);
            project.getItems().remove(item);
            fileItems.add(item);
        }
        if (pm != null) {
            this.fireItemsRemove(fileItems, project, pm);
        }
        this.disposeAll(fileItems);
        return Status.OK_STATUS;
    }

    private Set<FileItem> newFileItems() throws ExecutionException {
        final LinkedHashSet fileItems = Util.newLinkedHashSet();
        final Set errorFiles = Util.newSet();
        IRunnableWithProgress runnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                monitor.beginTask("\u30d5\u30a1\u30a4\u30eb\u3092\u8aad\u307f\u8fbc\u307f\u4e2d...", NewFileItemsOperation.this._files.size());
                for (File file : NewFileItemsOperation.this._files) {
                    monitor.subTask(file.getName());
                    FileItem item = NewFileItemsOperation.this._elementFactory.newFileItem(file);
                    if (item != null) {
                        fileItems.add(item);
                    } else {
                        errorFiles.add(file);
                    }
                    if (monitor.isCanceled()) {
                        throw new InterruptedException("canceled");
                    }
                    monitor.worked(1);
                }
                monitor.done();
            }
        };
        try {
            ProgressMonitorDialog dialog = new ProgressMonitorDialog(this.getShell()){

                protected int getShellStyle() {
                    return super.getShellStyle() | 0x10000000;
                }
            };
            dialog.run(true, true, runnable);
        }
        catch (InvocationTargetException e) {
            this.disposeAll(fileItems);
            throw new ExecutionException("error reading files", e.getCause());
        }
        catch (InterruptedException interruptedException) {
            this.disposeAll(fileItems);
            return null;
        }
        if (errorFiles.size() > 0) {
            for (File file : errorFiles) {
                System.err.println("error reading file: " + file.getName());
            }
        }
        return fileItems;
    }

    private Set<FileItem> decodeFileItems(final Project project, boolean shadow) throws ExecutionException {
        final LinkedHashSet fileItems = Util.newLinkedHashSet();
        final Set errorFiles = Util.newSet();
        IRunnableWithProgress runnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                try {
                    monitor.beginTask("\u30d5\u30a1\u30a4\u30eb\u306e\u8aad\u307f\u8fbc\u307f...", NewFileItemsOperation.this._data.size());
                    for (String data : NewFileItemsOperation.this._data.values()) {
                        FileItem item = (FileItem)NewFileItemsOperation.this._decoder.decodeElement((CharSequence)data, FileItem.class);
                        monitor.subTask(item.getFile().getName());
                        fileItems.add(item);
                        item.afterDecode(project);
                        if (item instanceof MediaItem && ((MediaItem)item).getMediaInput() == null) {
                            errorFiles.add(item.getFile());
                        }
                        if (monitor.isCanceled()) {
                            throw new InterruptedException("canceled");
                        }
                        monitor.worked(1);
                    }
                    monitor.done();
                }
                catch (ProjectDecodeException e) {
                    throw new InvocationTargetException(e);
                }
            }
        };
        try {
            if (shadow) {
                runnable.run((IProgressMonitor)new NullProgressMonitor());
            } else {
                ProgressMonitorDialog dialog = new ProgressMonitorDialog(this.getShell()){

                    protected int getShellStyle() {
                        return super.getShellStyle() | 0x10000000;
                    }
                };
                dialog.run(true, true, runnable);
            }
        }
        catch (InvocationTargetException e) {
            this.disposeAll(fileItems);
            throw new ExecutionException("error decoding FileItem data", e.getCause());
        }
        catch (InterruptedException interruptedException) {
            this.disposeAll(fileItems);
            return null;
        }
        if (errorFiles.size() > 0) {
            for (File file : errorFiles) {
                System.err.println("error reading file: " + file.getName());
            }
        }
        return fileItems;
    }

    private void fireItemsAdd(Set<FileItem> fileItems, Project project, ProjectManager pm) {
        if (this._parentId != null) {
            Folder parent = (Folder)project.getItem(this._parentId);
            pm.fireItemsAdd(fileItems, Collections.singleton(parent));
        } else {
            pm.fireItemsAdd(fileItems, null);
        }
    }

    private void fireItemsRemove(Set<FileItem> fileItems, Project project, ProjectManager pm) {
        if (this._parentId != null) {
            Folder parent = (Folder)project.getItem(this._parentId);
            pm.fireItemsRemove(fileItems, Collections.singleton(parent));
        } else {
            pm.fireItemsRemove(fileItems, null);
        }
    }

    private void disposeAll(Collection<FileItem> fileItems) {
        for (FileItem item : fileItems) {
            item.dispose();
        }
    }
}

