/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.app.project;

import ch.kuramo.javie.api.Time;
import ch.kuramo.javie.app.InjectorHolder;
import ch.kuramo.javie.app.PropertyUtil;
import ch.kuramo.javie.app.project.ProjectManager;
import ch.kuramo.javie.app.project.ProjectOperation;
import ch.kuramo.javie.core.Layer;
import ch.kuramo.javie.core.LayerComposition;
import ch.kuramo.javie.core.Project;
import ch.kuramo.javie.core.ProjectDecodeException;
import ch.kuramo.javie.core.Util;
import ch.kuramo.javie.core.services.ProjectDecoder;
import ch.kuramo.javie.core.services.ProjectEncoder;
import com.google.inject.Inject;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DuplicateLayersOperation
extends ProjectOperation {
    private final String _compId;
    private final List<Object[]> _data;
    private final Time _splitTime;
    @Inject
    private ProjectEncoder _encoder;
    @Inject
    private ProjectDecoder _decoder;

    public DuplicateLayersOperation(ProjectManager pm, Collection<Layer> layers, int insertIndex) {
        this(pm, layers, insertIndex, null);
    }

    public DuplicateLayersOperation(ProjectManager pm, Collection<Layer> layers, Time splitTime) {
        this(pm, layers, -1, splitTime);
        this.setLabel("\u30ec\u30a4\u30e4\u30fc\u306e\u5206\u5272");
    }

    public DuplicateLayersOperation(ProjectManager pm, Collection<Layer> layers, int insertIndex, Time splitTime) {
        super(pm, "\u30ec\u30a4\u30e4\u30fc\u306e\u8907\u88fd");
        InjectorHolder.getInjector().injectMembers((Object)this);
        if (layers.size() == 0) {
            this._noEffect = true;
            this._compId = null;
            this._data = null;
            this._splitTime = null;
            return;
        }
        Set layerSet = Util.newSet(layers);
        if (layerSet.size() != layers.size()) {
            throw new IllegalArgumentException("duplicated elements exist in layers argument");
        }
        LayerComposition comp = pm.checkLayer((Layer)layerSet.iterator().next());
        this._compId = comp.getId();
        if (insertIndex < -1 || insertIndex > comp.getLayers().size()) {
            throw new IllegalArgumentException("insertIndex is out of range");
        }
        if (splitTime != null && insertIndex != -1) {
            throw new IllegalArgumentException("insertIndex must be -1 when splitTime is specified");
        }
        this._data = Util.newList();
        this._splitTime = splitTime;
        ListIterator it = comp.getLayers().listIterator();
        while (it.hasNext()) {
            int index = it.nextIndex();
            Layer layer = (Layer)it.next();
            if (!layerSet.remove(layer) || splitTime != null && (!splitTime.after(layer.getInPoint()) || !splitTime.before(layer.getOutPoint()))) continue;
            if (splitTime != null) {
                this._data.add(new Object[]{index + 1, this._encoder.encodeElement((Object)layer), Util.randomId(), layer.getId(), layer.getOutPoint()});
                continue;
            }
            if (insertIndex == -1) {
                this._data.add(new Object[]{index + 1, this._encoder.encodeElement((Object)layer), Util.randomId()});
                continue;
            }
            this._data.add(new Object[]{insertIndex, this._encoder.encodeElement((Object)layer), Util.randomId()});
        }
        if (!layerSet.isEmpty()) {
            throw new IllegalArgumentException("all layers must belong to same composition");
        }
        this._noEffect = this._data.isEmpty();
    }

    @Override
    protected IStatus executeOrRedo(IProgressMonitor monitor, IAdaptable info, Project project, ProjectManager pm) throws ExecutionException {
        LayerComposition comp = (LayerComposition)project.getComposition(this._compId);
        List layers = comp.getLayers();
        List newLayers = Util.newList();
        List origLayers = null;
        if (this._splitTime != null) {
            origLayers = Util.newList();
        }
        try {
            ListIterator<Object[]> it = this._data.listIterator(this._data.size());
            while (it.hasPrevious()) {
                Object[] o = it.previous();
                Integer index = (Integer)o[0];
                String data = (String)o[1];
                String newId = (String)o[2];
                Layer layer = (Layer)this._decoder.decodeElement((CharSequence)data, Layer.class);
                PropertyUtil.setProperty(layer, "id", newId);
                layer.afterDecode(project, comp);
                if (this._splitTime != null) {
                    layer.setInPoint(this._splitTime);
                    origLayers.add(comp.getLayer((String)o[3]));
                }
                layers.add(index, layer);
                newLayers.add(layer);
            }
        }
        catch (ProjectDecodeException e) {
            layers.removeAll(newLayers);
            throw new ExecutionException("error decoding Layer data", (Throwable)e);
        }
        if (this._splitTime != null) {
            for (Layer layer : origLayers) {
                layer.setOutPoint(this._splitTime);
            }
        }
        if (pm != null) {
            if (this._splitTime != null) {
                pm.fireLayerTimesChange(comp, origLayers);
            }
            pm.fireLayersAdd(comp, newLayers);
        }
        return Status.OK_STATUS;
    }

    @Override
    protected IStatus undo(IProgressMonitor monitor, IAdaptable info, Project project, ProjectManager pm) throws ExecutionException {
        LayerComposition comp = (LayerComposition)project.getComposition(this._compId);
        List undoingLayers = Util.newList();
        List origLayers = null;
        if (this._splitTime != null) {
            origLayers = Util.newList();
        }
        for (Object[] o : this._data) {
            int index = (Integer)o[0];
            undoingLayers.add((Layer)comp.getLayers().remove(index));
            if (this._splitTime == null) continue;
            Layer layer = comp.getLayer((String)o[3]);
            layer.setOutPoint((Time)o[4]);
            origLayers.add(layer);
        }
        if (pm != null) {
            if (this._splitTime != null) {
                pm.fireLayerTimesChange(comp, origLayers);
            }
            pm.fireLayersRemove(comp, undoingLayers);
        }
        return Status.OK_STATUS;
    }
}

