/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.app.project;

import ch.kuramo.javie.app.InjectorHolder;
import ch.kuramo.javie.app.project.ProjectManager;
import ch.kuramo.javie.app.project.ProjectOperation;
import ch.kuramo.javie.core.Effect;
import ch.kuramo.javie.core.EffectableLayer;
import ch.kuramo.javie.core.Layer;
import ch.kuramo.javie.core.LayerComposition;
import ch.kuramo.javie.core.Project;
import ch.kuramo.javie.core.ProjectDecodeException;
import ch.kuramo.javie.core.Util;
import ch.kuramo.javie.core.services.ProjectDecoder;
import ch.kuramo.javie.core.services.ProjectEncoder;
import com.google.inject.Inject;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DuplicateEffectsOperation
extends ProjectOperation {
    private final String _compId;
    private final List<Object[]> _srcData;
    private final String _dstLayerId;
    private final int _dstIndex;
    @Inject
    private ProjectEncoder _encoder;
    @Inject
    private ProjectDecoder _decoder;

    public DuplicateEffectsOperation(ProjectManager pm, List<EffectableLayer> srcLayers, List<Effect> effects, EffectableLayer dstLayer, int insertBefore) {
        super(pm, "\u30a8\u30d5\u30a7\u30af\u30c8\u306e\u8907\u88fd");
        InjectorHolder.getInjector().injectMembers((Object)this);
        if (srcLayers.size() != effects.size()) {
            throw new IllegalArgumentException();
        }
        if (srcLayers.isEmpty()) {
            this._noEffect = true;
            this._compId = null;
            this._srcData = null;
            this._dstLayerId = null;
            this._dstIndex = 0;
            return;
        }
        LayerComposition comp = pm.checkLayer((Layer)srcLayers.get(0));
        if (dstLayer != null && pm.checkLayer((Layer)dstLayer) != comp) {
            throw new IllegalArgumentException();
        }
        this._compId = comp.getId();
        this._srcData = Util.newList();
        if (dstLayer != null) {
            this._dstLayerId = dstLayer.getId();
            int dstEffectCount = dstLayer.getEffects().size();
            this._dstIndex = insertBefore < 0 || insertBefore > dstEffectCount ? dstEffectCount : insertBefore;
        } else {
            this._dstLayerId = null;
            this._dstIndex = 0;
        }
        ListIterator<EffectableLayer> it = srcLayers.listIterator();
        while (it.hasNext()) {
            int i = it.nextIndex();
            EffectableLayer srcLayer = it.next();
            Effect effect = effects.get(i);
            int layerIndex = comp.getLayers().indexOf(srcLayer);
            if (layerIndex == -1) {
                throw new IllegalArgumentException();
            }
            int effectIndex = srcLayer.getEffects().indexOf(effect);
            if (effectIndex == -1) {
                throw new IllegalArgumentException();
            }
            this._srcData.add(new Object[]{layerIndex, effectIndex, this._encoder.encodeElement((Object)effect)});
        }
        Collections.sort(this._srcData, new Comparator<Object[]>(){

            @Override
            public int compare(Object[] o1, Object[] o2) {
                int compare = (Integer)o1[0] - (Integer)o2[0];
                return compare != 0 ? compare : (Integer)o2[1] - (Integer)o1[1];
            }
        });
    }

    /*
     * Unable to fully structure code
     */
    @Override
    protected IStatus executeOrRedo(IProgressMonitor monitor, IAdaptable info, Project project, ProjectManager pm) throws ExecutionException {
        block11: {
            comp = (LayerComposition)project.getComposition(this._compId);
            data = null;
            if (pm != null) {
                data = Util.newList();
            }
            newEffects = Util.newSet();
            try {
                if (this._dstLayerId != null) {
                    dstLayer = (EffectableLayer)comp.getLayer(this._dstLayerId);
                    for (Object[] o : this._srcData) {
                        effect = (Effect)this._decoder.decodeElement((CharSequence)((String)o[2]), Effect.class);
                        effect.afterDecode(project);
                        dstLayer.getEffects().add(this._dstIndex, effect);
                        newEffects.add(effect);
                        if (pm == null) continue;
                        data.add(new Object[]{dstLayer, this._dstIndex + data.size()});
                    }
                } else {
                    for (Object[] o : this._srcData) {
                        effect = (Effect)this._decoder.decodeElement((CharSequence)((String)o[2]), Effect.class);
                        effect.afterDecode(project);
                        srcLayer = (EffectableLayer)comp.getLayers().get((Integer)o[0]);
                        srcLayer.getEffects().add((Integer)o[1] + 1, effect);
                        newEffects.add(effect);
                        if (pm == null) continue;
                        data.add(new Object[]{srcLayer, effect});
                    }
                    if (pm != null) {
                        for (Object[] o : data) {
                            o[1] = ((EffectableLayer)o[0]).getEffects().indexOf(o[1]);
                        }
                    }
                }
                break block11;
            }
            catch (ProjectDecodeException e) {
                ** for (layer : comp.getLayers())
            }
lbl-1000:
            // 1 sources

            {
                if (!(layer instanceof EffectableLayer)) continue;
                ((EffectableLayer)layer).getEffects().removeAll(newEffects);
                continue;
            }
lbl42:
            // 1 sources

            throw new ExecutionException("error decoding effect data", (Throwable)e);
        }
        if (pm != null) {
            pm.fireEffectsAdd(comp, (Object[][])data.toArray((T[])new Object[data.size()][]));
        }
        return Status.OK_STATUS;
    }

    @Override
    protected IStatus undo(IProgressMonitor monitor, IAdaptable info, Project project, ProjectManager pm) throws ExecutionException {
        LayerComposition comp = (LayerComposition)project.getComposition(this._compId);
        if (this._dstLayerId != null) {
            EffectableLayer dstLayer = (EffectableLayer)comp.getLayer(this._dstLayerId);
            dstLayer.getEffects().subList(this._dstIndex, this._dstIndex + this._srcData.size()).clear();
            if (pm != null) {
                pm.fireEffectsRemove(comp, new Object[][]{{dstLayer, -1}});
            }
        } else {
            List data = null;
            if (pm != null) {
                data = Util.newList();
            }
            ListIterator<Object[]> it = this._srcData.listIterator(this._srcData.size());
            while (it.hasPrevious()) {
                Object[] o = it.previous();
                EffectableLayer srcLayer = (EffectableLayer)comp.getLayers().get((Integer)o[0]);
                srcLayer.getEffects().remove((Integer)o[1] + 1);
                if (pm == null) continue;
                data.add(new Object[]{srcLayer, -1});
            }
            if (pm != null) {
                pm.fireEffectsRemove(comp, (Object[][])data.toArray((T[])new Object[data.size()][]));
            }
        }
        return Status.OK_STATUS;
    }
}

