/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.app.actions;

import ch.kuramo.javie.app.project.ProjectManager;
import ch.kuramo.javie.app.project.ReverseLayerTimeOperation;
import ch.kuramo.javie.app.views.layercomp.LayerElement;
import ch.kuramo.javie.core.Util;
import java.util.Set;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;

public class ReverseLayerTimeAction
extends Action {
    private final TreeViewer viewer;

    public ReverseLayerTimeAction(TreeViewer viewer) {
        super("\u6642\u9593\u53cd\u8ee2");
        this.viewer = viewer;
        this.setEnabled(false);
        viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                boolean enabled = false;
                TreeSelection selection = (TreeSelection)event.getSelection();
                if (!selection.isEmpty()) {
                    enabled = true;
                    for (Object element : selection.toList()) {
                        if (element instanceof LayerElement) continue;
                        enabled = false;
                        break;
                    }
                }
                ReverseLayerTimeAction.this.setEnabled(enabled);
            }
        });
    }

    public void run() {
        Set layers = Util.newSet();
        TreeSelection selection = (TreeSelection)this.viewer.getSelection();
        for (Object element : selection.toList()) {
            if (!(element instanceof LayerElement)) {
                return;
            }
            layers.add(((LayerElement)element).layer);
        }
        if (layers.isEmpty()) {
            return;
        }
        ProjectManager pm = (ProjectManager)this.viewer.getData("PROJECT_MANAGER");
        pm.postOperation(new ReverseLayerTimeOperation(pm, layers));
    }
}

