/*
 * Decompiled with CFR 0.152.
 */
package org.dyndns.nuda.tools.util;

import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StringUtil {
    private static final String FORMAT_P03D = "%03d";
    private static final String CRLF = "";
    private static final String TAB = "\t";
    private static final String ptnStr = "\\{\\}";
    private static final Pattern PTN = Pattern.compile("\\{\\}", 40);
    private static final String NOT_REPLACE_HOLDER = "<StringUtil.NOT_REPLACE>";
    private static final String ptnStr2 = "<StringUtil\\.NOT_REPLACE>";
    private static final Pattern PTN2 = Pattern.compile("<StringUtil\\.NOT_REPLACE>", 40);
    private static final String ptnStr3 = "\\{([^\\{|^\\}]+?)\\}";
    private static final Pattern PTN3 = Pattern.compile("\\{([^\\{|^\\}]+?)\\}", 40);
    private static final String BLACKET_LEFT_REPLACE = "<<<org.dyndns.nuda.repserv.util.StringUtil.BLACKET_LEFT>>>";
    private static final String BLACKET_RIGHT_REPLACE = "<<<org.dyndns.nuda.repserv.util.StringUtil.BLACKET_RIGHT>>>";
    private static final String BLACKET_LEFT = "{";
    private static final String BLACKET_RIGHT = "}";
    private static final String BLACKET = "{}";
    private static final String REPLACEMENT_HOLDER = "<<<org.dyndns.nuda.repserv.util.StringUtil.REPLACEMENT_HOLDER>>>";
    private static final String REPLACEMENT_HOLDER_PTN = "<<<org\\.dyndns\\.nuda\\.repserv\\.util\\.StringUtil\\.REPLACEMENT_HOLDER>>>";
    private static final String DC = "\"";
    private static final String splitCSVRowPTNSTR = "((?!\")((\\p{InCJKUnifiedIdeographs}|\\p{InHiragana}|\\p{InKatakana}|\\p{InHalfwidthAndFullwidthForms}|[a-zA-Z0-9])+)(?!\"))|((?:\")([,\\w\\s\\W]+?)(?:\"))".replace("@", "\"");
    private static final String splitCSVRowPTNSTR2 = "@(.+?)@".replace("@", "\"");
    private static final Pattern splitCSVRowPTN = Pattern.compile(splitCSVRowPTNSTR, 40);
    private static final Pattern splitCSVRowPTN2 = Pattern.compile(splitCSVRowPTNSTR2, 40);

    private StringUtil() {
    }

    public static String deIndent(String content) {
        String content0 = content;
        String patternStr0 = "\\t+";
        Pattern p0 = Pattern.compile(patternStr0, 40);
        Matcher m0 = p0.matcher(content);
        String replacement = CRLF;
        if (m0.find()) {
            replacement = m0.group();
            content0 = m0.replaceFirst(CRLF);
        }
        Pattern p = Pattern.compile("^" + replacement, 40);
        Matcher m = p.matcher(content0);
        String replaceItem = CRLF;
        while (m.find()) {
            replaceItem = m.replaceFirst(REPLACEMENT_HOLDER);
            m.reset(replaceItem);
        }
        replaceItem = replaceItem.replace(REPLACEMENT_HOLDER, CRLF);
        return replaceItem;
    }

    public static String indent(String content, int tabCount) {
        String content0 = content;
        Pattern p = Pattern.compile("^((?!<REPLACEMENT>).+?)$", 40);
        Matcher m = p.matcher(content0);
        String replaceItem = CRLF;
        while (m.find()) {
            replaceItem = m.replaceFirst("<REPLACEMENT>" + m.group(1));
            m.reset(replaceItem);
        }
        StringBuilder tab = new StringBuilder();
        int i = 0;
        while (i < tabCount) {
            tab.append(TAB);
            ++i;
        }
        replaceItem = replaceItem.replace("<REPLACEMENT>", tab.toString());
        return replaceItem;
    }

    public static String indentWithNum(String content, int tabCount) {
        String content0 = content;
        Pattern p = Pattern.compile("^((?!<REPLACEMENT>|\\d|\\:).+?)$", 40);
        Matcher m = p.matcher(content0);
        String replaceItem = CRLF;
        int lineNum = 1;
        while (m.find()) {
            String lineNumStr = String.format(FORMAT_P03D, lineNum);
            replaceItem = m.replaceFirst(String.valueOf(lineNumStr) + " :<REPLACEMENT>" + m.group(1));
            m.reset(replaceItem);
            ++lineNum;
        }
        StringBuilder tab = new StringBuilder();
        int i = 0;
        while (i < tabCount) {
            tab.append(TAB);
            ++i;
        }
        replaceItem = replaceItem.replace("<REPLACEMENT>", tab.toString());
        return replaceItem;
    }

    public static String format(String format, Object ... params) {
        String result = CRLF;
        if (format == null) {
            return null;
        }
        if (params == null || params.length == 0) {
            result = format;
        } else {
            Matcher m = PTN.matcher(format);
            int i = 0;
            while (m.find()) {
                if (i < params.length) {
                    String replaceResult;
                    if (params[i] != null) {
                        replaceResult = m.replaceFirst(params[i].toString());
                        m.reset(replaceResult);
                        result = replaceResult;
                    } else {
                        replaceResult = m.replaceFirst(NOT_REPLACE_HOLDER);
                        m.reset(replaceResult);
                        result = replaceResult;
                    }
                }
                ++i;
            }
            Matcher m2 = PTN2.matcher(result);
            while (m2.find()) {
                String r = m2.replaceFirst(BLACKET);
                m2.reset(r);
                result = r;
            }
        }
        return result;
    }

    public static String format(String format, Map<String, Object> map) {
        String result = CRLF;
        if (format == null) {
            return null;
        }
        if (map == null || map.size() == 0) {
            result = format;
        } else {
            Matcher m = PTN3.matcher(format);
            int i = 0;
            while (m.find()) {
                String replaceResult;
                String g = m.group(1);
                Object val = map.get(g);
                if (map.containsKey(g)) {
                    replaceResult = m.replaceFirst(val.toString());
                    m.reset(replaceResult);
                    result = replaceResult;
                } else if (g.isEmpty()) {
                    replaceResult = m.replaceFirst(NOT_REPLACE_HOLDER);
                    m.reset(replaceResult);
                    result = replaceResult;
                } else {
                    String group = m.group();
                    group = group.replace(BLACKET_LEFT, BLACKET_LEFT_REPLACE).replace(BLACKET_RIGHT, BLACKET_RIGHT_REPLACE);
                    String replaceResult2 = m.replaceFirst(group);
                    m.reset(replaceResult2);
                    result = replaceResult2;
                }
                ++i;
            }
            Matcher m2 = PTN2.matcher(result);
            while (m2.find()) {
                String r = m2.replaceFirst(BLACKET);
                m2.reset(r);
                result = r;
            }
            result = result.replace(BLACKET_LEFT_REPLACE, BLACKET_LEFT).replace(BLACKET_RIGHT_REPLACE, BLACKET_RIGHT);
        }
        return result;
    }

    public static List<String> splitCSVRow(String csvRow) {
        LinkedList<String> result = new LinkedList<String>();
        Matcher m = splitCSVRowPTN.matcher(csvRow);
        while (m.find()) {
            String r = m.group();
            Matcher m2 = splitCSVRowPTN2.matcher(r);
            if (m2.find()) {
                result.add(m2.group(1));
                continue;
            }
            result.add(r.trim());
        }
        return result;
    }
}

