/*
 * Decompiled with CFR 0.152.
 */
package org.idempiere.hazelcast.service;

import com.hazelcast.config.Config;
import com.hazelcast.config.FileSystemXmlConfig;
import com.hazelcast.core.Hazelcast;
import com.hazelcast.core.HazelcastInstance;
import java.io.File;
import java.io.FileNotFoundException;
import java.net.URL;
import java.text.DateFormat;
import java.util.Date;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import org.compiere.Adempiere;
import org.compiere.model.ServerStateChangeEvent;
import org.compiere.model.ServerStateChangeListener;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;

public class Activator
implements BundleActivator {
    private static BundleContext context;
    private static volatile HazelcastInstance hazelcastInstance;
    private static Future<?> future;

    static BundleContext getContext() {
        return context;
    }

    public void start(BundleContext bundleContext) throws Exception {
        context = bundleContext;
        if (Adempiere.isStarted()) {
            Activator.createHazelCastInstance();
        } else {
            Adempiere.addServerStateChangeListener((ServerStateChangeListener)new ServerStateChangeListener(){

                public void stateChange(ServerStateChangeEvent event) {
                    if (event.getEventType() == 0) {
                        Activator.createHazelCastInstance();
                    }
                }
            });
        }
    }

    private static synchronized void createHazelCastInstance() {
        ScheduledThreadPoolExecutor executor = Adempiere.getThreadPoolExecutor();
        future = executor.submit(new Runnable(){

            @Override
            public void run() {
                File file = null;
                String dataArea = System.getProperty("IDEMPIERE_HOME");
                if (dataArea != null && dataArea.trim().length() > 0) {
                    try {
                        file = new File(dataArea, "hazelcast.xml");
                        if (!file.exists()) {
                            file = null;
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (file == null && (dataArea = System.getProperty("user.dir")) != null && dataArea.trim().length() > 0) {
                    try {
                        file = new File(dataArea, "hazelcast.xml");
                        if (!file.exists()) {
                            file = null;
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (file == null && (dataArea = System.getProperty("osgi.install.area")) != null && dataArea.trim().length() > 0) {
                    try {
                        URL url = new URL(dataArea);
                        file = new File(url.getPath(), "hazelcast.xml");
                        if (!file.exists()) {
                            file = null;
                        }
                    }
                    catch (Exception url) {
                        // empty catch block
                    }
                }
                if (file != null && file.exists()) {
                    try {
                        FileSystemXmlConfig config = new FileSystemXmlConfig(file);
                        Activator.hazelcastInstance = Hazelcast.newHazelcastInstance((Config)config);
                        return;
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        // empty catch block
                    }
                }
                Activator.hazelcastInstance = Hazelcast.newHazelcastInstance(null);
            }
        });
    }

    public static synchronized HazelcastInstance getHazelcastInstance() {
        if (future != null && !future.isDone()) {
            try {
                future.get();
            }
            catch (InterruptedException interruptedException) {
            }
            catch (ExecutionException executionException) {
                // empty catch block
            }
        }
        if (hazelcastInstance != null && !hazelcastInstance.getLifecycleService().isRunning()) {
            System.err.println(String.valueOf(DateFormat.getDateTimeInstance().format(new Date())) + " Hazelcast instance is down!");
            try {
                hazelcastInstance = Hazelcast.newHazelcastInstance(null);
                if (!hazelcastInstance.getLifecycleService().isRunning()) {
                    hazelcastInstance = null;
                    System.err.println(String.valueOf(DateFormat.getDateTimeInstance().format(new Date())) + " Failed to re-create Hazelcast instance!");
                } else {
                    System.err.println(String.valueOf(DateFormat.getDateTimeInstance().format(new Date())) + " Hazelcast instance re-created!");
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
                hazelcastInstance = null;
                System.err.println(String.valueOf(DateFormat.getDateTimeInstance().format(new Date())) + " Failed to re-create Hazelcast instance!");
            }
        }
        return hazelcastInstance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(BundleContext bundleContext) throws Exception {
        context = null;
        Class<Activator> clazz = Activator.class;
        synchronized (Activator.class) {
            if (future != null && !future.isDone()) {
                future.cancel(true);
            } else if (hazelcastInstance != null) {
                hazelcastInstance.getLifecycleService().shutdown();
                hazelcastInstance = null;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }
}

