/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.swing;

import java.awt.Color;
import java.awt.SystemColor;
import java.util.HashMap;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.FontUIResource;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.metal.MetalTheme;
import org.compiere.plaf.CompiereColor;
import org.compiere.swing.ExtendedTheme;

public final class ThemeUtils {
    private static Logger log = Logger.getLogger(ThemeUtils.class.getName());
    public static final String P_Primary1 = "#ColorPrimary1";
    public static final String P_Primary2 = "#ColorPrimary2";
    public static final String P_Primary3 = "#ColorPrimary3";
    public static final String P_Secondary1 = "#ColorSecondary1";
    public static final String P_Secondary2 = "#ColorSecondary2";
    public static final String P_Secondary3 = "#ColorSecondary3";
    public static final String P_Black = "#ColorBlack";
    public static final String P_White = "#ColorWhite";
    public static final String P_Error = "#ColorError";
    public static final String P_Info = "#ColorInfo";
    public static final String P_Mandatory = "#ColorMandatory";
    public static final String P_Inactive = "#ColorInactive";
    public static final String P_Txt_OK = "#ColorTextOK";
    public static final String P_Txt_Error = "#ColorTextError";
    public static final String P_Control = "#FontControl";
    public static final String P_System = "#FontSystem";
    public static final String P_User = "#FontUser";
    public static final String P_Small = "#FontSmall";
    public static final String P_Window = "#FontWindow";
    public static final String P_Menu = "#FontMenu";

    public static String getColorAsString(Color c) {
        if (c == null) {
            c = SystemColor.control;
        }
        StringBuffer sb = new StringBuffer("[r=").append(c.getRed()).append(",g=").append(c.getGreen()).append(",b=").append(c.getBlue()).append(",a=").append(c.getAlpha()).append("]");
        return sb.toString();
    }

    public static ColorUIResource parseColor(String information, ColorUIResource stdColor) {
        if (information == null || information.length() == 0 || information.trim().length() == 0) {
            return stdColor;
        }
        try {
            int r = Integer.parseInt(information.substring(information.indexOf("r=") + 2, information.indexOf(",g=")));
            int g = Integer.parseInt(information.substring(information.indexOf("g=") + 2, information.indexOf(",b=")));
            int b = 0;
            int a = 255;
            if (information.indexOf("a=") == -1) {
                b = Integer.parseInt(information.substring(information.indexOf("b=") + 2, information.indexOf(93)));
            } else {
                b = Integer.parseInt(information.substring(information.indexOf("b=") + 2, information.indexOf(",a=")));
                a = Integer.parseInt(information.substring(information.indexOf("a=") + 2, information.indexOf(93)));
            }
            ColorUIResource retValue = new ColorUIResource(new Color(r, g, b, a));
            return retValue;
        }
        catch (Exception e) {
            if (log.isLoggable(Level.CONFIG)) {
                log.config(String.valueOf(information) + " - cannot parse: " + e.toString());
            }
            return stdColor;
        }
    }

    public static FontUIResource parseFont(String information, FontUIResource stdFont) {
        if (information == null || information.length() == 0 || information.trim().length() == 0) {
            return stdFont;
        }
        try {
            String name = information.substring(information.indexOf("name=") + 5, information.indexOf(",style="));
            String s = information.substring(information.indexOf("style=") + 6, information.indexOf(",size="));
            int style = 0;
            if (s.equals("bold")) {
                style = 1;
            } else if (s.equals("italic")) {
                style = 2;
            } else if (s.equals("bolditalic")) {
                style = 3;
            }
            int size = Integer.parseInt(information.substring(information.indexOf(",size=") + 6, information.lastIndexOf(93)));
            FontUIResource retValue = new FontUIResource(name, style, size);
            return retValue;
        }
        catch (Exception e) {
            if (log.isLoggable(Level.CONFIG)) {
                log.config(String.valueOf(information) + " - cannot parse: " + e.toString());
            }
            return stdFont;
        }
    }

    public static void save(Properties properties, MetalTheme theme) {
        if (log.isLoggable(Level.CONFIG)) {
            log.config(CompiereColor.getDefaultBackground().toString());
        }
        properties.setProperty(P_Primary1, ThemeUtils.getColorAsString(theme.getPrimaryControlDarkShadow()));
        properties.setProperty(P_Primary2, ThemeUtils.getColorAsString(theme.getPrimaryControlShadow()));
        properties.setProperty(P_Primary3, ThemeUtils.getColorAsString(theme.getPrimaryControl()));
        properties.setProperty(P_Secondary1, ThemeUtils.getColorAsString(theme.getControlDarkShadow()));
        properties.setProperty(P_Secondary2, ThemeUtils.getColorAsString(theme.getControlShadow()));
        properties.setProperty(P_Secondary3, ThemeUtils.getColorAsString(theme.getControl()));
        properties.setProperty(P_Txt_OK, ThemeUtils.getColorAsString(theme.getUserTextColor()));
        if (theme instanceof ExtendedTheme) {
            ExtendedTheme e = (ExtendedTheme)((Object)theme);
            properties.setProperty(P_Error, ThemeUtils.getColorAsString(e.getErrorBackground()));
            properties.setProperty(P_Txt_Error, ThemeUtils.getColorAsString(e.getErrorForeground()));
            properties.setProperty(P_Mandatory, ThemeUtils.getColorAsString(e.getMandatoryBackground()));
            properties.setProperty(P_Inactive, ThemeUtils.getColorAsString(e.getInactiveBackground()));
            properties.setProperty(P_White, ThemeUtils.getColorAsString(e.getWhite()));
            properties.setProperty(P_Black, ThemeUtils.getColorAsString(e.getBlack()));
            properties.setProperty(P_Info, ThemeUtils.getColorAsString(e.getInfoBackground()));
        } else {
            properties.setProperty(P_White, ThemeUtils.getColorAsString(Color.white));
            properties.setProperty(P_Black, ThemeUtils.getColorAsString(Color.black));
            properties.setProperty(P_Error, ThemeUtils.getColorAsString(ExtendedTheme.DEFAULT_ERROR_BG));
            properties.setProperty(P_Txt_Error, ThemeUtils.getColorAsString(ExtendedTheme.DEFAULT_ERROR_FG));
            properties.setProperty(P_Mandatory, ThemeUtils.getColorAsString(ExtendedTheme.DEFAULT_MANDATORY_BG));
            properties.setProperty(P_Inactive, ThemeUtils.getColorAsString(ExtendedTheme.DEFAULT_INACTIVE_BG));
            properties.setProperty(P_Info, ThemeUtils.getColorAsString(theme.getPrimaryControl()));
        }
        properties.setProperty(P_Control, theme.getControlTextFont().toString());
        properties.setProperty(P_System, theme.getSystemTextFont().toString());
        properties.setProperty(P_User, theme.getUserTextFont().toString());
        properties.setProperty(P_Small, theme.getSubTextFont().toString());
        properties.setProperty(P_Window, theme.getWindowTitleFont().toString());
        properties.setProperty(P_Menu, theme.getMenuTextFont().toString());
    }

    public static void load(Properties properties, ExtendedTheme theme) {
        HashMap<String, UIResource> p2 = new HashMap<String, UIResource>();
        p2.put(P_Primary1, ThemeUtils.parseColor(properties.getProperty(P_Primary1), null));
        p2.put(P_Primary2, ThemeUtils.parseColor(properties.getProperty(P_Primary2), null));
        p2.put(P_Primary3, ThemeUtils.parseColor(properties.getProperty(P_Primary3), null));
        p2.put(P_Secondary1, ThemeUtils.parseColor(properties.getProperty(P_Secondary1), null));
        p2.put(P_Secondary2, ThemeUtils.parseColor(properties.getProperty(P_Secondary2), null));
        p2.put(P_Secondary3, ThemeUtils.parseColor(properties.getProperty(P_Secondary3), null));
        p2.put(P_Error, ThemeUtils.parseColor(properties.getProperty(P_Error), null));
        p2.put(P_Info, ThemeUtils.parseColor(properties.getProperty(P_Info), null));
        p2.put(P_Mandatory, ThemeUtils.parseColor(properties.getProperty(P_Mandatory), null));
        p2.put(P_Inactive, ThemeUtils.parseColor(properties.getProperty(P_Inactive), null));
        p2.put(P_White, ThemeUtils.parseColor(properties.getProperty(P_White), null));
        p2.put(P_Black, ThemeUtils.parseColor(properties.getProperty(P_Black), null));
        p2.put(P_Txt_OK, ThemeUtils.parseColor(properties.getProperty(P_Txt_OK), null));
        p2.put(P_Txt_Error, ThemeUtils.parseColor(properties.getProperty(P_Txt_Error), null));
        p2.put(P_Control, ThemeUtils.parseFont(properties.getProperty(P_Control), null));
        p2.put(P_System, ThemeUtils.parseFont(properties.getProperty(P_System), null));
        p2.put(P_User, ThemeUtils.parseFont(properties.getProperty(P_User), null));
        p2.put(P_Small, ThemeUtils.parseFont(properties.getProperty(P_Small), null));
        p2.put(P_Window, ThemeUtils.parseFont(properties.getProperty(P_Window), null));
        p2.put(P_Menu, ThemeUtils.parseFont(properties.getProperty(P_Menu), null));
        theme.setUIProperties(p2);
    }
}

