/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.report.core;

import java.awt.Component;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.logging.Level;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import org.compiere.report.core.RColumn;
import org.compiere.report.core.RModel;
import org.compiere.report.core.ResultTableCellEditor;
import org.compiere.report.core.ResultTableCellRenderer;
import org.compiere.report.core.ResultTableModel;
import org.compiere.util.CLogger;
import org.compiere.util.MSort;

public class ResultTable
extends JTable
implements MouseListener {
    private static final long serialVersionUID = -2633317327407673345L;
    private int m_lastSortIndex = -1;
    private boolean m_asc = true;
    private RModel m_model = null;
    private static CLogger log = CLogger.getCLogger(ResultTable.class);

    public ResultTable() {
        this.setCellSelectionEnabled(false);
        this.setColumnSelectionAllowed(false);
        this.setRowSelectionAllowed(false);
        this.setSelectionMode(0);
        this.setAutoResizeMode(0);
        ResultTableCellEditor rtce = new ResultTableCellEditor();
        this.setCellEditor(rtce);
        this.addMouseListener(this);
        this.getTableHeader().addMouseListener(this);
    }

    public ResultTable(RModel reportModel) {
        this();
        this.setModel(reportModel);
    }

    public void setModel(RModel reportModel) {
        if (log.isLoggable(Level.CONFIG)) {
            log.config(reportModel.toString());
        }
        this.m_model = reportModel;
        super.setModel((TableModel)new ResultTableModel(reportModel));
        TableColumnModel tcm = this.getColumnModel();
        int i = 0;
        while (i < tcm.getColumnCount()) {
            TableColumn tc = tcm.getColumn(i);
            RColumn rc = reportModel.getRColumn(i);
            if (rc.getColHeader().equals(tc.getHeaderValue())) {
                ResultTableCellRenderer rtcr = new ResultTableCellRenderer(reportModel, rc);
                tc.setCellRenderer(rtcr);
            } else {
                log.log(Level.SEVERE, "RColumn=" + rc.getColHeader() + " <> TableColumn=" + tc.getHeaderValue());
            }
            ++i;
        }
        this.autoSize();
    }

    public RModel getRModel() {
        return this.m_model;
    }

    @Override
    public void setModel(TableModel ignored) {
        super.setModel(ignored);
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        super.tableChanged(e);
        if (log.isLoggable(Level.FINE)) {
            log.fine("Type=" + e.getType());
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        int col = this.getColumnModel().getColumnIndexAtX(e.getX());
        if (log.isLoggable(Level.FINE)) {
            log.fine("Column " + col + " = " + this.getColumnModel().getColumn(col).getHeaderValue() + ", Table r=" + this.getSelectedRow() + " c=" + this.getSelectedColumn());
        }
        if (e.getSource() != this) {
            int mc = this.convertColumnIndexToModel(col);
            this.sort(mc);
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    private void autoSize() {
        log.config("");
        int SLACK = 8;
        int MAXSIZE = 300;
        TableColumnModel tcm = this.getColumnModel();
        int col = 0;
        while (col < tcm.getColumnCount()) {
            TableColumn tc = tcm.getColumn(col);
            int width = 0;
            TableCellRenderer renderer = tc.getHeaderRenderer();
            if (renderer == null) {
                renderer = new DefaultTableCellRenderer();
            }
            Component comp = renderer.getTableCellRendererComponent(this, tc.getHeaderValue(), false, false, 0, 0);
            width = comp.getPreferredSize().width + 8;
            int maxRow = Math.min(30, this.getRowCount());
            int row = 0;
            while (row < maxRow) {
                renderer = this.getCellRenderer(row, col);
                comp = renderer.getTableCellRendererComponent(this, this.getValueAt(row, col), false, false, row, col);
                int rowWidth = comp.getPreferredSize().width + 8;
                width = Math.max(width, rowWidth);
                ++row;
            }
            width = Math.min(300, width);
            tc.setPreferredWidth(width);
            ++col;
        }
    }

    private void sort(final int modelColumnIndex) {
        int rows = this.getRowCount();
        if (rows == 0) {
            return;
        }
        this.m_asc = modelColumnIndex != this.m_lastSortIndex ? true : !this.m_asc;
        this.m_lastSortIndex = modelColumnIndex;
        if (log.isLoggable(Level.CONFIG)) {
            log.config("#" + modelColumnIndex + " - rows=" + rows + ", asc=" + this.m_asc);
        }
        ResultTableModel model = (ResultTableModel)this.getModel();
        final MSort sort = new MSort(0, null);
        sort.setSortAsc(this.m_asc);
        Collections.sort(model.getDataList(), new Comparator<Object>(){

            @Override
            public int compare(Object o1, Object o2) {
                Object item1 = ((ArrayList)o1).get(modelColumnIndex);
                Object item2 = ((ArrayList)o2).get(modelColumnIndex);
                return sort.compare(item1, item2);
            }
        });
    }
}

