/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.grid.ed;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Properties;
import java.util.logging.Level;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import org.adempiere.plaf.AdempierePLAF;
import org.compiere.apps.AEnv;
import org.compiere.apps.FieldRecordInfo;
import org.compiere.grid.ed.VAccountDialog;
import org.compiere.grid.ed.VEditor;
import org.compiere.model.GridField;
import org.compiere.model.MAccountLookup;
import org.compiere.model.MRole;
import org.compiere.swing.CButton;
import org.compiere.swing.CTextField;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;

public final class VAccount
extends JComponent
implements VEditor,
ActionListener,
FocusListener {
    private static final long serialVersionUID = 8918710495283801426L;
    private CTextField m_text = new CTextField(15);
    private CButton m_button = new CButton();
    private MAccountLookup m_mAccount;
    private Object m_value;
    private String m_title;
    private int m_WindowNo;
    private String m_columnName;
    JPopupMenu popupMenu = new JPopupMenu();
    private static CLogger log = CLogger.getCLogger(VAccount.class);
    private boolean m_cmdTextRunning = false;
    private GridField m_mField;

    public VAccount(String columnName, boolean mandatory, boolean isReadOnly, boolean isUpdateable, MAccountLookup mAccount, String title) {
        super.setName(columnName);
        this.m_columnName = columnName;
        this.m_mAccount = mAccount;
        this.m_title = title;
        LookAndFeel.installBorder(this, "TextField.border");
        this.setLayout(new BorderLayout());
        this.setPreferredSize(this.m_text.getPreferredSize());
        int height = this.m_text.getPreferredSize().height;
        this.m_text.setBorder(null);
        this.m_text.addActionListener(this);
        this.m_text.addFocusListener(this);
        this.m_text.setFont(AdempierePLAF.getFont_Field());
        this.m_text.setForeground(AdempierePLAF.getTextColor_Normal());
        this.m_text.addMouseListener(new VAccount_mouseAdapter(this));
        this.add((Component)this.m_text, "Center");
        this.m_button.setIcon(Env.getImageIcon((String)"Account10.gif"));
        this.m_button.setMargin(new Insets(0, 0, 0, 0));
        this.m_button.setPreferredSize(new Dimension(height, height));
        this.m_button.addActionListener(this);
        this.m_button.setFocusable(false);
        this.add((Component)this.m_button, "East");
        if (isReadOnly || !isUpdateable) {
            this.setReadWrite(false);
        } else {
            this.setReadWrite(true);
        }
        this.setMandatory(mandatory);
    }

    @Override
    public void dispose() {
        this.m_text = null;
        this.m_button = null;
        this.m_mAccount = null;
    }

    @Override
    public void setReadWrite(boolean value) {
        this.m_button.setReadWrite(value);
        this.m_text.setReadWrite(value);
        if (this.m_button.isVisible() != value) {
            this.m_button.setVisible(value);
        }
        this.setBackground(false);
    }

    @Override
    public boolean isReadWrite() {
        return this.m_button.isReadWrite();
    }

    @Override
    public void setMandatory(boolean mandatory) {
        this.m_button.setMandatory(mandatory);
        this.setBackground(false);
    }

    @Override
    public boolean isMandatory() {
        return this.m_button.isMandatory();
    }

    @Override
    public void setBackground(Color color) {
        this.m_text.setBackground(color);
    }

    @Override
    public void setBackground(boolean error) {
        if (error) {
            this.setBackground(AdempierePLAF.getFieldBackground_Error());
        } else if (!this.isReadWrite()) {
            this.setBackground(AdempierePLAF.getFieldBackground_Inactive());
        } else if (this.isMandatory()) {
            this.setBackground(AdempierePLAF.getFieldBackground_Mandatory());
        } else {
            this.setBackground(AdempierePLAF.getFieldBackground_Normal());
        }
    }

    @Override
    public void setForeground(Color fg) {
        this.m_text.setForeground(fg);
    }

    @Override
    public void setValue(Object value) {
        this.m_value = value;
        this.m_text.setText(this.m_mAccount.getDisplay(value));
        this.m_text.setToolTipText(this.m_mAccount.getDescription());
    }

    @Override
    public void requestFocus() {
        this.m_text.requestFocus();
    }

    @Override
    public boolean requestFocusInWindow() {
        return this.m_text.requestFocusInWindow();
    }

    @Override
    public Component getFocusableComponent() {
        return this.m_text;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("FieldValue")) {
            this.setValue(evt.getNewValue());
        }
    }

    @Override
    public Object getValue() {
        return new Integer(this.m_mAccount.C_ValidCombination_ID);
    }

    @Override
    public String getDisplay() {
        return this.m_text.getText();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals("ChangeLog")) {
            FieldRecordInfo.start(this.m_mField);
            return;
        }
        if (e.getSource() == this.m_text) {
            this.cmd_text();
        } else {
            this.cmd_button();
        }
    }

    public void cmd_button() {
        this.setCursor(Cursor.getPredefinedCursor(3));
        int C_AcctSchema_ID = Env.getContextAsInt((Properties)Env.getCtx(), (int)this.m_WindowNo, (String)"C_AcctSchema_ID", (boolean)false);
        if (C_AcctSchema_ID <= 0) {
            C_AcctSchema_ID = Env.getContextAsInt((Properties)Env.getCtx(), (String)"$C_AcctSchema_ID");
        }
        VAccountDialog ad = new VAccountDialog((Frame)AEnv.getFrame(this), this.m_title, this.m_mAccount, C_AcctSchema_ID);
        this.setCursor(Cursor.getDefaultCursor());
        Integer newValue = ad.getValue();
        this.setValue(newValue);
        try {
            this.fireVetoableChange(this.m_columnName, null, newValue);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
    }

    public void cmd_text() {
        int C_ValidCombination_ID;
        block15: {
            if (this.m_cmdTextRunning) {
                return;
            }
            this.m_cmdTextRunning = true;
            String text = this.m_text.getText();
            if (log.isLoggable(Level.INFO)) {
                log.info("Text=" + text);
            }
            if (text == null || text.length() == 0 || text.equals("%")) {
                this.cmd_button();
                this.m_cmdTextRunning = false;
                return;
            }
            if (!text.endsWith("%")) {
                text = String.valueOf(text) + "%";
            }
            String sql = "SELECT C_ValidCombination_ID FROM C_ValidCombination WHERE C_AcctSchema_ID=? AND (UPPER(Alias) LIKE ? OR UPPER(Combination) LIKE ?)";
            sql = MRole.getDefault().addAccessSQL(sql, "C_ValidCombination", false, false);
            int C_AcctSchema_ID = Env.getContextAsInt((Properties)Env.getCtx(), (int)this.m_WindowNo, (String)"C_AcctSchema_ID");
            C_ValidCombination_ID = 0;
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement((String)sql, null);
                    pstmt.setInt(1, C_AcctSchema_ID);
                    pstmt.setString(2, text.toUpperCase());
                    pstmt.setString(3, text.toUpperCase());
                    rs = pstmt.executeQuery();
                    if (rs.next()) {
                        C_ValidCombination_ID = rs.getInt(1);
                        if (rs.next()) {
                            C_ValidCombination_ID = 0;
                        }
                    }
                }
                catch (Exception e) {
                    log.log(Level.SEVERE, sql, (Throwable)e);
                    DB.close(rs, (Statement)pstmt);
                    rs = null;
                    pstmt = null;
                    break block15;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, (Statement)pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close((ResultSet)rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
        }
        if (C_ValidCombination_ID > 0) {
            Integer newValue = new Integer(C_ValidCombination_ID);
            this.setValue(newValue);
            try {
                this.fireVetoableChange(this.m_columnName, null, newValue);
            }
            catch (PropertyVetoException propertyVetoException) {}
        } else {
            this.cmd_button();
        }
        this.m_cmdTextRunning = false;
    }

    @Override
    public void addActionListener(ActionListener listener) {
        this.m_text.addActionListener(listener);
    }

    @Override
    public void setField(GridField mField) {
        if (mField != null) {
            this.m_WindowNo = mField.getWindowNo();
        }
        this.m_mField = mField;
        if (this.m_mField != null) {
            FieldRecordInfo.addMenu(this, this.popupMenu);
        }
    }

    @Override
    public GridField getField() {
        return this.m_mField;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("VAccount[");
        sb.append(this.m_value).append("]");
        return sb.toString();
    }

    @Override
    public void focusGained(FocusEvent e) {
    }

    @Override
    public void focusLost(FocusEvent e) {
        String actualText;
        if (this.m_text == null) {
            return;
        }
        String newText = this.m_text.getText();
        if (newText == null) {
            newText = "";
        }
        if ((actualText = this.m_mAccount.getDisplay(this.m_value)) == null) {
            actualText = "";
        }
        if (!newText.equals(actualText)) {
            this.cmd_text();
        }
    }

    final class VAccount_mouseAdapter
    extends MouseAdapter {
        private VAccount m_adaptee;

        VAccount_mouseAdapter(VAccount adaptee) {
            this.m_adaptee = adaptee;
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (SwingUtilities.isRightMouseButton(e)) {
                this.m_adaptee.popupMenu.show((Component)e.getSource(), e.getX(), e.getY());
            }
        }
    }
}

