/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.apps;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileWriter;
import java.nio.charset.Charset;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Properties;
import java.util.Vector;
import java.util.logging.Level;
import javax.swing.BorderFactory;
import javax.swing.JFileChooser;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.plaf.metal.MetalLookAndFeel;
import javax.swing.plaf.metal.MetalTheme;
import javax.swing.table.DefaultTableModel;
import org.adempiere.plaf.AdempierePLAF;
import org.adempiere.plaf.PLAFEditorPanel;
import org.compiere.apps.ADialog;
import org.compiere.apps.AEnv;
import org.compiere.apps.ConfirmPanel;
import org.compiere.apps.EMailDialog;
import org.compiere.apps.StatusBar;
import org.compiere.grid.ed.VDate;
import org.compiere.minigrid.MiniTable;
import org.compiere.model.MRole;
import org.compiere.model.MSystem;
import org.compiere.model.MUser;
import org.compiere.print.CPrinter;
import org.compiere.swing.CButton;
import org.compiere.swing.CCheckBox;
import org.compiere.swing.CComboBox;
import org.compiere.swing.CDialog;
import org.compiere.swing.CLabel;
import org.compiere.swing.CPanel;
import org.compiere.swing.CTabbedPane;
import org.compiere.swing.CTextArea;
import org.compiere.swing.CToggleButton;
import org.compiere.util.CLogErrorBuffer;
import org.compiere.util.CLogMgt;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.compiere.util.Ini;
import org.compiere.util.Msg;
import org.compiere.util.ValueNamePair;

public final class Preference
extends CDialog
implements ActionListener,
ListSelectionListener {
    private static final long serialVersionUID = -4691368295400769754L;
    private static CLogger log = CLogger.getCLogger(Preference.class);
    private CPanel panel = new CPanel();
    private BorderLayout panelLayout = new BorderLayout();
    private CTabbedPane tabPane = new CTabbedPane();
    private CPanel customizePane = new CPanel();
    private CPanel contextPane = new CPanel();
    private GridBagLayout customizeLayout = new GridBagLayout();
    private CCheckBox autoCommit = new CCheckBox();
    private CCheckBox autoNew = new CCheckBox();
    private CCheckBox printPreview = new CCheckBox();
    private CCheckBox validateConnectionOnStartup = new CCheckBox();
    private CCheckBox singleInstancePerWindow = new CCheckBox();
    private CCheckBox openWindowMaximized = new CCheckBox();
    private CPanel southPanel = new CPanel();
    private BorderLayout southLayout = new BorderLayout();
    private BorderLayout icontextLayout = new BorderLayout();
    private JList infoList = new JList();
    private JScrollPane contextListScrollPane = new JScrollPane(this.infoList);
    private CPanel contextSouthPanel = new CPanel();
    private CTextArea contextHeader = new CTextArea(4, 15);
    private CTextArea contextDetail = new CTextArea(4, 35);
    private CTextArea infoArea = new CTextArea(5, 30);
    private BorderLayout contextSouthLayout = new BorderLayout();
    private StatusBar statusBar = new StatusBar();
    private ConfirmPanel confirm = new ConfirmPanel(true);
    private CComboBox traceLevel = new CComboBox(CLogMgt.LEVELS);
    private CLabel traceLabel = new CLabel();
    private CCheckBox traceFile = new CCheckBox();
    private CCheckBox autoLogin = new CCheckBox();
    private CCheckBox adempiereSys = new CCheckBox();
    private CCheckBox logMigrationScript = new CCheckBox();
    private CCheckBox storePassword = new CCheckBox();
    private CCheckBox showTrl = new CCheckBox();
    private CCheckBox showAcct = new CCheckBox();
    private CCheckBox cacheWindow = new CCheckBox();
    private CLabel lPrinter = new CLabel();
    private CPrinter fPrinter = new CPrinter();
    private CLabel lDate = new CLabel();
    private VDate fDate = new VDate();
    private CPanel errorPane = new CPanel();
    private BorderLayout errorLayout = new BorderLayout();
    private JScrollPane errorScrollPane = new JScrollPane();
    private MiniTable errorTable = new MiniTable();
    private CPanel errorPanel = new CPanel(new FlowLayout(4));
    private CToggleButton bErrorsOnly = new CToggleButton(Msg.getMsg((Properties)Env.getCtx(), (String)"ErrorsOnly"));
    private CButton bErrorReset = new CButton(Msg.getMsg((Properties)Env.getCtx(), (String)"Reset"));
    private CButton bErrorEMail = new CButton(Msg.getMsg((Properties)Env.getCtx(), (String)"SendEMail"));
    private CButton bErrorSave = new CButton(Msg.getMsg((Properties)Env.getCtx(), (String)"SaveFile"));
    private CButton bRoleInfo = new CButton(Msg.translate((Properties)Env.getCtx(), (String)"AD_Role_ID"));
    private CLabel lCharset = new CLabel();
    private CComboBox fCharset = new CComboBox(Ini.getAvailableCharsets());
    private CPanel configPanel = new CPanel();
    private PLAFEditorPanel plafEditor = new PLAFEditorPanel();

    public Preference(Frame frame, int WindowNo) {
        super(frame, Msg.getMsg((Properties)Env.getCtx(), (String)"Preference"), true);
        log.config("Preference");
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            log.log(Level.SEVERE, ex.getMessage());
        }
        this.load();
        StringBuilder sta = new StringBuilder("#");
        sta.append(Env.getCtx().size()).append(" - ").append(Msg.translate((Properties)Env.getCtx(), (String)"AD_Window_ID")).append("=").append(WindowNo);
        this.statusBar.setStatusLine(sta.toString());
        this.statusBar.setStatusDB("");
        AEnv.positionCenterWindow(frame, this);
    }

    void jbInit() throws Exception {
        this.traceLabel.setRequestFocusEnabled(false);
        this.traceLabel.setText(Msg.getMsg((Properties)Env.getCtx(), (String)"TraceLevel", (boolean)true));
        this.traceLabel.setToolTipText(Msg.getMsg((Properties)Env.getCtx(), (String)"TraceLevel", (boolean)false));
        this.traceFile.setText(Msg.getMsg((Properties)Env.getCtx(), (String)"TraceFile", (boolean)true));
        this.traceFile.setToolTipText(Msg.getMsg((Properties)Env.getCtx(), (String)"TraceFile", (boolean)false));
        this.autoCommit.setText(Msg.getMsg((Properties)Env.getCtx(), (String)"AutoCommit", (boolean)true));
        this.autoCommit.setToolTipText(Msg.getMsg((Properties)Env.getCtx(), (String)"AutoCommit", (boolean)false));
        this.autoNew.setText(Msg.getMsg((Properties)Env.getCtx(), (String)"AutoNew", (boolean)true));
        this.autoNew.setToolTipText(Msg.getMsg((Properties)Env.getCtx(), (String)"AutoNew", (boolean)false));
        this.adempiereSys.setText(Msg.getMsg((Properties)Env.getCtx(), (String)"AdempiereSys", (boolean)true));
        this.adempiereSys.setToolTipText(Msg.getMsg((Properties)Env.getCtx(), (String)"AdempiereSys", (boolean)false));
        this.logMigrationScript.setText(Msg.getMsg((Properties)Env.getCtx(), (String)"LogMigrationScript", (boolean)true));
        this.logMigrationScript.setToolTipText(Msg.getMsg((Properties)Env.getCtx(), (String)"LogMigrationScript", (boolean)false));
        this.printPreview.setText(Msg.getMsg((Properties)Env.getCtx(), (String)"AlwaysPrintPreview", (boolean)true));
        this.printPreview.setToolTipText(Msg.getMsg((Properties)Env.getCtx(), (String)"AlwaysPrintPreview", (boolean)false));
        this.validateConnectionOnStartup.setText(Msg.getMsg((Properties)Env.getCtx(), (String)"ValidateConnectionOnStartup", (boolean)true));
        this.validateConnectionOnStartup.setToolTipText(Msg.getMsg((Properties)Env.getCtx(), (String)"ValidateConnectionOnStartup", (boolean)false));
        this.singleInstancePerWindow.setText(Msg.getMsg((Properties)Env.getCtx(), (String)"SingleInstancePerWindow", (boolean)true));
        this.singleInstancePerWindow.setToolTipText(Msg.getMsg((Properties)Env.getCtx(), (String)"SingleInstancePerWindow", (boolean)false));
        this.openWindowMaximized.setText(Msg.getMsg((Properties)Env.getCtx(), (String)"OpenWindowMaximized", (boolean)true));
        this.openWindowMaximized.setToolTipText(Msg.getMsg((Properties)Env.getCtx(), (String)"OpenWindowMaximized", (boolean)false));
        this.autoLogin.setText(Msg.getMsg((Properties)Env.getCtx(), (String)"AutoLogin", (boolean)true));
        this.autoLogin.setToolTipText(Msg.getMsg((Properties)Env.getCtx(), (String)"AutoLogin", (boolean)false));
        this.storePassword.setText(Msg.getMsg((Properties)Env.getCtx(), (String)"StorePassword", (boolean)true));
        this.storePassword.setToolTipText(Msg.getMsg((Properties)Env.getCtx(), (String)"StorePassword", (boolean)false));
        this.showTrl.setText(Msg.getMsg((Properties)Env.getCtx(), (String)"ShowTrlTab", (boolean)true));
        this.showTrl.setToolTipText(Msg.getMsg((Properties)Env.getCtx(), (String)"ShowTrlTab", (boolean)false));
        this.showAcct.setText(Msg.getMsg((Properties)Env.getCtx(), (String)"ShowAcctTab", (boolean)true));
        this.showAcct.setToolTipText(Msg.getMsg((Properties)Env.getCtx(), (String)"ShowAcctTab", (boolean)false));
        this.cacheWindow.setText(Msg.getMsg((Properties)Env.getCtx(), (String)"CacheWindow", (boolean)true));
        this.cacheWindow.setToolTipText(Msg.getMsg((Properties)Env.getCtx(), (String)"CacheWindow", (boolean)false));
        this.lPrinter.setText(Msg.getMsg((Properties)Env.getCtx(), (String)"Printer"));
        this.lDate.setText(Msg.getMsg((Properties)Env.getCtx(), (String)"Date"));
        this.infoArea.setReadWrite(false);
        this.lCharset.setText(Msg.getMsg((Properties)Env.getCtx(), (String)"Charset", (boolean)true));
        this.lCharset.setToolTipText(Msg.getMsg((Properties)Env.getCtx(), (String)"Charset", (boolean)false));
        this.getContentPane().add(this.panel);
        this.panel.setLayout(this.panelLayout);
        this.panel.add((Component)this.tabPane, "Center");
        this.tabPane.add((Component)this.customizePane, Msg.getMsg((Properties)Env.getCtx(), (String)"Preference"));
        this.customizePane.setLayout(this.customizeLayout);
        this.customizePane.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        Border insetBorder = BorderFactory.createEmptyBorder(2, 2, 2, 0);
        if (MSystem.isSwingRememberPasswordAllowed()) {
            CPanel loginPanel = new CPanel();
            loginPanel.setBorder(BorderFactory.createTitledBorder(Msg.getMsg((Properties)Env.getCtx(), (String)"Login")));
            loginPanel.setLayout(new GridLayout(1, 2));
            this.autoLogin.setBorder(insetBorder);
            this.storePassword.setBorder(insetBorder);
            loginPanel.add(this.autoLogin);
            loginPanel.add(this.storePassword);
            this.customizePane.add((Component)loginPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(2, 0, 2, 0), 0, 0));
        }
        CPanel windowPanel = new CPanel();
        windowPanel.setBorder(BorderFactory.createTitledBorder(Msg.getMsg((Properties)Env.getCtx(), (String)"Window")));
        windowPanel.setLayout(new GridLayout(4, 2));
        windowPanel.add(this.showAcct);
        this.showAcct.setBorder(insetBorder);
        windowPanel.add(this.showTrl);
        this.showTrl.setBorder(insetBorder);
        windowPanel.add(this.autoCommit);
        this.autoCommit.setBorder(insetBorder);
        windowPanel.add(this.autoNew);
        this.autoNew.setBorder(insetBorder);
        windowPanel.add(this.cacheWindow);
        this.cacheWindow.setBorder(insetBorder);
        windowPanel.add(this.openWindowMaximized);
        this.openWindowMaximized.setBorder(insetBorder);
        windowPanel.add(this.singleInstancePerWindow);
        this.singleInstancePerWindow.setBorder(insetBorder);
        this.customizePane.add((Component)windowPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(2, 0, 2, 0), 0, 0));
        CPanel connPanel = new CPanel();
        connPanel.setBorder(BorderFactory.createTitledBorder(Msg.getMsg((Properties)Env.getCtx(), (String)"Connection")));
        connPanel.setLayout(new GridBagLayout());
        connPanel.add((Component)this.validateConnectionOnStartup, new GridBagConstraints(0, 1, 2, 1, 1.0, 0.0, 17, 0, new Insets(2, 2, 2, 0), 0, 0));
        this.customizePane.add((Component)connPanel, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 17, 2, new Insets(2, 0, 2, 0), 0, 0));
        CPanel tracePanel = new CPanel();
        tracePanel.setBorder(BorderFactory.createTitledBorder(Msg.getMsg((Properties)Env.getCtx(), (String)"TraceInfo")));
        tracePanel.setLayout(new GridBagLayout());
        tracePanel.add((Component)this.traceLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 2, 2, 0), 0, 0));
        tracePanel.add((Component)this.traceLevel, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(2, 2, 2, 0), 0, 0));
        tracePanel.add((Component)this.traceFile, new GridBagConstraints(0, 1, 2, 1, 1.0, 0.0, 17, 0, new Insets(2, 2, 2, 0), 0, 0));
        this.customizePane.add((Component)tracePanel, new GridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 17, 2, new Insets(2, 0, 2, 0), 0, 0));
        CPanel printPanel = new CPanel();
        printPanel.setBorder(BorderFactory.createTitledBorder(Msg.getMsg((Properties)Env.getCtx(), (String)"Printing")));
        printPanel.setLayout(new GridBagLayout());
        printPanel.add((Component)this.lPrinter, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 2, 2, 0), 0, 0));
        printPanel.add((Component)this.fPrinter, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 2, 2, 0), 0, 0));
        printPanel.add((Component)this.printPreview, new GridBagConstraints(0, 1, 2, 1, 1.0, 0.0, 17, 0, new Insets(2, 2, 2, 0), 0, 0));
        this.customizePane.add((Component)printPanel, new GridBagConstraints(0, 4, 1, 1, 1.0, 0.0, 17, 2, new Insets(2, 0, 2, 0), 0, 0));
        CPanel otherPanel = new CPanel();
        otherPanel.setBorder(BorderFactory.createEmptyBorder());
        otherPanel.setLayout(new GridLayout());
        CPanel datePanel = new CPanel();
        datePanel.setLayout(new FlowLayout());
        ((FlowLayout)datePanel.getLayout()).setAlignment(0);
        datePanel.add(this.lDate);
        datePanel.add(this.fDate);
        otherPanel.add(datePanel);
        datePanel.setBorder(insetBorder);
        otherPanel.add(this.adempiereSys);
        this.adempiereSys.setBorder(insetBorder);
        otherPanel.add(this.logMigrationScript);
        this.logMigrationScript.setBorder(insetBorder);
        this.customizePane.add((Component)otherPanel, new GridBagConstraints(0, 5, 1, 1, 1.0, 0.0, 17, 2, new Insets(2, 0, 2, 0), 0, 0));
        CPanel charsetPanel = new CPanel();
        charsetPanel.setBorder(BorderFactory.createEmptyBorder());
        charsetPanel.setLayout(new FlowLayout());
        ((FlowLayout)charsetPanel.getLayout()).setAlignment(0);
        charsetPanel.add(this.lCharset);
        charsetPanel.add(this.fCharset);
        this.customizePane.add((Component)charsetPanel, new GridBagConstraints(0, 6, 1, 1, 1.0, 0.0, 17, 2, new Insets(2, 0, 2, 0), 0, 0));
        CPanel themePanel = new CPanel();
        themePanel.setLayout(new GridLayout(1, 1));
        themePanel.add(this.plafEditor);
        this.tabPane.add((Component)themePanel, Msg.getMsg((Properties)Env.getCtx(), (String)"UITheme", (boolean)true));
        this.configPanel.setLayout(new BorderLayout());
        this.configPanel.add((Component)this.infoArea, "Center");
        CPanel configSouth = new CPanel();
        configSouth.setLayout(new FlowLayout());
        ((FlowLayout)configSouth.getLayout()).setAlignment(2);
        configSouth.add(this.bRoleInfo);
        this.configPanel.add((Component)configSouth, "South");
        this.tabPane.add((Component)this.configPanel, Msg.getMsg((Properties)Env.getCtx(), (String)"Info"));
        this.tabPane.add((Component)this.contextPane, Msg.getMsg((Properties)Env.getCtx(), (String)"Context"));
        this.contextPane.setLayout(this.icontextLayout);
        this.contextPane.add((Component)this.contextListScrollPane, "Center");
        this.contextListScrollPane.setPreferredSize(new Dimension(200, 300));
        this.infoList.setSelectionMode(1);
        this.infoList.setBackground(AdempierePLAF.getFieldBackground_Inactive());
        this.infoList.addListSelectionListener(this);
        this.infoList.setFixedCellWidth(30);
        this.contextPane.add((Component)this.contextSouthPanel, "South");
        this.contextSouthPanel.setLayout(this.contextSouthLayout);
        this.contextSouthPanel.add((Component)this.contextHeader, "West");
        this.contextHeader.setBackground(SystemColor.info);
        this.contextHeader.setReadWrite(false);
        this.contextHeader.setLineWrap(true);
        this.contextHeader.setWrapStyleWord(true);
        this.contextHeader.setBorder(BorderFactory.createLoweredBevelBorder());
        this.contextSouthPanel.add((Component)this.contextDetail, "Center");
        this.contextDetail.setBackground(SystemColor.info);
        this.contextDetail.setReadWrite(false);
        this.contextDetail.setLineWrap(true);
        this.contextDetail.setWrapStyleWord(true);
        this.contextDetail.setBorder(BorderFactory.createLoweredBevelBorder());
        this.errorPane.setLayout(this.errorLayout);
        this.tabPane.add((Component)this.errorPane, "Errors");
        this.errorPane.add((Component)this.errorScrollPane, "Center");
        this.errorScrollPane.getViewport().add((Component)this.errorTable, null);
        this.errorPanel.add(this.bErrorsOnly);
        this.errorPanel.add(this.bErrorReset);
        this.errorPanel.add(this.bErrorEMail);
        this.errorPanel.add(this.bErrorSave);
        this.errorPane.add((Component)this.errorPanel, "South");
        this.panel.add((Component)this.southPanel, "South");
        this.southPanel.setLayout(this.southLayout);
        this.southPanel.add((Component)this.statusBar, "South");
        this.southPanel.add((Component)this.confirm, "Center");
        this.bRoleInfo.addActionListener(this);
        this.confirm.addActionListener(this);
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (e.getValueIsAdjusting()) {
            return;
        }
        String value = (String)this.infoList.getSelectedValue();
        if (value == null) {
            return;
        }
        int pos = value.indexOf("==");
        if (pos == -1) {
            this.contextHeader.setText("");
            this.contextDetail.setText(value);
        } else {
            this.contextHeader.setText(value.substring(0, pos).replace('|', '\n'));
            this.contextDetail.setText(value.substring(pos + 3));
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals("Cancel")) {
            this.dispose();
        } else if (e.getActionCommand().equals("Ok")) {
            this.cmd_save();
        } else if (e.getSource() == this.bErrorsOnly) {
            this.cmd_displayErrors();
        } else if (e.getSource() == this.bErrorReset) {
            this.cmd_errorReset();
        } else if (e.getSource() == this.bErrorEMail) {
            this.cmd_errorEMail();
        } else if (e.getSource() == this.bErrorSave) {
            this.cmd_errorSave();
        } else if (e.getSource() == this.bRoleInfo) {
            ADialog.info(0, this, "RoleInfo", MRole.getDefault().toStringX(Env.getCtx()));
        }
    }

    private void load() {
        log.config("");
        this.infoArea.setText(CLogMgt.getInfo(null).toString());
        this.infoArea.setCaretPosition(0);
        this.autoCommit.setSelected(Env.isAutoCommit((Properties)Env.getCtx()));
        this.autoNew.setSelected(Env.isAutoNew((Properties)Env.getCtx()));
        this.adempiereSys.setSelected(Ini.isPropertyBool((String)"AdempiereSys"));
        this.logMigrationScript.setSelected(Ini.isPropertyBool((String)"LogMigrationScript"));
        if (Env.getAD_Client_ID((Properties)Env.getCtx()) > 20) {
            this.adempiereSys.setSelected(false);
            this.adempiereSys.setEnabled(false);
            if (Env.getAD_User_ID((Properties)Env.getCtx()) > 100) {
                this.logMigrationScript.setSelected(false);
                this.logMigrationScript.setEnabled(false);
            }
        }
        if (MSystem.isSwingRememberPasswordAllowed()) {
            this.autoLogin.setSelected(Ini.isPropertyBool((String)"AutoLogin"));
            this.storePassword.setSelected(Ini.isPropertyBool((String)"StorePassword"));
        } else {
            this.autoLogin.setSelected(false);
            this.storePassword.setSelected(false);
        }
        if (MRole.getDefault().isShowAcct()) {
            this.showAcct.setSelected(Ini.isPropertyBool((String)"ShowAcct"));
        } else {
            this.showAcct.setSelected(false);
            this.showAcct.setReadWrite(false);
        }
        this.showTrl.setSelected(Ini.isPropertyBool((String)"ShowTrl"));
        this.cacheWindow.setSelected(Ini.isCacheWindow());
        this.printPreview.setSelected(Ini.isPropertyBool((String)"PrintPreview"));
        this.validateConnectionOnStartup.setSelected(Ini.isPropertyBool((String)"ValidateConnectionOnStartup"));
        this.singleInstancePerWindow.setSelected(Ini.isPropertyBool((String)"SingleInstancePerWindow"));
        this.openWindowMaximized.setSelected(Ini.isPropertyBool((String)"OpenWindowMaximized"));
        this.traceLevel.setSelectedItem(CLogMgt.getLevel());
        this.traceFile.setSelected(Ini.isPropertyBool((String)"TraceFile"));
        this.fPrinter.setValue(Env.getContext((Properties)Env.getCtx(), (String)"#Printer"));
        this.fDate.setValue(Env.getContextAsDate((Properties)Env.getCtx(), (String)"#Date"));
        this.fCharset.setSelectedItem(Ini.getCharset());
        Object[] context = Env.getEntireContext((Properties)Env.getCtx());
        Arrays.sort(context);
        this.infoList.setListData(context);
        this.bErrorsOnly.setSelected(true);
        this.errorTable.setCellSelectionEnabled(true);
        this.cmd_displayErrors();
        this.bErrorsOnly.addActionListener(this);
        this.bErrorReset.addActionListener(this);
        this.bErrorSave.addActionListener(this);
        this.bErrorEMail.addActionListener(this);
    }

    private void cmd_save() {
        log.config("");
        Ini.setProperty((String)"AutoCommit", (boolean)this.autoCommit.isSelected());
        Env.setAutoCommit((Properties)Env.getCtx(), (boolean)this.autoCommit.isSelected());
        Ini.setProperty((String)"AutoNew", (boolean)this.autoNew.isSelected());
        Env.setAutoNew((Properties)Env.getCtx(), (boolean)this.autoNew.isSelected());
        Ini.setProperty((String)"AdempiereSys", (boolean)this.adempiereSys.isSelected());
        Ini.setProperty((String)"LogMigrationScript", (boolean)this.logMigrationScript.isSelected());
        if (MSystem.isSwingRememberPasswordAllowed()) {
            Ini.setProperty((String)"AutoLogin", (boolean)this.autoLogin.isSelected());
            Ini.setProperty((String)"StorePassword", (boolean)this.storePassword.isSelected());
        } else {
            Ini.setProperty((String)"AutoLogin", (boolean)false);
            Ini.setProperty((String)"StorePassword", (boolean)false);
        }
        Ini.setProperty((String)"ShowAcct", (boolean)this.showAcct.isSelected());
        Env.setContext((Properties)Env.getCtx(), (String)"#ShowAcct", (boolean)this.showAcct.isSelected());
        Ini.setProperty((String)"ShowTrl", (boolean)this.showTrl.isSelected());
        Env.setContext((Properties)Env.getCtx(), (String)"#ShowTrl", (boolean)this.showTrl.isSelected());
        Ini.setProperty((String)"CacheWindow", (boolean)this.cacheWindow.isSelected());
        Ini.setProperty((String)"PrintPreview", (boolean)this.printPreview.isSelected());
        Ini.setProperty((String)"ValidateConnectionOnStartup", (boolean)this.validateConnectionOnStartup.isSelected());
        Ini.setProperty((String)"SingleInstancePerWindow", (boolean)this.singleInstancePerWindow.isSelected());
        Ini.setProperty((String)"OpenWindowMaximized", (boolean)this.openWindowMaximized.isSelected());
        Level level = (Level)this.traceLevel.getSelectedItem();
        CLogMgt.setLevel((Level)level);
        Ini.setProperty((String)"TraceLevel", (String)level.getName());
        Ini.setProperty((String)"TraceFile", (boolean)this.traceFile.isSelected());
        String printer = (String)this.fPrinter.getSelectedItem();
        Env.setContext((Properties)Env.getCtx(), (String)"#Printer", (String)printer);
        Ini.setProperty((String)"Printer", (String)printer);
        Timestamp ts = (Timestamp)this.fDate.getValue();
        if (ts != null) {
            Env.setContext((Properties)Env.getCtx(), (String)"#Date", (Timestamp)ts);
        }
        Charset charset = (Charset)this.fCharset.getSelectedItem();
        Ini.setProperty((String)"Charset", (String)charset.name());
        ValueNamePair laf = this.plafEditor.getSelectedLook();
        ValueNamePair theme = this.plafEditor.getSelectedTheme();
        if (laf != null) {
            String clazz = laf.getValue();
            String currentLaf = UIManager.getLookAndFeel().getClass().getName();
            if (clazz != null && clazz.length() > 0 && !currentLaf.equals(clazz)) {
                AdempierePLAF.setPLAF(laf, theme, true);
                AEnv.updateUI();
            } else if (UIManager.getLookAndFeel() instanceof MetalLookAndFeel) {
                MetalTheme currentTheme = MetalLookAndFeel.getCurrentTheme();
                String themeClass = currentTheme.getClass().getName();
                String sTheme = theme.getValue();
                if (sTheme != null && sTheme.length() > 0 && !sTheme.equals(themeClass)) {
                    ValueNamePair plaf = new ValueNamePair(UIManager.getLookAndFeel().getClass().getName(), UIManager.getLookAndFeel().getName());
                    AdempierePLAF.setPLAF(plaf, theme, true);
                    AEnv.updateUI();
                }
            }
        }
        Ini.saveProperties((boolean)Ini.isClient());
        this.dispose();
    }

    private void cmd_displayErrors() {
        Vector data = CLogErrorBuffer.get((boolean)true).getLogData(this.bErrorsOnly.isSelected());
        Vector columnNames = CLogErrorBuffer.get((boolean)true).getColumnNames(Env.getCtx());
        DefaultTableModel model = new DefaultTableModel(data, columnNames);
        this.errorTable.setModel(model);
        if (this.bErrorsOnly.isSelected()) {
            this.tabPane.setTitleAt(4, String.valueOf(Msg.getMsg((Properties)Env.getCtx(), (String)"Errors")) + " (" + data.size() + ")");
        } else {
            this.tabPane.setTitleAt(4, String.valueOf(Msg.getMsg((Properties)Env.getCtx(), (String)"TraceInfo")) + " (" + data.size() + ")");
        }
        this.errorTable.autoSize();
    }

    private void cmd_errorReset() {
        CLogErrorBuffer.get((boolean)true).resetBuffer(this.bErrorsOnly.isSelected());
        this.cmd_displayErrors();
    }

    private void cmd_errorEMail() {
        EMailDialog emd = new EMailDialog(this, "EMail Trace", MUser.get((Properties)Env.getCtx()), "", "Adempiere Trace Info", CLogErrorBuffer.get((boolean)true).getErrorInfo(Env.getCtx(), this.bErrorsOnly.isSelected()), null);
    }

    private void cmd_errorSave() {
        JFileChooser chooser = new JFileChooser();
        chooser.setDialogType(1);
        chooser.setDialogTitle("Adempiere Trace File");
        chooser.setFileSelectionMode(0);
        chooser.setSelectedFile(new File("traceInfo.log"));
        int returnVal = chooser.showSaveDialog(this);
        if (returnVal != 0) {
            return;
        }
        try {
            File file = chooser.getSelectedFile();
            FileWriter writer = new FileWriter(file);
            writer.write(CLogErrorBuffer.get((boolean)true).getErrorInfo(Env.getCtx(), this.bErrorsOnly.isSelected()));
            writer.flush();
            writer.close();
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "", (Throwable)e);
        }
    }
}

