/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.pipo2;

import java.util.Properties;
import org.adempiere.pipo2.Element;
import org.adempiere.pipo2.IDFinder;
import org.adempiere.pipo2.POFinder;
import org.compiere.model.MTable;
import org.compiere.model.PO;
import org.compiere.util.CLogger;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.xml.sax.helpers.AttributesImpl;

public class ReferenceUtils {
    private static final CLogger log = CLogger.getCLogger(ReferenceUtils.class);

    public static int resolveReference(Properties ctx, Element e, String trxName) {
        String value = e.contents.toString();
        String referenceKey = e.attributes.getValue("reference-key");
        if (value != null && value.trim().length() > 0) {
            if (ReferenceUtils.isIDLookup(e)) {
                int id = Integer.parseInt(value);
                return id;
            }
            if (ReferenceUtils.isUUIDLookup(e)) {
                String uuid = value.trim();
                String target = Env.getAD_Client_ID((Properties)ctx) > 0 ? POFinder.getTargetUUID(ctx, referenceKey, uuid, trxName) : uuid;
                int id = IDFinder.findIdByColumn(referenceKey, PO.getUUIDColumnName((String)referenceKey), target, Env.getAD_Client_ID((Properties)ctx), trxName);
                return id;
            }
            throw new IllegalArgumentException("Unknown column reference type=" + e.attributes.getValue("reference"));
        }
        return 0;
    }

    public static boolean isLookup(Element element) {
        return ReferenceUtils.isIDLookup(element) || ReferenceUtils.isUUIDLookup(element);
    }

    public static boolean isIDLookup(Element element) {
        return "id".equals(element.attributes.getValue("reference"));
    }

    public static boolean isUUIDLookup(Element element) {
        return "uuid".equals(element.attributes.getValue("reference"));
    }

    public static String getTableReference(String tableName, int id, AttributesImpl atts) {
        String sql;
        String value;
        String keyColumn = String.valueOf(tableName) + "_ID";
        if (id > 0 && id <= 999999 || id == 0 && MTable.isZeroIDTable((String)tableName)) {
            atts.addAttribute("", "", "reference", "CDATA", "id");
            String value2 = Integer.toString(id);
            return value2;
        }
        if (id <= 0) {
            atts.addAttribute("", "", "reference", "CDATA", "id");
            return "";
        }
        MTable table = MTable.get((Properties)Env.getCtx(), (String)tableName);
        if (table == null) {
            throw new RuntimeException("Table Not Found. TableName=" + tableName);
        }
        String uuidColumnName = PO.getUUIDColumnName((String)tableName);
        if (table.getColumn(uuidColumnName) != null && (value = DB.getSQLValueString(null, (String)(sql = "SELECT " + uuidColumnName + " FROM " + tableName + " WHERE " + keyColumn + " = ?"), (int)id)) != null && value.trim().length() > 0) {
            atts.addAttribute("", "", "reference", "CDATA", "uuid");
            atts.addAttribute("", "", "reference-key", "CDATA", tableName);
            return value.trim();
        }
        atts.addAttribute("", "", "reference", "CDATA", "id");
        return "";
    }
}

