/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.text;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import org.jpedal.PdfDecoder;
import org.jpedal.exception.PdfException;
import org.jpedal.exception.PdfSecurityException;
import org.jpedal.grouping.PdfGroupingAlgorithms;
import org.jpedal.objects.PdfPageData;
import org.jpedal.utils.LogWriter;

public class ExtractTextInRectangle {
    public static boolean isTest = false;
    protected String text = null;
    private static boolean useXMLExtraction = false;
    protected static boolean writeToFile = true;
    protected String user_dir = System.getProperty("user.dir");
    public static boolean showMessages = true;
    protected String separator = System.getProperty("file.separator");
    protected PdfDecoder decodePdf = null;
    protected String outputDir = "";
    protected static int defX1 = -1;
    protected static int defX2;
    protected static int defY1;
    protected static int defY2;
    private static String testFile;

    public ExtractTextInRectangle() {
    }

    public ExtractTextInRectangle(String string) {
        String string2 = System.getProperty("xml");
        if (string2 != null) {
            useXMLExtraction = true;
        }
        if (!this.user_dir.endsWith(this.separator)) {
            this.user_dir = this.user_dir + this.separator;
        }
        if (string.toLowerCase().endsWith(".pdf")) {
            this.decodeFile(string);
        } else {
            String[] stringArray = null;
            File file = null;
            if (!string.endsWith(this.separator)) {
                string = string + this.separator;
            }
            try {
                file = new File(string);
                if (!file.isDirectory()) {
                    System.err.println(string + " is not a directory. Exiting program");
                }
                stringArray = file.list();
            }
            catch (Exception exception) {
                LogWriter.writeLog("Exception trying to access file " + exception.getMessage());
            }
            long l = stringArray.length;
            int n = 0;
            while ((long)n < l) {
                if (showMessages) {
                    System.out.println(n + "/ " + l + " " + stringArray[n]);
                }
                if (stringArray[n].toLowerCase().endsWith(".pdf")) {
                    if (showMessages) {
                        System.out.println(string + stringArray[n]);
                    }
                    this.decodeFile(string + stringArray[n]);
                }
                ++n;
            }
        }
    }

    protected void decodeFile(String string) {
        String string2 = "demo";
        int n = string.lastIndexOf(this.separator);
        if (n != -1) {
            string2 = string.substring(n + 1, string.length() - 4);
        }
        this.outputDir = this.user_dir + "text" + this.separator + string2 + this.separator;
        try {
            this.decodePdf = new PdfDecoder(false);
            if (!isTest && !useXMLExtraction) {
                PdfDecoder.useTextExtraction();
            }
            this.decodePdf.setExtractionMode(1);
            this.decodePdf.init(true);
            if (showMessages) {
                System.out.println("Opening file :" + string);
            }
            this.decodePdf.openPdfFile(string);
        }
        catch (PdfSecurityException pdfSecurityException) {
            System.err.println("Security Exception " + pdfSecurityException + " in pdf code for text extraction on file " + this.decodePdf.getObjectStore().getCurrentFilename());
        }
        catch (PdfException pdfException) {
            System.err.println("Pdf Exception " + pdfException + " in pdf code for text extraction on file " + this.decodePdf.getObjectStore().getCurrentFilename());
        }
        catch (Exception exception) {
            System.err.println("Exception " + exception + " in pdf code for text extraction on file " + this.decodePdf.getObjectStore().getCurrentFilename());
            exception.printStackTrace();
        }
        if (!this.decodePdf.isExtractionAllowed()) {
            if (showMessages) {
                System.out.println("Text extraction not allowed");
            }
        } else if (this.decodePdf.isEncrypted() && !this.decodePdf.isPasswordSupplied()) {
            if (showMessages) {
                System.out.println("Encrypted settings");
                System.out.println("Please look at SimpleViewer for code sample to handle such files");
                System.out.println("Or get support/consultancy");
            }
        } else {
            int n2 = 1;
            int n3 = this.decodePdf.getPageCount();
            if (n3 > 10 && isTest) {
                n3 = 10;
            }
            try {
                for (int i = n2; i < n3 + 1; ++i) {
                    int n4;
                    int n5;
                    int n6;
                    int n7;
                    this.decodePdf.decodePage(i);
                    PdfGroupingAlgorithms pdfGroupingAlgorithms = this.decodePdf.getGroupingObject();
                    PdfPageData pdfPageData = this.decodePdf.getPdfPageData();
                    if (defX1 == -1) {
                        n7 = pdfPageData.getMediaBoxX(i);
                        n6 = pdfPageData.getMediaBoxWidth(i) + n7;
                        n5 = pdfPageData.getMediaBoxY(i);
                        n4 = pdfPageData.getMediaBoxHeight(i) + n5;
                    } else {
                        n7 = defX1;
                        n4 = defY1;
                        n6 = defX2;
                        n5 = defY2;
                    }
                    if (showMessages) {
                        System.out.println("Extracting text from rectangle (" + n7 + "," + n4 + " " + n6 + "," + n5 + ")");
                    }
                    this.text = null;
                    try {
                        this.text = pdfGroupingAlgorithms.extractTextInRectangle(n7, n4, n6, n5, i, false, true);
                    }
                    catch (PdfException pdfException) {
                        this.decodePdf.closePdfFile();
                        System.err.println("Exception " + pdfException.getMessage() + " in file " + this.decodePdf.getObjectStore().fullFileName);
                        pdfException.printStackTrace();
                    }
                    if (this.text == null) {
                        if (showMessages) {
                            System.out.println("No text found");
                        }
                    } else if (writeToFile) {
                        File file = new File(this.outputDir + this.separator);
                        if (!file.exists()) {
                            file.mkdirs();
                        }
                        String string3 = ".txt";
                        String string4 = System.getProperty("file.encoding");
                        if (useXMLExtraction) {
                            string3 = ".xml";
                            string4 = "UTF-8";
                        }
                        if (isTest) {
                            string3 = ".xml";
                        }
                        if (showMessages) {
                            System.out.println("Writing to " + this.outputDir + i + string3);
                        }
                        OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(this.outputDir + i + string3), string4);
                        if (useXMLExtraction | isTest) {
                            outputStreamWriter.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n\n");
                            outputStreamWriter.write("<!-- Pixel Location of text x1,y1,x2,y2\n");
                            outputStreamWriter.write("(x1,y1 is top left corner)\n");
                            outputStreamWriter.write("(x1,y1 is bottom right corner)\n");
                            outputStreamWriter.write("(origin is bottom left corner)  -->\n");
                            outputStreamWriter.write("\n\n<ARTICLE>\n");
                            outputStreamWriter.write("<LOCATION x1=\"" + n7 + "\" " + "y1=\"" + n4 + "\" " + "x2=\"" + n6 + "\" " + "y2=\"" + n5 + "\" />\n");
                            outputStreamWriter.write("\n\n<TEXT>\n");
                            outputStreamWriter.write(this.text);
                            outputStreamWriter.write("\n\n</TEXT>\n");
                            outputStreamWriter.write("\n\n</ARTICLE>\n");
                        } else {
                            outputStreamWriter.write(this.text);
                        }
                        outputStreamWriter.close();
                    }
                    this.decodePdf.flushObjectValues(false);
                }
            }
            catch (Exception exception) {
                this.decodePdf.closePdfFile();
                System.err.println("Exception " + exception.getMessage());
                exception.printStackTrace();
                System.out.println(this.decodePdf.getObjectStore().getCurrentFilename());
            }
            this.decodePdf.flushObjectValues(true);
            if (showMessages) {
                System.out.println("Text read");
            }
        }
        this.decodePdf.closePdfFile();
    }

    public static void main(String[] stringArray) {
        if (showMessages) {
            System.out.println("Simple demo to extract text objects");
        }
        String string = testFile;
        if (stringArray.length == 1) {
            string = stringArray[0];
            System.out.println("File :" + string);
        } else if (stringArray.length == 5) {
            string = stringArray[0];
            System.out.println("File :" + string);
            System.out.println("User coordinates supplied");
            defX1 = Integer.parseInt(stringArray[1]);
            defY1 = Integer.parseInt(stringArray[2]);
            defX2 = Integer.parseInt(stringArray[3]);
            defY2 = Integer.parseInt(stringArray[4]);
        } else {
            System.out.println("Please call with either ");
            System.out.println("FileName");
            System.out.println("or");
            System.out.println("FileName x1 y1 x2 y2");
        }
        File file = new File(string);
        if (!file.exists()) {
            System.out.println("File " + string + " not found");
        }
        long l = System.currentTimeMillis();
        ExtractTextInRectangle extractTextInRectangle = new ExtractTextInRectangle(string);
        long l2 = System.currentTimeMillis();
        if (!isTest) {
            System.out.println("Time taken=" + (l2 - l) / 1000L);
        }
    }

    public String getExtractedText() {
        return this.text;
    }

    static {
        testFile = "/mnt/shared/sample.pdf";
    }
}

