/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.install;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Properties;
import java.util.logging.Level;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.compiere.Adempiere;
import org.compiere.install.TranslationHandler;
import org.compiere.model.MLanguage;
import org.compiere.model.MTable;
import org.compiere.model.PO;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Language;
import org.compiere.util.Login;
import org.compiere.util.Msg;
import org.compiere.util.Util;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.helpers.DefaultHandler;

public class Translation {
    public static final String DTD = "<!DOCTYPE idempiereTrl PUBLIC \"-//ComPiere, Inc.//DTD iDempiere Translation 1.0//EN\" \"http://www.idempiere.com/dtd/idempiereTrl.dtd\">";
    public static final String XML_TAG = "idempiereTrl";
    public static final String XML_TAG2 = "adempiereTrl";
    public static final String XML_TAG3 = "compiereTrl";
    public static final String XML_ATTRIBUTE_TABLE = "table";
    public static final String XML_ATTRIBUTE_LANGUAGE = "language";
    public static final String XML_ROW_TAG = "row";
    public static final String XML_ROW_ATTRIBUTE_ID = "id";
    public static final String XML_ROW_ATTRIBUTE_UUID = "uuid";
    public static final String XML_ROW_ATTRIBUTE_TRANSLATED = "trl";
    public static final String XML_VALUE_TAG = "value";
    public static final String XML_VALUE_ATTRIBUTE_COLUMN = "column";
    public static final String XML_VALUE_ATTRIBUTE_ORIGINAL = "original";
    private boolean m_IsCentrallyMaintained = false;
    private CLogger log = CLogger.getCLogger(this.getClass());
    private Properties m_ctx = null;

    public Translation(Properties ctx) {
        this.m_ctx = ctx;
    }

    public String importTrl(String directory, int AD_Client_ID, String AD_Language, String Trl_Table) {
        String fileName = String.valueOf(directory) + File.separator + Trl_Table + "_" + AD_Language + ".xml";
        this.log.info(fileName);
        File in = new File(fileName);
        if (!in.exists()) {
            String msg = "File does not exist: " + fileName;
            this.log.log(Level.SEVERE, msg);
            return msg;
        }
        try {
            MLanguage lang;
            TranslationHandler handler = new TranslationHandler(AD_Client_ID);
            SAXParserFactory factory = SAXParserFactory.newInstance();
            SAXParser parser = factory.newSAXParser();
            parser.parse(in, (DefaultHandler)handler);
            if (this.log.isLoggable(Level.INFO)) {
                this.log.info("Updated=" + handler.getUpdateCount());
            }
            if (!(lang = MLanguage.get((Properties)this.m_ctx, (String)AD_Language)).isLoginLocale()) {
                lang.setIsLoginLocale(true);
                lang.saveEx();
            }
            return String.valueOf(Msg.getMsg((Properties)this.m_ctx, (String)"Updated")) + "=" + handler.getUpdateCount();
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, "importTrl", (Throwable)e);
            return e.toString();
        }
    }

    public String exportTrl(String directory, int AD_Client_ID, String AD_Language, String Trl_Table) {
        String fileName = String.valueOf(directory) + File.separator + Trl_Table + "_" + AD_Language + ".xml";
        this.log.info(fileName);
        File out = new File(fileName);
        boolean isBaseLanguage = Language.isBaseLanguage((String)AD_Language);
        String tableName = Trl_Table;
        int pos = tableName.indexOf("_Trl");
        String Base_Table = Trl_Table.substring(0, pos);
        if (isBaseLanguage) {
            tableName = Base_Table;
        }
        String keyColumn = String.valueOf(Base_Table) + "_ID";
        String uuidColumn = MTable.getUUIDColumnName((String)Base_Table);
        String[] trlColumns = this.getTrlColumns(Base_Table);
        StringBuffer sql = null;
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.newDocument();
            document.appendChild(document.createComment(Adempiere.getSummaryAscii()));
            document.appendChild(document.createComment(DTD));
            Element root = document.createElement(XML_TAG);
            root.setAttribute(XML_ATTRIBUTE_LANGUAGE, AD_Language);
            root.setAttribute(XML_ATTRIBUTE_TABLE, Base_Table);
            document.appendChild(root);
            sql = new StringBuffer("SELECT ");
            if (isBaseLanguage) {
                sql.append("'Y',");
            } else {
                sql.append("t.IsTranslated,");
            }
            sql.append("t.").append(keyColumn);
            sql.append(", o.").append(uuidColumn);
            int i = 0;
            while (i < trlColumns.length) {
                sql.append(", t.").append(trlColumns[i]).append(",o.").append(trlColumns[i]).append(" AS ").append(trlColumns[i]).append("O");
                ++i;
            }
            sql.append(" FROM ").append(tableName).append(" t").append(" INNER JOIN ").append(Base_Table).append(" o ON (t.").append(keyColumn).append("=o.").append(keyColumn).append(")");
            boolean haveWhere = false;
            if (!isBaseLanguage) {
                sql.append(" WHERE t.AD_Language=?");
                haveWhere = true;
            }
            if (this.m_IsCentrallyMaintained) {
                sql.append(haveWhere ? " AND " : " WHERE ").append("o.IsCentrallyMaintained='N'");
                haveWhere = true;
            }
            if (AD_Client_ID >= 0) {
                sql.append(haveWhere ? " AND " : " WHERE ").append("o.AD_Client_ID=").append(AD_Client_ID);
            }
            sql.append(" ORDER BY t.").append(keyColumn);
            pstmt = DB.prepareStatement((String)sql.toString(), null);
            if (!isBaseLanguage) {
                pstmt.setString(1, AD_Language);
            }
            rs = pstmt.executeQuery();
            int rows = 0;
            while (rs.next()) {
                Element row = document.createElement(XML_ROW_TAG);
                int keyid = rs.getInt(2);
                String uuid = rs.getString(3);
                if (keyid <= 999999 || Util.isEmpty((String)uuid)) {
                    row.setAttribute(XML_ROW_ATTRIBUTE_ID, String.valueOf(keyid));
                } else {
                    row.setAttribute(XML_ROW_ATTRIBUTE_UUID, String.valueOf(uuid));
                }
                row.setAttribute(XML_ROW_ATTRIBUTE_TRANSLATED, rs.getString(1));
                int i2 = 0;
                while (i2 < trlColumns.length) {
                    String valueString;
                    Element value = document.createElement(XML_VALUE_TAG);
                    value.setAttribute(XML_VALUE_ATTRIBUTE_COLUMN, trlColumns[i2]);
                    String origString = rs.getString(String.valueOf(trlColumns[i2]) + "O");
                    if (origString == null) {
                        origString = "";
                    }
                    if ((valueString = rs.getString(trlColumns[i2])) == null) {
                        valueString = "";
                    }
                    value.setAttribute(XML_VALUE_ATTRIBUTE_ORIGINAL, origString);
                    if (valueString.indexOf("<") != -1 || valueString.indexOf(">") != -1 || valueString.indexOf("&") != -1) {
                        value.appendChild(document.createCDATASection(valueString));
                    } else {
                        value.appendChild(document.createTextNode(valueString));
                    }
                    row.appendChild(value);
                    ++i2;
                }
                root.appendChild(row);
                ++rows;
            }
            if (this.log.isLoggable(Level.INFO)) {
                this.log.info("Records=" + rows + ", DTD=" + document.getDoctype() + " - " + Trl_Table);
            }
            DOMSource source = new DOMSource(document);
            TransformerFactory tFactory = TransformerFactory.newInstance();
            tFactory.setAttribute("indent-number", 1);
            Transformer transformer = tFactory.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            out.createNewFile();
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(out), "utf-8");
            StreamResult result = new StreamResult(writer);
            transformer.transform(source, result);
            ((Writer)writer).close();
        }
        catch (SQLException e) {
            this.log.log(Level.SEVERE, sql.toString(), (Throwable)e);
            String string = e.toString();
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
            return string;
        }
        catch (Exception e) {
            try {
                this.log.log(Level.SEVERE, "", (Throwable)e);
                String string = e.toString();
                return string;
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
            }
        }
        DB.close((ResultSet)rs, (Statement)pstmt);
        rs = null;
        pstmt = null;
        return "";
    }

    private String[] getTrlColumns(String Base_Table) {
        ArrayList<String> list;
        block13: {
            ResultSet rs;
            CPreparedStatement pstmt;
            String sql;
            block11: {
                this.m_IsCentrallyMaintained = false;
                sql = "SELECT TableName FROM AD_Table t INNER JOIN AD_Column c ON (c.AD_Table_ID=t.AD_Table_ID AND c.ColumnName='IsCentrallyMaintained') WHERE t.TableName=? AND c.IsActive='Y'";
                pstmt = null;
                rs = null;
                try {
                    try {
                        pstmt = DB.prepareStatement((String)sql, null);
                        pstmt.setString(1, Base_Table);
                        rs = pstmt.executeQuery();
                        if (rs.next()) {
                            this.m_IsCentrallyMaintained = true;
                        }
                    }
                    catch (SQLException e) {
                        this.log.log(Level.SEVERE, sql, (Throwable)e);
                        DB.close((ResultSet)rs, (Statement)pstmt);
                        rs = null;
                        pstmt = null;
                        break block11;
                    }
                }
                catch (Throwable throwable) {
                    DB.close(rs, (Statement)pstmt);
                    rs = null;
                    pstmt = null;
                    throw throwable;
                }
                DB.close((ResultSet)rs, (Statement)pstmt);
                rs = null;
                pstmt = null;
            }
            sql = "SELECT ColumnName FROM AD_Column c INNER JOIN AD_Table t ON (c.AD_Table_ID=t.AD_Table_ID) WHERE t.TableName=? AND c.ColumnName NOT LIKE ?  AND c.AD_Reference_ID IN (10,14,36) ORDER BY IsMandatory DESC, ColumnName";
            list = new ArrayList<String>();
            try {
                try {
                    pstmt = DB.prepareStatement((String)sql, null);
                    pstmt.setString(1, String.valueOf(Base_Table) + "_Trl");
                    pstmt.setString(2, PO.getUUIDColumnName((String)(String.valueOf(Base_Table) + "_Trl")));
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        String s = rs.getString(1);
                        list.add(s);
                    }
                }
                catch (SQLException e) {
                    this.log.log(Level.SEVERE, sql, (Throwable)e);
                    DB.close((ResultSet)rs, (Statement)pstmt);
                    rs = null;
                    pstmt = null;
                    break block13;
                }
            }
            catch (Throwable throwable) {
                DB.close((ResultSet)rs, (Statement)pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close((ResultSet)rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
        }
        String[] retValue = new String[list.size()];
        list.toArray(retValue);
        return retValue;
    }

    public String validateLanguage(String AD_Language) {
        String sql = "SELECT * FROM AD_Language WHERE AD_Language=?";
        MLanguage language = null;
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                pstmt = DB.prepareStatement((String)sql, null);
                pstmt.setString(1, AD_Language);
                rs = pstmt.executeQuery();
                if (rs.next()) {
                    language = new MLanguage(this.m_ctx, rs, null);
                }
            }
            catch (SQLException e) {
                this.log.log(Level.SEVERE, sql, (Throwable)e);
                String string = e.toString();
                DB.close((ResultSet)rs, (Statement)pstmt);
                rs = null;
                pstmt = null;
                return string;
            }
        }
        catch (Throwable throwable) {
            DB.close(rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
            throw throwable;
        }
        DB.close((ResultSet)rs, (Statement)pstmt);
        rs = null;
        pstmt = null;
        if (language == null) {
            this.log.log(Level.SEVERE, "Language does not exist: " + AD_Language);
            return "Language does not exist: " + AD_Language;
        }
        if (language.isActive()) {
            if (language.isBaseLanguage()) {
                return "";
            }
        } else {
            this.log.log(Level.SEVERE, "Language not active or not system language: " + AD_Language);
            return "Language not active or not system language: " + AD_Language;
        }
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("Start Validating ... " + language);
        }
        language.maintain(true);
        return "";
    }

    private void process(String directory, String AD_Language, String mode) {
        ArrayList<String> trlTables;
        block14: {
            String sql = "SELECT Name, TableName FROM AD_Table WHERE TableName LIKE '%_Trl' ORDER BY Name";
            trlTables = new ArrayList<String>();
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement((String)sql, null);
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        trlTables.add(rs.getString(2));
                    }
                }
                catch (SQLException e) {
                    this.log.log(Level.SEVERE, sql, (Throwable)e);
                    DB.close((ResultSet)rs, (Statement)pstmt);
                    rs = null;
                    pstmt = null;
                    break block14;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, (Statement)pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close((ResultSet)rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
        }
        int i = 0;
        while (i < trlTables.size()) {
            String table = (String)trlTables.get(i);
            File dir = new File(directory);
            if (mode.equals("import")) {
                if (!dir.exists() || !dir.isDirectory()) {
                    System.out.println("The language cannot be imported from " + directory + " as this directory does not exist.");
                    System.exit(1);
                }
                this.importTrl(directory, -1, AD_Language, table);
            } else if (mode.equals("export")) {
                if (!dir.exists()) {
                    dir.mkdir();
                }
                if (!(dir = new File(directory)).exists()) {
                    System.out.println("Cannot create directory " + directory + " to export the language to it.");
                    System.exit(1);
                }
                this.exportTrl(directory, -1, AD_Language, table);
            } else {
                System.out.println("Just import and export are supported as modes.");
            }
            ++i;
        }
    }

    public static void main(String[] args) {
        if (args.length != 3) {
            System.out.println("format : java Translation directory AD_Language import|export");
            System.out.println("example: java Translation /Adempiere/data/de_DE de_DE import");
            System.out.println("example: java Translation /Adempiere/data/fr_FR fr_FR export");
            System.exit(1);
        }
        Login.initTest((boolean)false);
        String directory = args[0];
        String AD_Language = args[1];
        String mode = args[2];
        Translation trl = new Translation(Env.getCtx());
        String msg = trl.validateLanguage(AD_Language);
        if (msg.length() > 0) {
            System.err.println(msg);
        } else {
            trl.process(directory, AD_Language, mode);
        }
        System.exit(0);
    }
}

