/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.db;

import com.mchange.v2.c3p0.ComboPooledDataSource;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Properties;
import java.util.Random;
import java.util.logging.Level;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.DataSource;
import javax.sql.RowSet;
import org.adempiere.db.postgresql.PostgreSQLBundleActivator;
import org.adempiere.exceptions.DBException;
import org.compiere.db.AdempiereDatabase;
import org.compiere.db.CConnection;
import org.compiere.db.Database;
import org.compiere.dbPort.Convert;
import org.compiere.dbPort.Convert_PostgreSQL;
import org.compiere.model.PO;
import org.compiere.util.CCache;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.DisplayType;
import org.compiere.util.Ini;
import org.compiere.util.Trx;
import org.compiere.util.Util;
import org.jfree.io.IOUtils;

public class DB_PostgreSQL
implements AdempiereDatabase {
    private static final String POOL_PROPERTIES = "pool.properties";
    private org.postgresql.Driver s_driver = null;
    public static final String DRIVER = "org.postgresql.Driver";
    public static final int DEFAULT_PORT = 5432;
    private ComboPooledDataSource m_ds = null;
    private Convert_PostgreSQL m_convert = new Convert_PostgreSQL();
    private String m_connection;
    private String m_dbName = null;
    private String m_userName = null;
    private String m_connectionURL;
    private static CLogger log = CLogger.getCLogger(DB_PostgreSQL.class);
    private static int m_maxbusyconnections = 0;
    public static final String NATIVE_MARKER = "NATIVE_" + Database.DB_POSTGRESQL + "_KEYWORK";
    private CCache<String, String> convertCache = new CCache(null, "DB_PostgreSQL_Convert_Cache", 1000, 0, true);
    private Random rand = new Random();

    public Convert getConvert() {
        return this.m_convert;
    }

    public String getName() {
        return Database.DB_POSTGRESQL;
    }

    public String getDescription() {
        try {
            if (this.s_driver == null) {
                this.getDriver();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.s_driver != null) {
            return this.s_driver.toString();
        }
        return "No Driver";
    }

    public int getStandardPort() {
        return 5432;
    }

    public Driver getDriver() throws SQLException {
        if (this.s_driver == null) {
            this.s_driver = new org.postgresql.Driver();
            DriverManager.registerDriver((Driver)this.s_driver);
            DriverManager.setLoginTimeout(Database.CONNECTION_TIMEOUT);
        }
        return this.s_driver;
    }

    public String getConnectionURL(CConnection connection) {
        StringBuilder sb = new StringBuilder("jdbc:postgresql://").append(connection.getDbHost()).append(":").append(connection.getDbPort()).append("/").append(connection.getDbName()).append("?encoding=UNICODE");
        String urlParameters = System.getProperty("org.idempiere.postgresql.URLParameters");
        if (!Util.isEmpty((String)urlParameters)) {
            sb.append("&").append(urlParameters);
        }
        this.m_connection = sb.toString();
        return this.m_connection;
    }

    public String getConnectionURL(String dbHost, int dbPort, String dbName, String userName) {
        StringBuilder sb = new StringBuilder("jdbc:postgresql://").append(dbHost).append(":").append(dbPort).append("/").append(dbName);
        String urlParameters = System.getProperty("org.idempiere.postgresql.URLParameters");
        if (!Util.isEmpty((String)urlParameters)) {
            sb.append("?").append(urlParameters);
        }
        return sb.toString();
    }

    public String getConnectionURL(String connectionURL, String userName) {
        this.m_userName = userName;
        this.m_connectionURL = connectionURL;
        return this.m_connectionURL;
    }

    public String getCatalog() {
        if (this.m_dbName != null) {
            return this.m_dbName;
        }
        return null;
    }

    public String getSchema() {
        return "adempiere";
    }

    public boolean supportsBLOB() {
        return true;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("DB_PostgreSQL[");
        sb.append(this.m_connectionURL);
        try {
            StringBuilder logBuffer = new StringBuilder(50);
            logBuffer.append("# Connections: ").append(this.m_ds.getNumConnections());
            logBuffer.append(" , # Busy Connections: ").append(this.m_ds.getNumBusyConnections());
            logBuffer.append(" , # Idle Connections: ").append(this.m_ds.getNumIdleConnections());
            logBuffer.append(" , # Orphaned Connections: ").append(this.m_ds.getNumUnclosedOrphanedConnections());
        }
        catch (Exception e) {
            sb.append("=").append(e.getLocalizedMessage());
        }
        sb.append("]");
        return sb.toString();
    }

    public String getStatus() {
        if (this.m_ds == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        try {
            sb.append("# Connections: ").append(this.m_ds.getNumConnections());
            sb.append(" , # Busy Connections: ").append(this.m_ds.getNumBusyConnections());
            sb.append(" , # Idle Connections: ").append(this.m_ds.getNumIdleConnections());
            sb.append(" , # Orphaned Connections: ").append(this.m_ds.getNumUnclosedOrphanedConnections());
            sb.append(" , # Min Pool Size: ").append(this.m_ds.getMinPoolSize());
            sb.append(" , # Max Pool Size: ").append(this.m_ds.getMaxPoolSize());
            sb.append(" , # Max Statements Cache Per Session: ").append(this.m_ds.getMaxStatementsPerConnection());
            sb.append(" , # Active Transactions: ").append(Trx.getActiveTransactions().length);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return sb.toString();
    }

    public String convertStatement(String oraStatement) {
        String cache = (String)this.convertCache.get((Object)oraStatement);
        if (cache != null) {
            Convert.logMigrationScript((String)oraStatement, (String)cache);
            return cache;
        }
        String[] retValue = this.m_convert.convert(oraStatement);
        if (retValue == null || retValue.length == 0) {
            return oraStatement;
        }
        if (retValue.length != 1) {
            log.log(Level.SEVERE, "DB_PostgreSQL.convertStatement - Convert Command Number=" + retValue.length + " (" + oraStatement + ") - " + this.m_convert.getConversionError());
            throw new IllegalArgumentException("DB_PostgreSQL.convertStatement - Convert Command Number=" + retValue.length + " (" + oraStatement + ") - " + this.m_convert.getConversionError());
        }
        this.convertCache.put((Object)oraStatement, (Object)retValue[0]);
        if (log.isLoggable(Level.FINE) && !oraStatement.equals(retValue[0]) && retValue[0].indexOf("AD_Error") == -1 && log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "PostgreSQL =>" + retValue[0] + "<= <" + oraStatement + ">");
        }
        Convert.logMigrationScript((String)oraStatement, (String)retValue[0]);
        return retValue[0];
    }

    public String getSystemUser() {
        return "postgres";
    }

    public String getSystemDatabase(String databaseName) {
        return "template1";
    }

    public String TO_DATE(Timestamp time, boolean dayOnly) {
        if (time == null) {
            if (dayOnly) {
                return "current_date()";
            }
            return "current_date()";
        }
        StringBuilder dateString = new StringBuilder("TO_DATE('");
        String myDate = time.toString();
        if (dayOnly) {
            dateString.append(myDate.substring(0, 10));
            dateString.append("','YYYY-MM-DD')");
        } else {
            dateString.append(myDate.substring(0, myDate.indexOf(46)));
            dateString.append("','YYYY-MM-DD HH24:MI:SS')");
        }
        return dateString.toString();
    }

    public String TO_CHAR(String columnName, int displayType, String AD_Language) {
        StringBuilder retValue = new StringBuilder("CAST (");
        retValue.append(columnName);
        retValue.append(" AS Text)");
        return retValue.toString();
    }

    public String TO_NUMBER(BigDecimal number, int displayType) {
        if (number == null) {
            return "NULL";
        }
        BigDecimal result = number;
        int scale = DisplayType.getDefaultPrecision((int)displayType);
        if (scale > number.scale()) {
            try {
                result = number.setScale(scale, 4);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return result.toString();
    }

    public String[] getCommands(int cmdType) {
        if (cmdType == 0) {
            return new String[]{"CREATE USER adempiere;"};
        }
        if (1 == cmdType) {
            return new String[]{"CREATE DATABASE adempiere OWNER adempiere;", "GRANT ALL PRIVILEGES ON adempiere TO adempiere;", "CREATE SCHEMA adempiere;", "SET search_path TO adempiere;"};
        }
        if (2 == cmdType) {
            return new String[]{"DROP DATABASE adempiere;"};
        }
        return null;
    }

    public RowSet getRowSet(ResultSet rs) throws SQLException {
        throw new UnsupportedOperationException("PostgreSQL does not support RowSets");
    }

    public Connection getCachedConnection(CConnection connection, boolean autoCommit, int transactionIsolation) throws Exception {
        Connection conn = null;
        Exception exception = null;
        try {
            if (this.m_ds == null) {
                this.getDataSource(connection);
            }
            try {
                int randomNum;
                int numConnections = this.m_ds.getNumBusyConnections();
                if (numConnections >= m_maxbusyconnections && m_maxbusyconnections > 0) {
                    randomNum = this.rand.nextInt(21) + 20;
                    Thread.sleep(randomNum * 1000);
                }
                if ((conn = this.m_ds.getConnection()) == null) {
                    randomNum = this.rand.nextInt(21) + 10;
                    Thread.sleep(randomNum * 1000);
                    conn = this.m_ds.getConnection();
                }
                if (conn != null) {
                    if (conn.getTransactionIsolation() != transactionIsolation) {
                        conn.setTransactionIsolation(transactionIsolation);
                    }
                    if (conn.getAutoCommit() != autoCommit) {
                        conn.setAutoCommit(autoCommit);
                    }
                }
            }
            catch (Exception e) {
                exception = e;
                conn = null;
            }
            if (conn == null && exception != null) {
                System.err.println(exception.toString());
            }
        }
        catch (Exception e) {
            exception = e;
        }
        try {
            if (conn != null) {
                boolean trace = "true".equalsIgnoreCase(System.getProperty("org.adempiere.db.traceStatus"));
                int numConnections = this.m_ds.getNumBusyConnections();
                if (numConnections > 1) {
                    if (trace) {
                        log.warning(this.getStatus());
                    }
                    if (numConnections >= m_maxbusyconnections && m_maxbusyconnections > 0) {
                        if (!trace) {
                            log.warning(this.getStatus());
                        }
                        Runtime.getRuntime().runFinalization();
                    }
                }
            } else {
                System.err.println("Failed to acquire new connection. Status=" + this.getStatus());
            }
        }
        catch (Exception exception2) {
            // empty catch block
        }
        if (exception != null) {
            throw exception;
        }
        return conn;
    }

    private String getFileName() {
        String base = null;
        base = Ini.isClient() ? System.getProperty("user.home") : Ini.getAdempiereHome();
        if (base != null && !base.endsWith(File.separator)) {
            base = String.valueOf(base) + File.separator;
        }
        return String.valueOf(base) + this.getName() + File.separator + POOL_PROPERTIES;
    }

    public DataSource getDataSource(CConnection connection) {
        if (this.m_ds != null) {
            return this.m_ds;
        }
        InputStream inputStream = null;
        String propertyFilename = this.getFileName();
        File propertyFile = null;
        if (!Util.isEmpty((String)propertyFilename) && (propertyFile = new File(propertyFilename)).exists() && propertyFile.canRead()) {
            try {
                inputStream = new FileInputStream(propertyFile);
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
        }
        URL url = null;
        if (inputStream == null) {
            propertyFile = null;
            url = Ini.isClient() ? PostgreSQLBundleActivator.bundleContext.getBundle().getEntry("META-INF/pool/client.default.properties") : PostgreSQLBundleActivator.bundleContext.getBundle().getEntry("META-INF/pool/server.default.properties");
            try {
                inputStream = url.openStream();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        Properties poolProperties = new Properties();
        try {
            poolProperties.load(inputStream);
            inputStream.close();
            inputStream = null;
        }
        catch (IOException e) {
            throw new DBException((Exception)e);
        }
        if (propertyFile == null) {
            String directoryName = propertyFilename.substring(0, propertyFilename.length() - (POOL_PROPERTIES.length() + 1));
            File dir = new File(directoryName);
            if (!dir.exists()) {
                dir.mkdir();
            }
            propertyFile = new File(propertyFilename);
            try {
                FileOutputStream fos = new FileOutputStream(propertyFile);
                inputStream = url.openStream();
                IOUtils.getInstance().copyStreams(inputStream, (OutputStream)fos);
                fos.close();
                inputStream.close();
                inputStream = null;
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (inputStream != null) {
            try {
                inputStream.close();
            }
            catch (IOException directoryName) {
                // empty catch block
            }
        }
        int idleConnectionTestPeriod = this.getIntProperty(poolProperties, "IdleConnectionTestPeriod", 1200);
        int acquireRetryAttempts = this.getIntProperty(poolProperties, "AcquireRetryAttempts", 2);
        int maxIdleTimeExcessConnections = this.getIntProperty(poolProperties, "MaxIdleTimeExcessConnections", 1200);
        int maxIdleTime = this.getIntProperty(poolProperties, "MaxIdleTime", 1200);
        int unreturnedConnectionTimeout = this.getIntProperty(poolProperties, "UnreturnedConnectionTimeout", 0);
        boolean testConnectionOnCheckin = this.getBooleanProperty(poolProperties, "TestConnectionOnCheckin", false);
        boolean testConnectionOnCheckout = this.getBooleanProperty(poolProperties, "TestConnectionOnCheckout", false);
        int checkoutTimeout = this.getIntProperty(poolProperties, "CheckoutTimeout", 0);
        try {
            System.setProperty("com.mchange.v2.log.MLog", "com.mchange.v2.log.FallbackMLog");
            ComboPooledDataSource cpds = new ComboPooledDataSource();
            cpds.setDataSourceName("iDempiereDS");
            cpds.setDriverClass(DRIVER);
            cpds.setJdbcUrl(this.getConnectionURL(connection));
            cpds.setUser(connection.getDbUid());
            cpds.setPassword(connection.getDbPwd());
            cpds.setPreferredTestQuery("SELECT Version FROM AD_System");
            cpds.setIdleConnectionTestPeriod(idleConnectionTestPeriod);
            cpds.setMaxIdleTimeExcessConnections(maxIdleTimeExcessConnections);
            cpds.setMaxIdleTime(maxIdleTime);
            cpds.setTestConnectionOnCheckin(testConnectionOnCheckin);
            cpds.setTestConnectionOnCheckout(testConnectionOnCheckout);
            cpds.setAcquireRetryAttempts(acquireRetryAttempts);
            if (checkoutTimeout > 0) {
                cpds.setCheckoutTimeout(checkoutTimeout);
            }
            if (Ini.isClient()) {
                int maxPoolSize = this.getIntProperty(poolProperties, "MaxPoolSize", 15);
                int initialPoolSize = this.getIntProperty(poolProperties, "InitialPoolSize", 1);
                int minPoolSize = this.getIntProperty(poolProperties, "MinPoolSize", 1);
                cpds.setInitialPoolSize(initialPoolSize);
                cpds.setMinPoolSize(minPoolSize);
                cpds.setMaxPoolSize(maxPoolSize);
                m_maxbusyconnections = (int)((double)maxPoolSize * 0.9);
            } else {
                int maxPoolSize = this.getIntProperty(poolProperties, "MaxPoolSize", 400);
                int initialPoolSize = this.getIntProperty(poolProperties, "InitialPoolSize", 10);
                int minPoolSize = this.getIntProperty(poolProperties, "MinPoolSize", 5);
                cpds.setInitialPoolSize(initialPoolSize);
                cpds.setInitialPoolSize(initialPoolSize);
                cpds.setMinPoolSize(minPoolSize);
                cpds.setMaxPoolSize(maxPoolSize);
                m_maxbusyconnections = (int)((double)maxPoolSize * 0.9);
                int maxStatementsPerConnection = this.getIntProperty(poolProperties, "MaxStatementsPerConnection", 0);
                if (maxStatementsPerConnection > 0) {
                    cpds.setMaxStatementsPerConnection(maxStatementsPerConnection);
                }
            }
            if (unreturnedConnectionTimeout > 0) {
                cpds.setUnreturnedConnectionTimeout(1200);
                cpds.setDebugUnreturnedConnectionStackTraces(true);
            }
            this.m_ds = cpds;
            this.m_connectionURL = this.m_ds.getJdbcUrl();
        }
        catch (Exception ex) {
            this.m_ds = null;
            log.log(Level.SEVERE, "Could not initialise C3P0 Datasource", (Throwable)ex);
        }
        return this.m_ds;
    }

    public ConnectionPoolDataSource createPoolDataSource(CConnection connection) {
        throw new UnsupportedOperationException("Not supported/implemented");
    }

    public Connection getDriverConnection(CConnection connection) throws SQLException {
        this.getDriver();
        return DriverManager.getConnection(this.getConnectionURL(connection), connection.getDbUid(), connection.getDbPwd());
    }

    public Connection getDriverConnection(String dbUrl, String dbUid, String dbPwd) throws SQLException {
        this.getDriver();
        return DriverManager.getConnection(dbUrl, dbUid, dbPwd);
    }

    public void close() {
        if (log.isLoggable(Level.CONFIG)) {
            log.config(this.toString());
        }
        if (this.m_ds != null) {
            try {
                this.m_ds.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.m_ds = null;
    }

    public String getAlternativeSQL(int reExNo, String msg, String sql) {
        return null;
    }

    public String getConstraintType(Connection conn, String tableName, String IXName) {
        if (IXName == null || IXName.length() == 0) {
            return "0";
        }
        if (IXName.toUpperCase().endsWith("_KEY")) {
            return "1" + IXName;
        }
        return "0";
    }

    public boolean isSupported(String sql) {
        return true;
    }

    public static void dumpLocks(Connection conn) {
        block8: {
            Statement stmt = null;
            ResultSet rs = null;
            try {
                try {
                    String sql = "select pg_class.relname,pg_locks.* from pg_class,pg_locks where pg_class.relfilenode=pg_locks.relation order by 1";
                    stmt = conn.createStatement();
                    rs = stmt.executeQuery(sql);
                    int cnt = rs.getMetaData().getColumnCount();
                    System.out.println();
                    while (rs.next()) {
                        int i = 0;
                        while (i < cnt) {
                            Object value = rs.getObject(i + 1);
                            if (i > 0) {
                                System.out.print(", ");
                            }
                            System.out.print(value != null ? value.toString() : "");
                            ++i;
                        }
                        System.out.println();
                    }
                    System.out.println();
                }
                catch (Exception exception) {
                    DB.close(rs, (Statement)stmt);
                    rs = null;
                    stmt = null;
                    break block8;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, stmt);
                rs = null;
                stmt = null;
                throw throwable;
            }
            DB.close((ResultSet)rs, (Statement)stmt);
            rs = null;
            stmt = null;
        }
    }

    public int getNextID(String name) {
        int m_sequence_id = DB.getSQLValueEx(null, (String)("SELECT nextval('" + name.toLowerCase() + "')"), (Object[])new Object[0]);
        return m_sequence_id;
    }

    public boolean createSequence(String name, int increment, int minvalue, int maxvalue, int start, String trxName) {
        int no;
        int cnt = DB.getSQLValueEx((String)trxName, (String)"SELECT COUNT(*) FROM pg_class WHERE UPPER(relname)=? AND relkind='S'", (Object[])new Object[]{name.toUpperCase()});
        if (start < minvalue) {
            start = minvalue;
        }
        return (no = cnt == 0 ? DB.executeUpdate((String)("CREATE SEQUENCE " + name.toUpperCase() + " INCREMENT BY " + increment + " MINVALUE " + minvalue + " MAXVALUE " + maxvalue + " START WITH " + start), (String)trxName) : DB.executeUpdate((String)("ALTER SEQUENCE " + name.toUpperCase() + " INCREMENT BY " + increment + " MINVALUE " + minvalue + " MAXVALUE " + maxvalue + " RESTART WITH " + start), (String)trxName)) != -1;
    }

    public boolean isQueryTimeoutSupported() {
        return true;
    }

    public String addPagingSQL(String sql, int start, int end) {
        String newSql = String.valueOf(sql) + " " + NATIVE_MARKER + "LIMIT " + (end - start + 1) + "  " + NATIVE_MARKER + "OFFSET " + (start - 1);
        return newSql;
    }

    public boolean isPagingSupported() {
        return true;
    }

    private int getIntProperty(Properties properties, String key, int defaultValue) {
        int i = defaultValue;
        try {
            String s = properties.getProperty(key);
            if (s != null && s.trim().length() > 0) {
                i = Integer.parseInt(s);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return i;
    }

    private boolean getBooleanProperty(Properties properties, String key, boolean defaultValue) {
        boolean b = defaultValue;
        try {
            String s = properties.getProperty(key);
            if (s != null && s.trim().length() > 0) {
                b = Boolean.valueOf(s);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return b;
    }

    public boolean forUpdate(PO po, int timeout) {
        if (po.get_TrxName() == null) {
            return false;
        }
        String[] keyColumns = po.get_KeyColumns();
        if (keyColumns != null && keyColumns.length > 0 && !po.is_new()) {
            ResultSet rs;
            CPreparedStatement stmt;
            block12: {
                StringBuilder sqlBuffer = new StringBuilder(" SELECT ");
                sqlBuffer.append(keyColumns[0]).append(" FROM ").append(po.get_TableName()).append(" WHERE ");
                int i = 0;
                while (i < keyColumns.length) {
                    if (i > 0) {
                        sqlBuffer.append(" AND ");
                    }
                    sqlBuffer.append(keyColumns[i]).append("=?");
                    ++i;
                }
                sqlBuffer.append(" FOR UPDATE ");
                Object[] parameters = new Object[keyColumns.length];
                int i2 = 0;
                while (i2 < keyColumns.length) {
                    Object parameter = po.get_Value(keyColumns[i2]);
                    if (parameter != null && parameter instanceof Boolean) {
                        parameter = (Boolean)parameter != false ? "Y" : "N";
                    }
                    parameters[i2] = parameter;
                    ++i2;
                }
                stmt = null;
                rs = null;
                try {
                    stmt = DB.prepareStatement((String)sqlBuffer.toString(), (int)1003, (int)1008, (String)po.get_TrxName());
                    int i3 = 0;
                    while (i3 < keyColumns.length) {
                        stmt.setObject(i3 + 1, parameters[i3]);
                        ++i3;
                    }
                    stmt.setQueryTimeout(timeout > 0 ? timeout : 60);
                    rs = stmt.executeQuery();
                    if (!rs.next()) break block12;
                }
                catch (Exception e) {
                    try {
                        if (log.isLoggable(Level.INFO)) {
                            log.log(Level.INFO, e.getLocalizedMessage(), (Throwable)e);
                        }
                        throw new DBException("Could not lock record for " + po.toString() + " caused by " + e.getLocalizedMessage());
                    }
                    catch (Throwable throwable) {
                        DB.close(rs, stmt);
                        rs = null;
                        stmt = null;
                        throw throwable;
                    }
                }
                DB.close((ResultSet)rs, (Statement)stmt);
                rs = null;
                stmt = null;
                return true;
            }
            DB.close((ResultSet)rs, (Statement)stmt);
            rs = null;
            stmt = null;
            return false;
        }
        return false;
    }

    public String getNameOfUniqueConstraintError(Exception e) {
        String info = e.getMessage();
        int fromIndex = info.indexOf("\"");
        if (fromIndex == -1) {
            return info;
        }
        int toIndex = info.indexOf("\"", fromIndex + 1);
        if (toIndex == -1) {
            return info;
        }
        return info.substring(fromIndex + 1, toIndex);
    }
}

