/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.transport.nio;

import java.nio.channels.ClosedChannelException;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import org.apache.activemq.transport.nio.SelectorManager;
import org.apache.activemq.transport.nio.SelectorWorker;

public final class SelectorSelection {
    private final SelectorWorker worker;
    private final SelectionKey key;
    private final SelectorManager.Listener listener;
    private int interest;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SelectorSelection(SelectorWorker worker, SocketChannel socketChannel, SelectorManager.Listener listener) throws ClosedChannelException {
        this.worker = worker;
        this.listener = listener;
        worker.lock();
        try {
            this.key = socketChannel.register(worker.selector, 0, this);
            worker.incrementUseCounter();
        }
        finally {
            worker.unlock();
        }
    }

    public void setInterestOps(int ops) {
        this.interest = ops;
    }

    public void enable() {
        this.key.interestOps(this.interest);
        this.worker.selector.wakeup();
    }

    public void disable() {
        if (this.key.isValid()) {
            this.key.interestOps(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        this.worker.decrementUseCounter();
        this.worker.lock();
        try {
            this.key.cancel();
        }
        finally {
            this.worker.unlock();
        }
    }

    public void onSelect() {
        this.listener.onSelect(this);
    }

    public void onError(Throwable e) {
        this.listener.onError(this, e);
    }
}

