/*************************************************************************************************/
/*!
   	@file		iView.h
	@author 	Fanzo
 	@date 		2008/5/10
*/
/*************************************************************************************************/
#pragma		once

///////////////////////////////////////////////////////////////////////////////////////////////////
//include files


#pragma pack( push , 8 )		//set align

namespace shared
{
using namespace icubic;
///////////////////////////////////////////////////////////////////////////////////////////////////
// preprocessor deifne

///////////////////////////////////////////////////////////////////////////////////////////////////
// type define
enum Msg
{
	MouseMove_Msg , 
	LButtonDown_Msg , 
	LButtonUp_Msg , 
	LDragStart_Msg , 
	LDrag_Msg , 
	LDragEnd_Msg , 
	LDragCancel_Msg , 
};
///////////////////////////////////////////////////////////////////////////////////////////////////
// classes define
class IMsg
{
public:
	Msg		m_msg;
};
//MouseMove
class MouseMove_MsgPM : public IMsg
{
public:
	ivector2	m_pos;
};
//LButtonDown
class LButtonDown_MsgPM : public IMsg
{
public:
	ivector2	m_pos;
};
//LButtonUp
class LButtonUp_MsgPM : public IMsg
{
public:
	ivector2	m_pos;
};
//LDragStart
class LDragStart_MsgPM : public IMsg
{
public:
	ivector2	m_pos;
};
//LDrag
class LDrag_MsgPM : public IMsg
{
public:
	ivector2	m_pos;
};
//LDragEnd
class LDragEnd_MsgPM : public IMsg
{
public:
	ivector2	m_pos;
};
//LDragCancel
class LDragCancel_MsgPM : public IMsg
{
public:
};
class IView;
class IView_IID;
typedef icubic::iface_object< IView , IView_IID >	iView;

/**************************************************************************************************
 "IViewParentCtrl" interface 
***************************************************************************************************/
cb_guid_define( IViewParentCtrl_IID , 0xE6D651B9 , 0x689748c8 , 0xA7141EEE , 0x4B50CDCB );
class IViewParentCtrl;
typedef icubic::iface_object< IViewParentCtrl , IViewParentCtrl_IID >	iViewParentCtrl;
typedef icubic::iface_reference< IViewParentCtrl , IViewParentCtrl_IID >	rViewParentCtrl;
///////////////////////////////////////////////////////////////////////////////////////////////////
class IViewParentCtrl
{
public:
//=================================================================================================
//!	regist child
//!	@retval			---
//-------------------------------------------------------------------------------------------------
virtual
void cb_call RegistChild
		(
		iView&		child
		) = 0;
//=================================================================================================
//!	remove child
//!	@retval			---
//-------------------------------------------------------------------------------------------------
virtual
void cb_call RemoveChild
		(
		iView&		child
		) = 0;
//=================================================================================================
//!	require update
//!	@retval			---
//-------------------------------------------------------------------------------------------------
virtual
void cb_call RequireUpdate
		(
		const irect&	update , 
		bool			sync
		) = 0;
//=================================================================================================
//!	ToWindow
//!	@retval			---
//-------------------------------------------------------------------------------------------------
virtual
ivector2 cb_call ViewToWindow
		(
		const ivector2&	pos
		) = 0;
//=================================================================================================
//!	ToScreen
//!	@retval			---
//-------------------------------------------------------------------------------------------------
virtual
ivector2 cb_call ViewToScreen
		(
		const ivector2&	pos
		) = 0;
//=================================================================================================
//!	WindowToView
//!	@retval			---
//-------------------------------------------------------------------------------------------------
virtual
ivector2 cb_call WindowToView
		(
		const ivector2&	pos
		) = 0;
//=================================================================================================
//!	ScreenToView
//!	@retval			---
//-------------------------------------------------------------------------------------------------
virtual
ivector2 cb_call ScreenToView
		(
		const ivector2&	pos
		) = 0;
};

/**************************************************************************************************
 "IViewChildCtrl" interface 
***************************************************************************************************/
cb_guid_define( IViewChildCtrl_IID , 0xA8E2B492 , 0x2EA847a6 , 0x8B081588 , 0x5301A9B7 );
class IViewChildCtrl;
typedef icubic::iface_object< IViewChildCtrl , IViewChildCtrl_IID >	iViewChildCtrl;
typedef icubic::iface_reference< IViewChildCtrl , IViewChildCtrl_IID >	rViewChildCtrl;
///////////////////////////////////////////////////////////////////////////////////////////////////
class IViewChildCtrl
{
public:
//=================================================================================================
//!	msg
//!	@retval			---
//-------------------------------------------------------------------------------------------------
virtual
bool cb_call Msg
		(
		IMsg*		msg
		) = 0;
//=================================================================================================
//!	Update
//!	@retval			---
//-------------------------------------------------------------------------------------------------
virtual
void cb_call Update
		(
		iSurfaceViewport&	surface , 
		const irect&		update
		) = 0;
};

/**************************************************************************************************
 "IView" interface 
***************************************************************************************************/
cb_guid_define( IView_IID , 0x0F460231 , 0xE8FD42a0 , 0xAE0F30B1 , 0x432EFF7F );
typedef icubic::iface_reference< IView , IView_IID >	rView;
///////////////////////////////////////////////////////////////////////////////////////////////////
class IView : public IViewParentCtrl , public IViewChildCtrl
{
public:
//=================================================================================================
//!	create
//!	@retval			---
//-------------------------------------------------------------------------------------------------
virtual
bool cb_call Create
		(
		rViewParentCtrl&	parent , 
		const irect&		rect , 
		bool				show = true
		) = 0;
//=================================================================================================
//!	move
//!	@retval			---
//-------------------------------------------------------------------------------------------------
virtual
void cb_call Move
		(
		const irect&	rect
		) = 0;
//=================================================================================================
//!	get rect
//!	@retval			---
//-------------------------------------------------------------------------------------------------
virtual
irect cb_call GetRect()const = 0;
};

///////////////////////////////////////////////////////////////////////////////////////////////////
// global variable define

///////////////////////////////////////////////////////////////////////////////////////////////////
// global functions define

};	//namespace

//using namespace iView;		

#pragma pack( pop )			//release align
