/*************************************************************************************************/
/*!
   	@file		TimeCfgView.h
	@author 	Fanzo
*/
/*************************************************************************************************/
#pragma		once

///////////////////////////////////////////////////////////////////////////////////////////////////
//include files


#pragma pack( push , 8 )		//set align

namespace shared
{
using namespace icubic;
///////////////////////////////////////////////////////////////////////////////////////////////////
// preprocessor deifne

///////////////////////////////////////////////////////////////////////////////////////////////////
// type define

///////////////////////////////////////////////////////////////////////////////////////////////////
// classes define

/**************************************************************************************************
"TimeCfgView" class 
**************************************************************************************************/
class TimeCfgView : public View
{
	msg_view_map_begin()
	msg_view_hook( Update , OnUpdate )
	msg_view_hook( LButtonUp , OnLButtonUp )
	msg_view_map_end( View )

// variable member
private:
	instance<Font>			m_font;
	double						m_times[3];

	cb_align(4)
	LARGE_INTEGER				m_start;
	cb_align(4)
	LARGE_INTEGER				m_freq;
	
	rControlMsg					m_msg;
	int							m_id;
	const int					m_item_h;

// msg functions
protected:
//=================================================================================================
void OnUpdate
		(
		Update_ViewPM*	p
		)
{
	fvector2	pos( 1.0f , 1.0f );
	int		off , num = _countof( m_times );
	for( off = 0 ; off < num ; off++ )
	{
		wchar_t	text[ 256 ];
		if( m_times[off] == 0.0 )
			cb_swprintf( text , L"%d: ---[ms]" , off + 1 );
		else
			cb_swprintf( text , L"%d: %.2lf[ms]" , off + 1 , m_times[off] * 1000.0 );
		DrawText( (iSurfaceDest)p->m_surface , pos , text , ( iFont )m_font , rgb(0,0,0) , Top_TextAlign );
		pos.x += 90.0f;
	}
}
//=================================================================================================
void OnLButtonUp
		(
		LButtonUp_ViewPM*	p
		)
{
	iControlMsg	ms = m_msg.lock();
	if( ms == true )
		ms->ValueChanged_controlmsg( m_id );
}

// public functions
public:
//=================================================================================================
//!	construct
//-------------------------------------------------------------------------------------------------
TimeCfgView() : 
		m_item_h( 20 ) , 
		m_id( 0 )
{
	MemoryZero( &m_start , sizeof( m_start ) );
	cb_verify( 0 != ::QueryPerformanceFrequency( &m_freq ) );
	cb_verify( true == m_font->Create( fsize( 0.0f , 10.0f ) , L"Tahoma" , Roman_FontCharsetType , 400 , false ) );
	int		off , num = _countof( m_times );
	for( off = 0 ; off < num ; off++ )
		m_times[off] = 0.0;
}
//=================================================================================================
//!	set msg
//!	@retval			---
//-------------------------------------------------------------------------------------------------
void SetMsgCallback
		(
		rControlMsg&		msg , 
		int					id
		)
{
	m_msg	= msg;
	m_id	= id;
}
//=================================================================================================
//!	Begin
//!	@retval			---
//-------------------------------------------------------------------------------------------------
void BeginMeasure()
{
	cb_verify( 0 != ::QueryPerformanceCounter( &m_start ) );
}
//=================================================================================================
//!	end
//!	@retval			---
//-------------------------------------------------------------------------------------------------
void EndMeasure()
{
	LARGE_INTEGER		start	= m_start;
	cb_verify( 0 != ::QueryPerformanceCounter( &m_start) );
	double		time	= ( double )( m_start.QuadPart - start.QuadPart ) / ( double )m_freq.QuadPart;

	int		off;
	for( off = _countof( m_times ) - 1 ; off >= 1 ; off-- )
		m_times[ off ] = m_times[ off - 1 ];
	m_times[0]= time;
}
};

///////////////////////////////////////////////////////////////////////////////////////////////////
// global variable define

///////////////////////////////////////////////////////////////////////////////////////////////////
// global functions define

};	//namespace

//using namespace TimeCfgView;		

#pragma pack( pop )			//release align
